/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.hudi.org.openjdk.jol.vm.VM;
import org.apache.hudi.org.openjdk.jol.vm.VirtualMachine;

public class ObjectUtils {
    public static String safeToString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            Class<?> type2 = o.getClass().getComponentType();
            if (type2 == Boolean.TYPE) {
                return Arrays.toString((boolean[])o);
            }
            if (type2 == Byte.TYPE) {
                return Arrays.toString((byte[])o);
            }
            if (type2 == Short.TYPE) {
                return Arrays.toString((short[])o);
            }
            if (type2 == Character.TYPE) {
                return Arrays.toString((char[])o);
            }
            if (type2 == Integer.TYPE) {
                return Arrays.toString((int[])o);
            }
            if (type2 == Float.TYPE) {
                return Arrays.toString((float[])o);
            }
            if (type2 == Long.TYPE) {
                return Arrays.toString((long[])o);
            }
            if (type2 == Double.TYPE) {
                return Arrays.toString((double[])o);
            }
            Object[] oos = (Object[])o;
            Object[] strs = new String[oos.length];
            for (int i = 0; i < oos.length; ++i) {
                strs[i] = oos[i] == null ? "null" : ObjectUtils.safeToString(oos[i]);
            }
            return Arrays.toString(strs);
        }
        if (o.getClass().isPrimitive()) {
            return o.toString();
        }
        if (o.getClass() == Boolean.class) {
            return o.toString();
        }
        if (o.getClass() == Byte.class) {
            return o.toString();
        }
        if (o.getClass() == Short.class) {
            return o.toString();
        }
        if (o.getClass() == Character.class) {
            return o.toString();
        }
        if (o.getClass() == Integer.class) {
            return o.toString();
        }
        if (o.getClass() == Float.class) {
            return o.toString();
        }
        if (o.getClass() == Long.class) {
            return o.toString();
        }
        if (o.getClass() == Double.class) {
            return o.toString();
        }
        return "(object)";
    }

    public static Object value(Object o, Field f) {
        try {
            return f.get(o);
        }
        catch (Exception exception) {
            try {
                f.setAccessible(true);
                return f.get(o);
            }
            catch (Exception exception2) {
                VirtualMachine vm = VM.current();
                long off = vm.fieldOffset(f);
                Class<?> t = f.getType();
                if (t.isPrimitive()) {
                    if (t == Boolean.TYPE) {
                        return vm.getBoolean(o, off);
                    }
                    if (t == Byte.TYPE) {
                        return vm.getByte(o, off);
                    }
                    if (t == Character.TYPE) {
                        return Character.valueOf(vm.getChar(o, off));
                    }
                    if (t == Short.TYPE) {
                        return vm.getShort(o, off);
                    }
                    if (t == Integer.TYPE) {
                        return vm.getInt(o, off);
                    }
                    if (t == Float.TYPE) {
                        return Float.valueOf(vm.getFloat(o, off));
                    }
                    if (t == Long.TYPE) {
                        return vm.getLong(o, off);
                    }
                    if (t == Double.TYPE) {
                        return vm.getDouble(o, off);
                    }
                    throw new IllegalStateException("Unhandled primitive: " + t);
                }
                return vm.getObject(o, off);
            }
        }
    }
}

