/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.SparkFileFormatInternalRowReaderContext;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.EngineBroadcastManager;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.parquet.SparkParquetReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.JavaConverters;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;

public class SparkBroadcastManager
extends EngineBroadcastManager {
    private static final Logger LOG = LoggerFactory.getLogger(SparkBroadcastManager.class);
    private final transient HoodieEngineContext context;
    protected Option<SparkParquetReader> parquetReaderOpt = Option.empty();
    protected Broadcast<SQLConf> sqlConfBroadcast;
    protected Broadcast<SparkParquetReader> parquetReaderBroadcast;
    protected Broadcast<SerializableConfiguration> configurationBroadcast;

    public SparkBroadcastManager(HoodieEngineContext context) {
        this.context = context;
    }

    @Override
    public void prepareAndBroadcast() {
        if (!(this.context instanceof HoodieSparkEngineContext)) {
            throw new HoodieIOException("Expected to be called using Engine's context and not local context");
        }
        HoodieSparkEngineContext hoodieSparkEngineContext = (HoodieSparkEngineContext)this.context;
        SQLConf sqlConf = hoodieSparkEngineContext.getSqlContext().sessionState().conf();
        JavaSparkContext jsc = hoodieSparkEngineContext.jsc();
        boolean returningBatch = sqlConf.parquetVectorizedReaderEnabled();
        Map options = (Map)Map$.MODULE$.empty().$plus(new Tuple2((Object)FileFormat.OPTION_RETURNING_BATCH(), (Object)Boolean.toString(returningBatch)));
        this.sqlConfBroadcast = jsc.broadcast((Object)sqlConf);
        Configuration hadoopConf = new Configuration(jsc.hadoopConfiguration());
        hadoopConf.setBoolean(SQLConf.NESTED_SCHEMA_PRUNING_ENABLED().key(), false);
        hadoopConf.setBoolean(SQLConf.CASE_SENSITIVE().key(), false);
        hadoopConf.setBoolean(SQLConf.PARQUET_BINARY_AS_STRING().key(), false);
        hadoopConf.setBoolean(SQLConf.PARQUET_INT96_AS_TIMESTAMP().key(), true);
        hadoopConf.setBoolean("spark.sql.legacy.parquet.nanosAsLong", false);
        if (HoodieSparkUtils.gteqSpark3_4()) {
            hadoopConf.setBoolean("spark.sql.parquet.inferTimestampNTZ.enabled", false);
        }
        this.configurationBroadcast = jsc.broadcast((Object)new SerializableConfiguration(hadoopConf));
        this.parquetReaderOpt = Option.of(SparkAdapterSupport$.MODULE$.sparkAdapter().createParquetFileReader(false, (SQLConf)this.sqlConfBroadcast.getValue(), (Map<String, String>)options, ((SerializableConfiguration)this.configurationBroadcast.getValue()).value()));
        this.parquetReaderBroadcast = jsc.broadcast((Object)this.parquetReaderOpt.get());
    }

    @Override
    public Option<HoodieReaderContext> retrieveFileGroupReaderContext(StoragePath basePath) {
        if (this.parquetReaderBroadcast == null) {
            throw new HoodieException("Spark Parquet reader broadcast is not initialized.");
        }
        SparkParquetReader sparkParquetReader = (SparkParquetReader)this.parquetReaderBroadcast.getValue();
        if (sparkParquetReader != null) {
            ArrayList filters = new ArrayList();
            return Option.of(new SparkFileFormatInternalRowReaderContext(sparkParquetReader, (Seq<Filter>)((Buffer)JavaConverters.asScalaBufferConverter(filters).asScala()).toSeq(), (Seq<Filter>)((Buffer)JavaConverters.asScalaBufferConverter(filters).asScala()).toSeq()));
        }
        throw new HoodieException("Cannot get the broadcast Spark Parquet reader.");
    }

    @Override
    public Option<Configuration> retrieveStorageConfig() {
        return Option.of(((SerializableConfiguration)this.configurationBroadcast.getValue()).value());
    }
}

