/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieCompactionException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.table.HoodieTable;

public class CompactHelpers<T, I, K, O> {
    private static final CompactHelpers SINGLETON_INSTANCE = new CompactHelpers();

    private CompactHelpers() {
    }

    public static CompactHelpers getInstance() {
        return SINGLETON_INSTANCE;
    }

    public HoodieCommitMetadata createCompactionMetadata(HoodieTable table, String compactionInstantTime, HoodieData<WriteStatus> writeStatuses, String schema) throws IOException {
        InstantGenerator instantGenerator = table.getInstantGenerator();
        byte[] planBytes = table.getActiveTimeline().readCompactionPlanAsBytes(instantGenerator.getCompactionRequestedInstant(compactionInstantTime)).get();
        HoodieCompactionPlan compactionPlan = TimelineMetadataUtils.deserializeCompactionPlan(planBytes);
        List<HoodieWriteStat> updateStatusMap = writeStatuses.map(WriteStatus::getStat).collectAsList();
        HoodieCommitMetadata metadata2 = new HoodieCommitMetadata(true);
        for (HoodieWriteStat stat : updateStatusMap) {
            metadata2.addWriteStat(stat.getPartitionPath(), stat);
        }
        metadata2.addMetadata("schema", schema);
        metadata2.setOperationType(WriteOperationType.COMPACT);
        if (compactionPlan.getExtraMetadata() != null) {
            compactionPlan.getExtraMetadata().forEach(metadata2::addMetadata);
        }
        return metadata2;
    }

    public void completeInflightCompaction(HoodieTable table, String compactionCommitTime, HoodieCommitMetadata commitMetadata) {
        HoodieActiveTimeline activeTimeline = table.getActiveTimeline();
        try {
            InstantGenerator instantGenerator = table.getInstantGenerator();
            activeTimeline.transitionCompactionInflightToComplete(false, instantGenerator.getCompactionInflightInstant(compactionCommitTime), TimelineMetadataUtils.serializeCommitMetadata(table.getMetaClient().getCommitMetadataSerDe(), commitMetadata));
        }
        catch (IOException e) {
            throw new HoodieCompactionException("Failed to commit " + table.getMetaClient().getBasePath() + " at time " + compactionCommitTime, e);
        }
    }

    public void completeInflightLogCompaction(HoodieTable table, String logCompactionCommitTime, HoodieCommitMetadata commitMetadata) {
        HoodieActiveTimeline activeTimeline = table.getActiveTimeline();
        try {
            InstantGenerator instantGenerator = table.getInstantGenerator();
            activeTimeline.transitionLogCompactionInflightToComplete(false, instantGenerator.getLogCompactionInflightInstant(logCompactionCommitTime), TimelineMetadataUtils.serializeCommitMetadata(table.getMetaClient().getCommitMetadataSerDe(), commitMetadata));
        }
        catch (IOException e) {
            throw new HoodieCompactionException("Failed to commit " + table.getMetaClient().getBasePath() + " at time " + logCompactionCommitTime, e);
        }
    }

    public Option<InstantRange> getInstantRange(HoodieTableMetaClient metaClient) {
        return metaClient.isMetadataTable() != false ? Option.of(this.getMetadataLogReaderInstantRange(metaClient)) : Option.empty();
    }

    private InstantRange getMetadataLogReaderInstantRange(HoodieTableMetaClient metadataMetaClient) {
        HoodieTableMetaClient dataMetaClient = HoodieTableMetaClient.builder().setConf(metadataMetaClient.getStorageConf().newInstance()).setBasePath(HoodieTableMetadata.getDatasetBasePath(metadataMetaClient.getBasePath().toString())).build();
        Set<String> validInstants = HoodieTableMetadataUtil.getValidInstantTimestamps(dataMetaClient, metadataMetaClient);
        return InstantRange.builder().rangeType(InstantRange.RangeType.EXACT_MATCH).explicitInstants(validInstants).build();
    }
}

