/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.util.SparkKeyGenUtils;

public class SparkUpgradeDowngradeHelper
implements SupportsUpgradeDowngrade {
    private static final SparkUpgradeDowngradeHelper SINGLETON_INSTANCE = new SparkUpgradeDowngradeHelper();

    private SparkUpgradeDowngradeHelper() {
    }

    public static SparkUpgradeDowngradeHelper getInstance() {
        return SINGLETON_INSTANCE;
    }

    @Override
    public HoodieTable getTable(HoodieWriteConfig config, HoodieEngineContext context) {
        return HoodieSparkTable.create(config, context);
    }

    @Override
    public String getPartitionColumns(HoodieWriteConfig config) {
        return SparkKeyGenUtils.getPartitionColumns(config.getProps());
    }

    @Override
    public BaseHoodieWriteClient getWriteClient(HoodieWriteConfig config, HoodieEngineContext context) {
        return new SparkRDDWriteClient(context, config);
    }
}

