/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.Serializable;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class PathUtils$ {
    public static final PathUtils$ MODULE$ = new PathUtils$();

    public boolean isGlobPath(StoragePath pattern) {
        Set set = Predef$.MODULE$.wrapString("{}[]*?\\").toSet();
        return StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(pattern.toString()), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains(elem)));
    }

    public Seq<StoragePath> globPath(HoodieStorage storage2, StoragePath pattern) {
        ObjectRef basePath = ObjectRef.create((Object)pattern.getParent());
        while (((StoragePath)basePath.elem).getName().equals("*")) {
            basePath.elem = ((StoragePath)basePath.elem).getParent();
        }
        return (Seq)Option$.MODULE$.apply(storage2.globEntries(pattern)).map((Function1 & Serializable)pathInfoList -> {
            Buffer nonMetaStatuses = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(pathInfoList).asScala()).filterNot((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)PathUtils$.$anonfun$globPath$2(basePath, entry)));
            return ((IterableOnceOps)nonMetaStatuses.map((Function1 & Serializable)e -> e.getPath().makeQualified(storage2.getUri()))).toSeq();
        }).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    public Seq<StoragePath> globPathIfNecessary(HoodieStorage storage2, StoragePath pattern) {
        return this.isGlobPath(pattern) ? this.globPath(storage2, pattern) : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StoragePath[]{pattern}));
    }

    public Seq<StoragePath> checkAndGlobPathIfNecessary(Seq<String> paths, HoodieStorage storage2) {
        return (Seq)paths.flatMap((Function1 & Serializable)path -> {
            StoragePath qualified = new StoragePath((String)path).makeQualified(storage2.getUri());
            return MODULE$.globPathIfNecessary(storage2, qualified);
        });
    }

    public static final /* synthetic */ boolean $anonfun$globPath$2(ObjectRef basePath$1, StoragePathInfo entry) {
        StoragePath leafPath = entry.getPath();
        while (!leafPath.equals((StoragePath)basePath$1.elem) && !leafPath.getName().equals(".hoodie")) {
            leafPath = leafPath.getParent();
        }
        return leafPath.getName().equals(".hoodie");
    }

    private PathUtils$() {
    }
}

