/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.multitable;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.utilities.HoodieCompactor;
import org.apache.hudi.utilities.multitable.TableServiceTask;
import org.apache.spark.api.java.JavaSparkContext;

class CompactionTask
extends TableServiceTask {
    public String compactionRunningMode;
    public String compactionStrategyName;
    private int parallelism;
    private HoodieTableMetaClient metaClient;

    CompactionTask() {
    }

    @Override
    void run() {
        HoodieCompactor.Config compactionCfg = new HoodieCompactor.Config();
        compactionCfg.basePath = this.basePath;
        compactionCfg.strategyClassName = this.compactionStrategyName;
        compactionCfg.runningMode = this.compactionRunningMode;
        compactionCfg.parallelism = this.parallelism;
        compactionCfg.retry = this.retry;
        new HoodieCompactor(this.jsc, compactionCfg, this.props, this.metaClient).compact(this.retry);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TypedProperties props;
        private String compactionRunningMode;
        public String compactionStrategyName;
        private int parallelism;
        private int retry;
        private String basePath;
        private JavaSparkContext jsc;
        private HoodieTableMetaClient metaClient;

        public Builder withProps(TypedProperties props) {
            this.props = props;
            return this;
        }

        public Builder withCompactionRunningMode(String compactionRunningMode) {
            this.compactionRunningMode = compactionRunningMode;
            return this;
        }

        public Builder withCompactionStrategyName(String compactionStrategyName) {
            this.compactionStrategyName = compactionStrategyName;
            return this;
        }

        public Builder withParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public Builder withRetry(int retry) {
            this.retry = retry;
            return this;
        }

        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder withJsc(JavaSparkContext jsc) {
            this.jsc = jsc;
            return this;
        }

        public Builder withMetaclient(HoodieTableMetaClient metaClient) {
            this.metaClient = metaClient;
            return this;
        }

        public CompactionTask build() {
            CompactionTask compactionTask = new CompactionTask();
            compactionTask.basePath = this.basePath;
            compactionTask.jsc = this.jsc;
            compactionTask.parallelism = this.parallelism;
            compactionTask.compactionRunningMode = this.compactionRunningMode;
            compactionTask.compactionStrategyName = this.compactionStrategyName;
            compactionTask.retry = this.retry;
            compactionTask.props = this.props;
            compactionTask.metaClient = this.metaClient;
            return compactionTask;
        }
    }
}

