/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.hudi.org.apache.http.ssl.SSLContextBuilder;
import org.apache.hudi.org.apache.http.ssl.SSLContexts;
import org.apache.hudi.org.apache.http.ssl.TrustStrategy;
import org.apache.hudi.utilities.config.HoodieSchemaProviderConfig;
import org.apache.hudi.utilities.exception.HoodieSchemaFetchException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaSparkContext;

public class SchemaRegistryProvider
extends SchemaProvider {
    private static final Pattern URL_PATTERN = Pattern.compile("(.*/)subjects/(.*)/versions/(.*)");
    private static final String LATEST = "latest";
    private final Option<SchemaConverter> schemaConverter;
    private final SerializableFunctionUnchecked<String, RestService> restServiceProvider;
    private final SerializableFunctionUnchecked<RestService, SchemaRegistryClient> registryClientProvider;
    private SSLSocketFactory sslSocketFactory;

    public SchemaRegistryProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        String schemaConverter;
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL));
        if (this.config.containsKey("schema.registry.ssl.keystore.location") || this.config.containsKey("schema.registry.ssl.truststore.location")) {
            this.setUpSSLStores();
        }
        this.schemaConverter = !StringUtils.isNullOrEmpty(schemaConverter = ConfigUtils.getStringWithAltKeys((Properties)this.config, HoodieSchemaProviderConfig.SCHEMA_CONVERTER, true)) ? Option.of((SchemaConverter)ReflectionUtils.loadClass(schemaConverter, new Class[]{TypedProperties.class}, new Object[]{this.config})) : Option.empty();
        this.restServiceProvider = RestService::new;
        this.registryClientProvider = restService -> new CachedSchemaRegistryClient((RestService)restService, 100, Arrays.asList(new ProtobufSchemaProvider(), new JsonSchemaProvider(), new AvroSchemaProvider()), null, null);
    }

    @VisibleForTesting
    SchemaRegistryProvider(TypedProperties props, JavaSparkContext jssc, Option<SchemaConverter> schemaConverter, SerializableFunctionUnchecked<String, RestService> restServiceProvider, SerializableFunctionUnchecked<RestService, SchemaRegistryClient> registryClientProvider) {
        super(props, jssc);
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL));
        this.schemaConverter = schemaConverter;
        this.restServiceProvider = restServiceProvider;
        this.registryClientProvider = registryClientProvider;
    }

    public Schema parseSchemaFromRegistry(String registryUrl) {
        String schema = this.fetchSchemaFromRegistry(registryUrl);
        return new Schema.Parser().parse(schema);
    }

    public String fetchSchemaFromRegistry(String registryUrl) {
        try {
            Triple<String, String, String> registryInfo;
            Matcher matcher = Pattern.compile("://(.*?)@").matcher(registryUrl);
            String creds = null;
            if (matcher.find()) {
                creds = matcher.group(1);
                String urlWithoutCreds = registryUrl.replace(creds + "@", "");
                registryInfo = this.getUrlSubjectAndVersion(urlWithoutCreds);
            } else {
                registryInfo = this.getUrlSubjectAndVersion(registryUrl);
            }
            String url2 = registryInfo.getLeft();
            RestService restService = this.getRestService(url2);
            if (creds != null) {
                this.setAuthorizationHeader(creds, restService);
            }
            String subject = registryInfo.getMiddle();
            String version = registryInfo.getRight();
            SchemaRegistryClient registryClient = this.registryClientProvider.apply(restService);
            SchemaMetadata schemaMetadata = version.equals(LATEST) ? registryClient.getLatestSchemaMetadata(subject) : registryClient.getSchemaMetadata(subject, Integer.parseInt(version));
            ParsedSchema parsedSchema = registryClient.parseSchema(schemaMetadata.getSchemaType(), schemaMetadata.getSchema(), schemaMetadata.getReferences()).orElseThrow(() -> new HoodieSchemaException("Failed to parse schema from registry"));
            if (this.schemaConverter.isPresent()) {
                return this.schemaConverter.get().convert(parsedSchema);
            }
            return parsedSchema.canonicalString();
        }
        catch (Exception e) {
            throw new HoodieSchemaFetchException("Failed to fetch schema from registry", e);
        }
    }

    private Triple<String, String, String> getUrlSubjectAndVersion(String registryUrl) {
        String[] splitRegistryUrls = registryUrl.split(",");
        String subjectName = null;
        String version = null;
        ArrayList<String> urls = new ArrayList<String>(splitRegistryUrls.length);
        for (String url2 : splitRegistryUrls) {
            Matcher matcher = URL_PATTERN.matcher(url2);
            if (!matcher.matches()) {
                throw new HoodieSchemaFetchException("Failed to extract subject name and version from registry url");
            }
            urls.add(matcher.group(1));
            subjectName = matcher.group(2);
            version = matcher.group(3);
        }
        if (subjectName == null) {
            throw new HoodieSchemaFetchException("Failed to extract subject name from registry url");
        }
        return Triple.of(String.join((CharSequence)",", urls), subjectName, version);
    }

    protected RestService getRestService(String url2) {
        RestService restService = this.restServiceProvider.apply(url2);
        if (this.sslSocketFactory != null) {
            restService.setSslSocketFactory(this.sslSocketFactory);
            return restService;
        }
        return restService;
    }

    protected void setAuthorizationHeader(String creds, RestService restService) {
        String encodedAuth = Base64.getEncoder().encodeToString(creds.getBytes(StandardCharsets.UTF_8));
        restService.setHttpHeaders(Collections.singletonMap("Authorization", "Basic " + encodedAuth));
    }

    private void setUpSSLStores() {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        try {
            if (this.config.containsKey("schema.registry.ssl.truststore.location")) {
                sslContextBuilder.loadTrustMaterial(new File(this.config.getString("schema.registry.ssl.truststore.location")), this.config.getString("schema.registry.ssl.truststore.password").toCharArray(), (TrustStrategy)new TrustSelfSignedStrategy());
            }
            if (this.config.containsKey("schema.registry.ssl.keystore.location")) {
                sslContextBuilder.loadKeyMaterial(new File(this.config.getString("schema.registry.ssl.keystore.location")), this.config.getString("schema.registry.ssl.keystore.password").toCharArray(), this.config.getString("schema.registry.ssl.key.password").toCharArray());
            }
            this.sslSocketFactory = sslContextBuilder.build().getSocketFactory();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Schema getSourceSchema() {
        String registryUrl = ConfigUtils.getStringWithAltKeys(this.config, HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL);
        try {
            return this.parseSchemaFromRegistry(registryUrl);
        }
        catch (Exception e) {
            throw new HoodieSchemaFetchException(String.format("Error reading source schema from registry. Please check %s is configured correctly. Truncated URL: %s", Config.SRC_SCHEMA_REGISTRY_URL_PROP, StringUtils.truncate(registryUrl, 10, 10)), e);
        }
    }

    @Override
    public Schema getTargetSchema() {
        String registryUrl = ConfigUtils.getStringWithAltKeys(this.config, HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL);
        String targetRegistryUrl = ConfigUtils.getStringWithAltKeys((Properties)this.config, HoodieSchemaProviderConfig.TARGET_SCHEMA_REGISTRY_URL, registryUrl);
        try {
            return this.parseSchemaFromRegistry(targetRegistryUrl);
        }
        catch (Exception e) {
            throw new HoodieSchemaFetchException(String.format("Error reading target schema from registry. Please check %s is configured correctly. If that is not configured then check %s. Truncated URL: %s", Config.SRC_SCHEMA_REGISTRY_URL_PROP, Config.TARGET_SCHEMA_REGISTRY_URL_PROP, StringUtils.truncate(targetRegistryUrl, 10, 10)), e);
        }
    }

    @FunctionalInterface
    public static interface SchemaConverter {
        public String convert(ParsedSchema var1) throws IOException;
    }

    public static class Config {
        @Deprecated
        public static final String SRC_SCHEMA_REGISTRY_URL_PROP = HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL.key();
        @Deprecated
        public static final String TARGET_SCHEMA_REGISTRY_URL_PROP = HoodieSchemaProviderConfig.TARGET_SCHEMA_REGISTRY_URL.key();
        @Deprecated
        public static final String SCHEMA_CONVERTER_PROP = HoodieSchemaProviderConfig.SCHEMA_CONVERTER.key();
        public static final String SSL_KEYSTORE_LOCATION_PROP = "schema.registry.ssl.keystore.location";
        public static final String SSL_TRUSTSTORE_LOCATION_PROP = "schema.registry.ssl.truststore.location";
        public static final String SSL_KEYSTORE_PASSWORD_PROP = "schema.registry.ssl.keystore.password";
        public static final String SSL_TRUSTSTORE_PASSWORD_PROP = "schema.registry.ssl.truststore.password";
        public static final String SSL_KEY_PASSWORD_PROP = "schema.registry.ssl.key.password";
    }
}

