/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.config.HoodieStreamerConfig;
import org.apache.hudi.utilities.exception.HoodieReadFromSourceException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.sources.helpers.SanitizationUtils;
import org.apache.hudi.utilities.streamer.StreamContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public abstract class RowSource
extends Source<Dataset<Row>> {
    public RowSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider, Source.SourceType.ROW);
    }

    public RowSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, StreamContext streamContext) {
        super(props, sparkContext, sparkSession, Source.SourceType.ROW, streamContext);
    }

    protected abstract Pair<Option<Dataset<Row>>, Checkpoint> fetchNextBatch(Option<Checkpoint> var1, long var2);

    @Override
    protected final InputBatch<Dataset<Row>> fetchNewData(Option<String> lastCkptStr, long sourceLimit) {
        throw new UnsupportedOperationException("RowSource#fetchNewData should not be called");
    }

    @Override
    protected final InputBatch<Dataset<Row>> readFromCheckpoint(Option<Checkpoint> lastCheckpoint, long sourceLimit) {
        Pair<Option<Dataset<Row>>, Checkpoint> res = this.fetchNextBatch(lastCheckpoint, sourceLimit);
        return res.getKey().map(dsr -> {
            Dataset<Row> sanitizedRows = SanitizationUtils.sanitizeColumnNamesForAvro((Dataset<Row>)dsr, this.props);
            SchemaProvider rowSchemaProvider = UtilHelpers.createRowBasedSchemaProvider(sanitizedRows.schema(), this.props, this.sparkContext);
            Dataset<Row> wrappedDf = HoodieSparkUtils.maybeWrapDataFrameWithException(sanitizedRows, HoodieReadFromSourceException.class.getName(), "Failed to read from row source", ConfigUtils.getBooleanWithAltKeys(this.props, HoodieStreamerConfig.ROW_THROW_EXPLICIT_EXCEPTIONS));
            return new InputBatch<Dataset<Row>>(Option.of(wrappedDf), (Checkpoint)res.getValue(), rowSchemaProvider);
        }).orElseGet(() -> new InputBatch((Option)res.getKey(), (Checkpoint)res.getValue()));
    }
}

