/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers.gcs;

import com.google.cloud.ServiceOptions;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.com.google.protobuf.util.Timestamps;

public class PubsubQueueClient {
    private static final String METRIC_FILTER_PATTERN = "metric.type=\"pubsub.googleapis.com/subscription/%s\" AND resource.label.subscription_id=\"%s\"";
    private static final String NUM_UNDELIVERED_MESSAGES = "num_undelivered_messages";

    public SubscriberStub getSubscriber(SubscriberStubSettings subscriberStubSettings) throws IOException {
        return GrpcSubscriberStub.create((SubscriberStubSettings)subscriberStubSettings);
    }

    public PullResponse makePullRequest(SubscriberStub subscriber, String subscriptionName, int batchSize) throws IOException {
        PullRequest pullRequest = PullRequest.newBuilder().setMaxMessages(batchSize).setSubscription(subscriptionName).build();
        return (PullResponse)subscriber.pullCallable().call((Object)pullRequest);
    }

    public void makeAckRequest(SubscriberStub subscriber, String subscriptionName, List<String> messages) {
        AcknowledgeRequest acknowledgeRequest = AcknowledgeRequest.newBuilder().setSubscription(subscriptionName).addAllAckIds(messages).build();
        subscriber.acknowledgeCallable().call((Object)acknowledgeRequest);
    }

    public long getNumUnAckedMessages(String subscriptionId) throws IOException {
        try (MetricServiceClient metricServiceClient = MetricServiceClient.create();){
            MetricServiceClient.ListTimeSeriesPagedResponse response = metricServiceClient.listTimeSeries(ListTimeSeriesRequest.newBuilder().setName(ProjectName.of((String)ServiceOptions.getDefaultProjectId()).toString()).setFilter(String.format(METRIC_FILTER_PATTERN, NUM_UNDELIVERED_MESSAGES, subscriptionId)).setInterval(TimeInterval.newBuilder().setStartTime(Timestamps.fromSeconds((long)(Instant.now().getEpochSecond() - TimeUnit.MINUTES.toSeconds(2L)))).setEndTime(Timestamps.fromSeconds((long)Instant.now().getEpochSecond())).build()).build());
            List pointList = ((TimeSeries)((MetricServiceClient.ListTimeSeriesPage)response.getPage()).getValues().iterator().next()).getPointsList();
            long l = pointList.stream().findFirst().map(point -> point.getValue().getInt64Value()).orElse(Long.MAX_VALUE);
            return l;
        }
    }
}

