/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ConfigEntry {
    private final String name;
    private final String value;
    private final ConfigSource source;
    private final boolean isSensitive;
    private final boolean isReadOnly;
    private final List<ConfigSynonym> synonyms;
    private final ConfigType type;
    private final String documentation;

    public ConfigEntry(String name2, String value) {
        this(name2, value, ConfigSource.UNKNOWN, false, false, Collections.emptyList(), ConfigType.UNKNOWN, null);
    }

    public ConfigEntry(String name2, String value, ConfigSource source, boolean isSensitive, boolean isReadOnly, List<ConfigSynonym> synonyms, ConfigType type2, String documentation) {
        Objects.requireNonNull(name2, "name should not be null");
        this.name = name2;
        this.value = value;
        this.source = source;
        this.isSensitive = isSensitive;
        this.isReadOnly = isReadOnly;
        this.synonyms = synonyms;
        this.type = type2;
        this.documentation = documentation;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public ConfigSource source() {
        return this.source;
    }

    public boolean isDefault() {
        return this.source == ConfigSource.DEFAULT_CONFIG;
    }

    public boolean isSensitive() {
        return this.isSensitive;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public List<ConfigSynonym> synonyms() {
        return this.synonyms;
    }

    public ConfigType type() {
        return this.type;
    }

    public String documentation() {
        return this.documentation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigEntry that = (ConfigEntry)o;
        return this.name.equals(that.name) && Objects.equals(this.value, that.value) && this.isSensitive == that.isSensitive && this.isReadOnly == that.isReadOnly && Objects.equals((Object)this.source, (Object)that.source) && Objects.equals(this.synonyms, that.synonyms) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.documentation, that.documentation);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.name.hashCode();
        result2 = 31 * result2 + Objects.hashCode(this.value);
        result2 = 31 * result2 + (this.isSensitive ? 1 : 0);
        result2 = 31 * result2 + (this.isReadOnly ? 1 : 0);
        result2 = 31 * result2 + Objects.hashCode((Object)this.source);
        result2 = 31 * result2 + Objects.hashCode(this.synonyms);
        result2 = 31 * result2 + Objects.hashCode((Object)this.type);
        result2 = 31 * result2 + Objects.hashCode(this.documentation);
        return result2;
    }

    public String toString() {
        return "ConfigEntry(name=" + this.name + ", value=" + (this.isSensitive ? "Redacted" : this.value) + ", source=" + (Object)((Object)this.source) + ", isSensitive=" + this.isSensitive + ", isReadOnly=" + this.isReadOnly + ", synonyms=" + this.synonyms + ", type=" + (Object)((Object)this.type) + ", documentation=" + this.documentation + ")";
    }

    public static class ConfigSynonym {
        private final String name;
        private final String value;
        private final ConfigSource source;

        ConfigSynonym(String name2, String value, ConfigSource source) {
            this.name = name2;
            this.value = value;
            this.source = source;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public ConfigSource source() {
            return this.source;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigSynonym that = (ConfigSynonym)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && this.source == that.source;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.value, this.source});
        }

        public String toString() {
            return "ConfigSynonym(name=" + this.name + ", value=" + this.value + ", source=" + (Object)((Object)this.source) + ")";
        }
    }

    public static enum ConfigSource {
        DYNAMIC_TOPIC_CONFIG,
        DYNAMIC_BROKER_LOGGER_CONFIG,
        DYNAMIC_BROKER_CONFIG,
        DYNAMIC_DEFAULT_BROKER_CONFIG,
        STATIC_BROKER_CONFIG,
        DEFAULT_CONFIG,
        UNKNOWN;

    }

    public static enum ConfigType {
        UNKNOWN,
        BOOLEAN,
        STRING,
        INT,
        SHORT,
        LONG,
        DOUBLE,
        LIST,
        CLASS,
        PASSWORD;

    }
}

