/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListGroupsRequestData
implements ApiMessage {
    List<String> statesFilter;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 4;

    public ListGroupsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ListGroupsRequestData() {
        this.statesFilter = new ArrayList<String>(0);
    }

    @Override
    public short apiKey() {
        return 16;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable _readable, short _version) {
        if (_version >= 4) {
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field statesFilter was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                int length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field statesFilter element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field statesFilter element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.statesFilter = newCollection;
        } else {
            this.statesFilter = new ArrayList<String>(0);
        }
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.statesFilter.size() + 1);
            for (String statesFilterElement : this.statesFilter) {
                byte[] _stringBytes = _cache.getSerializedValue(statesFilterElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
        } else if (!this.statesFilter.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default statesFilter at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.statesFilter.size() + 1));
            for (String statesFilterElement : this.statesFilter) {
                byte[] _stringBytes = statesFilterElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'statesFilterElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(statesFilterElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListGroupsRequestData)) {
            return false;
        }
        ListGroupsRequestData other = (ListGroupsRequestData)obj;
        if (this.statesFilter == null ? other.statesFilter != null : !this.statesFilter.equals(other.statesFilter)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode2 = 0;
        hashCode2 = 31 * hashCode2 + (this.statesFilter == null ? 0 : this.statesFilter.hashCode());
        return hashCode2;
    }

    @Override
    public ListGroupsRequestData duplicate() {
        ListGroupsRequestData _duplicate = new ListGroupsRequestData();
        ArrayList<String> newStatesFilter = new ArrayList<String>(this.statesFilter.size());
        for (String _element : this.statesFilter) {
            newStatesFilter.add(_element);
        }
        _duplicate.statesFilter = newStatesFilter;
        return _duplicate;
    }

    public String toString() {
        return "ListGroupsRequestData(statesFilter=" + MessageUtil.deepToString(this.statesFilter.iterator()) + ")";
    }

    public List<String> statesFilter() {
        return this.statesFilter;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListGroupsRequestData setStatesFilter(List<String> v) {
        this.statesFilter = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[0]));
        SCHEMA_3 = new Schema(Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_4 = new Schema(new Field("states_filter", new CompactArrayOf(Type.COMPACT_STRING), "The states of the groups we want to list. If empty all groups are returned with their state."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }
}

