/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.TaggedFields;
import org.apache.kafka.common.protocol.types.Type;

public class Field {
    public final String name;
    public final String docString;
    public final Type type;
    public final boolean hasDefaultValue;
    public final Object defaultValue;

    public Field(String name2, Type type2, String docString, boolean hasDefaultValue, Object defaultValue) {
        this.name = name2;
        this.docString = docString;
        this.type = type2;
        this.hasDefaultValue = hasDefaultValue;
        this.defaultValue = defaultValue;
        if (hasDefaultValue) {
            type2.validate(defaultValue);
        }
    }

    public Field(String name2, Type type2, String docString) {
        this(name2, type2, docString, false, null);
    }

    public Field(String name2, Type type2, String docString, Object defaultValue) {
        this(name2, type2, docString, true, defaultValue);
    }

    public Field(String name2, Type type2) {
        this(name2, type2, null, false, null);
    }

    public static class ComplexArray {
        public final String name;
        public final String docString;

        public ComplexArray(String name2, String docString) {
            this.name = name2;
            this.docString = docString;
        }

        public Field withFields(Field ... fields2) {
            Schema elementType = new Schema(fields2);
            return new Field(this.name, new ArrayOf(elementType), this.docString, false, null);
        }

        public Field nullableWithFields(Field ... fields2) {
            Schema elementType = new Schema(fields2);
            return new Field(this.name, ArrayOf.nullable(elementType), this.docString, false, null);
        }

        public Field withFields(String docStringOverride, Field ... fields2) {
            Schema elementType = new Schema(fields2);
            return new Field(this.name, new ArrayOf(elementType), docStringOverride, false, null);
        }
    }

    public static class TaggedFieldsSection
    extends Field {
        private static final String NAME = "_tagged_fields";
        private static final String DOC_STRING = "The tagged fields";

        public static TaggedFieldsSection of(Object ... fields2) {
            return new TaggedFieldsSection(TaggedFields.of(fields2));
        }

        public TaggedFieldsSection(Type type2) {
            super(NAME, type2, DOC_STRING, false, null);
        }
    }

    public static class CompactArray
    extends Field {
        public CompactArray(String name2, Type elementType, String docString) {
            super(name2, new CompactArrayOf(elementType), docString, false, null);
        }
    }

    public static class Array
    extends Field {
        public Array(String name2, Type elementType, String docString) {
            super(name2, new ArrayOf(elementType), docString, false, null);
        }
    }

    public static class Bool
    extends Field {
        public Bool(String name2, String docString) {
            super(name2, Type.BOOLEAN, docString, false, null);
        }
    }

    public static class CompactNullableStr
    extends Field {
        public CompactNullableStr(String name2, String docString) {
            super(name2, Type.COMPACT_NULLABLE_STRING, docString, false, null);
        }
    }

    public static class NullableStr
    extends Field {
        public NullableStr(String name2, String docString) {
            super(name2, Type.NULLABLE_STRING, docString, false, null);
        }
    }

    public static class CompactStr
    extends Field {
        public CompactStr(String name2, String docString) {
            super(name2, Type.COMPACT_STRING, docString, false, null);
        }
    }

    public static class Str
    extends Field {
        public Str(String name2, String docString) {
            super(name2, Type.STRING, docString, false, null);
        }
    }

    public static class Float64
    extends Field {
        public Float64(String name2, String docString) {
            super(name2, Type.FLOAT64, docString, false, null);
        }

        public Float64(String name2, String docString, double defaultValue) {
            super(name2, Type.FLOAT64, docString, true, defaultValue);
        }
    }

    public static class Uint32
    extends Field {
        public Uint32(String name2, String docString) {
            super(name2, Type.UNSIGNED_INT32, docString, false, null);
        }
    }

    public static class Uint16
    extends Field {
        public Uint16(String name2, String docString) {
            super(name2, Type.UINT16, docString, false, null);
        }
    }

    public static class Int16
    extends Field {
        public Int16(String name2, String docString) {
            super(name2, Type.INT16, docString, false, null);
        }
    }

    public static class UUID
    extends Field {
        public UUID(String name2, String docString) {
            super(name2, Type.UUID, docString, false, null);
        }

        public UUID(String name2, String docString, UUID defaultValue) {
            super(name2, Type.UUID, docString, true, defaultValue);
        }
    }

    public static class Int64
    extends Field {
        public Int64(String name2, String docString) {
            super(name2, Type.INT64, docString, false, null);
        }

        public Int64(String name2, String docString, long defaultValue) {
            super(name2, Type.INT64, docString, true, defaultValue);
        }
    }

    public static class Int32
    extends Field {
        public Int32(String name2, String docString) {
            super(name2, Type.INT32, docString, false, null);
        }

        public Int32(String name2, String docString, int defaultValue) {
            super(name2, Type.INT32, docString, true, defaultValue);
        }
    }

    public static class Int8
    extends Field {
        public Int8(String name2, String docString) {
            super(name2, Type.INT8, docString, false, null);
        }

        public Int8(String name2, String docString, byte defaultValue) {
            super(name2, Type.INT8, docString, true, defaultValue);
        }
    }
}

