/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.ControlledShutdownRequestData;
import org.apache.kafka.common.message.ControlledShutdownResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ControlledShutdownResponse;

public class ControlledShutdownRequest
extends AbstractRequest {
    private final ControlledShutdownRequestData data;

    private ControlledShutdownRequest(ControlledShutdownRequestData data2, short version) {
        super(ApiKeys.CONTROLLED_SHUTDOWN, version);
        this.data = data2;
    }

    @Override
    public ControlledShutdownResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ControlledShutdownResponseData data2 = new ControlledShutdownResponseData().setErrorCode(Errors.forException(e).code());
        return new ControlledShutdownResponse(data2);
    }

    public static ControlledShutdownRequest parse(ByteBuffer buffer, short version) {
        return new ControlledShutdownRequest(new ControlledShutdownRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public ControlledShutdownRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<ControlledShutdownRequest> {
        private final ControlledShutdownRequestData data;

        public Builder(ControlledShutdownRequestData data2, short desiredVersion) {
            super(ApiKeys.CONTROLLED_SHUTDOWN, desiredVersion);
            this.data = data2;
        }

        @Override
        public ControlledShutdownRequest build(short version) {
            return new ControlledShutdownRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

