/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class ShortDeserializer
implements Deserializer<Short> {
    @Override
    public Short deserialize(String topic, byte[] data2) {
        if (data2 == null) {
            return null;
        }
        if (data2.length != 2) {
            throw new SerializationException("Size of data received by ShortDeserializer is not 2");
        }
        short value = 0;
        for (byte b : data2) {
            value = (short)(value << 8);
            value = (short)(value | b & 0xFF);
        }
        return value;
    }
}

