/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.spark3.internal.ReflectUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.Spark3ParsePartitionUtil;
import org.apache.spark.sql.execution.datasources.SparkParsePartitionUtil;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class Spark3ParsePartitionUtil$
implements SparkParsePartitionUtil {
    public static final Spark3ParsePartitionUtil$ MODULE$ = new Spark3ParsePartitionUtil$();
    private static final ConcurrentHashMap<ZoneId, Tuple2<DateFormatter, TimestampFormatter>> cache = new ConcurrentHashMap(1);

    private ConcurrentHashMap<ZoneId, Tuple2<DateFormatter, TimestampFormatter>> cache() {
        return cache;
    }

    @Override
    public InternalRow parsePartition(Path path, boolean typeInference, Set<Path> basePaths, Map<String, DataType> userSpecifiedDataTypes, TimeZone tz, boolean validatePartitionValues) {
        Option partitionValues;
        Tuple2 tuple2 = this.cache().computeIfAbsent(tz.toZoneId(), zoneId -> {
            DateFormatter dateFormatter = ReflectUtil.getDateFormatter(zoneId);
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(PartitioningUtils$.MODULE$.timestampPartitionPattern(), zoneId, true);
            return new Tuple2((Object)dateFormatter, (Object)timestampFormatter);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DateFormatter dateFormatter = (DateFormatter)tuple2._1();
        TimestampFormatter timestampFormatter = (TimestampFormatter)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dateFormatter, (Object)timestampFormatter);
        Tuple2 tuple23 = tuple22;
        DateFormatter dateFormatter2 = (DateFormatter)tuple23._1();
        TimestampFormatter timestampFormatter2 = (TimestampFormatter)tuple23._2();
        Tuple2<Option<Spark3ParsePartitionUtil.PartitionValues>, Option<Path>> tuple24 = this.parsePartition(path, typeInference, basePaths, userSpecifiedDataTypes, validatePartitionValues, tz.toZoneId(), dateFormatter2, timestampFormatter2);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        Option option = partitionValues = (Option)tuple24._1();
        Option partitionValues2 = option;
        return (InternalRow)partitionValues2.map((Function1 & Serializable)x0$1 -> {
            Seq<String> seq;
            Seq<Spark3ParsePartitionUtil.TypedPartValue> typedValues;
            block3: {
                Spark3ParsePartitionUtil.PartitionValues partitionValues;
                block2: {
                    partitionValues = x0$1;
                    if (partitionValues == null) break block2;
                    Seq<String> columnNames = partitionValues.columnNames();
                    typedValues = partitionValues.typedValues();
                    if (columnNames == null) break block2;
                    seq = columnNames;
                    if (typedValues != null) break block3;
                }
                throw new MatchError((Object)partitionValues);
            }
            Seq<Spark3ParsePartitionUtil.TypedPartValue> seq2 = typedValues;
            Seq rowValues = (Seq)((IterableOps)seq.zip(seq2)).map((Function1 & Serializable)x0$2 -> {
                Object object;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String columnName = (String)tuple2._1();
                    Spark3ParsePartitionUtil.TypedPartValue typedValue = (Spark3ParsePartitionUtil.TypedPartValue)tuple2._2();
                    try {
                        object = MODULE$.castPartValueToDesiredType(typedValue.dataType(), typedValue.value(), tz.toZoneId());
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            if (validatePartitionValues) {
                                throw new RuntimeException(new StringBuilder(0).append(new StringBuilder(27).append("Failed to cast value `").append(typedValue.value()).append("` to ").toString()).append(new StringBuilder(26).append("`").append(typedValue.dataType()).append("` for partition column `").append(columnName).append("`").toString()).toString());
                            }
                        } else {
                            throw throwable;
                        }
                        Object var4_9 = null;
                        object = var4_9;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Object object2 = object;
                return object2;
            });
            InternalRow internalRow = InternalRow$.MODULE$.fromSeq(rowValues);
            return internalRow;
        }).getOrElse((Function0 & Serializable)() -> InternalRow$.MODULE$.empty());
    }

    private Tuple2<Option<Spark3ParsePartitionUtil.PartitionValues>, Option<Path>> parsePartition(Path path, boolean typeInference, Set<Path> basePaths, Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        Tuple2 tuple2;
        ArrayBuffer columns = ArrayBuffer$.MODULE$.empty();
        boolean finished = path.getParent() == null;
        Path currentPath = path;
        while (!finished) {
            String string = currentPath.getName().toLowerCase(Locale.ROOT);
            String string2 = "_temporary";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (basePaths.contains((Object)currentPath)) {
                finished = true;
                continue;
            }
            Option<Tuple2<String, Spark3ParsePartitionUtil.TypedPartValue>> maybeColumn = this.parsePartitionColumn(currentPath.getName(), typeInference, userSpecifiedDataTypes, validatePartitionColumns, zoneId, dateFormatter, timestampFormatter);
            maybeColumn.foreach((Function1 & Serializable)x$2 -> (ArrayBuffer)columns.$plus$eq(x$2));
            finished = maybeColumn.isEmpty() && !columns.isEmpty() || currentPath.getParent() == null;
            if (finished) continue;
            currentPath = currentPath.getParent();
        }
        if (columns.isEmpty()) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)path));
        } else {
            Tuple2 tuple22 = ((StrictOptimizedIterableOps)columns.reverse()).unzip(Predef$.MODULE$.$conforms());
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            ArrayBuffer columnNames = (ArrayBuffer)tuple22._1();
            ArrayBuffer values2 = (ArrayBuffer)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)columnNames, (Object)values2);
            Tuple2 tuple24 = tuple23;
            ArrayBuffer columnNames2 = (ArrayBuffer)tuple24._1();
            ArrayBuffer values3 = (ArrayBuffer)tuple24._2();
            tuple2 = new Tuple2((Object)new Some((Object)new Spark3ParsePartitionUtil.PartitionValues((Seq<String>)columnNames2.toSeq(), (Seq<Spark3ParsePartitionUtil.TypedPartValue>)values3.toSeq())), (Object)new Some((Object)currentPath));
        }
        return tuple2;
    }

    @Override
    public boolean parsePartition$default$6() {
        return false;
    }

    private Option<Tuple2<String, Spark3ParsePartitionUtil.TypedPartValue>> parsePartitionColumn(String columnSpec, boolean typeInference, Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        None$ none$;
        int equalSignIndex = columnSpec.indexOf(61);
        if (equalSignIndex == -1) {
            none$ = None$.MODULE$;
        } else {
            String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(columnSpec), equalSignIndex));
            Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(columnName)), (Function0 & Serializable)() -> new StringBuilder(33).append("Empty partition column name in '").append(columnSpec).append("'").toString());
            String rawColumnValue = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(columnSpec), equalSignIndex + 1);
            Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(rawColumnValue)), (Function0 & Serializable)() -> new StringBuilder(34).append("Empty partition column value in '").append(columnSpec).append("'").toString());
            DataType dataType = userSpecifiedDataTypes.contains((Object)columnName) ? (DataType)userSpecifiedDataTypes.apply((Object)columnName) : this.inferPartitionColumnValue(rawColumnValue, typeInference, zoneId, dateFormatter, timestampFormatter);
            none$ = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)new Spark3ParsePartitionUtil.TypedPartValue(rawColumnValue, dataType)));
        }
        return none$;
    }

    private DataType inferPartitionColumnValue(String raw, boolean typeInference, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        Object object;
        Try decimalTry = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            BigDecimal bigDecimal = new BigDecimal(raw);
            Predef$.MODULE$.require(bigDecimal.scale() <= 0);
            return MODULE$.fromDecimal(Decimal$.MODULE$.apply(bigDecimal));
        });
        Try dateTry = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            dateFormatter.parse(raw);
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)raw), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            Object dateValue = qual$1.eval(x$1);
            Predef$.MODULE$.require(dateValue != null);
            return DateType$.MODULE$;
        });
        Try timestampTry = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String unescapedRaw = ExternalCatalogUtils$.MODULE$.unescapePathName(raw);
            TimestampType$ timestampType = TimestampType$.MODULE$;
            timestampFormatter.parse(unescapedRaw);
            Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)unescapedRaw), (DataType)timestampType, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
            InternalRow x$2 = qual$2.eval$default$1();
            Object timestampValue = qual$2.eval(x$2);
            Predef$.MODULE$.require(timestampValue != null);
            return timestampType;
        });
        if (typeInference) {
            object = (DataType)Try$.MODULE$.apply((Function0 & Serializable)() -> {
                Integer.parseInt(raw);
                return IntegerType$.MODULE$;
            }).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
                Long.parseLong(raw);
                return LongType$.MODULE$;
            })).orElse((Function0 & Serializable)() -> decimalTry).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
                Double.parseDouble(raw);
                return DoubleType$.MODULE$;
            })).orElse((Function0 & Serializable)() -> timestampTry).orElse((Function0 & Serializable)() -> dateTry).getOrElse((Function0 & Serializable)() -> {
                String string = raw;
                String string2 = "__HIVE_DEFAULT_PARTITION__";
                return !(string != null ? !string.equals(string2) : string2 != null) ? NullType$.MODULE$ : StringType$.MODULE$;
            });
        } else {
            String string = raw;
            String string2 = "__HIVE_DEFAULT_PARTITION__";
            object = !(string != null ? !string.equals(string2) : string2 != null) ? NullType$.MODULE$ : StringType$.MODULE$;
        }
        return object;
    }

    public Object castPartValueToDesiredType(DataType desiredType, String value, ZoneId zoneId) {
        Object object;
        DataType dataType = desiredType;
        String string = value;
        String string2 = "__HIVE_DEFAULT_PARTITION__";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            object = null;
        } else if (NullType$.MODULE$.equals(dataType)) {
            object = null;
        } else if (StringType$.MODULE$.equals(dataType)) {
            object = UTF8String.fromString((String)ExternalCatalogUtils$.MODULE$.unescapePathName(value));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToByte((byte)((byte)Integer.parseInt(value)));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToShort((short)((short)Integer.parseInt(value)));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToInteger((int)Integer.parseInt(value));
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToLong((long)Long.parseLong(value));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToFloat((float)((float)Double.parseDouble(value)));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToDouble((double)Double.parseDouble(value));
        } else if (dataType instanceof DecimalType) {
            object = Literal$.MODULE$.apply((Object)new BigDecimal(value)).value();
        } else if (DateType$.MODULE$.equals(dataType)) {
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)value), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            object = qual$1.eval(x$1);
        } else if (dataType instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)dataType;
            object = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(value)), (DataType)timestampType, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
                InternalRow x$2 = qual$2.eval$default$1();
                return qual$2.eval(x$2);
            }).getOrElse((Function0 & Serializable)() -> {
                Cast qual$3 = new Cast((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)value), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4()), (DataType)timestampType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                InternalRow x$3 = qual$3.eval$default$1();
                return qual$3.eval(x$3);
            });
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            object = value.getBytes();
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(value)));
        } else {
            throw new IllegalArgumentException(new StringBuilder(16).append("Unexpected type ").append(dataType).toString());
        }
        return object;
    }

    private DecimalType fromDecimal(Decimal d) {
        return new DecimalType(d.precision(), d.scale());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Spark3ParsePartitionUtil$.class);
    }

    private Spark3ParsePartitionUtil$() {
    }
}

