/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.spark.sql.HoodieSchemaUtils;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HoodieParquetFileFormatHelper$ {
    public static final HoodieParquetFileFormatHelper$ MODULE$ = new HoodieParquetFileFormatHelper$();

    public Tuple2<java.util.Map<Integer, Pair<DataType, DataType>>, StructType> buildImplicitSchemaChangeInfo(Configuration hadoopConf, FileMetaData parquetFileMetaData, StructType requiredSchema) {
        ParquetToSparkSchemaConverter convert = new ParquetToSparkSchemaConverter(hadoopConf);
        StructType fileStruct = convert.convert(parquetFileMetaData.getSchema());
        return this.buildImplicitSchemaChangeInfo(fileStruct, requiredSchema);
    }

    public Tuple2<java.util.Map<Integer, Pair<DataType, DataType>>, StructType> buildImplicitSchemaChangeInfo(StructType fileStruct, StructType requiredSchema) {
        HashMap implicitTypeChangeInfo = new HashMap();
        Map fileStructMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fileStruct.fields()), (Function1 & Serializable)f -> new Tuple2((Object)f.name(), (Object)f.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Seq sparkRequestStructFields = (scala.collection.immutable.Seq)requiredSchema.map((Function1 & Serializable)f -> {
            StructField structField;
            DataType requiredType = f.dataType();
            if (fileStructMap.contains((Object)f.name()) && !MODULE$.isDataTypeEqual(requiredType, (DataType)fileStructMap.apply((Object)f.name()))) {
                DataType readerType = MODULE$.addMissingFields(requiredType, (DataType)fileStructMap.apply((Object)f.name()));
                implicitTypeChangeInfo.put(new Integer(requiredSchema.fieldIndex(f.name())), Pair.of(requiredType, readerType));
                structField = new StructField(f.name(), readerType, f.nullable(), StructField$.MODULE$.apply$default$4());
            } else {
                structField = f;
            }
            return structField;
        });
        return new Tuple2(implicitTypeChangeInfo, (Object)StructType$.MODULE$.apply(sparkRequestStructFields));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDataTypeEqual(DataType requiredType, DataType fileType) {
        Tuple2 tuple2;
        while (true) {
            if ((tuple2 = new Tuple2((Object)requiredType, (Object)fileType)) != null) {
                DataType requiredType2 = (DataType)tuple2._1();
                DataType fileType2 = (DataType)tuple2._2();
                DataType dataType = requiredType2;
                DataType dataType2 = fileType2;
                if (dataType == null) {
                    if (dataType2 == null) return true;
                } else if (dataType.equals(dataType2)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType rt = arrayType.elementType();
                    if (dataType3 instanceof ArrayType) {
                        DataType ft;
                        ArrayType arrayType2 = (ArrayType)dataType3;
                        fileType = ft = arrayType2.elementType();
                        requiredType = rt;
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (!(dataType instanceof MapType)) break;
            MapType mapType = (MapType)dataType;
            DataType requiredKey = mapType.keyType();
            DataType requiredValue = mapType.valueType();
            if (!(dataType4 instanceof MapType)) break;
            MapType mapType2 = (MapType)dataType4;
            DataType fileKey = mapType2.keyType();
            DataType fileValue = mapType2.valueType();
            if (!this.isDataTypeEqual(requiredKey, fileKey)) return false;
            fileType = fileValue;
            requiredType = requiredValue;
        }
        if (tuple2 == null) return false;
        DataType dataType = (DataType)tuple2._1();
        DataType dataType5 = (DataType)tuple2._2();
        if (!(dataType instanceof StructType)) return false;
        StructType structType = (StructType)dataType;
        StructField[] requiredFields = structType.fields();
        if (!(dataType5 instanceof StructType)) return false;
        StructType structType2 = (StructType)dataType5;
        StructField[] fileFields = structType2.fields();
        String[] commonFieldNames = (String[])ArrayOps$.MODULE$.intersect$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])requiredFields), (Function1 & Serializable)x$1 -> x$1.name(), ClassTag$.MODULE$.apply(String.class))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fileFields), (Function1 & Serializable)x$2 -> x$2.name(), ClassTag$.MODULE$.apply(String.class))));
        StructField[] fileFilteredFields = (StructField[])ArrayOps$.MODULE$.sortWith$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])fileFields), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])commonFieldNames), (Object)f.name())))), (Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(x$3.name()), x$4.name())));
        StructField[] requiredFilteredFields = (StructField[])ArrayOps$.MODULE$.sortWith$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])requiredFields), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])commonFieldNames), (Object)f.name())))), (Function2 & Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(x$5.name()), x$6.name())));
        return ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])requiredFilteredFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])fileFilteredFields))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$7(x0$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType addMissingFields(DataType requiredType, DataType fileType) {
        Tuple2 tuple2 = new Tuple2((Object)requiredType, (Object)fileType);
        if (tuple2 != null) {
            DataType requiredType2 = (DataType)tuple2._1();
            DataType fileType2 = (DataType)tuple2._2();
            DataType dataType = requiredType2;
            DataType dataType2 = fileType2;
            if (dataType == null) {
                if (dataType2 == null) return fileType2;
            } else if (dataType.equals(dataType2)) {
                return fileType2;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType rt = arrayType.elementType();
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType3;
                    DataType ft = arrayType2.elementType();
                    return ArrayType$.MODULE$.apply(this.addMissingFields(rt, ft));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType requiredKey = mapType.keyType();
                DataType requiredValue = mapType.valueType();
                if (dataType4 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType4;
                    DataType fileKey = mapType2.keyType();
                    DataType fileValue = mapType2.valueType();
                    return MapType$.MODULE$.apply(this.addMissingFields(requiredKey, fileKey), this.addMissingFields(requiredValue, fileValue));
                }
            }
        }
        if (tuple2 == null) return fileType;
        DataType dataType = (DataType)tuple2._1();
        DataType dataType5 = (DataType)tuple2._2();
        if (!(dataType instanceof StructType)) return fileType;
        StructType structType = (StructType)dataType;
        StructField[] requiredFields = structType.fields();
        if (!(dataType5 instanceof StructType)) return fileType;
        StructType structType2 = (StructType)dataType5;
        StructField[] fileFields = structType2.fields();
        Map fileFieldMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fileFields), (Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])requiredFields), (Function1 & Serializable)f -> {
            StructField structField;
            Option option = fileFieldMap.get((Object)f.name());
            if (option instanceof Some) {
                Some some = (Some)option;
                StructField ff = (StructField)some.value();
                structField = new StructField(ff.name(), MODULE$.addMissingFields(f.dataType(), ff.dataType()), ff.nullable(), ff.metadata());
            } else if (None$.MODULE$.equals(option)) {
                structField = f;
            } else {
                throw new MatchError((Object)option);
            }
            return structField;
        }, ClassTag$.MODULE$.apply(StructField.class)));
    }

    public UnsafeProjection generateUnsafeProjection(scala.collection.immutable.Seq<Attribute> fullSchema, Option<String> timeZoneId, java.util.Map<Integer, Pair<DataType, DataType>> typeChangeInfos, StructType requiredSchema, StructType partitionSchema, HoodieSchemaUtils schemaUtils) {
        UnsafeProjection unsafeProjection;
        if (typeChangeInfos.isEmpty()) {
            unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate(fullSchema, fullSchema);
        } else {
            StructType newSchema = new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                StructField structField = typeChangeInfos.containsKey(BoxesRunTime.boxToInteger((int)i)) ? new StructField(f.name(), (DataType)((Pair)typeChangeInfos.get(BoxesRunTime.boxToInteger((int)i))).getRight(), f.nullable(), f.metadata()) : f;
                return structField;
            }, ClassTag$.MODULE$.apply(StructField.class)));
            scala.collection.immutable.Seq newFullSchema = (scala.collection.immutable.Seq)schemaUtils.toAttributes(newSchema).$plus$plus(schemaUtils.toAttributes(partitionSchema));
            scala.collection.immutable.Seq castSchema = (scala.collection.immutable.Seq)((IterableOps)newFullSchema.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
                DataType srcType;
                boolean needTimeZone;
                DataType dstType;
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Attribute attr = (Attribute)tuple2._1();
                int i = tuple2._2$mcI$sp();
                Attribute attribute = typeChangeInfos.containsKey(BoxesRunTime.boxToInteger((int)i)) ? new Cast((Expression)attr, dstType, (Option)((needTimeZone = Cast$.MODULE$.needsTimeZone(srcType = (DataType)((Pair)typeChangeInfos.get(BoxesRunTime.boxToInteger((int)i))).getRight(), dstType = (DataType)((Pair)typeChangeInfos.get(BoxesRunTime.boxToInteger((int)i))).getLeft())) ? timeZoneId : None$.MODULE$), Cast$.MODULE$.apply$default$4()) : attr;
                return attribute;
            });
            unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)castSchema, newFullSchema);
        }
        return unsafeProjection;
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$7(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField requiredField = (StructField)tuple2._1();
        StructField fileFilteredField = (StructField)tuple2._2();
        boolean bl = MODULE$.isDataTypeEqual(requiredField.dataType(), fileFilteredField.dataType());
        return bl;
    }

    private HoodieParquetFileFormatHelper$() {
    }
}

