/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.HoodieSQLOption;
import org.apache.spark.sql.hudi.HoodieSQLOptionBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class HoodieOptionConfig$ {
    public static final HoodieOptionConfig$ MODULE$ = new HoodieOptionConfig$();
    private static Map<String, String> sqlOptionKeyToWriteConfigKey;
    private static Map<String, String> writeConfigKeyToSqlOptionKey;
    private static Map<String, String> sqlOptionKeyToTableConfigKey;
    private static Map<String, String> tableConfigKeyToSqlOptionKey;
    private static Map<String, String> hoodieConfigValueToSqlOptionValue;
    private static final String SQL_VALUE_TABLE_TYPE_COW;
    private static final String SQL_VALUE_TABLE_TYPE_MOR;
    private static final HoodieSQLOption<String> SQL_KEY_TABLE_PRIMARY_KEY;
    private static final HoodieSQLOption<String> SQL_KEY_TABLE_TYPE;
    private static final HoodieSQLOption<String> SQL_KEY_PRECOMBINE_FIELD;
    private static final HoodieSQLOption<String> SQL_PAYLOAD_CLASS;
    private static final HoodieSQLOption<String> SQL_RECORD_MERGE_MODE;
    private static final HoodieSQLOption<String> SQL_RECORD_MERGE_STRATEGY_ID;
    private static final Map<String, String> sqlOptionValueToHoodieConfigValue;
    private static final Map<String, String> defaultSqlOptions;
    private static volatile byte bitmap$0;

    static {
        SQL_VALUE_TABLE_TYPE_COW = "cow";
        SQL_VALUE_TABLE_TYPE_MOR = "mor";
        SQL_KEY_TABLE_PRIMARY_KEY = MODULE$.buildConf().withSqlKey("primaryKey").withHoodieKey(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()).withTableConfigKey(HoodieTableConfig.RECORDKEY_FIELDS.key()).build();
        SQL_KEY_TABLE_TYPE = MODULE$.buildConf().withSqlKey("type").withHoodieKey(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()).withTableConfigKey(HoodieTableConfig.TYPE.key()).defaultValue(MODULE$.SQL_VALUE_TABLE_TYPE_COW()).build();
        SQL_KEY_PRECOMBINE_FIELD = MODULE$.buildConf().withSqlKey("preCombineField").withHoodieKey(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()).withTableConfigKey(HoodieTableConfig.PRECOMBINE_FIELD.key()).build();
        SQL_PAYLOAD_CLASS = MODULE$.buildConf().withSqlKey("payloadClass").withHoodieKey(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().key()).withTableConfigKey(HoodieTableConfig.PAYLOAD_CLASS_NAME.key()).build();
        SQL_RECORD_MERGE_MODE = MODULE$.buildConf().withSqlKey("recordMergeMode").withHoodieKey(HoodieWriteConfig.RECORD_MERGE_MODE.key()).withTableConfigKey(HoodieTableConfig.RECORD_MERGE_MODE.key()).build();
        SQL_RECORD_MERGE_STRATEGY_ID = MODULE$.buildConf().withSqlKey("recordMergeStrategyId").withHoodieKey(DataSourceWriteOptions$.MODULE$.RECORD_MERGE_STRATEGY_ID().key()).withTableConfigKey(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID.key()).build();
        sqlOptionValueToHoodieConfigValue = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.SQL_VALUE_TABLE_TYPE_COW()), (Object)HoodieTableType.COPY_ON_WRITE.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.SQL_VALUE_TABLE_TYPE_MOR()), (Object)HoodieTableType.MERGE_ON_READ.name())}));
        defaultSqlOptions = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])MODULE$.getClass().getDeclaredFields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$defaultSqlOptions$1(f)))), (Function1 & Serializable)f -> {
            f.setAccessible(true);
            return (HoodieSQLOption)f.get(MODULE$);
        }, ClassTag$.MODULE$.apply(HoodieSQLOption.class))), (Function1 & Serializable)option -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$defaultSqlOptions$3(option)))), (Function1 & Serializable)option -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)option.sqlKeyName()), (Object)option.defaultValue().get().toString()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String SQL_VALUE_TABLE_TYPE_COW() {
        return SQL_VALUE_TABLE_TYPE_COW;
    }

    public String SQL_VALUE_TABLE_TYPE_MOR() {
        return SQL_VALUE_TABLE_TYPE_MOR;
    }

    public HoodieSQLOption<String> SQL_KEY_TABLE_PRIMARY_KEY() {
        return SQL_KEY_TABLE_PRIMARY_KEY;
    }

    public HoodieSQLOption<String> SQL_KEY_TABLE_TYPE() {
        return SQL_KEY_TABLE_TYPE;
    }

    public HoodieSQLOption<String> SQL_KEY_PRECOMBINE_FIELD() {
        return SQL_KEY_PRECOMBINE_FIELD;
    }

    public HoodieSQLOption<String> SQL_PAYLOAD_CLASS() {
        return SQL_PAYLOAD_CLASS;
    }

    public HoodieSQLOption<String> SQL_RECORD_MERGE_MODE() {
        return SQL_RECORD_MERGE_MODE;
    }

    public HoodieSQLOption<String> SQL_RECORD_MERGE_STRATEGY_ID() {
        return SQL_RECORD_MERGE_STRATEGY_ID;
    }

    private Map<String, String> sqlOptionKeyToWriteConfigKey$lzycompute() {
        HoodieOptionConfig$ hoodieOptionConfig$ = this;
        synchronized (hoodieOptionConfig$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                sqlOptionKeyToWriteConfigKey = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.getClass().getDeclaredFields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$sqlOptionKeyToWriteConfigKey$1(f)))), (Function1 & Serializable)f -> {
                    f.setAccessible(true);
                    return (HoodieSQLOption)f.get(MODULE$);
                }, ClassTag$.MODULE$.apply(HoodieSQLOption.class))), (Function1 & Serializable)option -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)option.sqlKeyName()), (Object)option.hoodieKeyName()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return sqlOptionKeyToWriteConfigKey;
    }

    private Map<String, String> sqlOptionKeyToWriteConfigKey() {
        return (byte)(bitmap$0 & 1) == 0 ? this.sqlOptionKeyToWriteConfigKey$lzycompute() : sqlOptionKeyToWriteConfigKey;
    }

    private Map<String, String> writeConfigKeyToSqlOptionKey$lzycompute() {
        HoodieOptionConfig$ hoodieOptionConfig$ = this;
        synchronized (hoodieOptionConfig$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                writeConfigKeyToSqlOptionKey = (Map)this.sqlOptionKeyToWriteConfigKey().map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._2()), f._1()));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return writeConfigKeyToSqlOptionKey;
    }

    private Map<String, String> writeConfigKeyToSqlOptionKey() {
        return (byte)(bitmap$0 & 2) == 0 ? this.writeConfigKeyToSqlOptionKey$lzycompute() : writeConfigKeyToSqlOptionKey;
    }

    private Map<String, String> sqlOptionKeyToTableConfigKey$lzycompute() {
        HoodieOptionConfig$ hoodieOptionConfig$ = this;
        synchronized (hoodieOptionConfig$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                sqlOptionKeyToTableConfigKey = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.getClass().getDeclaredFields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$sqlOptionKeyToTableConfigKey$1(f)))), (Function1 & Serializable)f -> {
                    f.setAccessible(true);
                    return (HoodieSQLOption)f.get(MODULE$);
                }, ClassTag$.MODULE$.apply(HoodieSQLOption.class))), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$sqlOptionKeyToTableConfigKey$3(x$1)))), (Function1 & Serializable)option -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)option.sqlKeyName()), option.tableConfigKey().get()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return sqlOptionKeyToTableConfigKey;
    }

    private Map<String, String> sqlOptionKeyToTableConfigKey() {
        return (byte)(bitmap$0 & 4) == 0 ? this.sqlOptionKeyToTableConfigKey$lzycompute() : sqlOptionKeyToTableConfigKey;
    }

    private Map<String, String> tableConfigKeyToSqlOptionKey$lzycompute() {
        HoodieOptionConfig$ hoodieOptionConfig$ = this;
        synchronized (hoodieOptionConfig$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                tableConfigKeyToSqlOptionKey = (Map)this.sqlOptionKeyToTableConfigKey().map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._2()), f._1()));
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return tableConfigKeyToSqlOptionKey;
    }

    private Map<String, String> tableConfigKeyToSqlOptionKey() {
        return (byte)(bitmap$0 & 8) == 0 ? this.tableConfigKeyToSqlOptionKey$lzycompute() : tableConfigKeyToSqlOptionKey;
    }

    private Map<String, String> sqlOptionValueToHoodieConfigValue() {
        return sqlOptionValueToHoodieConfigValue;
    }

    private Map<String, String> hoodieConfigValueToSqlOptionValue$lzycompute() {
        HoodieOptionConfig$ hoodieOptionConfig$ = this;
        synchronized (hoodieOptionConfig$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                hoodieConfigValueToSqlOptionValue = (Map)this.sqlOptionValueToHoodieConfigValue().map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._2()), f._1()));
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return hoodieConfigValueToSqlOptionValue;
    }

    private Map<String, String> hoodieConfigValueToSqlOptionValue() {
        return (byte)(bitmap$0 & 0x10) == 0 ? this.hoodieConfigValueToSqlOptionValue$lzycompute() : hoodieConfigValueToSqlOptionValue;
    }

    public Map<String, String> withDefaultSqlOptions(Map<String, String> options) {
        return (Map)this.defaultSqlOptions().$plus$plus(options);
    }

    public Map<String, String> mapSqlOptionsToDataSourceWriteConfigs(Map<String, String> options) {
        return (Map)options.map((Function1 & Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.sqlOptionKeyToWriteConfigKey().getOrElse(kv._1(), (Function0 & Serializable)() -> (String)kv._1())), MODULE$.sqlOptionValueToHoodieConfigValue().getOrElse(kv._2(), (Function0 & Serializable)() -> (String)kv._2())));
    }

    public Map<String, String> mapHoodieConfigsToSqlOptions(Map<String, String> options) {
        return (Map)options.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = MODULE$.writeConfigKeyToSqlOptionKey().contains((Object)k) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.writeConfigKeyToSqlOptionKey().apply((Object)k)), MODULE$.hoodieConfigValueToSqlOptionValue().getOrElse((Object)v, (Function0 & Serializable)() -> v)) : (MODULE$.tableConfigKeyToSqlOptionKey().contains((Object)k) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.tableConfigKeyToSqlOptionKey().apply((Object)k)), MODULE$.hoodieConfigValueToSqlOptionValue().getOrElse((Object)v, (Function0 & Serializable)() -> v)) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v));
            return tuple22;
        });
    }

    public Map<String, String> mapSqlOptionsToTableConfigs(Map<String, String> options) {
        return (Map)options.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = MODULE$.sqlOptionKeyToTableConfigKey().contains((Object)k) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.sqlOptionKeyToTableConfigKey().apply((Object)k)), MODULE$.sqlOptionValueToHoodieConfigValue().getOrElse((Object)v.toLowerCase(), (Function0 & Serializable)() -> v)) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            return tuple22;
        });
    }

    public Map<String, String> defaultSqlOptions() {
        return defaultSqlOptions;
    }

    public String getTableType(Map<String, String> options) {
        Map<String, String> params = this.mapSqlOptionsToDataSourceWriteConfigs(options);
        return (String)params.getOrElse((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), (Function0 & Serializable)() -> DataSourceWriteOptions$.MODULE$.TABLE_TYPE().defaultValue());
    }

    public Option<String> getPreCombineField(Map<String, String> options) {
        Map<String, String> params = this.mapSqlOptionsToDataSourceWriteConfigs(options);
        return params.get((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2))));
    }

    public Map<String, String> deleteHoodieOptions(Map<String, String> options) {
        return (Map)((IterableOps)options.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$deleteHoodieOptions$1(x$3)))).filterNot((Function1 & Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$deleteHoodieOptions$2(kv)));
    }

    public Map<String, String> extractHoodieOptions(Map<String, String> options) {
        return (Map)((MapOps)options.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$extractHoodieOptions$1(x$4)))).$plus$plus(this.extractSqlOptions(options));
    }

    public Map<String, String> extractSqlOptions(Map<String, String> options) {
        Map<String, String> sqlOptions = this.mapHoodieConfigsToSqlOptions(options);
        Set targetOptions = (Set)this.sqlOptionKeyToWriteConfigKey().keySet().$minus$minus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.SQL_PAYLOAD_CLASS().sqlKeyName(), this.SQL_RECORD_MERGE_STRATEGY_ID().sqlKeyName(), this.SQL_RECORD_MERGE_MODE().sqlKeyName()})));
        return sqlOptions.filterKeys((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)targetOptions.contains((Object)elem))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void validateTable(SparkSession spark, StructType schema, Map<String, String> sqlOptions) {
        block2: {
            Option preCombineKey;
            Function2 resolver2 = spark.sessionState().conf().resolver();
            Option primaryKeys = sqlOptions.get((Object)this.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName()).map((Function1 & Serializable)x$5 -> (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])x$5.split(",")), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$validateTable$2(x$6))));
            if (primaryKeys.isDefined()) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])primaryKeys.get()), (Function1 & Serializable)primaryKey -> {
                    HoodieOptionConfig$.$anonfun$validateTable$3(schema, resolver2, primaryKey);
                    return BoxedUnit.UNIT;
                });
            }
            if ((preCombineKey = sqlOptions.get((Object)this.SQL_KEY_PRECOMBINE_FIELD().sqlKeyName())).isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)preCombineKey.get()))) {
                ValidationUtils.checkArgument(schema.exists((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$validateTable$5(resolver2, preCombineKey, f))), new StringBuilder(32).append("Can't find preCombineKey `").append(preCombineKey.get()).append("` in ").append(schema.treeString()).append(".").toString());
            }
            Option tableType = sqlOptions.get((Object)this.SQL_KEY_TABLE_TYPE().sqlKeyName());
            ValidationUtils.checkArgument(tableType.nonEmpty(), "No `type` is specified.");
            ValidationUtils.checkArgument(((String)tableType.get()).equalsIgnoreCase(this.SQL_VALUE_TABLE_TYPE_COW()) || ((String)tableType.get()).equalsIgnoreCase(this.SQL_VALUE_TABLE_TYPE_MOR()), new StringBuilder(23).append("'type' must be '").append(this.SQL_VALUE_TABLE_TYPE_COW()).append("' or '").append(this.SQL_VALUE_TABLE_TYPE_MOR()).append("'").toString());
            Option indexType = sqlOptions.get((Object)HoodieIndexConfig.INDEX_TYPE.key());
            if (indexType.isEmpty()) break block2;
            HoodieIndexConfig.INDEX_TYPE.checkValues((String)indexType.get());
        }
    }

    public <T> HoodieSQLOptionBuilder<T> buildConf() {
        return new HoodieSQLOptionBuilder();
    }

    public Map<String, String> makeOptionsCaseInsensitive(Map<String, String> sqlOptions) {
        Seq standardOptions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HoodieSQLOption[]{this.SQL_KEY_TABLE_PRIMARY_KEY(), this.SQL_KEY_PRECOMBINE_FIELD(), this.SQL_KEY_TABLE_TYPE(), this.SQL_PAYLOAD_CLASS(), this.SQL_RECORD_MERGE_STRATEGY_ID(), this.SQL_RECORD_MERGE_MODE()})).map((Function1 & Serializable)key -> key.sqlKeyName());
        return (Map)sqlOptions.map((Function1 & Serializable)option -> {
            Tuple2 tuple2;
            Option option2 = standardOptions.find((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$makeOptionsCaseInsensitive$3(option, x)));
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String standardKey = (String)some.value();
                tuple2 = new Tuple2((Object)standardKey, option._2());
            } else if (None$.MODULE$.equals(option2)) {
                tuple2 = new Tuple2(option._1(), option._2());
            } else {
                throw new MatchError((Object)option2);
            }
            return tuple2;
        });
    }

    public static final /* synthetic */ boolean $anonfun$sqlOptionKeyToWriteConfigKey$1(Field f) {
        Class<?> clazz = f.getType();
        Class<HoodieSQLOption> clazz2 = HoodieSQLOption.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sqlOptionKeyToTableConfigKey$1(Field f) {
        Class<?> clazz = f.getType();
        Class<HoodieSQLOption> clazz2 = HoodieSQLOption.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sqlOptionKeyToTableConfigKey$3(HoodieSQLOption x$1) {
        return x$1.tableConfigKey().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$defaultSqlOptions$1(Field f) {
        Class<?> clazz = f.getType();
        Class<HoodieSQLOption> clazz2 = HoodieSQLOption.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$defaultSqlOptions$3(HoodieSQLOption option) {
        return option.tableConfigKey().isDefined() && option.defaultValue().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$deleteHoodieOptions$1(Tuple2 x$3) {
        return ((String)x$3._1()).startsWith("hoodie.");
    }

    public static final /* synthetic */ boolean $anonfun$deleteHoodieOptions$2(Tuple2 kv) {
        return MODULE$.sqlOptionKeyToWriteConfigKey().contains(kv._1());
    }

    public static final /* synthetic */ boolean $anonfun$extractHoodieOptions$1(Tuple2 x$4) {
        return ((String)x$4._1()).startsWith("hoodie.");
    }

    public static final /* synthetic */ boolean $anonfun$validateTable$2(String x$6) {
        return x$6.length() > 0;
    }

    public static final /* synthetic */ boolean $anonfun$validateTable$4(Function2 resolver$1, String primaryKey$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)HoodieAvroUtils.getRootLevelFieldName(primaryKey$1)));
    }

    public static final /* synthetic */ void $anonfun$validateTable$3(StructType schema$1, Function2 resolver$1, String primaryKey) {
        ValidationUtils.checkArgument(schema$1.exists((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$validateTable$4(resolver$1, primaryKey, f))), new StringBuilder(29).append("Can't find primaryKey `").append(primaryKey).append("` in ").append(schema$1.treeString()).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$validateTable$5(Function2 resolver$1, Option preCombineKey$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)HoodieAvroUtils.getRootLevelFieldName((String)preCombineKey$1.get())));
    }

    public static final /* synthetic */ boolean $anonfun$makeOptionsCaseInsensitive$3(Tuple2 option$1, String x) {
        return x.toLowerCase().contains(((String)option$1._1()).toLowerCase());
    }

    private HoodieOptionConfig$() {
    }
}

