/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.client.SparkTaskContextSupplier;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hadoop.HoodieAvroParquetWriter;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.runtime.BoxedUnit;

public final class SparkHelpers$ {
    public static final SparkHelpers$ MODULE$ = new SparkHelpers$();

    public void skipKeysAndWriteNewFile(String instantTime, StorageConfiguration<Configuration> conf, HoodieStorage storage2, StoragePath sourceFile, StoragePath destinationFile, Set<String> keysToSkip) throws Exception {
        Buffer sourceRecords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieIOFactory.getIOFactory(storage2).getFileFormatUtils(HoodieFileFormat.PARQUET).readAvroRecords(storage2, sourceFile)).asScala();
        Schema schema = ((GenericContainer)sourceRecords.head()).getSchema();
        BloomFilter filter = BloomFilterFactory.createBloomFilter(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(HoodieStorageConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE.defaultValue())), StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(HoodieStorageConfig.BLOOM_FILTER_FPP_VALUE.defaultValue())), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(HoodieStorageConfig.BLOOM_FILTER_DYNAMIC_MAX_ENTRIES.defaultValue())), HoodieStorageConfig.BLOOM_FILTER_TYPE.defaultValue());
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter(conf.unwrap()).convert(schema), schema, Option.of(filter), new Properties());
        HoodieParquetConfig<HoodieAvroWriteSupport> parquetConfig = new HoodieParquetConfig<HoodieAvroWriteSupport>(writeSupport, CompressionCodecName.GZIP, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(HoodieStorageConfig.PARQUET_BLOCK_SIZE.defaultValue())), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(HoodieStorageConfig.PARQUET_PAGE_SIZE.defaultValue())), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.defaultValue())), conf, StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION.defaultValue())), Predef$.MODULE$.Boolean2boolean(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED.defaultValue()));
        conf.unwrap().setClassLoader(Thread.currentThread().getContextClassLoader());
        HoodieAvroParquetWriter writer = new HoodieAvroParquetWriter(destinationFile, parquetConfig, instantTime, new SparkTaskContextSupplier(), true);
        sourceRecords.foreach((Function1 & Serializable)rec -> {
            SparkHelpers$.$anonfun$skipKeysAndWriteNewFile$1(keysToSkip, writer, rec);
            return BoxedUnit.UNIT;
        });
        writer.close();
    }

    public static final /* synthetic */ void $anonfun$skipKeysAndWriteNewFile$1(Set keysToSkip$1, HoodieAvroParquetWriter writer$1, GenericRecord rec) {
        block0: {
            String key = rec.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            if (keysToSkip$1.contains((Object)key)) break block0;
            writer$1.writeAvro(key, (IndexedRecord)rec);
        }
    }

    private SparkHelpers$() {
    }
}

