/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.analysis;

import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.command.AlterTableAddColumnsCommand;
import org.apache.spark.sql.execution.command.AlterTableAddPartitionCommand;
import org.apache.spark.sql.execution.command.AlterTableChangeColumnCommand;
import org.apache.spark.sql.execution.command.AlterTableDropPartitionCommand;
import org.apache.spark.sql.execution.command.AlterTableRenameCommand;
import org.apache.spark.sql.execution.command.CreateDataSourceTableCommand;
import org.apache.spark.sql.execution.command.DropTableCommand;
import org.apache.spark.sql.execution.command.ShowCreateTableCommand;
import org.apache.spark.sql.execution.command.ShowPartitionsCommand;
import org.apache.spark.sql.execution.command.TruncateTableCommand;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$MatchCreateTableLike$;
import org.apache.spark.sql.hudi.analysis.HoodiePostAnalysisRule$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddPartitionCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableDropPartitionCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableRenameCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableLikeCommand;
import org.apache.spark.sql.hudi.command.DropHoodieTableCommand;
import org.apache.spark.sql.hudi.command.RepairHoodieTableCommand;
import org.apache.spark.sql.hudi.command.ShowHoodieCreateTableCommand;
import org.apache.spark.sql.hudi.command.ShowHoodieTablePartitionsCommand;
import org.apache.spark.sql.hudi.command.TruncateHoodieTableCommand;
import org.apache.spark.sql.types.StructField;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001B\f\u0019\u0001\u0016B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0015\")q\n\u0001C\u0001!\")A\u000b\u0001C!+\"9\u0001\fAA\u0001\n\u0003I\u0006bB.\u0001#\u0003%\t\u0001\u0018\u0005\bO\u0002\t\t\u0011\"\u0011i\u0011\u001d\t\b!!A\u0005\u0002IDqA\u001e\u0001\u0002\u0002\u0013\u0005q\u000fC\u0004~\u0001\u0005\u0005I\u0011\t@\t\u0013\u0005-\u0001!!A\u0005\u0002\u00055\u0001\"CA\f\u0001\u0005\u0005I\u0011IA\r\u0011%\ti\u0002AA\u0001\n\u0003\ny\u0002C\u0005\u0002\"\u0001\t\t\u0011\"\u0011\u0002$!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0013qE\u0004\n\u0003WA\u0012\u0011!E\u0001\u0003[1\u0001b\u0006\r\u0002\u0002#\u0005\u0011q\u0006\u0005\u0007\u001fF!\t!a\u0012\t\u0013\u0005\u0005\u0012#!A\u0005F\u0005\r\u0002\u0002\u0003+\u0012\u0003\u0003%\t)!\u0013\t\u0013\u00055\u0013#!A\u0005\u0002\u0006=\u0003\"CA.#\u0005\u0005I\u0011BA/\u0005YAun\u001c3jKB{7\u000f^!oC2L8/[:Sk2,'BA\r\u001b\u0003!\tg.\u00197zg&\u001c(BA\u000e\u001d\u0003\u0011AW\u000fZ5\u000b\u0005uq\u0012aA:rY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011c\u0007\u0010\t\u0004O1rS\"\u0001\u0015\u000b\u0005%R\u0013!\u0002:vY\u0016\u001c(BA\u0016\u001d\u0003!\u0019\u0017\r^1msN$\u0018BA\u0017)\u0005\u0011\u0011V\u000f\\3\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003g)\nQ\u0001\u001d7b]NL!!\u000e\u0019\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b!J|G-^2u!\tiTI\u0004\u0002?\u0007:\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tJ\u0001\u0007yI|w\u000e\u001e \n\u0003eJ!\u0001\u0012\u001d\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\tb\nAb\u001d9be.\u001cVm]:j_:,\u0012A\u0013\t\u0003\u00172k\u0011\u0001H\u0005\u0003\u001br\u0011Ab\u00159be.\u001cVm]:j_:\fQb\u001d9be.\u001cVm]:j_:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002R'B\u0011!\u000bA\u0007\u00021!)\u0001j\u0001a\u0001\u0015\u0006)\u0011\r\u001d9msR\u0011aF\u0016\u0005\u0006/\u0012\u0001\rAL\u0001\u0005a2\fg.\u0001\u0003d_BLHCA)[\u0011\u001dAU\u0001%AA\u0002)\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001^U\tQelK\u0001`!\t\u0001W-D\u0001b\u0015\t\u00117-A\u0005v]\u000eDWmY6fI*\u0011A\rO\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00014b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003%\u0004\"A[8\u000e\u0003-T!\u0001\\7\u0002\t1\fgn\u001a\u0006\u0002]\u0006!!.\u0019<b\u0013\t\u00018N\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002gB\u0011q\u0007^\u0005\u0003kb\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"\u0001_>\u0011\u0005]J\u0018B\u0001>9\u0005\r\te.\u001f\u0005\by&\t\t\u00111\u0001t\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\tq\u0010E\u0003\u0002\u0002\u0005\u001d\u00010\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\n\u0005\r!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0004\u0002\u0016A\u0019q'!\u0005\n\u0007\u0005M\u0001HA\u0004C_>dW-\u00198\t\u000fq\\\u0011\u0011!a\u0001q\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\rI\u00171\u0004\u0005\by2\t\t\u00111\u0001t\u0003!A\u0017m\u001d5D_\u0012,G#A:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012![\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=\u0011\u0011\u0006\u0005\by>\t\t\u00111\u0001y\u0003YAun\u001c3jKB{7\u000f^!oC2L8/[:Sk2,\u0007C\u0001*\u0012'\u0015\t\u0012\u0011GA\u001f!\u0019\t\u0019$!\u000fK#6\u0011\u0011Q\u0007\u0006\u0004\u0003oA\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003w\t)DA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007j\u0017AA5p\u0013\r1\u0015\u0011\t\u000b\u0003\u0003[!2!UA&\u0011\u0015AE\u00031\u0001K\u0003\u001d)h.\u00199qYf$B!!\u0015\u0002XA!q'a\u0015K\u0013\r\t)\u0006\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005eS#!AA\u0002E\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\u0006E\u0002k\u0003CJ1!a\u0019l\u0005\u0019y%M[3di\u0002")
public class HoodiePostAnalysisRule
extends Rule<LogicalPlan>
implements Product,
Serializable {
    private final SparkSession sparkSession;

    public static Option<SparkSession> unapply(HoodiePostAnalysisRule x$0) {
        return HoodiePostAnalysisRule$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<SparkSession, A> andThen(Function1<HoodiePostAnalysisRule, A> g) {
        return HoodiePostAnalysisRule$.MODULE$.andThen(g);
    }

    public static <A> Function1<A, HoodiePostAnalysisRule> compose(Function1<A, SparkSession> g) {
        return HoodiePostAnalysisRule$.MODULE$.compose(g);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public LogicalPlan apply(LogicalPlan plan) {
        Option<Tuple6<TableIdentifier, TableIdentifier, CatalogStorageFormat, Option<String>, Map<String, String>, Object>> option;
        void var2_19;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof CreateDataSourceTableCommand) {
            CreateDataSourceTableCommand createDataSourceTableCommand = (CreateDataSourceTableCommand)logicalPlan;
            CatalogTable table = createDataSourceTableCommand.table();
            boolean ignoreIfExists = createDataSourceTableCommand.ignoreIfExists();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(table)) {
                CreateHoodieTableCommand createHoodieTableCommand = new CreateHoodieTableCommand(table, ignoreIfExists);
                return var2_19;
            }
        }
        if (logicalPlan != null && !(option = HoodieAnalysis$MatchCreateTableLike$.MODULE$.unapply(logicalPlan)).isEmpty()) {
            TableIdentifier targetTable = (TableIdentifier)((Tuple6)option.get())._1();
            TableIdentifier sourceTable = (TableIdentifier)((Tuple6)option.get())._2();
            CatalogStorageFormat fileFormat = (CatalogStorageFormat)((Tuple6)option.get())._3();
            Option provider = (Option)((Tuple6)option.get())._4();
            Map properties2 = (Map)((Tuple6)option.get())._5();
            boolean ifNotExists = BoxesRunTime.unboxToBoolean((Object)((Tuple6)option.get())._6());
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable((String)provider.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))) {
                CreateHoodieTableLikeCommand createHoodieTableLikeCommand = new CreateHoodieTableLikeCommand(targetTable, sourceTable, fileFormat, (Map<String, String>)properties2, ifNotExists);
                return var2_19;
            }
        }
        if (logicalPlan instanceof DropTableCommand) {
            DropTableCommand dropTableCommand = (DropTableCommand)logicalPlan;
            TableIdentifier tableName = dropTableCommand.tableName();
            boolean ifExists = dropTableCommand.ifExists();
            boolean bl = dropTableCommand.isView();
            boolean purge = dropTableCommand.purge();
            if (!bl && this.sparkSession().sessionState().catalog().tableExists(tableName) && HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName, this.sparkSession())) {
                DropHoodieTableCommand dropHoodieTableCommand = new DropHoodieTableCommand(tableName, ifExists, false, purge);
                return var2_19;
            }
        }
        if (logicalPlan instanceof AlterTableAddPartitionCommand) {
            AlterTableAddPartitionCommand alterTableAddPartitionCommand = (AlterTableAddPartitionCommand)logicalPlan;
            TableIdentifier tableName = alterTableAddPartitionCommand.tableName();
            Seq partitionSpecsAndLocs = alterTableAddPartitionCommand.partitionSpecsAndLocs();
            boolean ifNotExists = alterTableAddPartitionCommand.ifNotExists();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName, this.sparkSession())) {
                AlterHoodieTableAddPartitionCommand alterHoodieTableAddPartitionCommand = new AlterHoodieTableAddPartitionCommand(tableName, (Seq<Tuple2<Map<String, String>, Option<String>>>)partitionSpecsAndLocs, ifNotExists);
                return var2_19;
            }
        }
        if (logicalPlan instanceof AlterTableDropPartitionCommand) {
            AlterTableDropPartitionCommand alterTableDropPartitionCommand = (AlterTableDropPartitionCommand)logicalPlan;
            TableIdentifier tableName = alterTableDropPartitionCommand.tableName();
            Seq specs = alterTableDropPartitionCommand.specs();
            boolean ifExists = alterTableDropPartitionCommand.ifExists();
            boolean purge = alterTableDropPartitionCommand.purge();
            boolean retainData = alterTableDropPartitionCommand.retainData();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName, this.sparkSession())) {
                AlterHoodieTableDropPartitionCommand alterHoodieTableDropPartitionCommand = new AlterHoodieTableDropPartitionCommand(tableName, (Seq<Map<String, String>>)specs, ifExists, purge, retainData);
                return var2_19;
            }
        }
        if (logicalPlan instanceof AlterTableAddColumnsCommand) {
            AlterTableAddColumnsCommand alterTableAddColumnsCommand = (AlterTableAddColumnsCommand)logicalPlan;
            TableIdentifier tableId = alterTableAddColumnsCommand.table();
            Seq colsToAdd = alterTableAddColumnsCommand.colsToAdd();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableId, this.sparkSession())) {
                AlterHoodieTableAddColumnsCommand alterHoodieTableAddColumnsCommand = new AlterHoodieTableAddColumnsCommand(tableId, (Seq<StructField>)colsToAdd);
                return var2_19;
            }
        }
        if (logicalPlan instanceof ShowCreateTableCommand) {
            ShowCreateTableCommand showCreateTableCommand = (ShowCreateTableCommand)logicalPlan;
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(showCreateTableCommand.table(), this.sparkSession())) {
                ShowHoodieCreateTableCommand showHoodieCreateTableCommand = new ShowHoodieCreateTableCommand(showCreateTableCommand.table());
                return var2_19;
            }
        }
        if (logicalPlan instanceof AlterTableRenameCommand) {
            AlterTableRenameCommand alterTableRenameCommand = (AlterTableRenameCommand)logicalPlan;
            TableIdentifier oldName = alterTableRenameCommand.oldName();
            TableIdentifier newName = alterTableRenameCommand.newName();
            boolean isView = alterTableRenameCommand.isView();
            if (!isView && HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(oldName, this.sparkSession())) {
                AlterHoodieTableRenameCommand alterHoodieTableRenameCommand = new AlterHoodieTableRenameCommand(oldName, newName, isView);
                return var2_19;
            }
        }
        if (logicalPlan instanceof AlterTableChangeColumnCommand) {
            AlterTableChangeColumnCommand alterTableChangeColumnCommand = (AlterTableChangeColumnCommand)logicalPlan;
            TableIdentifier tableName = alterTableChangeColumnCommand.tableName();
            String columnName = alterTableChangeColumnCommand.columnName();
            StructField newColumn = alterTableChangeColumnCommand.newColumn();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName, this.sparkSession())) {
                AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = new AlterHoodieTableChangeColumnCommand(tableName, columnName, newColumn);
                return var2_19;
            }
        }
        if (logicalPlan instanceof ShowPartitionsCommand) {
            ShowPartitionsCommand showPartitionsCommand = (ShowPartitionsCommand)logicalPlan;
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(showPartitionsCommand.tableName(), this.sparkSession())) {
                ShowHoodieTablePartitionsCommand showHoodieTablePartitionsCommand = new ShowHoodieTablePartitionsCommand(showPartitionsCommand.tableName(), (Option<Map<String, String>>)showPartitionsCommand.spec());
                return var2_19;
            }
        }
        if (logicalPlan instanceof TruncateTableCommand) {
            TruncateTableCommand truncateTableCommand = (TruncateTableCommand)logicalPlan;
            TableIdentifier tableName = truncateTableCommand.tableName();
            Option partitionSpec = truncateTableCommand.partitionSpec();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName, this.sparkSession())) {
                TruncateHoodieTableCommand truncateHoodieTableCommand = new TruncateHoodieTableCommand(tableName, (Option<Map<String, String>>)partitionSpec);
                return var2_19;
            }
        }
        if (!HoodieAnalysis$.MODULE$.sparkAdapter().getCatalystPlanUtils().isRepairTable(logicalPlan)) {
            LogicalPlan logicalPlan2 = plan;
            return var2_19;
        }
        Tuple4 tuple4 = (Tuple4)HoodieAnalysis$.MODULE$.sparkAdapter().getCatalystPlanUtils().getRepairTableChildren(logicalPlan).get();
        if (tuple4 == null) throw new MatchError((Object)tuple4);
        TableIdentifier tableName = (TableIdentifier)tuple4._1();
        boolean enableAddPartitions = BoxesRunTime.unboxToBoolean((Object)tuple4._2());
        boolean enableDropPartitions = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
        String cmd = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)tableName, (Object)BoxesRunTime.boxToBoolean((boolean)enableAddPartitions), (Object)BoxesRunTime.boxToBoolean((boolean)enableDropPartitions), (Object)cmd);
        Tuple4 tuple43 = tuple42;
        TableIdentifier tableName2 = (TableIdentifier)tuple43._1();
        boolean enableAddPartitions2 = BoxesRunTime.unboxToBoolean((Object)tuple43._2());
        boolean enableDropPartitions2 = BoxesRunTime.unboxToBoolean((Object)tuple43._3());
        String cmd2 = (String)tuple43._4();
        LogicalPlan logicalPlan3 = HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName2, this.sparkSession()) ? new RepairHoodieTableCommand(tableName2, enableAddPartitions2, enableDropPartitions2, cmd2) : logicalPlan;
        return var2_19;
    }

    public HoodiePostAnalysisRule copy(SparkSession sparkSession) {
        return new HoodiePostAnalysisRule(sparkSession);
    }

    public SparkSession copy$default$1() {
        return this.sparkSession();
    }

    public String productPrefix() {
        return "HoodiePostAnalysisRule";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.sparkSession();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HoodiePostAnalysisRule;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "sparkSession";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HoodiePostAnalysisRule)) return false;
        boolean bl = true;
        if (!bl) return false;
        HoodiePostAnalysisRule hoodiePostAnalysisRule = (HoodiePostAnalysisRule)x$1;
        SparkSession sparkSession = this.sparkSession();
        SparkSession sparkSession2 = hoodiePostAnalysisRule.sparkSession();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!hoodiePostAnalysisRule.canEqual(this)) return false;
        return true;
    }

    public HoodiePostAnalysisRule(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Product.$init$((Product)this);
    }
}

