/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.analysis;

import java.io.Serializable;
import org.apache.hudi.HoodieSchemaUtils$;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$MatchInsertIntoStatement$;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$ResolvesToHudiTable$;
import org.apache.spark.sql.hudi.analysis.ResolveImplementationsEarly$;
import org.apache.spark.sql.hudi.command.CreateHoodieTableAsSelectCommand;
import org.apache.spark.sql.hudi.command.InsertIntoHoodieTableCommand;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\u000b\u0016\u0001\nBQ!\u0012\u0001\u0005\u0002\u0019CQ!\u0013\u0001\u0005B)Cq!\u0014\u0001\u0002\u0002\u0013\u0005a\tC\u0004O\u0001\u0005\u0005I\u0011I(\t\u000fa\u0003\u0011\u0011!C\u00013\"9Q\fAA\u0001\n\u0003q\u0006b\u00023\u0001\u0003\u0003%\t%\u001a\u0005\bY\u0002\t\t\u0011\"\u0001n\u0011\u001d\u0011\b!!A\u0005BMDq!\u001e\u0001\u0002\u0002\u0013\u0005c\u000fC\u0004x\u0001\u0005\u0005I\u0011\t=\t\u000fe\u0004\u0011\u0011!C!u\u001e9A0FA\u0001\u0012\u0003iha\u0002\u000b\u0016\u0003\u0003E\tA \u0005\u0007\u000b:!\t!!\u0006\t\u000f]t\u0011\u0011!C#q\"9\u0011JDA\u0001\n\u00033\u0005\"CA\f\u001d\u0005\u0005I\u0011QA\r\u0011%\tyBDA\u0001\n\u0013\t\tCA\u000eSKN|GN^3J[BdW-\\3oi\u0006$\u0018n\u001c8t\u000b\u0006\u0014H.\u001f\u0006\u0003-]\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u00031e\tA\u0001[;eS*\u0011!dG\u0001\u0004gFd'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M!\u0001aI\u001a:!\r!\u0013fK\u0007\u0002K)\u0011aeJ\u0001\u0006eVdWm\u001d\u0006\u0003Qe\t\u0001bY1uC2L8\u000f^\u0005\u0003U\u0015\u0012AAU;mKB\u0011A&M\u0007\u0002[)\u0011afL\u0001\bY><\u0017nY1m\u0015\t\u0001t%A\u0003qY\u0006t7/\u0003\u00023[\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000f\"\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \"\u0003\u0019a$o\\8u}%\ta'\u0003\u0002Bk\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\tU'\u0001\u0004=S:LGO\u0010\u000b\u0002\u000fB\u0011\u0001\nA\u0007\u0002+\u0005)\u0011\r\u001d9msR\u00111f\u0013\u0005\u0006\u0019\n\u0001\raK\u0001\u0005a2\fg.\u0001\u0003d_BL\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001Q!\t\tf+D\u0001S\u0015\t\u0019F+\u0001\u0003mC:<'\"A+\u0002\t)\fg/Y\u0005\u0003/J\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001.\u0011\u0005QZ\u0016B\u0001/6\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ty&\r\u0005\u00025A&\u0011\u0011-\u000e\u0002\u0004\u0003:L\bbB2\u0007\u0003\u0003\u0005\rAW\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003\u0019\u00042a\u001a6`\u001b\u0005A'BA56\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W\"\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0011a.\u001d\t\u0003i=L!\u0001]\u001b\u0003\u000f\t{w\u000e\\3b]\"91\rCA\u0001\u0002\u0004y\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$\"\u0001\u0015;\t\u000f\rL\u0011\u0011!a\u00015\u0006A\u0001.Y:i\u0007>$W\rF\u0001[\u0003!!xn\u0015;sS:<G#\u0001)\u0002\r\u0015\fX/\u00197t)\tq7\u0010C\u0004d\u0019\u0005\u0005\t\u0019A0\u00027I+7o\u001c7wK&k\u0007\u000f\\3nK:$\u0018\r^5p]N,\u0015M\u001d7z!\tAeb\u0005\u0003\u000f\u007f\u0006-\u0001#BA\u0001\u0003\u000f9UBAA\u0002\u0015\r\t)!N\u0001\beVtG/[7f\u0013\u0011\tI!a\u0001\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\u0007\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002V\u0001\u0003S>L1aQA\b)\u0005i\u0018aB;oCB\u0004H.\u001f\u000b\u0004]\u0006m\u0001\u0002CA\u000f%\u0005\u0005\t\u0019A$\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002$A\u0019\u0011+!\n\n\u0007\u0005\u001d\"K\u0001\u0004PE*,7\r\u001e")
public class ResolveImplementationsEarly
extends Rule<LogicalPlan>
implements Product,
Serializable {
    public static boolean unapply(ResolveImplementationsEarly x$0) {
        return ResolveImplementationsEarly$.MODULE$.unapply(x$0);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LogicalPlan apply(LogicalPlan plan) {
        Option<Tuple6<LogicalPlan, Seq<String>, Map<String, Option<String>>, LogicalPlan, Object, Object>> option;
        boolean bl = false;
        CreateTable createTable = null;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan != null && !(option = HoodieAnalysis$MatchInsertIntoStatement$.MODULE$.unapply(logicalPlan)).isEmpty()) {
            Option<CatalogTable> option2;
            LogicalPlan relation = (LogicalPlan)((Tuple6)option.get())._1();
            Seq userSpecifiedCols = (Seq)((Tuple6)option.get())._2();
            Map partition = (Map)((Tuple6)option.get())._3();
            LogicalPlan query = (LogicalPlan)((Tuple6)option.get())._4();
            boolean overwrite = BoxesRunTime.unboxToBoolean((Object)((Tuple6)option.get())._5());
            if (relation != null && !(option2 = HoodieAnalysis$ResolvesToHudiTable$.MODULE$.unapply(relation)).isEmpty() && query.resolved()) {
                LogicalPlan logicalPlan2;
                LogicalPlan logicalPlan3 = relation;
                if (logicalPlan3 instanceof LogicalRelation) {
                    Option<LogicalPlan> option3;
                    LogicalRelation logicalRelation = (LogicalRelation)logicalPlan3;
                    if (userSpecifiedCols.nonEmpty()) {
                        ValidationUtils.checkState(logicalRelation.catalogTable().isDefined(), "Missing catalog table");
                        option3 = HoodieAnalysis$.MODULE$.sparkAdapter().getCatalystPlanUtils().createProjectForByNameQuery(logicalRelation, logicalPlan);
                    } else {
                        option3 = None$.MODULE$;
                    }
                    Option<LogicalPlan> projectByUserSpecified = option3;
                    logicalPlan2 = new InsertIntoHoodieTableCommand(logicalRelation, (LogicalPlan)projectByUserSpecified.getOrElse((Function0 & Serializable)() -> query), (Map<String, Option<String>>)partition, overwrite);
                    return logicalPlan2;
                } else {
                    logicalPlan2 = logicalPlan;
                }
                return logicalPlan2;
            }
        }
        if (logicalPlan instanceof CreateTable) {
            bl = true;
            createTable = (CreateTable)logicalPlan;
            CatalogTable table = createTable.tableDesc();
            SaveMode mode = createTable.mode();
            Option option4 = createTable.query();
            if (option4 instanceof Some) {
                Some some = (Some)option4;
                LogicalPlan query = (LogicalPlan)some.value();
                if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(table) && createTable.query().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.resolved()))) {
                    return new CreateHoodieTableAsSelectCommand(table, mode, query);
                }
            }
        }
        if (!bl) return plan;
        try {
            StructType tableSchema = (StructType)createTable.query().map((Function1 & Serializable)x$4 -> x$4.schema()).getOrElse((Function0 & Serializable)() -> createTable.tableDesc().schema());
            HoodieSchemaUtils$.MODULE$.checkPartitionSchemaOrder(tableSchema, (Seq<String>)createTable.tableDesc().partitionColumnNames());
            return plan;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception exception) {
            this.logWarning((Function0 & Serializable)() -> "An unexpected exception occurred while checking partition schema order. Proceeding with the plan.");
        }
        return plan;
    }

    public ResolveImplementationsEarly copy() {
        return new ResolveImplementationsEarly();
    }

    public String productPrefix() {
        return "ResolveImplementationsEarly";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        Object object = Statics.ioobe((int)x$1);
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ResolveImplementationsEarly;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        String string = (String)Statics.ioobe((int)x$1);
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        boolean bl = object instanceof ResolveImplementationsEarly;
        return bl && ((ResolveImplementationsEarly)x$1).canEqual(this);
    }

    public ResolveImplementationsEarly() {
        Product.$init$((Product)this);
    }
}

