/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.catalog;

import java.io.Serializable;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.HoodieSpark3CatalogUtils$MatchBucketTransform$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.IdentityTransform$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class HoodieCatalog$ {
    public static final HoodieCatalog$ MODULE$ = new HoodieCatalog$();

    public Tuple2<Seq<String>, Option<BucketSpec>> convertTransforms(Seq<Transform> transforms) {
        ArrayBuffer identityCols = new ArrayBuffer();
        ObjectRef bucketSpec = ObjectRef.create((Object)Option$.MODULE$.empty());
        transforms.foreach((Function1 & Serializable)x0$1 -> {
            Option<Tuple3<Object, Seq<NamedReference>, Seq<NamedReference>>> option;
            Growable growable;
            SeqOps seqOps;
            Seq seq;
            FieldReference fieldReference;
            Option option2;
            Transform transform = x0$1;
            if (transform != null && !(option2 = IdentityTransform$.MODULE$.unapply(transform)).isEmpty() && (fieldReference = (FieldReference)option2.get()) != null && (seq = fieldReference.parts()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                String col = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                growable = identityCols.$plus$eq((Object)col);
            } else if (transform != null && !(option = HoodieSpark3CatalogUtils$MatchBucketTransform$.MODULE$.unapply(transform)).isEmpty()) {
                BoxedUnit boxedUnit;
                int numBuckets = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._1());
                Seq col = (Seq)((Tuple3)option.get())._2();
                Seq sortCol = (Seq)((Tuple3)option.get())._3();
                if (((Option)bucketSpec$1.elem).nonEmpty()) {
                    throw new HoodieException("Multiple bucket transformations are not supported");
                }
                if (sortCol.isEmpty()) {
                    bucketSpec$1.elem = new Some((Object)new BucketSpec(numBuckets, (Seq)col.map((Function1 & Serializable)x$4 -> Predef$.MODULE$.wrapRefArray((Object[])x$4.fieldNames()).mkString(".")), (Seq)package$.MODULE$.Nil()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    bucketSpec$1.elem = new Some((Object)new BucketSpec(numBuckets, (Seq)col.map((Function1 & Serializable)x$5 -> Predef$.MODULE$.wrapRefArray((Object[])x$5.fieldNames()).mkString(".")), (Seq)sortCol.map((Function1 & Serializable)x$6 -> Predef$.MODULE$.wrapRefArray((Object[])x$6.fieldNames()).mkString("."))));
                    boxedUnit = BoxedUnit.UNIT;
                }
                growable = boxedUnit;
            } else {
                throw new HoodieException(new StringBuilder(50).append("Partitioning by transformation `").append(transform).append("` is not supported").toString());
            }
            return growable;
        });
        return new Tuple2((Object)identityCols.toSeq(), (Object)((Option)bucketSpec.elem));
    }

    public boolean isTablePartitioned(Option<CatalogTable> table) {
        return table.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalog$.$anonfun$isTablePartitioned$1(x$7)));
    }

    public Transform[] buildPartitionTransforms(SparkSession spark, String basePath) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConf(spark.sessionState().newHadoopConf())).setBasePath(basePath).build();
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieTableFileSystemView metadataFileSystemView = FileSystemViewManager.createInMemoryFileSystemView(new HoodieSparkEngineContext(JavaSparkContext$.MODULE$.fromSparkContext(spark.sparkContext())), metaClient, metadataConfig);
        List partitions = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(metadataFileSystemView.getPartitionPaths()).asScala()).toList();
        Set transforms = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitions.foreach((Function1 & Serializable)path -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])path.toString().split("/")), (Function1 & Serializable)part -> {
                BoxedUnit boxedUnit;
                Object object;
                String[] stringArray = part.split("=");
                if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                    String key = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    boxedUnit = transforms$1.$plus$eq((Object)new IdentityTransform((NamedReference)new FieldReference((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key})))));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            return BoxedUnit.UNIT;
        });
        return (Transform[])transforms.toArray(ClassTag$.MODULE$.apply(Transform.class));
    }

    public static final /* synthetic */ boolean $anonfun$isTablePartitioned$1(CatalogTable x$7) {
        return x$7.partitionColumnNames().nonEmpty();
    }

    private HoodieCatalog$() {
    }
}

