/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddPartitionCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\u000e\u001d\u0001&B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t!\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005z\u0001\tE\t\u0015!\u0003T\u0011!Q\bA!f\u0001\n\u0003Y\b\u0002C@\u0001\u0005#\u0005\u000b\u0011\u0002?\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011Q\u0002\u0001\u0005B\u0005=\u0001\"CA\u0013\u0001\u0005\u0005I\u0011AA\u0014\u0011%\ty\u0003AI\u0001\n\u0003\t\t\u0004C\u0005\u0002H\u0001\t\n\u0011\"\u0001\u0002J!I\u0011Q\n\u0001\u0012\u0002\u0013\u0005\u0011q\n\u0005\n\u0003'\u0002\u0011\u0011!C!\u0003+B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u0005=\u0004!!A\u0005\u0002\u0005E\u0004\"CA?\u0001\u0005\u0005I\u0011IA@\u0011%\ti\tAA\u0001\n\u0003\ty\tC\u0005\u0002\u0014\u0002\t\t\u0011\"\u0011\u0002\u0016\"I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00131T\u0004\n\u0003?c\u0012\u0011!E\u0001\u0003C3\u0001b\u0007\u000f\u0002\u0002#\u0005\u00111\u0015\u0005\b\u0003\u0003)B\u0011AA^\u0011%\ti,FA\u0001\n\u000b\ny\fC\u0005\u0002BV\t\t\u0011\"!\u0002D\"I\u00111Z\u000b\u0002\u0002\u0013\u0005\u0015Q\u001a\u0005\n\u00037,\u0012\u0011!C\u0005\u0003;\u00141%\u00117uKJDun\u001c3jKR\u000b'\r\\3BI\u0012\u0004\u0016M\u001d;ji&|gnQ8n[\u0006tGM\u0003\u0002\u001e=\u000591m\\7nC:$'BA\u0010!\u0003\u0011AW\u000fZ5\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001QC\u0007\u000f \u0011\u0005-\u0012T\"\u0001\u0017\u000b\u00055r\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003_A\nQ\u0001\u001d7b]NT!!\r\u0011\u0002\u0011\r\fG/\u00197zgRL!a\r\u0017\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003kYj\u0011\u0001H\u0005\u0003oq\u0011\u0011\u0004S8pI&,G*Z1g%Vtg.\u00192mK\u000e{W.\\1oIB\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t9\u0001K]8ek\u000e$\bCA H\u001d\t\u0001UI\u0004\u0002B\t6\t!I\u0003\u0002DQ\u00051AH]8pizJ\u0011aO\u0005\u0003\rj\nq\u0001]1dW\u0006<W-\u0003\u0002I\u0013\na1+\u001a:jC2L'0\u00192mK*\u0011aIO\u0001\u0010i\u0006\u0014G.Z%eK:$\u0018NZ5feV\tA\n\u0005\u0002N\u001d6\t\u0001'\u0003\u0002Pa\tyA+\u00192mK&#WM\u001c;jM&,'/\u0001\tuC\ndW-\u00133f]RLg-[3sA\u0005)\u0002/\u0019:uSRLwN\\*qK\u000e\u001c\u0018I\u001c3M_\u000e\u001cX#A*\u0011\u0007}\"f+\u0003\u0002V\u0013\n\u00191+Z9\u0011\te:\u0016L\\\u0005\u00031j\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001.l\u001d\tY\u0006N\u0004\u0002]M:\u0011Q,\u001a\b\u0003=\u0012t!aX2\u000f\u0005\u0001\u0014gBA!b\u0013\u00059\u0013BA\u0013'\u0013\t\u0019C%\u0003\u0002\"E%\u0011\u0011\u0007I\u0005\u0003OB\nqaY1uC2|w-\u0003\u0002jU\u0006a1)\u0019;bY><G+\u001f9fg*\u0011q\rM\u0005\u0003Y6\u0014!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0011\u0011N\u001b\t\u0004s=\f\u0018B\u00019;\u0005\u0019y\u0005\u000f^5p]B\u0011!O\u001e\b\u0003gR\u0004\"!\u0011\u001e\n\u0005UT\u0014A\u0002)sK\u0012,g-\u0003\u0002xq\n11\u000b\u001e:j]\u001eT!!\u001e\u001e\u0002-A\f'\u000f^5uS>t7\u000b]3dg\u0006sG\rT8dg\u0002\n1\"\u001b4O_R,\u00050[:ugV\tA\u0010\u0005\u0002:{&\u0011aP\u000f\u0002\b\u0005>|G.Z1o\u00031IgMT8u\u000bbL7\u000f^:!\u0003\u0019a\u0014N\\5u}QA\u0011QAA\u0004\u0003\u0013\tY\u0001\u0005\u00026\u0001!)!j\u0002a\u0001\u0019\")\u0011k\u0002a\u0001'\")!p\u0002a\u0001y\u0006\u0019!/\u001e8\u0015\t\u0005E\u00111\u0004\t\u0005\u007fQ\u000b\u0019\u0002\u0005\u0003\u0002\u0016\u0005]Q\"\u0001\u0011\n\u0007\u0005e\u0001EA\u0002S_^Dq!!\b\t\u0001\u0004\ty\"\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0003\u0002\u0016\u0005\u0005\u0012bAA\u0012A\ta1\u000b]1sWN+7o]5p]\u0006!1m\u001c9z)!\t)!!\u000b\u0002,\u00055\u0002b\u0002&\n!\u0003\u0005\r\u0001\u0014\u0005\b#&\u0001\n\u00111\u0001T\u0011\u001dQ\u0018\u0002%AA\u0002q\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00024)\u001aA*!\u000e,\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0011;\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\nYDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002L)\u001a1+!\u000e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u000b\u0016\u0004y\u0006U\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002XA!\u0011\u0011LA2\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013\u0001\u00027b]\u001eT!!!\u0019\u0002\t)\fg/Y\u0005\u0004o\u0006m\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA5!\rI\u00141N\u0005\u0004\u0003[R$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA:\u0003s\u00022!OA;\u0013\r\t9H\u000f\u0002\u0004\u0003:L\b\"CA>\u001f\u0005\u0005\t\u0019AA5\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0011\t\u0007\u0003\u0007\u000bI)a\u001d\u000e\u0005\u0005\u0015%bAADu\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0015Q\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002}\u0003#C\u0011\"a\u001f\u0012\u0003\u0003\u0005\r!a\u001d\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003/\n9\nC\u0005\u0002|I\t\t\u00111\u0001\u0002j\u00051Q-];bYN$2\u0001`AO\u0011%\tYhEA\u0001\u0002\u0004\t\u0019(A\u0012BYR,'\u000fS8pI&,G+\u00192mK\u0006#G\rU1si&$\u0018n\u001c8D_6l\u0017M\u001c3\u0011\u0005U*2#B\u000b\u0002&\u0006E\u0006#CAT\u0003[c5\u000b`A\u0003\u001b\t\tIKC\u0002\u0002,j\nqA];oi&lW-\u0003\u0003\u00020\u0006%&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!\u00111WA]\u001b\t\t)L\u0003\u0003\u00028\u0006}\u0013AA5p\u0013\rA\u0015Q\u0017\u000b\u0003\u0003C\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003/\nQ!\u00199qYf$\u0002\"!\u0002\u0002F\u0006\u001d\u0017\u0011\u001a\u0005\u0006\u0015b\u0001\r\u0001\u0014\u0005\u0006#b\u0001\ra\u0015\u0005\u0006ub\u0001\r\u0001`\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty-a6\u0011\tez\u0017\u0011\u001b\t\u0007s\u0005MGj\u0015?\n\u0007\u0005U'H\u0001\u0004UkBdWm\r\u0005\n\u00033L\u0012\u0011!a\u0001\u0003\u000b\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\u000e\u0005\u0003\u0002Z\u0005\u0005\u0018\u0002BAr\u00037\u0012aa\u00142kK\u000e$\b")
public class AlterHoodieTableAddPartitionCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
Serializable {
    private final TableIdentifier tableIdentifier;
    private final Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs;
    private final boolean ifNotExists;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, Seq<Tuple2<Map<String, String>, Option<String>>>, Object>> unapply(AlterHoodieTableAddPartitionCommand x$0) {
        return AlterHoodieTableAddPartitionCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<TableIdentifier, Seq<Tuple2<Map<String, String>, Option<String>>>, Object>, AlterHoodieTableAddPartitionCommand> tupled() {
        return AlterHoodieTableAddPartitionCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<Tuple2<Map<String, String>, Option<String>>>, Function1<Object, AlterHoodieTableAddPartitionCommand>>> curried() {
        return AlterHoodieTableAddPartitionCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterHoodieTableAddPartitionCommand alterHoodieTableAddPartitionCommand = this;
        synchronized (alterHoodieTableAddPartitionCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs() {
        return this.partitionSpecsAndLocs;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(52).append("start execute alter table add partition command for ").append(this.tableIdentifier()).toString());
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableIdentifier());
        if (!hoodieCatalogTable.isPartitionedTable()) {
            throw new AnalysisException(new StringBuilder(64).append(this.tableIdentifier()).append(" is a non-partitioned table that is not allowed to add partition").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = hoodieCatalogTable.table();
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        Seq normalizedSpecs = (Seq)this.partitionSpecsAndLocs().map((Function1 & Serializable)x0$1 -> {
            Map spec;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                spec = (Map)tuple2._1();
                Option location = (Option)tuple2._2();
                if (location.isDefined()) {
                    throw new AnalysisException("Hoodie table does not support specify partition location explicitly", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Map map2 = HoodieSqlCommonUtils$.MODULE$.normalizePartitionSpec(spec, (Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)hoodieCatalogTable.partitionFields()), hoodieCatalogTable.tableName(), (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver());
            return map2;
        });
        StoragePath basePath = new StoragePath(hoodieCatalogTable.tableLocation());
        HoodieStorage storage2 = hoodieCatalogTable.metaClient().getStorage();
        org.apache.hudi.common.util.Option<HoodieFileFormat> format = hoodieCatalogTable.tableConfig().getPartitionMetafileFormat();
        Tuple2 tuple2 = ((IterableOps)normalizedSpecs.map((Function1 & Serializable)spec -> {
            Some some;
            String partitionPath = HoodieSqlCommonUtils$.MODULE$.makePartitionPath(hoodieCatalogTable, (Map<String, String>)spec);
            StoragePath fullPartitionPath = FSUtils.constructAbsolutePath(basePath, partitionPath);
            if (HoodiePartitionMetadata.hasPartitionMetadata(storage2, fullPartitionPath)) {
                if (!this.ifNotExists()) {
                    throw new AnalysisException(new StringBuilder(44).append("Partition metadata already exists for path: ").append(fullPartitionPath).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                }
                some = None$.MODULE$;
            } else {
                some = new Some((Object)new HoodiePartitionMetadata(storage2, "00000000000000", basePath, fullPartitionPath, format));
            }
            Some metadata2 = some;
            return new Tuple2((Object)metadata2, (Object)new CatalogTablePartition(spec, table.storage().copy((Option)new Some((Object)fullPartitionPath.toUri()), table.storage().copy$default$2(), table.storage().copy$default$3(), table.storage().copy$default$4(), table.storage().copy$default$5(), table.storage().copy$default$6()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6()));
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionMetadata = (Seq)tuple2._1();
        Seq parts = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionMetadata, (Object)parts);
        Tuple2 tuple23 = tuple22;
        Seq partitionMetadata2 = (Seq)tuple23._1();
        Seq parts2 = (Seq)tuple23._2();
        ((IterableOnceOps)partitionMetadata2.flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)x$2 -> {
            x$2.trySave();
            return BoxedUnit.UNIT;
        });
        int batchSize = sparkSession.sparkContext().conf().getInt("spark.sql.addPartitionInBatch.size", 100);
        try {
            parts2.toIterator().grouped(batchSize).foreach((Function1 & Serializable)batch -> {
                catalog.createPartitions(this.tableIdentifier(), batch, true);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0 & Serializable)() -> "Failed to add partitions in external catalog", e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        sparkSession.catalog().refreshTable(this.tableIdentifier().unquotedString());
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public AlterHoodieTableAddPartitionCommand copy(TableIdentifier tableIdentifier, Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs, boolean ifNotExists) {
        return new AlterHoodieTableAddPartitionCommand(tableIdentifier, partitionSpecsAndLocs, ifNotExists);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public Seq<Tuple2<Map<String, String>, Option<String>>> copy$default$2() {
        return this.partitionSpecsAndLocs();
    }

    public boolean copy$default$3() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "AlterHoodieTableAddPartitionCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableIdentifier();
                break;
            }
            case 1: {
                object = this.partitionSpecsAndLocs();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterHoodieTableAddPartitionCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "tableIdentifier";
                break;
            }
            case 1: {
                string = "partitionSpecsAndLocs";
                break;
            }
            case 2: {
                string = "ifNotExists";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterHoodieTableAddPartitionCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterHoodieTableAddPartitionCommand alterHoodieTableAddPartitionCommand = (AlterHoodieTableAddPartitionCommand)x$1;
        if (this.ifNotExists() != alterHoodieTableAddPartitionCommand.ifNotExists()) return false;
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = alterHoodieTableAddPartitionCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<Tuple2<Map<String, String>, Option<String>>> seq = this.partitionSpecsAndLocs();
        Seq<Tuple2<Map<String, String>, Option<String>>> seq2 = alterHoodieTableAddPartitionCommand.partitionSpecsAndLocs();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!alterHoodieTableAddPartitionCommand.canEqual(this)) return false;
        return true;
    }

    public AlterHoodieTableAddPartitionCommand(TableIdentifier tableIdentifier, Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs, boolean ifNotExists) {
        this.tableIdentifier = tableIdentifier;
        this.partitionSpecsAndLocs = partitionSpecsAndLocs;
        this.ifNotExists = ifNotExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        Statics.releaseFence();
    }
}

