/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001\u0002\u000f\u001e\u0001*B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001b\"A!\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005]\u0001\tE\t\u0015!\u0003U\u0011!i\u0006A!f\u0001\n\u0003q\u0006\u0002C3\u0001\u0005#\u0005\u000b\u0011B0\t\u000b\u0019\u0004A\u0011A4\t\u000b1\u0004A\u0011I7\t\u000bi\u0004A\u0011B>\t\u0013\u0005\u0015\u0002!!A\u0005\u0002\u0005\u001d\u0002\"CA\u0018\u0001E\u0005I\u0011AA\u0019\u0011%\t9\u0005AI\u0001\n\u0003\tI\u0005C\u0005\u0002N\u0001\t\n\u0011\"\u0001\u0002P!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0013Q\u000b\u0005\n\u0003K\u0002\u0011\u0011!C\u0001\u0003OB\u0011\"a\u001c\u0001\u0003\u0003%\t!!\u001d\t\u0013\u0005u\u0004!!A\u0005B\u0005}\u0004\"CAG\u0001\u0005\u0005I\u0011AAH\u0011%\tI\nAA\u0001\n\u0003\nY\nC\u0005\u0002 \u0002\t\t\u0011\"\u0011\u0002\"\u001eI\u0011QU\u000f\u0002\u0002#\u0005\u0011q\u0015\u0004\t9u\t\t\u0011#\u0001\u0002*\"1aM\u0006C\u0001\u0003\u0003D\u0011\"a1\u0017\u0003\u0003%)%!2\t\u0013\u0005\u001dg#!A\u0005\u0002\u0006%\u0007\"CAi-\u0005\u0005I\u0011QAj\u0011%\t)OFA\u0001\n\u0013\t9OA\u0012BYR,'\u000fS8pI&,G+\u00192mK\u000eC\u0017M\\4f\u0007>dW/\u001c8D_6l\u0017M\u001c3\u000b\u0005yy\u0012aB2p[6\fg\u000e\u001a\u0006\u0003A\u0005\nA\u0001[;eS*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M)\u0001aK\u001b:\u007fA\u0011AfM\u0007\u0002[)\u0011afL\u0001\bY><\u0017nY1m\u0015\t\u0001\u0014'A\u0003qY\u0006t7O\u0003\u00023C\u0005A1-\u0019;bYf\u001cH/\u0003\u00025[\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t1t'D\u0001\u001e\u0013\tATDA\rI_>$\u0017.\u001a'fC\u001a\u0014VO\u001c8bE2,7i\\7nC:$\u0007C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0001\"s!!\u0011$\u000f\u0005\t+U\"A\"\u000b\u0005\u0011K\u0013A\u0002\u001fs_>$h(C\u0001=\u0013\t95(A\u0004qC\u000e\\\u0017mZ3\n\u0005%S%\u0001D*fe&\fG.\u001b>bE2,'BA$<\u0003=!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014X#A'\u0011\u00059{U\"A\u0019\n\u0005A\u000b$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002!Q\f'\r\\3JI\u0016tG/\u001b4jKJ\u0004\u0013AC2pYVlgNT1nKV\tA\u000b\u0005\u0002V3:\u0011ak\u0016\t\u0003\u0005nJ!\u0001W\u001e\u0002\rA\u0013X\rZ3g\u0013\tQ6L\u0001\u0004TiJLgn\u001a\u0006\u00031n\n1bY8mk6tg*Y7fA\u0005Ia.Z<D_2,XN\\\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!-I\u0001\u0006if\u0004Xm]\u0005\u0003I\u0006\u00141b\u0015;sk\u000e$h)[3mI\u0006Qa.Z<D_2,XN\u001c\u0011\u0002\rqJg.\u001b;?)\u0011A\u0017N[6\u0011\u0005Y\u0002\u0001\"B&\b\u0001\u0004i\u0005\"\u0002*\b\u0001\u0004!\u0006\"B/\b\u0001\u0004y\u0016a\u0001:v]R\u0011a.\u001e\t\u0004\u0001>\f\u0018B\u00019K\u0005\r\u0019V-\u001d\t\u0003eNl\u0011!I\u0005\u0003i\u0006\u00121AU8x\u0011\u00151\b\u00021\u0001x\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t\u0011\b0\u0003\u0002zC\ta1\u000b]1sWN+7o]5p]\u0006qa/\u00197jI\u0006$XmU2iK6\fG\u0003\u0002?\u0000\u0003\u001f\u0001\"AO?\n\u0005y\\$\u0001B+oSRDq!!\u0001\n\u0001\u0004\t\u0019!A\u0005oK^\u001c6\r[3nCB!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n\u0015\nA!\u0019<s_&!\u0011QBA\u0004\u0005\u0019\u00196\r[3nC\"9\u0011\u0011C\u0005A\u0002\u0005M\u0011AC7fi\u0006\u001cE.[3oiB!\u0011QCA\u0011\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011!\u0002;bE2,'\u0002BA\u000f\u0003?\taaY8n[>t'B\u0001\u0011&\u0013\u0011\t\u0019#a\u0006\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\u0006!1m\u001c9z)\u001dA\u0017\u0011FA\u0016\u0003[Aqa\u0013\u0006\u0011\u0002\u0003\u0007Q\nC\u0004S\u0015A\u0005\t\u0019\u0001+\t\u000fuS\u0001\u0013!a\u0001?\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001aU\ri\u0015QG\u0016\u0003\u0003o\u0001B!!\u000f\u0002D5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011I\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0005m\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA&U\r!\u0016QG\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tFK\u0002`\u0003k\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\nA\u0001\\1oO*\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-C\u0002[\u00037\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001b\u0011\u0007i\nY'C\u0002\u0002nm\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001d\u0002zA\u0019!(!\u001e\n\u0007\u0005]4HA\u0002B]fD\u0011\"a\u001f\u0011\u0003\u0003\u0005\r!!\u001b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\t\u0005\u0004\u0002\u0004\u0006%\u00151O\u0007\u0003\u0003\u000bS1!a\"<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\u000b)I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAI\u0003/\u00032AOAJ\u0013\r\t)j\u000f\u0002\b\u0005>|G.Z1o\u0011%\tYHEA\u0001\u0002\u0004\t\u0019(\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA,\u0003;C\u0011\"a\u001f\u0014\u0003\u0003\u0005\r!!\u001b\u0002\r\u0015\fX/\u00197t)\u0011\t\t*a)\t\u0013\u0005mD#!AA\u0002\u0005M\u0014aI!mi\u0016\u0014\bj\\8eS\u0016$\u0016M\u00197f\u0007\"\fgnZ3D_2,XN\\\"p[6\fg\u000e\u001a\t\u0003mY\u0019RAFAV\u0003o\u0003\u0002\"!,\u000246#v\f[\u0007\u0003\u0003_S1!!-<\u0003\u001d\u0011XO\u001c;j[\u0016LA!!.\u00020\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005e\u0016qX\u0007\u0003\u0003wSA!!0\u0002`\u0005\u0011\u0011n\\\u0005\u0004\u0013\u0006mFCAAT\u0003!!xn\u0015;sS:<GCAA,\u0003\u0015\t\u0007\u000f\u001d7z)\u001dA\u00171ZAg\u0003\u001fDQaS\rA\u00025CQAU\rA\u0002QCQ!X\rA\u0002}\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002V\u0006\u0005\b#\u0002\u001e\u0002X\u0006m\u0017bAAmw\t1q\n\u001d;j_:\u0004bAOAo\u001bR{\u0016bAApw\t1A+\u001e9mKNB\u0001\"a9\u001b\u0003\u0003\u0005\r\u0001[\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAu!\u0011\tI&a;\n\t\u00055\u00181\f\u0002\u0007\u001f\nTWm\u0019;")
public class AlterHoodieTableChangeColumnCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
Serializable {
    private final TableIdentifier tableIdentifier;
    private final String columnName;
    private final StructField newColumn;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterHoodieTableChangeColumnCommand x$0) {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterHoodieTableChangeColumnCommand> tupled() {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterHoodieTableChangeColumnCommand>>> curried() {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = this;
        synchronized (alterHoodieTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        Function2 resolver2 = sparkSession.sessionState().conf().resolver();
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableIdentifier());
        StructField originColumn = (StructField)HoodieSqlCommonUtils$.MODULE$.findColumnByName(hoodieCatalogTable.dataSchema(), this.columnName(), (Function2<String, String, Object>)resolver2).getOrElse((Function0 & Serializable)() -> {
            throw new AnalysisException(new StringBuilder(0).append(new StringBuilder(46).append("Can't find column `").append(this.columnName()).append("` given table data columns ").toString()).append(String.valueOf(Predef$.MODULE$.wrapRefArray((Object[])hoodieCatalogTable.dataSchema().fieldNames()).mkString("[`", "`, `", "`]"))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        });
        if (!HoodieSqlCommonUtils$.MODULE$.columnEqual(originColumn, this.newColumn(), (Function2<String, String, Object>)resolver2)) {
            throw new AnalysisException(new StringBuilder(63).append("ALTER TABLE CHANGE COLUMN is not supported for changing column ").append(new StringBuilder(19).append("'").append(originColumn.name()).append("' with type '").append(originColumn.dataType()).append("' to ").toString()).append(new StringBuilder(15).append("'").append(this.newColumn().name()).append("' with type '").append(this.newColumn().dataType()).append("'").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        StructType newTableSchema = new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.tableSchema().fields()), (Function1 & Serializable)field -> {
            String string = field.name();
            String string2 = originColumn.name();
            return !(string != null ? !string.equals(string2) : string2 != null) ? this.newColumn() : field;
        }, ClassTag$.MODULE$.apply(StructField.class)));
        StructType newDataSchema = new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.dataSchema().fields()), (Function1 & Serializable)field -> {
            String string = field.name();
            String string2 = this.columnName();
            return !(string != null ? !string.equals(string2) : string2 != null) ? this.newColumn() : field;
        }, ClassTag$.MODULE$.apply(StructField.class)));
        Tuple2<String, String> tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.tableIdentifier().table());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String structName = (String)tuple2._1();
        String nameSpace = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
        Tuple2 tuple23 = tuple22;
        String structName2 = (String)tuple23._1();
        String nameSpace2 = (String)tuple23._2();
        Schema newSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)newTableSchema, structName2, nameSpace2);
        this.validateSchema(newSchema, hoodieCatalogTable.metaClient());
        AlterHoodieTableAddColumnsCommand$.MODULE$.commitWithSchema(newSchema, hoodieCatalogTable, sparkSession);
        AlterHoodieTableAddColumnsCommand$.MODULE$.refreshSchema(sparkSession, hoodieCatalogTable, newDataSchema);
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private void validateSchema(Schema newSchema, HoodieTableMetaClient metaClient) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        Schema tableSchema = HoodieAvroUtils.createHoodieWriteSchema(schemaUtil.getTableAvroSchema(false));
        if (!AvroSchemaUtils.isSchemaCompatible(tableSchema, newSchema)) {
            throw new HoodieException(new StringBuilder(85).append("Failed schema compatibility check for newSchema :").append(newSchema).append(", origin table schema :").append(tableSchema).append(", base path :").append(metaClient.getBasePath()).toString());
        }
    }

    public AlterHoodieTableChangeColumnCommand copy(TableIdentifier tableIdentifier, String columnName, StructField newColumn) {
        return new AlterHoodieTableChangeColumnCommand(tableIdentifier, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterHoodieTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableIdentifier();
                break;
            }
            case 1: {
                object = this.columnName();
                break;
            }
            case 2: {
                object = this.newColumn();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterHoodieTableChangeColumnCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "tableIdentifier";
                break;
            }
            case 1: {
                string = "columnName";
                break;
            }
            case 2: {
                string = "newColumn";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterHoodieTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = (AlterHoodieTableChangeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = alterHoodieTableChangeColumnCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterHoodieTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterHoodieTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterHoodieTableChangeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public AlterHoodieTableChangeColumnCommand(TableIdentifier tableIdentifier, String columnName, StructField newColumn) {
        this.tableIdentifier = tableIdentifier;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        Statics.releaseFence();
    }
}

