/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.AlterTableRenameCommand;
import org.apache.spark.sql.execution.command.AlterTableSetPropertiesCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.command.AlterHoodieTableRenameCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001B\u000e\u001d\u0001&B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t!\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0011\u000b\u0001BK\u0002\u0013\u00051\n\u0003\u0005S\u0001\tE\t\u0015!\u0003M\u0011!\u0019\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003-\u0001\u0005#\u0005\u000b\u0011B+\t\u000be\u0003A\u0011\u0001.\t\u000b}\u0003A\u0011\t1\t\u000f5\u0004\u0011\u0011!C\u0001]\"9!\u000fAI\u0001\n\u0003\u0019\bb\u0002@\u0001#\u0003%\ta\u001d\u0005\t\u007f\u0002\t\n\u0011\"\u0001\u0002\u0002!I\u0011Q\u0001\u0001\u0002\u0002\u0013\u0005\u0013q\u0001\u0005\n\u00033\u0001\u0011\u0011!C\u0001\u00037A\u0011\"a\t\u0001\u0003\u0003%\t!!\n\t\u0013\u0005E\u0002!!A\u0005B\u0005M\u0002\"CA!\u0001\u0005\u0005I\u0011AA\"\u0011%\t9\u0005AA\u0001\n\u0003\nI\u0005C\u0005\u0002N\u0001\t\t\u0011\"\u0011\u0002P\u001dI\u00111\u000b\u000f\u0002\u0002#\u0005\u0011Q\u000b\u0004\t7q\t\t\u0011#\u0001\u0002X!1\u0011,\u0006C\u0001\u0003_B\u0011\"!\u001d\u0016\u0003\u0003%)%a\u001d\t\u0013\u0005UT#!A\u0005\u0002\u0006]\u0004\"CA@+\u0005\u0005I\u0011QAA\u0011%\t\u0019*FA\u0001\n\u0013\t)JA\u000fBYR,'\u000fS8pI&,G+\u00192mKJ+g.Y7f\u0007>lW.\u00198e\u0015\tib$A\u0004d_6l\u0017M\u001c3\u000b\u0005}\u0001\u0013\u0001\u00025vI&T!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00165qy\u0002\"a\u000b\u001a\u000e\u00031R!!\f\u0018\u0002\u000f1|w-[2bY*\u0011q\u0006M\u0001\u0006a2\fgn\u001d\u0006\u0003c\u0001\n\u0001bY1uC2L8\u000f^\u0005\u0003g1\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011QGN\u0007\u00029%\u0011q\u0007\b\u0002\u001a\u0011>|G-[3MK\u00064'+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$HA\u0004Qe>$Wo\u0019;\u0011\u0005}:eB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u0019\u0005&\u0001\u0004=e>|GOP\u0005\u0002w%\u0011aIO\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Gu\u00059q\u000e\u001c3OC6,W#\u0001'\u0011\u00055sU\"\u0001\u0019\n\u0005=\u0003$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0011=dGMT1nK\u0002\nqA\\3x\u001d\u0006lW-\u0001\u0005oK^t\u0015-\\3!\u0003\u0019I7OV5foV\tQ\u000b\u0005\u0002:-&\u0011qK\u000f\u0002\b\u0005>|G.Z1o\u0003\u001dI7OV5fo\u0002\na\u0001P5oSRtD\u0003B.];z\u0003\"!\u000e\u0001\t\u000b);\u0001\u0019\u0001'\t\u000bE;\u0001\u0019\u0001'\t\u000bM;\u0001\u0019A+\u0002\u0007I,h\u000e\u0006\u0002bQB\u0019qH\u00193\n\u0005\rL%aA*fcB\u0011QMZ\u0007\u0002A%\u0011q\r\t\u0002\u0004%><\b\"B5\t\u0001\u0004Q\u0017\u0001D:qCJ\\7+Z:tS>t\u0007CA3l\u0013\ta\u0007E\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0003d_BLH\u0003B.paFDqAS\u0005\u0011\u0002\u0003\u0007A\nC\u0004R\u0013A\u0005\t\u0019\u0001'\t\u000fMK\u0001\u0013!a\u0001+\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001;+\u00051+8&\u0001<\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018!C;oG\",7m[3e\u0015\tY((\u0001\u0006b]:|G/\u0019;j_:L!! =\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0001\u0016\u0003+V\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0005!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tA\u0001\\1oO*\u0011\u00111C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0018\u00055!AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u001eA\u0019\u0011(a\b\n\u0007\u0005\u0005\"HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002(\u00055\u0002cA\u001d\u0002*%\u0019\u00111\u0006\u001e\u0003\u0007\u0005s\u0017\u0010C\u0005\u00020=\t\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u000e\u0011\r\u0005]\u0012QHA\u0014\u001b\t\tIDC\u0002\u0002<i\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty$!\u000f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004+\u0006\u0015\u0003\"CA\u0018#\u0005\u0005\t\u0019AA\u0014\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005%\u00111\n\u0005\n\u0003_\u0011\u0012\u0011!a\u0001\u0003;\ta!Z9vC2\u001cHcA+\u0002R!I\u0011qF\n\u0002\u0002\u0003\u0007\u0011qE\u0001\u001e\u00032$XM\u001d%p_\u0012LW\rV1cY\u0016\u0014VM\\1nK\u000e{W.\\1oIB\u0011Q'F\n\u0006+\u0005e\u0013Q\r\t\t\u00037\n\t\u0007\u0014'V76\u0011\u0011Q\f\u0006\u0004\u0003?R\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003G\niFA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\n\t\"\u0001\u0002j_&\u0019\u0001*!\u001b\u0015\u0005\u0005U\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0011!B1qa2LHcB.\u0002z\u0005m\u0014Q\u0010\u0005\u0006\u0015b\u0001\r\u0001\u0014\u0005\u0006#b\u0001\r\u0001\u0014\u0005\u0006'b\u0001\r!V\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019)a$\u0011\u000be\n))!#\n\u0007\u0005\u001d%H\u0001\u0004PaRLwN\u001c\t\u0007s\u0005-E\nT+\n\u0007\u00055%H\u0001\u0004UkBdWm\r\u0005\t\u0003#K\u0012\u0011!a\u00017\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005]\u0005\u0003BA\u0006\u00033KA!a'\u0002\u000e\t1qJ\u00196fGR\u0004")
public class AlterHoodieTableRenameCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
Serializable {
    private final TableIdentifier oldName;
    private final TableIdentifier newName;
    private final boolean isView;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, TableIdentifier, Object>> unapply(AlterHoodieTableRenameCommand x$0) {
        return AlterHoodieTableRenameCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<TableIdentifier, TableIdentifier, Object>, AlterHoodieTableRenameCommand> tupled() {
        return AlterHoodieTableRenameCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<TableIdentifier, Function1<Object, AlterHoodieTableRenameCommand>>> curried() {
        return AlterHoodieTableRenameCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterHoodieTableRenameCommand alterHoodieTableRenameCommand = this;
        synchronized (alterHoodieTableRenameCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier oldName() {
        return this.oldName;
    }

    public TableIdentifier newName() {
        return this.newName;
    }

    public boolean isView() {
        return this.isView;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        BoxedUnit boxedUnit;
        TableIdentifier tableIdentifier = this.newName();
        TableIdentifier tableIdentifier2 = this.oldName();
        if (tableIdentifier == null ? tableIdentifier2 != null : !tableIdentifier.equals(tableIdentifier2)) {
            HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.oldName());
            HoodieTableMetaClient.newTableBuilder().fromProperties(hoodieCatalogTable.tableConfig().getProps()).setTableName(this.newName().table()).initTable(HadoopFSUtils.getStorageConf(sparkSession.sessionState().newHadoopConf()), hoodieCatalogTable.tableLocation());
            new AlterTableRenameCommand(this.oldName(), this.newName(), this.isView()).run(sparkSession);
            if (hoodieCatalogTable.table().properties().contains((Object)"path")) {
                CatalogTable catalogTable = sparkSession.sessionState().catalog().getTableMetadata(this.newName());
                String path = ((URI)catalogTable.storage().locationUri().get()).getPath();
                boxedUnit = new AlterTableSetPropertiesCommand(this.newName(), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)})), this.isView()).run(sparkSession);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public AlterHoodieTableRenameCommand copy(TableIdentifier oldName, TableIdentifier newName, boolean isView) {
        return new AlterHoodieTableRenameCommand(oldName, newName, isView);
    }

    public TableIdentifier copy$default$1() {
        return this.oldName();
    }

    public TableIdentifier copy$default$2() {
        return this.newName();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public String productPrefix() {
        return "AlterHoodieTableRenameCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.oldName();
                break;
            }
            case 1: {
                object = this.newName();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterHoodieTableRenameCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "oldName";
                break;
            }
            case 1: {
                string = "newName";
                break;
            }
            case 2: {
                string = "isView";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterHoodieTableRenameCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterHoodieTableRenameCommand alterHoodieTableRenameCommand = (AlterHoodieTableRenameCommand)x$1;
        if (this.isView() != alterHoodieTableRenameCommand.isView()) return false;
        TableIdentifier tableIdentifier = this.oldName();
        TableIdentifier tableIdentifier2 = alterHoodieTableRenameCommand.oldName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        TableIdentifier tableIdentifier3 = this.newName();
        TableIdentifier tableIdentifier4 = alterHoodieTableRenameCommand.newName();
        if (tableIdentifier3 == null) {
            if (tableIdentifier4 != null) {
                return false;
            }
        } else if (!tableIdentifier3.equals(tableIdentifier4)) return false;
        if (!alterHoodieTableRenameCommand.canEqual(this)) return false;
        return true;
    }

    public AlterHoodieTableRenameCommand(TableIdentifier oldName, TableIdentifier newName, boolean isView) {
        this.oldName = oldName;
        this.newName = newName;
        this.isView = isView;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        Statics.releaseFence();
    }
}

