/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.utils.SparkInternalSchemaConverter;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.action.TableChange;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.command.AlterTableCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rUa\u0001\u0002\u0016,\u0001bB\u0001b\u0018\u0001\u0003\u0016\u0004%\t\u0001\u0019\u0005\tO\u0002\u0011\t\u0012)A\u0005C\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005u\u0001\tE\t\u0015!\u0003k\u0011!)\bA!f\u0001\n\u00031\b\"CA\u0011\u0001\tE\t\u0015!\u0003x\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011q\u0011\u0001\u0005\n\u0005%\u0005bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!!,\u0001\t\u0003\ty\u000bC\u0004\u00024\u0002!\t!!.\t\u000f\u0005e\u0006\u0001\"\u0001\u0002<\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007\"CAr\u0001\u0005\u0005I\u0011AAs\u0011%\ti\u000fAI\u0001\n\u0003\ty\u000fC\u0005\u0003\u0006\u0001\t\n\u0011\"\u0001\u0003\b!I!1\u0002\u0001\u0012\u0002\u0013\u0005!Q\u0002\u0005\n\u0005#\u0001\u0011\u0011!C!\u0005'A\u0011Ba\t\u0001\u0003\u0003%\tA!\n\t\u0013\t5\u0002!!A\u0005\u0002\t=\u0002\"\u0003B\u001e\u0001\u0005\u0005I\u0011\tB\u001f\u0011%\u0011Y\u0005AA\u0001\n\u0003\u0011i\u0005C\u0005\u0003X\u0001\t\t\u0011\"\u0011\u0003Z!I!Q\f\u0001\u0002\u0002\u0013\u0005#qL\u0004\b\u0005GZ\u0003\u0012\u0001B3\r\u0019Q3\u0006#\u0001\u0003h!9\u00111E\u0010\u0005\u0002\te\u0004b\u0002B>?\u0011\u0005!Q\u0010\u0005\b\u0005\u0017{B\u0011\u0001BG\u0011\u001d\u0011Ik\bC\u0001\u0005WCqA!- \t\u0013\u0011\u0019\fC\u0004\u0003:~!\tAa/\t\u000f\t}w\u0004\"\u0001\u0003b\"I!Q^\u0010\u0002\u0002\u0013\u0005%q\u001e\u0005\n\u0005o|\u0012\u0011!CA\u0005sD\u0011ba\u0003 \u0003\u0003%Ia!\u0004\u0003#\u0005cG/\u001a:UC\ndWmQ8n[\u0006tGM\u0003\u0002-[\u000591m\\7nC:$'B\u0001\u00180\u0003\u0011AW\u000fZ5\u000b\u0005A\n\u0014aA:rY*\u0011!gM\u0001\u0006gB\f'o\u001b\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001I4iR'T!\tQ\u0014)D\u0001<\u0015\taT(A\u0004m_\u001eL7-\u00197\u000b\u0005yz\u0014!\u00029mC:\u001c(B\u0001!0\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\"<\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005\u0011+U\"A\u0016\n\u0005\u0019[#!\u0007%p_\u0012LW\rT3bMJ+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"\u0001S&\u000e\u0003%S!AS\u0019\u0002\u0011%tG/\u001a:oC2L!\u0001T%\u0003\u000f1{wmZ5oOB\u0011a*U\u0007\u0002\u001f*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\n9\u0001K]8ek\u000e$\bC\u0001+]\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002Yo\u00051AH]8pizJ\u0011\u0001U\u0005\u00037>\u000bq\u0001]1dW\u0006<W-\u0003\u0002^=\na1+\u001a:jC2L'0\u00192mK*\u00111lT\u0001\u0006i\u0006\u0014G.Z\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011AmP\u0001\bG\u0006$\u0018\r\\8h\u0013\t17M\u0001\u0007DCR\fGn\\4UC\ndW-\u0001\u0004uC\ndW\rI\u0001\bG\"\fgnZ3t+\u0005Q\u0007c\u0001+l[&\u0011AN\u0018\u0002\u0004'\u0016\f\bC\u00018s\u001b\u0005y'B\u00013q\u0015\t\tx&A\u0005d_:tWm\u0019;pe&\u00111o\u001c\u0002\f)\u0006\u0014G.Z\"iC:<W-\u0001\u0005dQ\u0006tw-Z:!\u0003)\u0019\u0007.\u00198hKRK\b/Z\u000b\u0002oB\u0019\u00010a\u0007\u000f\u0007e\f)BD\u0002{\u0003\u001fq1a_A\u0005\u001d\ra\u0018Q\u0001\b\u0004{\u0006\rab\u0001@\u0002\u00029\u0011ak`\u0005\u0002m%\u0011A'N\u0005\u0003]MJ1ASA\u0004\u0015\tq3'\u0003\u0003\u0002\f\u00055\u0011AB:dQ\u0016l\u0017MC\u0002K\u0003\u000fIA!!\u0005\u0002\u0014\u00051\u0011m\u0019;j_:TA!a\u0003\u0002\u000e%!\u0011qCA\r\u0003-!\u0016M\u00197f\u0007\"\fgnZ3\u000b\t\u0005E\u00111C\u0005\u0005\u0003;\tyB\u0001\bD_2,XN\\\"iC:<W-\u0013#\u000b\t\u0005]\u0011\u0011D\u0001\fG\"\fgnZ3UsB,\u0007%\u0001\u0004=S:LGO\u0010\u000b\t\u0003O\tI#a\u000b\u0002.A\u0011A\t\u0001\u0005\u0006?\u001e\u0001\r!\u0019\u0005\u0006Q\u001e\u0001\rA\u001b\u0005\u0006k\u001e\u0001\ra^\u0001\u0004eVtG\u0003BA\u001a\u0003{\u0001B\u0001V6\u00026A!\u0011qGA\u001d\u001b\u0005y\u0013bAA\u001e_\t\u0019!k\\<\t\u000f\u0005}\u0002\u00021\u0001\u0002B\u0005a1\u000f]1sWN+7o]5p]B!\u0011qGA\"\u0013\r\t)e\f\u0002\r'B\f'o[*fgNLwN\\\u0001\u0013CB\u0004H.\u001f*fa2\f7-Z!di&|g\u000e\u0006\u0003\u0002L\u0005E\u0003c\u0001(\u0002N%\u0019\u0011qJ(\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u007fI\u0001\u0019AA!\u0003U\t\u0007\u000f\u001d7z\u0003\u0012$\u0017i\u0019;j_:\u00144k\u00195f[\u0006$\u0002\"a\u0016\u0002`\u0005\u0005\u0014Q\r\t\u0005\u00033\nY&\u0004\u0002\u0002\u0014%!\u0011QLA\n\u00059Ie\u000e^3s]\u0006d7k\u00195f[\u0006Dq!a\u0010\u000b\u0001\u0004\t\t\u0005C\u0004\u0002d)\u0001\r!a\u0016\u0002\u0013=dGmU2iK6\f\u0007bBA4\u0015\u0001\u0007\u0011\u0011N\u0001\u000bC\u0012$7\t[1oO\u0016\u001c\b\u0003\u0002+l\u0003W\u0002B!!\u001c\u0002\u0002:!\u0011qNA@\u001d\u0011\t\t(! \u000f\t\u0005M\u00141\u0010\b\u0005\u0003k\nIHD\u0002~\u0003oJ!AM\u001a\n\u0005A\n\u0014BA90\u0013\t!\u0007/C\u0002\u0002\u0018=LA!a!\u0002\u0006\nI\u0011\t\u001a3D_2,XN\u001c\u0006\u0004\u0003/y\u0017\u0001G1qa2LH)\u001a7fi\u0016\f5\r^5p]J\u001a6\r[3nCRA\u0011qKAF\u0003\u001b\u000by\tC\u0004\u0002@-\u0001\r!!\u0011\t\u000f\u0005\r4\u00021\u0001\u0002X!9\u0011\u0011S\u0006A\u0002\u0005M\u0015!\u00043fY\u0016$Xm\u00115b]\u001e,7\u000f\u0005\u0003UW\u0006U\u0005\u0003BA7\u0003/KA!!'\u0002\u0006\naA)\u001a7fi\u0016\u001cu\u000e\\;n]\u0006q\u0011\r\u001d9ms\u0006#G-Q2uS>tG\u0003BA&\u0003?Cq!a\u0010\r\u0001\u0004\t\t%A\tbaBd\u0017\u0010R3mKR,\u0017i\u0019;j_:$B!a\u0013\u0002&\"9\u0011qH\u0007A\u0002\u0005\u0005\u0013!E1qa2LX\u000b\u001d3bi\u0016\f5\r^5p]R!\u00111JAV\u0011\u001d\tyD\u0004a\u0001\u0003\u0003\n!#\u00199qYf\u0004&o\u001c9feRLXK\\:fiR!\u00111JAY\u0011\u001d\tyd\u0004a\u0001\u0003\u0003\n\u0001#\u00199qYf\u0004&o\u001c9feRL8+\u001a;\u0015\t\u0005-\u0013q\u0017\u0005\b\u0003\u007f\u0001\u0002\u0019AA!\u0003\u0011:W\r^%oi\u0016\u0014h.\u00197TG\",W.Y!oI\"K7\u000f^8ssN\u001b\u0007.Z7b'R\u0014H\u0003BA_\u0003'\u0004rATA`\u0003/\n\u0019-C\u0002\u0002B>\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BAc\u0003\u001btA!a2\u0002JB\u0011akT\u0005\u0004\u0003\u0017|\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002P\u0006E'AB*ue&twMC\u0002\u0002L>Cq!a\u0010\u0012\u0001\u0004\t\t%A\tdQ\u0016\u001c7nU2iK6\f7\t[1oO\u0016$b!a\u0013\u0002Z\u0006}\u0007bBAn%\u0001\u0007\u0011Q\\\u0001\tG>dg*Y7fgB!Ak[Ab\u0011\u0019\t\tO\u0005a\u0001C\u0006a1-\u0019;bY><G+\u00192mK\u0006!1m\u001c9z)!\t9#a:\u0002j\u0006-\bbB0\u0014!\u0003\u0005\r!\u0019\u0005\bQN\u0001\n\u00111\u0001k\u0011\u001d)8\u0003%AA\u0002]\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002r*\u001a\u0011-a=,\u0005\u0005U\b\u0003BA|\u0005\u0003i!!!?\u000b\t\u0005m\u0018Q`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a@P\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0007\tIPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\n)\u001a!.a=\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0002\u0016\u0004o\u0006M\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0016A!!q\u0003B\u0011\u001b\t\u0011IB\u0003\u0003\u0003\u001c\tu\u0011\u0001\u00027b]\u001eT!Aa\b\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\u0014I\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003(A\u0019aJ!\u000b\n\u0007\t-rJA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00032\t]\u0002c\u0001(\u00034%\u0019!QG(\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003:e\t\t\u00111\u0001\u0003(\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0010\u0011\r\t\u0005#q\tB\u0019\u001b\t\u0011\u0019EC\u0002\u0003F=\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IEa\u0011\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u001f\u0012)\u0006E\u0002O\u0005#J1Aa\u0015P\u0005\u001d\u0011un\u001c7fC:D\u0011B!\u000f\u001c\u0003\u0003\u0005\rA!\r\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005+\u0011Y\u0006C\u0005\u0003:q\t\t\u00111\u0001\u0003(\u00051Q-];bYN$BAa\u0014\u0003b!I!\u0011H\u000f\u0002\u0002\u0003\u0007!\u0011G\u0001\u0012\u00032$XM\u001d+bE2,7i\\7nC:$\u0007C\u0001# '\u0019y\"\u0011N$\u0003pA\u0019aJa\u001b\n\u0007\t5tJ\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0005c\u00129(\u0004\u0002\u0003t)!!Q\u000fB\u000f\u0003\tIw.C\u0002^\u0005g\"\"A!\u001a\u0002!\r|W.\\5u/&$\bnU2iK6\fGCCA&\u0005\u007f\u0012\u0019Ia\"\u0003\n\"9!\u0011Q\u0011A\u0002\u0005]\u0013AD5oi\u0016\u0014h.\u00197TG\",W.\u0019\u0005\b\u0005\u000b\u000b\u0003\u0019AAb\u0003AA\u0017n\u001d;pef\u001c6\r[3nCN#(\u000fC\u0003`C\u0001\u0007\u0011\rC\u0004\u0002@\u0005\u0002\r!!\u0011\u0002)\u0005dG/\u001a:UC\ndW\rR1uCN\u001b\u0007.Z7b))\tYEa$\u0003\u0012\nU%\u0011\u0014\u0005\b\u0003\u007f\u0011\u0003\u0019AA!\u0011\u001d\u0011\u0019J\ta\u0001\u0003\u0007\f!\u0001\u001a2\t\u000f\t]%\u00051\u0001\u0002D\u0006IA/\u00192mK:\u000bW.\u001a\u0005\b\u00057\u0013\u0003\u0019\u0001BO\u0003=!\u0017\r^1Ta\u0006\u00148nU2iK6\f\u0007\u0003\u0002BP\u0005Kk!A!)\u000b\u0007\t\rv&A\u0003usB,7/\u0003\u0003\u0003(\n\u0005&AC*ueV\u001cG\u000fV=qK\u0006\u0001r-\u001a;UC\ndW\rT8dCRLwN\u001c\u000b\u0007\u0003\u0007\u0014iKa,\t\u000b}\u001b\u0003\u0019A1\t\u000f\u0005}2\u00051\u0001\u0002B\u0005\t\"/Z7pm\u0016\u0004F.Y2f\u0011>dG-\u001a:\u0015\t\u0005\r'Q\u0017\u0005\b\u0005o#\u0003\u0019AAb\u0003\u0011\u0001\u0018\r\u001e5\u0002#5\f7.\u001a)bi\"\fV/\u00197jM&,G\r\u0006\u0004\u0002D\nu&1\u001a\u0005\b\u0005o+\u0003\u0019\u0001B`!\u0011\u0011\tMa2\u000e\u0005\t\r'\u0002\u0002Bc\u0005;\t1A\\3u\u0013\u0011\u0011IMa1\u0003\u0007U\u0013\u0016\nC\u0004\u0003N\u0016\u0002\rAa4\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0003R\nmWB\u0001Bj\u0015\u0011\u0011)Na6\u0002\t\r|gN\u001a\u0006\u0004\u00053\u001c\u0014A\u00025bI>|\u0007/\u0003\u0003\u0003^\nM'!D\"p]\u001aLw-\u001e:bi&|g.A\u0007hKR\u0004\u0016M]3oi:\u000bW.\u001a\u000b\u0005\u0003\u0007\u0014\u0019\u000fC\u0004\u0003f\u001a\u0002\rAa:\u0002\u000b9\fW.Z:\u0011\u000b9\u0013I/a1\n\u0007\t-xJA\u0003BeJ\f\u00170A\u0003baBd\u0017\u0010\u0006\u0005\u0002(\tE(1\u001fB{\u0011\u0015yv\u00051\u0001b\u0011\u0015Aw\u00051\u0001k\u0011\u0015)x\u00051\u0001x\u0003\u001d)h.\u00199qYf$BAa?\u0004\bA)aJ!@\u0004\u0002%\u0019!q`(\u0003\r=\u0003H/[8o!\u0019q51A1ko&\u00191QA(\u0003\rQ+\b\u000f\\34\u0011%\u0019I\u0001KA\u0001\u0002\u0004\t9#A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"aa\u0004\u0011\t\t]1\u0011C\u0005\u0005\u0007'\u0011IB\u0001\u0004PE*,7\r\u001e")
public class AlterTableCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
Serializable {
    private final CatalogTable table;
    private final Seq<TableChange> changes;
    private final TableChange.ColumnChangeID changeType;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<CatalogTable, Seq<TableChange>, TableChange.ColumnChangeID>> unapply(AlterTableCommand x$0) {
        return AlterTableCommand$.MODULE$.unapply(x$0);
    }

    public static String getParentName(String[] names) {
        return AlterTableCommand$.MODULE$.getParentName(names);
    }

    public static String makePathQualified(URI path, Configuration hadoopConf) {
        return AlterTableCommand$.MODULE$.makePathQualified(path, hadoopConf);
    }

    public static String getTableLocation(CatalogTable table, SparkSession sparkSession) {
        return AlterTableCommand$.MODULE$.getTableLocation(table, sparkSession);
    }

    public static void alterTableDataSchema(SparkSession sparkSession, String db, String tableName, StructType dataSparkSchema) {
        AlterTableCommand$.MODULE$.alterTableDataSchema(sparkSession, db, tableName, dataSparkSchema);
    }

    public static void commitWithSchema(InternalSchema internalSchema, String historySchemaStr, CatalogTable table, SparkSession sparkSession) {
        AlterTableCommand$.MODULE$.commitWithSchema(internalSchema, historySchemaStr, table, sparkSession);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableCommand alterTableCommand = this;
        synchronized (alterTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public CatalogTable table() {
        return this.table;
    }

    public Seq<TableChange> changes() {
        return this.changes;
    }

    public TableChange.ColumnChangeID changeType() {
        return this.changeType;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Seq<Row> run(SparkSession sparkSession) {
        boolean bl = false;
        TableChange.ColumnChangeID columnChangeID = null;
        TableChange.ColumnChangeID columnChangeID2 = this.changeType();
        if (((Object)((Object)TableChange.ColumnChangeID.ADD)).equals((Object)columnChangeID2)) {
            this.applyAddAction(sparkSession);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (Seq)package$.MODULE$.Seq().empty();
        }
        if (((Object)((Object)TableChange.ColumnChangeID.DELETE)).equals((Object)columnChangeID2)) {
            this.applyDeleteAction(sparkSession);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (Seq)package$.MODULE$.Seq().empty();
        }
        if (((Object)((Object)TableChange.ColumnChangeID.UPDATE)).equals((Object)columnChangeID2)) {
            this.applyUpdateAction(sparkSession);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (Seq)package$.MODULE$.Seq().empty();
        }
        if (((Object)((Object)TableChange.ColumnChangeID.PROPERTY_CHANGE)).equals((Object)columnChangeID2)) {
            bl = true;
            columnChangeID = columnChangeID2;
            if (((SeqOps)this.changes().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterTableCommand.$anonfun$run$1(x$1)))).size() == this.changes().size()) {
                this.applyPropertySet(sparkSession);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (Seq)package$.MODULE$.Seq().empty();
            }
        }
        if (bl && ((SeqOps)this.changes().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterTableCommand.$anonfun$run$2(x$2)))).size() == this.changes().size()) {
            this.applyPropertyUnset(sparkSession);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (Seq)package$.MODULE$.Seq().empty();
        }
        if (!((Object)((Object)TableChange.ColumnChangeID.REPLACE)).equals((Object)columnChangeID2)) throw new RuntimeException(new StringBuilder(37).append("find unsupported alter command type: ").append((Object)columnChangeID2).toString());
        this.applyReplaceAction(sparkSession);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public void applyReplaceAction(SparkSession sparkSession) {
        Seq deleteChanges = (Seq)((IterableOps)this.changes().filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AlterTableCommand.$anonfun$applyReplaceAction$1(p)))).map((Function1 & Serializable)x$3 -> (TableChange.DeleteColumn)x$3);
        Seq addChanges = (Seq)((IterableOps)this.changes().filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AlterTableCommand.$anonfun$applyReplaceAction$3(p)))).map((Function1 & Serializable)x$4 -> (TableChange.AddColumn)x$4);
        Tuple2<InternalSchema, String> tuple2 = this.getInternalSchemaAndHistorySchemaStr(sparkSession);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InternalSchema oldSchema = (InternalSchema)tuple2._1();
        String historySchema = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)oldSchema, (Object)historySchema);
        Tuple2 tuple23 = tuple22;
        InternalSchema oldSchema2 = (InternalSchema)tuple23._1();
        String historySchema2 = (String)tuple23._2();
        InternalSchema newSchema = this.applyAddAction2Schema(sparkSession, this.applyDeleteAction2Schema(sparkSession, oldSchema2, (Seq<TableChange.DeleteColumn>)deleteChanges), (Seq<TableChange.AddColumn>)addChanges);
        String verifiedHistorySchema = historySchema2 == null || historySchema2.isEmpty() ? SerDeHelper.inheritSchemas(oldSchema2, "") : historySchema2;
        AlterTableCommand$.MODULE$.commitWithSchema(newSchema, verifiedHistorySchema, this.table(), sparkSession);
        this.logInfo((Function0 & Serializable)() -> "column replace finished");
    }

    public InternalSchema applyAddAction2Schema(SparkSession sparkSession, InternalSchema oldSchema, Seq<TableChange.AddColumn> addChanges) {
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get(oldSchema);
        addChanges.foreach((Function1 & Serializable)addColumn -> {
            Object object;
            String[] names = addColumn.fieldNames();
            String parentName = AlterTableCommand$.MODULE$.getParentName(names);
            Type colType = SparkInternalSchemaConverter.buildTypeFromStructType(addColumn.dataType(), Predef$.MODULE$.boolean2Boolean(true), new AtomicInteger(0));
            addChange.addColumns(parentName, (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])names)), colType, addColumn.comment());
            TableChange.ColumnPosition columnPosition = addColumn.position();
            if (columnPosition instanceof TableChange.After) {
                TableChange.After after = (TableChange.After)columnPosition;
                object = addChange.addPositionChange(Predef$.MODULE$.wrapRefArray((Object[])names).mkString("."), parentName.isEmpty() ? after.column() : new StringBuilder(1).append(parentName).append(".").append(after.column()).toString(), "after");
            } else {
                object = columnPosition instanceof TableChange.First ? addChange.addPositionChange(Predef$.MODULE$.wrapRefArray((Object[])names).mkString("."), "", "first") : BoxedUnit.UNIT;
            }
            return object;
        });
        return SchemaChangeUtils.applyTableChanges2Schema(oldSchema, addChange);
    }

    private InternalSchema applyDeleteAction2Schema(SparkSession sparkSession, InternalSchema oldSchema, Seq<TableChange.DeleteColumn> deleteChanges) {
        TableChanges.ColumnDeleteChange deleteChange = TableChanges.ColumnDeleteChange.get(oldSchema);
        deleteChanges.foreach((Function1 & Serializable)c -> {
            String originalColName = Predef$.MODULE$.wrapRefArray((Object[])c.fieldNames()).mkString(".");
            this.checkSchemaChange((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{originalColName}))), this.table());
            return deleteChange.deleteColumn(originalColName);
        });
        InternalSchema newSchema = SchemaChangeUtils.applyTableChanges2Schema(oldSchema, deleteChange);
        newSchema.setMaxColumnId(oldSchema.getMaxColumnId());
        return newSchema;
    }

    public void applyAddAction(SparkSession sparkSession) {
        Tuple2<InternalSchema, String> tuple2 = this.getInternalSchemaAndHistorySchemaStr(sparkSession);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InternalSchema oldSchema = (InternalSchema)tuple2._1();
        String historySchema = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)oldSchema, (Object)historySchema);
        Tuple2 tuple23 = tuple22;
        InternalSchema oldSchema2 = (InternalSchema)tuple23._1();
        String historySchema2 = (String)tuple23._2();
        InternalSchema newSchema = this.applyAddAction2Schema(sparkSession, oldSchema2, (Seq<TableChange.AddColumn>)((Seq)this.changes().map((Function1 & Serializable)x$7 -> (TableChange.AddColumn)x$7)));
        String verifiedHistorySchema = historySchema2 == null || historySchema2.isEmpty() ? SerDeHelper.inheritSchemas(oldSchema2, "") : historySchema2;
        AlterTableCommand$.MODULE$.commitWithSchema(newSchema, verifiedHistorySchema, this.table(), sparkSession);
        this.logInfo((Function0 & Serializable)() -> "column add finished");
    }

    public void applyDeleteAction(SparkSession sparkSession) {
        Tuple2<InternalSchema, String> tuple2 = this.getInternalSchemaAndHistorySchemaStr(sparkSession);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InternalSchema oldSchema = (InternalSchema)tuple2._1();
        String historySchema = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)oldSchema, (Object)historySchema);
        Tuple2 tuple23 = tuple22;
        InternalSchema oldSchema2 = (InternalSchema)tuple23._1();
        String historySchema2 = (String)tuple23._2();
        InternalSchema newSchema = this.applyDeleteAction2Schema(sparkSession, oldSchema2, (Seq<TableChange.DeleteColumn>)((Seq)this.changes().map((Function1 & Serializable)x$9 -> (TableChange.DeleteColumn)x$9)));
        String verifiedHistorySchema = historySchema2 == null || historySchema2.isEmpty() ? SerDeHelper.inheritSchemas(oldSchema2, "") : historySchema2;
        AlterTableCommand$.MODULE$.commitWithSchema(newSchema, verifiedHistorySchema, this.table(), sparkSession);
        this.logInfo((Function0 & Serializable)() -> "column delete finished");
    }

    public void applyUpdateAction(SparkSession sparkSession) {
        Tuple2<InternalSchema, String> tuple2 = this.getInternalSchemaAndHistorySchemaStr(sparkSession);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InternalSchema oldSchema = (InternalSchema)tuple2._1();
        String historySchema = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)oldSchema, (Object)historySchema);
        Tuple2 tuple23 = tuple22;
        InternalSchema oldSchema2 = (InternalSchema)tuple23._1();
        String historySchema2 = (String)tuple23._2();
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get(oldSchema2);
        this.changes().foreach((Function1 & Serializable)change -> {
            TableChanges.ColumnUpdateChange columnUpdateChange;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.UpdateColumnType) {
                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)tableChange;
                Type newType = SparkInternalSchemaConverter.buildTypeFromStructType(updateColumnType.newDataType(), Predef$.MODULE$.boolean2Boolean(true), new AtomicInteger(0));
                columnUpdateChange = updateChange.updateColumnType(Predef$.MODULE$.wrapRefArray((Object[])updateColumnType.fieldNames()).mkString("."), newType);
            } else if (tableChange instanceof TableChange.UpdateColumnComment) {
                TableChange.UpdateColumnComment updateColumnComment = (TableChange.UpdateColumnComment)tableChange;
                columnUpdateChange = updateChange.updateColumnComment(Predef$.MODULE$.wrapRefArray((Object[])updateColumnComment.fieldNames()).mkString("."), updateColumnComment.newComment());
            } else if (tableChange instanceof TableChange.RenameColumn) {
                TableChange.RenameColumn renameColumn = (TableChange.RenameColumn)tableChange;
                String originalColName = Predef$.MODULE$.wrapRefArray((Object[])renameColumn.fieldNames()).mkString(".");
                this.checkSchemaChange((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{originalColName}))), this.table());
                columnUpdateChange = updateChange.renameColumn(originalColName, renameColumn.newName());
            } else if (tableChange instanceof TableChange.UpdateColumnNullability) {
                TableChange.UpdateColumnNullability updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange;
                columnUpdateChange = updateChange.updateColumnNullability(Predef$.MODULE$.wrapRefArray((Object[])updateColumnNullability.fieldNames()).mkString("."), updateColumnNullability.nullable());
            } else if (tableChange instanceof TableChange.UpdateColumnPosition) {
                Object object;
                TableChange.UpdateColumnPosition updateColumnPosition = (TableChange.UpdateColumnPosition)tableChange;
                String[] names = updateColumnPosition.fieldNames();
                String parentName = AlterTableCommand$.MODULE$.getParentName(names);
                TableChange.ColumnPosition columnPosition = updateColumnPosition.position();
                if (columnPosition instanceof TableChange.After) {
                    TableChange.After after = (TableChange.After)columnPosition;
                    object = updateChange.addPositionChange(Predef$.MODULE$.wrapRefArray((Object[])names).mkString("."), parentName.isEmpty() ? after.column() : new StringBuilder(1).append(parentName).append(".").append(after.column()).toString(), "after");
                } else {
                    object = columnPosition instanceof TableChange.First ? updateChange.addPositionChange(Predef$.MODULE$.wrapRefArray((Object[])names).mkString("."), "", "first") : BoxedUnit.UNIT;
                }
                columnUpdateChange = object;
            } else {
                throw new MatchError((Object)tableChange);
            }
            return columnUpdateChange;
        });
        InternalSchema newSchema = SchemaChangeUtils.applyTableChanges2Schema(oldSchema2, updateChange);
        String verifiedHistorySchema = historySchema2 == null || historySchema2.isEmpty() ? SerDeHelper.inheritSchemas(oldSchema2, "") : historySchema2;
        AlterTableCommand$.MODULE$.commitWithSchema(newSchema, verifiedHistorySchema, this.table(), sparkSession);
        this.logInfo((Function0 & Serializable)() -> "column update finished");
    }

    public void applyPropertyUnset(SparkSession sparkSession) {
        Map newProperties;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        Seq propKeys = (Seq)((IterableOps)this.changes().map((Function1 & Serializable)x$11 -> (TableChange.RemoveProperty)x$11)).map((Function1 & Serializable)x$12 -> x$12.property());
        propKeys.foreach((Function1 & Serializable)k -> {
            AlterTableCommand.$anonfun$applyPropertyUnset$3(this, k);
            return BoxedUnit.UNIT;
        });
        None$ tableComment = propKeys.contains((Object)"comment") ? None$.MODULE$ : this.table().comment();
        Map x$1 = newProperties = (Map)this.table().properties().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AlterTableCommand.$anonfun$applyPropertyUnset$5(propKeys, x0$1)));
        None$ x$2 = tableComment;
        TableIdentifier x$3 = this.table().copy$default$1();
        CatalogTableType x$4 = this.table().copy$default$2();
        CatalogStorageFormat x$5 = this.table().copy$default$3();
        StructType x$6 = this.table().copy$default$4();
        Option x$7 = this.table().copy$default$5();
        Seq x$8 = this.table().copy$default$6();
        Option x$9 = this.table().copy$default$7();
        String x$10 = this.table().copy$default$8();
        long x$112 = this.table().copy$default$9();
        long x$122 = this.table().copy$default$10();
        String x$13 = this.table().copy$default$11();
        Option x$14 = this.table().copy$default$13();
        Option x$15 = this.table().copy$default$14();
        Seq x$16 = this.table().copy$default$16();
        boolean x$17 = this.table().copy$default$17();
        boolean x$18 = this.table().copy$default$18();
        Map x$19 = this.table().copy$default$19();
        Option x$20 = this.table().copy$default$20();
        CatalogTable newTable = this.table().copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$112, x$122, x$13, x$1, x$14, x$15, (Option)x$2, x$16, x$17, x$18, x$19, x$20);
        catalog.alterTable(newTable);
        this.logInfo((Function0 & Serializable)() -> "table properties change finished");
    }

    public void applyPropertySet(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        Map properties2 = ((IterableOnceOps)((IterableOps)this.changes().map((Function1 & Serializable)x$13 -> (TableChange.SetProperty)x$13)).map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.property()), (Object)f.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map x$1 = (Map)this.table().properties().$plus$plus((IterableOnce)properties2);
        Option x$2 = properties2.get((Object)"comment").orElse((Function0 & Serializable)() -> this.table().comment());
        TableIdentifier x$3 = this.table().copy$default$1();
        CatalogTableType x$4 = this.table().copy$default$2();
        CatalogStorageFormat x$5 = this.table().copy$default$3();
        StructType x$6 = this.table().copy$default$4();
        Option x$7 = this.table().copy$default$5();
        Seq x$8 = this.table().copy$default$6();
        Option x$9 = this.table().copy$default$7();
        String x$10 = this.table().copy$default$8();
        long x$11 = this.table().copy$default$9();
        long x$12 = this.table().copy$default$10();
        String x$132 = this.table().copy$default$11();
        Option x$14 = this.table().copy$default$13();
        Option x$15 = this.table().copy$default$14();
        Seq x$16 = this.table().copy$default$16();
        boolean x$17 = this.table().copy$default$17();
        boolean x$18 = this.table().copy$default$18();
        Map x$19 = this.table().copy$default$19();
        Option x$20 = this.table().copy$default$20();
        CatalogTable newTable = this.table().copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$132, x$1, x$14, x$15, x$2, x$16, x$17, x$18, x$19, x$20);
        catalog.alterTable(newTable);
        this.logInfo((Function0 & Serializable)() -> "table properties change finished");
    }

    public Tuple2<InternalSchema, String> getInternalSchemaAndHistorySchemaStr(SparkSession sparkSession) {
        String path = AlterTableCommand$.MODULE$.getTableLocation(this.table(), sparkSession);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(path).setConf(HadoopFSUtils.getStorageConf(sparkSession.sessionState().newHadoopConf())).build();
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        InternalSchema schema = schemaUtil.getTableInternalSchemaFromCommitMetadata().orElse(AvroInternalSchemaConverter.convert(schemaUtil.getTableAvroSchema()));
        String historySchemaStr = schemaUtil.getTableHistorySchemaStrFromCommitMetadata().orElse("");
        return new Tuple2((Object)schema, (Object)historySchemaStr);
    }

    public void checkSchemaChange(Seq<String> colNames, CatalogTable catalogTable) {
        String[] primaryKeys = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)catalogTable.storage().properties().getOrElse((Object)"primaryKey", (Function0 & Serializable)() -> (String)catalogTable.properties().getOrElse((Object)"primaryKey", (Function0 & Serializable)() -> "keyid"))).split(",")), (Function1 & Serializable)x$14 -> x$14.trim(), ClassTag$.MODULE$.apply(String.class));
        Seq preCombineKey = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)catalogTable.storage().properties().getOrElse((Object)"preCombineField", (Function0 & Serializable)() -> (String)catalogTable.properties().getOrElse((Object)"preCombineField", (Function0 & Serializable)() -> "ts"))})).map((Function1 & Serializable)x$15 -> x$15.trim());
        Seq partitionKey = (Seq)catalogTable.partitionColumnNames().map((Function1 & Serializable)x$16 -> x$16.trim());
        String[] checkNames = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])primaryKeys), (IterableOnce)preCombineKey, ClassTag$.MODULE$.apply(String.class))), (IterableOnce)partitionKey, ClassTag$.MODULE$.apply(String.class));
        colNames.foreach((Function1 & Serializable)col -> {
            AlterTableCommand.$anonfun$checkSchemaChange$8(checkNames, col);
            return BoxedUnit.UNIT;
        });
    }

    public AlterTableCommand copy(CatalogTable table, Seq<TableChange> changes, TableChange.ColumnChangeID changeType) {
        return new AlterTableCommand(table, changes, changeType);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public Seq<TableChange> copy$default$2() {
        return this.changes();
    }

    public TableChange.ColumnChangeID copy$default$3() {
        return this.changeType();
    }

    public String productPrefix() {
        return "AlterTableCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.changes();
                break;
            }
            case 2: {
                object = this.changeType();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "table";
                break;
            }
            case 1: {
                string = "changes";
                break;
            }
            case 2: {
                string = "changeType";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableCommand alterTableCommand = (AlterTableCommand)x$1;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = alterTableCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        Seq<TableChange> seq = this.changes();
        Seq<TableChange> seq2 = alterTableCommand.changes();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        TableChange.ColumnChangeID columnChangeID = this.changeType();
        TableChange.ColumnChangeID columnChangeID2 = alterTableCommand.changeType();
        if (columnChangeID == null) {
            if (columnChangeID2 != null) {
                return false;
            }
        } else if (!((Object)((Object)columnChangeID)).equals((Object)columnChangeID2)) return false;
        if (!alterTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$run$1(TableChange x$1) {
        return x$1 instanceof TableChange.SetProperty;
    }

    public static final /* synthetic */ boolean $anonfun$run$2(TableChange x$2) {
        return x$2 instanceof TableChange.RemoveProperty;
    }

    public static final /* synthetic */ boolean $anonfun$applyReplaceAction$1(TableChange p) {
        return p instanceof TableChange.DeleteColumn;
    }

    public static final /* synthetic */ boolean $anonfun$applyReplaceAction$3(TableChange p) {
        return p instanceof TableChange.AddColumn;
    }

    public static final /* synthetic */ void $anonfun$applyPropertyUnset$3(AlterTableCommand $this, String k) {
        block1: {
            if ($this.table().properties().contains((Object)k)) break block1;
            String string = k;
            String string2 = "comment";
            if (string == null ? string2 != null : !string.equals(string2)) {
                $this.logWarning((Function0 & Serializable)() -> new StringBuilder(43).append("find non exist unset property: ").append(k).append(" , ignore it").toString());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$applyPropertyUnset$5(Seq propKeys$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = !propKeys$1.contains((Object)k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$checkSchemaChange$8(String[] checkNames$1, String col) {
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])checkNames$1), (Object)col)) {
            throw new UnsupportedOperationException("cannot support apply changes for primaryKey/CombineKey/partitionKey");
        }
    }

    public AlterTableCommand(CatalogTable table, Seq<TableChange> changes, TableChange.ColumnChangeID changeType) {
        this.table = table;
        this.changes = changes;
        this.changeType = changeType;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        Statics.releaseFence();
    }
}

