/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.SparkConf;
import org.apache.spark.package$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.hive.HiveClientUtils$;
import org.apache.spark.sql.hive.HiveExternalCatalog$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CreateHoodieTableCommand$
implements Serializable {
    public static final CreateHoodieTableCommand$ MODULE$ = new CreateHoodieTableCommand$();

    public boolean validateTableSchema(StructType userDefinedSchema, StructType hoodieTableSchema) {
        boolean bl;
        if (userDefinedSchema.fields().length != 0 && userDefinedSchema.fields().length != hoodieTableSchema.fields().length) {
            bl = false;
        } else if (userDefinedSchema.fields().length != 0) {
            StructField[] sortedHoodieTableFields = (StructField[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])hoodieTableSchema.fields()), (Function1 & Serializable)x$1 -> x$1.name(), (Ordering)Ordering.String$.MODULE$);
            StructField[] sortedUserDefinedFields = (StructField[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])userDefinedSchema.fields()), (Function1 & Serializable)x$2 -> x$2.name(), (Ordering)Ordering.String$.MODULE$);
            boolean diffResult = ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])sortedHoodieTableFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])sortedUserDefinedFields))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CreateHoodieTableCommand$.$anonfun$validateTableSchema$3(x0$1)));
            if (!diffResult) {
                throw new HoodieValidationException(new StringBuilder(0).append("The defined schema is inconsistent with the schema in the hoodie metadata directory,").append(new StringBuilder(21).append(" hoodieTableSchema: ").append(hoodieTableSchema.simpleString()).append(",").toString()).append(new StringBuilder(20).append(" userDefinedSchema: ").append(userDefinedSchema.simpleString()).toString()).toString());
            }
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    public void validateTblProperties(HoodieCatalogTable hoodieCatalogTable) {
        block0: {
            if (!hoodieCatalogTable.hoodieTableExists()) break block0;
            Map originTableConfig = ((IterableOnceOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)hoodieCatalogTable.tableConfig().getProps()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map<String, String> tableOptions = hoodieCatalogTable.catalogProperties();
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.PRECOMBINE_FIELD.key());
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.PARTITION_FIELDS.key());
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.RECORDKEY_FIELDS.key());
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key());
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.URL_ENCODE_PARTITIONING.key());
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key());
        }
    }

    public void createTableInCatalog(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, boolean ignoreIfExists, Option<String> queryAsProp) {
        CatalogTable table = hoodieCatalogTable.table();
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        Predef$.MODULE$.assert(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2));
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        String path = hoodieCatalogTable.tableLocation();
        HoodieTableConfig tableConfig = hoodieCatalogTable.tableConfig();
        Map properties2 = ((IterableOnceOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)tableConfig.getProps()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        String tableType = tableConfig.getTableType().name();
        HoodieFileFormat fileFormat = tableConfig.getBaseFileFormat();
        String string = tableType;
        String string2 = DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL();
        String inputFormat = HoodieInputFormatUtils.getInputFormatClassName(fileFormat, !(string != null ? !string.equals(string2) : string2 != null));
        String outputFormat = HoodieInputFormatUtils.getOutputFormatClassName(fileFormat);
        String serdeFormat = HoodieInputFormatUtils.getSerDeClassName(fileFormat);
        Map<String, String> storageProperties = HoodieOptionConfig$.MODULE$.deleteHoodieOptions((Map<String, String>)properties2);
        CatalogStorageFormat newStorage = new CatalogStorageFormat((Option)new Some((Object)new Path(path).toUri()), (Option)new Some((Object)inputFormat), (Option)new Some((Object)outputFormat), (Option)new Some((Object)serdeFormat), table.storage().compressed(), (Map)storageProperties.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)).$plus$plus((IterableOnce)queryAsProp.map((Function1 & Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), x$3))));
        String tableName = HoodieSqlCommonUtils$.MODULE$.formatName(sparkSession, table.identifier().table());
        String newDatabaseName = HoodieSqlCommonUtils$.MODULE$.formatName(sparkSession, (String)table.identifier().database().getOrElse((Function0 & Serializable)() -> catalog.getCurrentDatabase()));
        TableIdentifier newTableIdentifier = table.identifier().copy(tableName, (Option)new Some((Object)newDatabaseName), table.identifier().copy$default$3());
        Seq partitionColumnNames = (Seq)hoodieCatalogTable.partitionSchema().map((Function1 & Serializable)x$4 -> x$4.name());
        Map newTblProperties = (Map)hoodieCatalogTable.catalogProperties().$minus$minus(HoodieCatalogTable$.MODULE$.needFilterProps()).$plus$plus(HoodieOptionConfig$.MODULE$.extractSqlOptions((Map<String, String>)properties2));
        newTblProperties = (Map)newTblProperties.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"hudi")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path));
        TableIdentifier x$1 = newTableIdentifier;
        CatalogStorageFormat x$2 = newStorage;
        StructType x$32 = hoodieCatalogTable.tableSchema();
        Some x$42 = new Some((Object)"hudi");
        Seq x$5 = partitionColumnNames;
        String x$6 = package$.MODULE$.SPARK_VERSION();
        Map x$7 = newTblProperties;
        CatalogTableType x$8 = table.copy$default$2();
        Option x$9 = table.copy$default$7();
        String x$10 = table.copy$default$8();
        long x$11 = table.copy$default$9();
        long x$12 = table.copy$default$10();
        Option x$13 = table.copy$default$13();
        Option x$14 = table.copy$default$14();
        Option x$15 = table.copy$default$15();
        Seq x$16 = table.copy$default$16();
        boolean x$17 = table.copy$default$17();
        boolean x$18 = table.copy$default$18();
        Map x$19 = table.copy$default$19();
        Option x$20 = table.copy$default$20();
        CatalogTable newTable = table.copy(x$1, x$8, x$2, x$32, (Option)x$42, x$5, x$9, x$10, x$11, x$12, x$6, x$7, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        boolean enableHive = HoodieSqlCommonUtils$.MODULE$.isUsingHiveCatalog(sparkSession);
        if (enableHive) {
            this.createHiveDataSourceTable(sparkSession, newTable);
        } else {
            catalog.createTable(newTable, false, false);
        }
    }

    public Option<String> createTableInCatalog$default$4() {
        return None$.MODULE$;
    }

    private void createHiveDataSourceTable(SparkSession sparkSession, CatalogTable table) {
        String dbName = (String)table.identifier().database().get();
        boolean dbExists = sparkSession.sessionState().catalog().databaseExists(dbName);
        if (!dbExists) {
            throw new NoSuchDatabaseException(dbName);
        }
        Map<String, String> dataSourceProps = this.tableMetaToTableProps(sparkSession.sparkContext().conf(), table, table.schema());
        Map x$1 = (Map)dataSourceProps.$plus$plus((IterableOnce)table.properties());
        TableIdentifier x$2 = table.copy$default$1();
        CatalogTableType x$3 = table.copy$default$2();
        CatalogStorageFormat x$4 = table.copy$default$3();
        StructType x$5 = table.copy$default$4();
        Option x$6 = table.copy$default$5();
        Seq x$7 = table.copy$default$6();
        Option x$8 = table.copy$default$7();
        String x$9 = table.copy$default$8();
        long x$10 = table.copy$default$9();
        long x$11 = table.copy$default$10();
        String x$12 = table.copy$default$11();
        Option x$13 = table.copy$default$13();
        Option x$14 = table.copy$default$14();
        Option x$15 = table.copy$default$15();
        Seq x$16 = table.copy$default$16();
        boolean x$17 = table.copy$default$17();
        boolean x$18 = table.copy$default$18();
        Map x$19 = table.copy$default$19();
        Option x$20 = table.copy$default$20();
        CatalogTable tableWithDataSourceProps = table.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        HiveClient client = HiveClientUtils$.MODULE$.getSingletonClientForMetadata(sparkSession);
        client.createTable(tableWithDataSourceProps, true);
    }

    private Map<String, String> tableMetaToTableProps(SparkConf sparkConf, CatalogTable table, StructType schema) {
        HashMap properties2;
        block3: {
            Seq partitionColumns = table.partitionColumnNames();
            Option bucketSpec = table.bucketSpec();
            properties2 = new HashMap();
            properties2.put((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_PROVIDER(), (Object)"hudi");
            properties2.put((Object)HiveExternalCatalog$.MODULE$.CREATED_SPARK_VERSION(), (Object)table.createVersion());
            int threshold = BoxesRunTime.unboxToInt((Object)sparkConf.get(StaticSQLConf$.MODULE$.SCHEMA_STRING_LENGTH_THRESHOLD()));
            String schemaJsonString = schema.json();
            Seq parts = StringOps$.MODULE$.grouped$extension(Predef$.MODULE$.augmentString(schemaJsonString), threshold).toSeq();
            properties2.put((Object)new StringBuilder(8).append(HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_PREFIX()).append("numParts").toString(), (Object)Integer.toString(parts.size()));
            ((IterableOnceOps)parts.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String part = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Option option = properties2.put((Object)new StringBuilder(0).append(HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_PART_PREFIX()).append(index).toString(), (Object)part);
                return option;
            });
            if (partitionColumns.nonEmpty()) {
                properties2.put((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_NUMPARTCOLS(), (Object)Integer.toString(partitionColumns.length()));
                ((IterableOnceOps)partitionColumns.zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String partCol = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Option option = properties2.put((Object)new StringBuilder(0).append(HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_PARTCOL_PREFIX()).append(index).toString(), (Object)partCol);
                    return option;
                });
            }
            if (!bucketSpec.isDefined()) break block3;
            BucketSpec bucketSpec2 = (BucketSpec)bucketSpec.get();
            if (bucketSpec2 == null) {
                throw new MatchError((Object)bucketSpec2);
            }
            int numBuckets = bucketSpec2.numBuckets();
            Seq bucketColumnNames = bucketSpec2.bucketColumnNames();
            Seq sortColumnNames = bucketSpec2.sortColumnNames();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)numBuckets), (Object)bucketColumnNames, (Object)sortColumnNames);
            Tuple3 tuple32 = tuple3;
            int numBuckets2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            Seq bucketColumnNames2 = (Seq)tuple32._2();
            Seq sortColumnNames2 = (Seq)tuple32._3();
            properties2.put((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_NUMBUCKETS(), (Object)Integer.toString(numBuckets2));
            properties2.put((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_NUMBUCKETCOLS(), (Object)Integer.toString(bucketColumnNames2.length()));
            ((IterableOnceOps)bucketColumnNames2.zipWithIndex()).foreach((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String bucketCol = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Option option = properties2.put((Object)new StringBuilder(0).append(HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_BUCKETCOL_PREFIX()).append(index).toString(), (Object)bucketCol);
                return option;
            });
            if (sortColumnNames2.nonEmpty()) {
                properties2.put((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_NUMSORTCOLS(), (Object)Integer.toString(sortColumnNames2.length()));
                ((IterableOnceOps)sortColumnNames2.zipWithIndex()).foreach((Function1 & Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String sortCol = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Option option = properties2.put((Object)new StringBuilder(0).append(HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_SORTCOL_PREFIX()).append(index).toString(), (Object)sortCol);
                    return option;
                });
            }
        }
        return properties2.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void checkTableConfigEqual(Map<String, String> originTableConfig, Map<String, String> newTableConfig, String configKey) {
        block0: {
            if (!originTableConfig.contains((Object)configKey) || !newTableConfig.contains((Object)configKey)) break block0;
            Predef$.MODULE$.assert(BoxesRunTime.equals((Object)originTableConfig.apply((Object)configKey), (Object)newTableConfig.apply((Object)configKey)), (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(75).append("Table config: ").append(configKey).append(" in the create table is: ").append(newTableConfig.apply((Object)configKey)).append(", is not the same with the value in ").toString()).append(new StringBuilder(53).append("hoodie.properties, which is:  ").append(originTableConfig.apply((Object)configKey)).append(". Please keep the same.").toString()).toString());
        }
    }

    public CreateHoodieTableCommand apply(CatalogTable table, boolean ignoreIfExists) {
        return new CreateHoodieTableCommand(table, ignoreIfExists);
    }

    public Option<Tuple2<CatalogTable, Object>> unapply(CreateHoodieTableCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.table(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.ignoreIfExists())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CreateHoodieTableCommand$.class);
    }

    public static final /* synthetic */ boolean $anonfun$validateTableSchema$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField hoodieTableColumn = (StructField)tuple2._1();
        StructField userDefinedColumn = (StructField)tuple2._2();
        boolean bl = hoodieTableColumn.name().equals(userDefinedColumn.name()) && (Cast$.MODULE$.canCast(hoodieTableColumn.dataType(), userDefinedColumn.dataType()) || SchemaConverters$.MODULE$.toAvroType(hoodieTableColumn.dataType(), SchemaConverters$.MODULE$.toAvroType$default$2(), SchemaConverters$.MODULE$.toAvroType$default$3(), SchemaConverters$.MODULE$.toAvroType$default$4()).equals((Object)SchemaConverters$.MODULE$.toAvroType(userDefinedColumn.dataType(), SchemaConverters$.MODULE$.toAvroType$default$2(), SchemaConverters$.MODULE$.toAvroType$default$3(), SchemaConverters$.MODULE$.toAvroType$default$4())));
        return bl;
    }

    private CreateHoodieTableCommand$() {
    }
}

