/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.CreateHoodieTableLikeCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001B\u0012%\u0001FB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t;\u0002\u0011\t\u0012)A\u00053\"Aa\f\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005`\u0001\tE\t\u0015!\u0003Z\u0011!\u0001\u0007A!f\u0001\n\u0003\t\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011\u00022\t\u0011%\u0004!Q3A\u0005\u0002)D\u0001B\u001e\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\to\u0002\u0011)\u001a!C\u0001q\"AA\u0010\u0001B\tB\u0003%\u0011\u0010C\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\f\u0001!\t%!\u0004\t\u0013\u0005\u001d\u0002!!A\u0005\u0002\u0005%\u0002\"CA\u001b\u0001E\u0005I\u0011AA\u001c\u0011%\ti\u0005AI\u0001\n\u0003\t9\u0004C\u0005\u0002P\u0001\t\n\u0011\"\u0001\u0002R!I\u0011Q\u000b\u0001\u0012\u0002\u0013\u0005\u0011q\u000b\u0005\n\u00037\u0002\u0011\u0013!C\u0001\u0003;B\u0011\"!\u0019\u0001\u0003\u0003%\t%a\u0019\t\u0013\u0005M\u0004!!A\u0005\u0002\u0005U\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\tY\tAA\u0001\n\u0003\ni\tC\u0005\u0002\u001c\u0002\t\t\u0011\"\u0001\u0002\u001e\"I\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u00131\u0015\u0005\n\u0003O\u0003\u0011\u0011!C!\u0003S;\u0011\"!,%\u0003\u0003E\t!a,\u0007\u0011\r\"\u0013\u0011!E\u0001\u0003cCa!`\u000e\u0005\u0002\u0005%\u0007\"CAf7\u0005\u0005IQIAg\u0011%\tymGA\u0001\n\u0003\u000b\t\u000eC\u0005\u0002^n\t\n\u0011\"\u0001\u0002X!I\u0011q\\\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u001d\u0005\n\u0003g\\\u0012\u0013!C\u0001\u0003/B\u0011\"!>\u001c\u0003\u0003%I!a>\u00039\r\u0013X-\u0019;f\u0011>|G-[3UC\ndW\rT5lK\u000e{W.\\1oI*\u0011QEJ\u0001\bG>lW.\u00198e\u0015\t9\u0003&\u0001\u0003ik\u0012L'BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u00011C\u0002\u00013y\u0001+5\n\u0005\u00024u5\tAG\u0003\u00026m\u00059An\\4jG\u0006d'BA\u001c9\u0003\u0015\u0001H.\u00198t\u0015\tI\u0004&\u0001\u0005dCR\fG._:u\u0013\tYDGA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA\u001f?\u001b\u0005!\u0013BA %\u0005eAun\u001c3jK2+\u0017M\u001a*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005\u0005\u001bU\"\u0001\"\u000b\u0005\u001db\u0013B\u0001#C\u0005M\u0019\u0006/\u0019:l\u0003\u0012\f\u0007\u000f^3s'V\u0004\bo\u001c:u!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0014+\u000f\u00055\u0013fB\u0001(R\u001b\u0005y%B\u0001)1\u0003\u0019a$o\\8u}%\t\u0001*\u0003\u0002T\u000f\u00069\u0001/Y2lC\u001e,\u0017BA+W\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0019v)A\u0006uCJ<W\r\u001e+bE2,W#A-\u0011\u0005i[V\"\u0001\u001d\n\u0005qC$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0019Q\f'oZ3u)\u0006\u0014G.\u001a\u0011\u0002\u0017M|WO]2f)\u0006\u0014G.Z\u0001\rg>,(oY3UC\ndW\rI\u0001\u000bM&dWMR8s[\u0006$X#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015D\u0014aB2bi\u0006dwnZ\u0005\u0003O\u0012\u0014AcQ1uC2|wm\u0015;pe\u0006<WMR8s[\u0006$\u0018a\u00034jY\u00164uN]7bi\u0002\n!\u0002\u001d:pa\u0016\u0014H/[3t+\u0005Y\u0007\u0003\u00027qgNt!!\u001c8\u0011\u00059;\u0015BA8H\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0004\u001b\u0006\u0004(BA8H!\taG/\u0003\u0002ve\n11\u000b\u001e:j]\u001e\f1\u0002\u001d:pa\u0016\u0014H/[3tA\u0005q\u0011n\u001a8pe\u0016Le-\u0012=jgR\u001cX#A=\u0011\u0005\u0019S\u0018BA>H\u0005\u001d\u0011un\u001c7fC:\fq\"[4o_J,\u0017JZ#ySN$8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0017}\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011\u0002\t\u0003{\u0001AQaV\u0006A\u0002eCQAX\u0006A\u0002eCQ\u0001Y\u0006A\u0002\tDq![\u0006\u0011\u0002\u0003\u00071\u000eC\u0003x\u0017\u0001\u0007\u00110A\u0002sk:$B!a\u0004\u0002\u001eA)A*!\u0005\u0002\u0016%\u0019\u00111\u0003,\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0018\u0005eQ\"\u0001\u0015\n\u0007\u0005m\u0001FA\u0002S_^Dq!a\b\r\u0001\u0004\t\t#\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0003\u0002\u0018\u0005\r\u0012bAA\u0013Q\ta1\u000b]1sWN+7o]5p]\u0006!1m\u001c9z)-y\u00181FA\u0017\u0003_\t\t$a\r\t\u000f]k\u0001\u0013!a\u00013\"9a,\u0004I\u0001\u0002\u0004I\u0006b\u00021\u000e!\u0003\u0005\rA\u0019\u0005\bS6\u0001\n\u00111\u0001l\u0011\u001d9X\u0002%AA\u0002e\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002:)\u001a\u0011,a\u000f,\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0012H\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\n\tEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005M#f\u00012\u0002<\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA-U\rY\u00171H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\tyFK\u0002z\u0003w\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\nA\u0001\\1oO*\u0011\u0011qN\u0001\u0005U\u00064\u0018-C\u0002v\u0003S\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001e\u0011\u0007\u0019\u000bI(C\u0002\u0002|\u001d\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!!\u0002\bB\u0019a)a!\n\u0007\u0005\u0015uIA\u0002B]fD\u0011\"!#\u0016\u0003\u0003\u0005\r!a\u001e\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\t\u0005\u0004\u0002\u0012\u0006]\u0015\u0011Q\u0007\u0003\u0003'S1!!&H\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00033\u000b\u0019J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA=\u0002 \"I\u0011\u0011R\f\u0002\u0002\u0003\u0007\u0011\u0011Q\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002f\u0005\u0015\u0006\"CAE1\u0005\u0005\t\u0019AA<\u0003\u0019)\u0017/^1mgR\u0019\u00110a+\t\u0013\u0005%\u0015$!AA\u0002\u0005\u0005\u0015\u0001H\"sK\u0006$X\rS8pI&,G+\u00192mK2K7.Z\"p[6\fg\u000e\u001a\t\u0003{m\u0019RaGAZ\u0003\u007f\u0003\"\"!.\u0002<fK&m[=\u0000\u001b\t\t9LC\u0002\u0002:\u001e\u000bqA];oi&lW-\u0003\u0003\u0002>\u0006]&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8okA!\u0011\u0011YAd\u001b\t\t\u0019M\u0003\u0003\u0002F\u00065\u0014AA5p\u0013\r)\u00161\u0019\u000b\u0003\u0003_\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003K\nQ!\u00199qYf$2b`Aj\u0003+\f9.!7\u0002\\\")qK\ba\u00013\")aL\ba\u00013\")\u0001M\ba\u0001E\"9\u0011N\bI\u0001\u0002\u0004Y\u0007\"B<\u001f\u0001\u0004I\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!\u00111]Ax!\u00151\u0015Q]Au\u0013\r\t9o\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011\u0019\u000bY/W-cWfL1!!<H\u0005\u0019!V\u000f\u001d7fk!A\u0011\u0011\u001f\u0011\u0002\u0002\u0003\u0007q0A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA}!\u0011\t9'a?\n\t\u0005u\u0018\u0011\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class CreateHoodieTableLikeCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
SparkAdapterSupport,
Serializable {
    private final TableIdentifier targetTable;
    private final TableIdentifier sourceTable;
    private final CatalogStorageFormat fileFormat;
    private final Map<String, String> properties;
    private final boolean ignoreIfExists;
    private SparkAdapter sparkAdapter;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile byte bitmap$0;

    public static Map<String, String> $lessinit$greater$default$4() {
        return CreateHoodieTableLikeCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<TableIdentifier, TableIdentifier, CatalogStorageFormat, Map<String, String>, Object>> unapply(CreateHoodieTableLikeCommand x$0) {
        return CreateHoodieTableLikeCommand$.MODULE$.unapply(x$0);
    }

    public static Map<String, String> apply$default$4() {
        return CreateHoodieTableLikeCommand$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<TableIdentifier, TableIdentifier, CatalogStorageFormat, Map<String, String>, Object>, CreateHoodieTableLikeCommand> tupled() {
        return CreateHoodieTableLikeCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<TableIdentifier, Function1<CatalogStorageFormat, Function1<Map<String, String>, Function1<Object, CreateHoodieTableLikeCommand>>>>> curried() {
        return CreateHoodieTableLikeCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        CreateHoodieTableLikeCommand createHoodieTableLikeCommand = this;
        synchronized (createHoodieTableLikeCommand) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CreateHoodieTableLikeCommand createHoodieTableLikeCommand = this;
        synchronized (createHoodieTableLikeCommand) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier targetTable() {
        return this.targetTable;
    }

    public TableIdentifier sourceTable() {
        return this.sourceTable;
    }

    public CatalogStorageFormat fileFormat() {
        return this.fileFormat;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean ignoreIfExists() {
        return this.ignoreIfExists;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        boolean tableIsExists = catalog.tableExists(this.targetTable());
        if (tableIsExists) {
            if (this.ignoreIfExists()) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Table ").append(this.targetTable()).append(" already exists.").toString());
        }
        CatalogTable sourceTableDesc = catalog.getTempViewOrPermanentTableMetadata(this.sourceTable());
        CatalogStorageFormat newStorage = this.fileFormat().inputFormat().isDefined() ? this.fileFormat() : sourceTableDesc.storage().copy(this.fileFormat().locationUri(), sourceTableDesc.storage().copy$default$2(), sourceTableDesc.storage().copy$default$3(), sourceTableDesc.storage().copy$default$4(), sourceTableDesc.storage().copy$default$5(), sourceTableDesc.storage().copy$default$6());
        CatalogTableType tblType = newStorage.locationUri().isEmpty() ? CatalogTableType$.MODULE$.MANAGED() : CatalogTableType$.MODULE$.EXTERNAL();
        Map targetTableProperties = this.sparkAdapter().isHoodieTable(sourceTableDesc) ? (Map)HoodieOptionConfig$.MODULE$.extractHoodieOptions((Map<String, String>)sourceTableDesc.properties()).$plus$plus(this.properties()) : this.properties();
        TableIdentifier x$1 = this.targetTable();
        CatalogTableType x$2 = tblType;
        CatalogStorageFormat x$3 = newStorage;
        StructType x$4 = sourceTableDesc.schema();
        Some x$5 = new Some((Object)"hudi");
        Seq x$6 = sourceTableDesc.partitionColumnNames();
        Option x$7 = sourceTableDesc.bucketSpec();
        Map x$8 = targetTableProperties;
        boolean x$9 = sourceTableDesc.tracksPartitionsInCatalog();
        String x$10 = CatalogTable$.MODULE$.apply$default$8();
        long x$11 = CatalogTable$.MODULE$.apply$default$9();
        long x$12 = CatalogTable$.MODULE$.apply$default$10();
        String x$13 = CatalogTable$.MODULE$.apply$default$11();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$14();
        Option x$16 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$17 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable newTableDesc = new CatalogTable(x$1, x$2, x$3, x$4, (Option)x$5, x$6, x$7, x$10, x$11, x$12, x$13, x$8, x$14, x$15, x$16, x$17, x$9, x$18, x$19, x$20);
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, newTableDesc);
        CreateHoodieTableCommand$.MODULE$.validateTblProperties(hoodieCatalogTable);
        Option queryAsProp = hoodieCatalogTable.catalogProperties().get((Object)"hoodie.query.as.ro.table");
        if (queryAsProp.isEmpty()) {
            hoodieCatalogTable.initHoodieTable();
        } else {
            if (!hoodieCatalogTable.hoodieTableExists()) {
                throw new AnalysisException("Creating ro/rt table need the existence of the base table.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
            }
            if (!((Object)((Object)HoodieTableType.MERGE_ON_READ)).equals((Object)hoodieCatalogTable.tableType())) {
                throw new AnalysisException("Creating ro/rt table should only apply to a mor table.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
            }
        }
        try {
            CreateHoodieTableCommand$.MODULE$.createTableInCatalog(sparkSession, hoodieCatalogTable, this.ignoreIfExists(), (Option<String>)queryAsProp);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new HoodieException("Failed to create catalog table in metastore", e);
            }
            throw throwable;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public CreateHoodieTableLikeCommand copy(TableIdentifier targetTable, TableIdentifier sourceTable, CatalogStorageFormat fileFormat, Map<String, String> properties2, boolean ignoreIfExists) {
        return new CreateHoodieTableLikeCommand(targetTable, sourceTable, fileFormat, properties2, ignoreIfExists);
    }

    public TableIdentifier copy$default$1() {
        return this.targetTable();
    }

    public TableIdentifier copy$default$2() {
        return this.sourceTable();
    }

    public CatalogStorageFormat copy$default$3() {
        return this.fileFormat();
    }

    public Map<String, String> copy$default$4() {
        return this.properties();
    }

    public boolean copy$default$5() {
        return this.ignoreIfExists();
    }

    public String productPrefix() {
        return "CreateHoodieTableLikeCommand";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.targetTable();
                break;
            }
            case 1: {
                object = this.sourceTable();
                break;
            }
            case 2: {
                object = this.fileFormat();
                break;
            }
            case 3: {
                object = this.properties();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreIfExists());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateHoodieTableLikeCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "targetTable";
                break;
            }
            case 1: {
                string = "sourceTable";
                break;
            }
            case 2: {
                string = "fileFormat";
                break;
            }
            case 3: {
                string = "properties";
                break;
            }
            case 4: {
                string = "ignoreIfExists";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateHoodieTableLikeCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateHoodieTableLikeCommand createHoodieTableLikeCommand = (CreateHoodieTableLikeCommand)x$1;
        if (this.ignoreIfExists() != createHoodieTableLikeCommand.ignoreIfExists()) return false;
        TableIdentifier tableIdentifier = this.targetTable();
        TableIdentifier tableIdentifier2 = createHoodieTableLikeCommand.targetTable();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        TableIdentifier tableIdentifier3 = this.sourceTable();
        TableIdentifier tableIdentifier4 = createHoodieTableLikeCommand.sourceTable();
        if (tableIdentifier3 == null) {
            if (tableIdentifier4 != null) {
                return false;
            }
        } else if (!tableIdentifier3.equals(tableIdentifier4)) return false;
        CatalogStorageFormat catalogStorageFormat = this.fileFormat();
        CatalogStorageFormat catalogStorageFormat2 = createHoodieTableLikeCommand.fileFormat();
        if (catalogStorageFormat == null) {
            if (catalogStorageFormat2 != null) {
                return false;
            }
        } else if (!catalogStorageFormat.equals(catalogStorageFormat2)) return false;
        Map<String, String> map2 = this.properties();
        Map<String, String> map3 = createHoodieTableLikeCommand.properties();
        if (map2 == null) {
            if (map3 != null) {
                return false;
            }
        } else if (!map2.equals(map3)) return false;
        if (!createHoodieTableLikeCommand.canEqual(this)) return false;
        return true;
    }

    public CreateHoodieTableLikeCommand(TableIdentifier targetTable, TableIdentifier sourceTable, CatalogStorageFormat fileFormat, Map<String, String> properties2, boolean ignoreIfExists) {
        this.targetTable = targetTable;
        this.sourceTable = sourceTable;
        this.fileFormat = fileFormat;
        this.properties = properties2;
        this.ignoreIfExists = ignoreIfExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        SparkAdapterSupport.$init$(this);
        Statics.releaseFence();
    }
}

