/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.hudi.command.CreateIndexCommand;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CreateIndexCommand$
implements Serializable {
    public static final CreateIndexCommand$ MODULE$ = new CreateIndexCommand$();

    public boolean matchesRecordKeys(scala.collection.immutable.Set<String> columnNames, HoodieTableConfig tableConfig) {
        boolean bl;
        scala.collection.immutable.Set recordKeyFields = Predef$.MODULE$.wrapRefArray((Object[])tableConfig.getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))).toSet();
        if (columnNames.equals((Object)recordKeyFields)) {
            bl = true;
        } else {
            scala.collection.immutable.Set recordKeyColumns = (scala.collection.immutable.Set)columnNames.intersect((Set)recordKeyFields);
            scala.collection.immutable.Set nonRecordKeyColumns = (scala.collection.immutable.Set)columnNames.$minus$minus((IterableOnce)recordKeyColumns);
            if (recordKeyColumns.isEmpty()) {
                bl = false;
            } else {
                if (nonRecordKeyColumns.nonEmpty()) {
                    throw new HoodieIndexException("Index can be created either on all record key columns or a non record key column");
                }
                throw new HoodieIndexException(String.format("Index can be only be created on all record key columns. Configured record key fields %s. Input columns: %s", recordKeyFields, columnNames));
            }
        }
        return bl;
    }

    public CreateIndexCommand apply(CatalogTable table, String indexName, String indexType, boolean ignoreIfExists, Seq<Tuple2<Seq<String>, Map<String, String>>> columns, Map<String, String> options) {
        return new CreateIndexCommand(table, indexName, indexType, ignoreIfExists, columns, options);
    }

    public Option<Tuple6<CatalogTable, String, String, Object, Seq<Tuple2<Seq<String>, Map<String, String>>>, Map<String, String>>> unapply(CreateIndexCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.table(), (Object)x$0.indexName(), (Object)x$0.indexType(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.ignoreIfExists()), x$0.columns(), x$0.options()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CreateIndexCommand$.class);
    }

    private CreateIndexCommand$() {
    }
}

