/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.hudi.HoodieSparkIndexClient;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.hudi.command.CreateIndexCommand$;
import org.apache.spark.sql.hudi.command.IndexBaseCommand;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u0013&\u0001JB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t'\u0002\u0011\t\u0012)A\u0005\u0017\"AA\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005_\u0001\tE\t\u0015!\u0003W\u0011!y\u0006A!f\u0001\n\u0003)\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011\u0002,\t\u0011\u0005\u0004!Q3A\u0005\u0002\tD\u0001B\u001a\u0001\u0003\u0012\u0003\u0006Ia\u0019\u0005\tO\u0002\u0011)\u001a!C\u0001Q\"A1\u000f\u0001B\tB\u0003%\u0011\u000e\u0003\u0005u\u0001\tU\r\u0011\"\u0001v\u0011!1\bA!E!\u0002\u0013\u0001\b\"B<\u0001\t\u0003A\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\n\u00033\u0001\u0011\u0011!C\u0001\u00037A\u0011\"!\u000b\u0001#\u0003%\t!a\u000b\t\u0013\u0005\u0005\u0003!%A\u0005\u0002\u0005\r\u0003\"CA$\u0001E\u0005I\u0011AA\"\u0011%\tI\u0005AI\u0001\n\u0003\tY\u0005C\u0005\u0002P\u0001\t\n\u0011\"\u0001\u0002R!I\u0011Q\u000b\u0001\u0012\u0002\u0013\u0005\u0011q\u000b\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;B\u0011\"!\u001c\u0001\u0003\u0003%\t!a\u001c\t\u0013\u0005]\u0004!!A\u0005\u0002\u0005e\u0004\"CAC\u0001\u0005\u0005I\u0011IAD\u0011%\t)\nAA\u0001\n\u0003\t9\nC\u0005\u0002\u001c\u0002\t\t\u0011\"\u0011\u0002\u001e\"I\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u00131U\u0004\b\u0003O+\u0003\u0012AAU\r\u0019!S\u0005#\u0001\u0002,\"1qO\bC\u0001\u0003{Cq!a0\u001f\t\u0003\t\t\rC\u0005\u0002bz\t\t\u0011\"!\u0002d\"I\u0011\u0011\u001f\u0010\u0002\u0002\u0013\u0005\u00151\u001f\u0005\n\u0005\u000bq\u0012\u0011!C\u0005\u0005\u000f\u0011!c\u0011:fCR,\u0017J\u001c3fq\u000e{W.\\1oI*\u0011aeJ\u0001\bG>lW.\u00198e\u0015\tA\u0013&\u0001\u0003ik\u0012L'B\u0001\u0016,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO\u000e\u00011\u0003\u0002\u00014ou\u0002\"\u0001N\u001b\u000e\u0003\u0015J!AN\u0013\u0003!%sG-\u001a=CCN,7i\\7nC:$\u0007C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$a\u0002)s_\u0012,8\r\u001e\t\u0003}\u0019s!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\t\u000b\u0014A\u0002\u001fs_>$h(C\u0001;\u0013\t)\u0015(A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%\u0001D*fe&\fG.\u001b>bE2,'BA#:\u0003\u0015!\u0018M\u00197f+\u0005Y\u0005C\u0001'R\u001b\u0005i%B\u0001(P\u0003\u001d\u0019\u0017\r^1m_\u001eT!\u0001U\u0015\u0002\u0011\r\fG/\u00197zgRL!AU'\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\u0002\rQ\f'\r\\3!\u0003%Ig\u000eZ3y\u001d\u0006lW-F\u0001W!\t96L\u0004\u0002Y3B\u0011\u0001)O\u0005\u00035f\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!,O\u0001\u000bS:$W\r\u001f(b[\u0016\u0004\u0013!C5oI\u0016DH+\u001f9f\u0003)Ig\u000eZ3y)f\u0004X\rI\u0001\u000fS\u001etwN]3JM\u0016C\u0018n\u001d;t+\u0005\u0019\u0007C\u0001\u001de\u0013\t)\u0017HA\u0004C_>dW-\u00198\u0002\u001f%<gn\u001c:f\u0013\u001a,\u00050[:ug\u0002\nqaY8mk6t7/F\u0001j!\rq$\u000e\\\u0005\u0003W\"\u00131aU3r!\u0011ATn\u001c9\n\u00059L$A\u0002+va2,'\u0007E\u0002?UZ\u0003BaV9W-&\u0011!/\u0018\u0002\u0004\u001b\u0006\u0004\u0018\u0001C2pYVlgn\u001d\u0011\u0002\u000f=\u0004H/[8ogV\t\u0001/\u0001\u0005paRLwN\\:!\u0003\u0019a\u0014N\\5u}Q9\u0011P_>}{z|\bC\u0001\u001b\u0001\u0011\u0015IU\u00021\u0001L\u0011\u0015!V\u00021\u0001W\u0011\u0015yV\u00021\u0001W\u0011\u0015\tW\u00021\u0001d\u0011\u00159W\u00021\u0001j\u0011\u0015!X\u00021\u0001q\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u000b\ty\u0001\u0005\u0003?U\u0006\u001d\u0001\u0003BA\u0005\u0003\u0017i\u0011!K\u0005\u0004\u0003\u001bI#a\u0001*po\"9\u0011\u0011\u0003\bA\u0002\u0005M\u0011\u0001D:qCJ\\7+Z:tS>t\u0007\u0003BA\u0005\u0003+I1!a\u0006*\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u001be\fi\"a\b\u0002\"\u0005\r\u0012QEA\u0014\u0011\u001dIu\u0002%AA\u0002-Cq\u0001V\b\u0011\u0002\u0003\u0007a\u000bC\u0004`\u001fA\u0005\t\u0019\u0001,\t\u000f\u0005|\u0001\u0013!a\u0001G\"9qm\u0004I\u0001\u0002\u0004I\u0007b\u0002;\u0010!\u0003\u0005\r\u0001]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiCK\u0002L\u0003_Y#!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003wI\u0014AC1o]>$\u0018\r^5p]&!\u0011qHA\u001b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)EK\u0002W\u0003_\tabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u00055#fA2\u00020\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA*U\rI\u0017qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\tIFK\u0002q\u0003_\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA0!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\nA\u0001\\1oO*\u0011\u0011\u0011N\u0001\u0005U\u00064\u0018-C\u0002]\u0003G\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001d\u0011\u0007a\n\u0019(C\u0002\u0002ve\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001f\u0002\u0002B\u0019\u0001(! \n\u0007\u0005}\u0014HA\u0002B]fD\u0011\"a!\u0019\u0003\u0003\u0005\r!!\u001d\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\t\u0005\u0004\u0002\f\u0006E\u00151P\u0007\u0003\u0003\u001bS1!a$:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\u000biI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA2\u0002\u001a\"I\u00111\u0011\u000e\u0002\u0002\u0003\u0007\u00111P\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002`\u0005}\u0005\"CAB7\u0005\u0005\t\u0019AA9\u0003\u0019)\u0017/^1mgR\u00191-!*\t\u0013\u0005\rE$!AA\u0002\u0005m\u0014AE\"sK\u0006$X-\u00138eKb\u001cu.\\7b]\u0012\u0004\"\u0001\u000e\u0010\u0014\u000by\ti+a-\u0011\u0007a\ny+C\u0002\u00022f\u0012a!\u00118z%\u00164\u0007\u0003BA[\u0003wk!!a.\u000b\t\u0005e\u0016qM\u0001\u0003S>L1aRA\\)\t\tI+A\tnCR\u001c\u0007.Z:SK\u000e|'\u000fZ&fsN$RaYAb\u0003\u001bDq!!2!\u0001\u0004\t9-A\u0006d_2,XN\u001c(b[\u0016\u001c\b\u0003B,\u0002JZK1!a3^\u0005\r\u0019V\r\u001e\u0005\b\u0003\u001f\u0004\u0003\u0019AAi\u0003-!\u0018M\u00197f\u0007>tg-[4\u0011\t\u0005M\u0017Q\\\u0007\u0003\u0003+T1!SAl\u0015\u0011\tI.a7\u0002\r\r|W.\\8o\u0015\tAS&\u0003\u0003\u0002`\u0006U'!\u0005%p_\u0012LW\rV1cY\u0016\u001cuN\u001c4jO\u0006)\u0011\r\u001d9msRi\u00110!:\u0002h\u0006%\u00181^Aw\u0003_DQ!S\u0011A\u0002-CQ\u0001V\u0011A\u0002YCQaX\u0011A\u0002YCQ!Y\u0011A\u0002\rDQaZ\u0011A\u0002%DQ\u0001^\u0011A\u0002A\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002v\n\u0005\u0001#\u0002\u001d\u0002x\u0006m\u0018bAA}s\t1q\n\u001d;j_:\u0004\u0012\u0002OA\u007f\u0017Z36-\u001b9\n\u0007\u0005}\u0018H\u0001\u0004UkBdWM\u000e\u0005\t\u0005\u0007\u0011\u0013\u0011!a\u0001s\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t%\u0001\u0003BA1\u0005\u0017IAA!\u0004\u0002d\t1qJ\u00196fGR\u0004")
public class CreateIndexCommand
extends IndexBaseCommand
implements Serializable {
    private final CatalogTable table;
    private final String indexName;
    private final String indexType;
    private final boolean ignoreIfExists;
    private final Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> columns;
    private final scala.collection.immutable.Map<String, String> options;

    public static Option<Tuple6<CatalogTable, String, String, Object, Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>>, scala.collection.immutable.Map<String, String>>> unapply(CreateIndexCommand x$0) {
        return CreateIndexCommand$.MODULE$.unapply(x$0);
    }

    public static boolean matchesRecordKeys(Set<String> columnNames, HoodieTableConfig tableConfig) {
        return CreateIndexCommand$.MODULE$.matchesRecordKeys(columnNames, tableConfig);
    }

    public CatalogTable table() {
        return this.table;
    }

    public String indexName() {
        return this.indexName;
    }

    public String indexType() {
        return this.indexType;
    }

    public boolean ignoreIfExists() {
        return this.ignoreIfExists;
    }

    public Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> columns() {
        return this.columns;
    }

    public scala.collection.immutable.Map<String, String> options() {
        return this.options;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        TableIdentifier tableId = this.table().identifier();
        HoodieTableMetaClient metaClient = this.createHoodieTableMetaClient(tableId, sparkSession);
        LinkedHashMap<String, java.util.Map<String, String>> columnsMap = new LinkedHashMap<String, java.util.Map<String, String>>();
        this.columns().map((Function1 & Serializable)c -> (java.util.Map)columnsMap.put(((IterableOnceOps)c._1()).mkString("."), (java.util.Map<String, String>)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)c._2()).asJava()));
        scala.collection.immutable.Map extraOpts = (scala.collection.immutable.Map)this.options().$plus$plus((IterableOnce)this.table().properties());
        if (this.indexType().equals("column_stats") || this.indexType().equals("bloom_filters")) {
            if (this.indexType().equals("column_stats") && ((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraOpts).asJava()).getOrDefault("expr", "identity").equals("identity")) {
                throw new HoodieIndexException("Column stats index without expression on any column can be created using datasource configs. Please refer https://hudi.apache.org/docs/metadata for more info");
            }
            new HoodieSparkIndexClient(sparkSession).create(metaClient, this.indexName(), this.indexType(), columnsMap, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraOpts).asJava());
        } else if (this.indexName().equals("record_index")) {
            ValidationUtils.checkArgument(CreateIndexCommand$.MODULE$.matchesRecordKeys((Set<String>)((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(columnsMap.keySet()).asScala()).toSet(), metaClient.getTableConfig()), new StringBuilder(58).append("Input columns should match configured record key columns: ").append(metaClient.getTableConfig().getRecordKeyFieldProp()).toString());
            new HoodieSparkIndexClient(sparkSession).create(metaClient, this.indexName(), "record_index", columnsMap, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraOpts).asJava());
        } else if (StringUtils.isNullOrEmpty(this.indexType())) {
            String derivedIndexType;
            Set columnNames = ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(columnsMap.keySet()).asScala()).toSet();
            String string = derivedIndexType = CreateIndexCommand$.MODULE$.matchesRecordKeys((Set<String>)columnNames, metaClient.getTableConfig()) ? "record_index" : "secondary_index";
            if (derivedIndexType.equals("secondary_index") && (metaClient.getTableConfig().getPayloadClass() != null && !metaClient.getTableConfig().getPayloadClass().equals(OverwriteWithLatestAvroPayload.class.getCanonicalName()) || metaClient.getTableConfig().getRecordMergeMode() != RecordMergeMode.COMMIT_TIME_ORDERING)) {
                throw new HoodieIndexException("Secondary Index can only be enabled on table with OverwriteWithLatestAvroPayload payload class or Merge mode set to OVERWRITE_WITH_LATEST");
            }
            new HoodieSparkIndexClient(sparkSession).create(metaClient, this.indexName(), derivedIndexType, columnsMap, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraOpts).asJava());
        } else {
            throw new HoodieIndexException(String.format("%s is not supported", this.indexType()));
        }
        sparkSession.sessionState().catalog().invalidateCachedTable(tableId);
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public CreateIndexCommand copy(CatalogTable table, String indexName, String indexType, boolean ignoreIfExists, Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> columns, scala.collection.immutable.Map<String, String> options) {
        return new CreateIndexCommand(table, indexName, indexType, ignoreIfExists, columns, options);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.indexName();
    }

    public String copy$default$3() {
        return this.indexType();
    }

    public boolean copy$default$4() {
        return this.ignoreIfExists();
    }

    public Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> copy$default$5() {
        return this.columns();
    }

    public scala.collection.immutable.Map<String, String> copy$default$6() {
        return this.options();
    }

    public String productPrefix() {
        return "CreateIndexCommand";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.indexName();
                break;
            }
            case 2: {
                object = this.indexType();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreIfExists());
                break;
            }
            case 4: {
                object = this.columns();
                break;
            }
            case 5: {
                object = this.options();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateIndexCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "table";
                break;
            }
            case 1: {
                string = "indexName";
                break;
            }
            case 2: {
                string = "indexType";
                break;
            }
            case 3: {
                string = "ignoreIfExists";
                break;
            }
            case 4: {
                string = "columns";
                break;
            }
            case 5: {
                string = "options";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateIndexCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateIndexCommand createIndexCommand = (CreateIndexCommand)x$1;
        if (this.ignoreIfExists() != createIndexCommand.ignoreIfExists()) return false;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = createIndexCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        String string = this.indexName();
        String string2 = createIndexCommand.indexName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.indexType();
        String string4 = createIndexCommand.indexType();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> seq = this.columns();
        Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> seq2 = createIndexCommand.columns();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        scala.collection.immutable.Map<String, String> map2 = this.options();
        scala.collection.immutable.Map<String, String> map3 = createIndexCommand.options();
        if (map2 == null) {
            if (map3 != null) {
                return false;
            }
        } else if (!map2.equals(map3)) return false;
        if (!createIndexCommand.canEqual(this)) return false;
        return true;
    }

    public CreateIndexCommand(CatalogTable table, String indexName, String indexType, boolean ignoreIfExists, Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> columns, scala.collection.immutable.Map<String, String> options) {
        this.table = table;
        this.indexName = indexName;
        this.indexType = indexType;
        this.ignoreIfExists = ignoreIfExists;
        this.columns = columns;
        this.options = options;
    }
}

