/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.command.DropHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001\u0002\u0013&\u0001JB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t3\u0002\u0011\t\u0012)A\u0005+\"A!\f\u0001BK\u0002\u0013\u00051\f\u0003\u0005`\u0001\tE\t\u0015!\u0003]\u0011!\u0001\u0007A!f\u0001\n\u0003Y\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011\u0002/\t\u0011\t\u0004!Q3A\u0005\u0002mC\u0001b\u0019\u0001\u0003\u0012\u0003\u0006I\u0001\u0018\u0005\u0006I\u0002!\t!\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0011\u0019)\b\u0001)A\u0005[\"9a\u000f\u0001b\u0001\n\u0013a\u0007BB<\u0001A\u0003%Q\u000eC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u00033\u0002\u0011\u0013!C\u0001\u00037B\u0011\"!\u001d\u0001#\u0003%\t!a\u001d\t\u0013\u0005]\u0004!%A\u0005\u0002\u0005M\u0004\"CA=\u0001E\u0005I\u0011AA:\u0011!\tY\bAA\u0001\n\u0003b\u0007\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\t9\tAA\u0001\n\u0003\tI\tC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0011\u0002\u0018\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003W\u0003\u0011\u0011!C!\u0003[C\u0011\"!-\u0001\u0003\u0003%\t%a-\b\u0013\u0005]V%!A\t\u0002\u0005ef\u0001\u0003\u0013&\u0003\u0003E\t!a/\t\r\u0011tB\u0011AAj\u0011%\t)NHA\u0001\n\u000b\n9\u000eC\u0005\u0002Zz\t\t\u0011\"!\u0002\\\"I\u0011Q\u001d\u0010\u0002\u0002\u0013\u0005\u0015q\u001d\u0005\n\u0003kt\u0012\u0011!C\u0005\u0003o\u0014a\u0003\u0012:pa\"{w\u000eZ5f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\u0006\u0003M\u001d\nqaY8n[\u0006tGM\u0003\u0002)S\u0005!\u0001.\u001e3j\u0015\tQ3&A\u0002tc2T!\u0001L\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0002\u0001'\u0015\u00011'P!H!\t!4(D\u00016\u0015\t1t'A\u0004m_\u001eL7-\u00197\u000b\u0005aJ\u0014!\u00029mC:\u001c(B\u0001\u001e*\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001f6\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005yzT\"A\u0013\n\u0005\u0001+#!\u0007%p_\u0012LW\rT3bMJ+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002I!:\u0011\u0011J\u0014\b\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019F\na\u0001\u0010:p_Rt\u0014\"\u0001#\n\u0005=\u001b\u0015a\u00029bG.\fw-Z\u0005\u0003#J\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aT\"\u0002\u001fQ\f'\r\\3JI\u0016tG/\u001b4jKJ,\u0012!\u0016\t\u0003-^k\u0011!O\u0005\u00031f\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u0011i\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0002\n\u0001\"\u001b4Fq&\u001cHo]\u000b\u00029B\u0011!)X\u0005\u0003=\u000e\u0013qAQ8pY\u0016\fg.A\u0005jM\u0016C\u0018n\u001d;tA\u00051\u0011n\u001d,jK^\fq![:WS\u0016<\b%A\u0003qkJ<W-\u0001\u0004qkJ<W\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0019<\u0007.\u001b6\u0011\u0005y\u0002\u0001\"B*\n\u0001\u0004)\u0006\"\u0002.\n\u0001\u0004a\u0006\"\u00021\n\u0001\u0004a\u0006\"\u00022\n\u0001\u0004a\u0016!G'P%~\u001bf*\u0011)T\u0011>#v\fV!C\u0019\u0016{6+\u0016$G\u0013b+\u0012!\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\fA\u0001\\1oO*\t!/\u0001\u0003kCZ\f\u0017B\u0001;p\u0005\u0019\u0019FO]5oO\u0006QRj\u0014*`':\u000b\u0005k\u0015%P)~#\u0016I\u0011'F?N+fIR%YA\u0005yRj\u0014*`%\u0016\u000bEiX(Q)&k\u0015JW#E?R\u000b%\tT#`'V3e)\u0013-\u0002A5{%k\u0018*F\u0003\u0012{v\n\u0015+J\u001b&SV\tR0U\u0003\ncUiX*V\r\u001aK\u0005\fI\u0001\u0004eVtGc\u0001>\u0002\u0004A\u0019\u0001j_?\n\u0005q\u0014&aA*fcB\u0011ap`\u0007\u0002S%\u0019\u0011\u0011A\u0015\u0003\u0007I{w\u000fC\u0004\u0002\u00069\u0001\r!a\u0002\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0007y\fI!C\u0002\u0002\f%\u0012Ab\u00159be.\u001cVm]:j_:\f!\u0003\u001a:paR\u000b'\r\\3J]\u000e\u000bG/\u00197pORQ\u0011\u0011CA\f\u00033\tY\"!\b\u0011\u0007\t\u000b\u0019\"C\u0002\u0002\u0016\r\u0013A!\u00168ji\"9\u0011QA\bA\u0002\u0005\u001d\u0001\"B*\u0010\u0001\u0004)\u0006\"\u0002.\u0010\u0001\u0004a\u0006\"\u00022\u0010\u0001\u0004a\u0016aD4fiR\u000b'\r\\3S)\u0006sGMU(\u0015\r\u0005\r\u00121HA\"!\u001d\u0011\u0015QEA\u0015\u0003SI1!a\nD\u0005\u0019!V\u000f\u001d7feA)!)a\u000b\u00020%\u0019\u0011QF\"\u0003\r=\u0003H/[8o!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001bs\u000591-\u0019;bY><\u0017\u0002BA\u001d\u0003g\u0011AbQ1uC2|w\rV1cY\u0016Dq!!\u000e\u0011\u0001\u0004\ti\u0004\u0005\u0003\u00022\u0005}\u0012\u0002BA!\u0003g\u0011abU3tg&|gnQ1uC2|w\rC\u0004\u0002FA\u0001\r!a\u0012\u0002\u0017!|w\u000eZ5f)\u0006\u0014G.\u001a\t\u0005\u0003c\tI%\u0003\u0003\u0002L\u0005M\"A\u0005%p_\u0012LWmQ1uC2|w\rV1cY\u0016\fAaY8qsRIa-!\u0015\u0002T\u0005U\u0013q\u000b\u0005\b'F\u0001\n\u00111\u0001V\u0011\u001dQ\u0016\u0003%AA\u0002qCq\u0001Y\t\u0011\u0002\u0003\u0007A\fC\u0004c#A\u0005\t\u0019\u0001/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\f\u0016\u0004+\u0006}3FAA1!\u0011\t\u0019'!\u001c\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-4)\u0001\u0006b]:|G/\u0019;j_:LA!a\u001c\u0002f\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u000f\u0016\u00049\u0006}\u0013AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0011\t\u0004\u0005\u0006\r\u0015bAAC\u0007\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111RAI!\r\u0011\u0015QR\u0005\u0004\u0003\u001f\u001b%aA!os\"I\u00111\u0013\r\u0002\u0002\u0003\u0007\u0011\u0011Q\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0005CBAN\u0003C\u000bY)\u0004\u0002\u0002\u001e*\u0019\u0011qT\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002$\u0006u%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001XAU\u0011%\t\u0019JGA\u0001\u0002\u0004\tY)\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,GcA7\u00020\"I\u00111S\u000e\u0002\u0002\u0003\u0007\u0011\u0011Q\u0001\u0007KF,\u0018\r\\:\u0015\u0007q\u000b)\fC\u0005\u0002\u0014r\t\t\u00111\u0001\u0002\f\u00061BI]8q\u0011>|G-[3UC\ndWmQ8n[\u0006tG\r\u0005\u0002?=M)a$!0\u0002JBI\u0011qXAc+rcFLZ\u0007\u0003\u0003\u0003T1!a1D\u0003\u001d\u0011XO\u001c;j[\u0016LA!a2\u0002B\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bT1!a4r\u0003\tIw.C\u0002R\u0003\u001b$\"!!/\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\\\u0001\u0006CB\u0004H.\u001f\u000b\nM\u0006u\u0017q\\Aq\u0003GDQaU\u0011A\u0002UCQAW\u0011A\u0002qCQ\u0001Y\u0011A\u0002qCQAY\u0011A\u0002q\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002j\u0006E\b#\u0002\"\u0002,\u0005-\bc\u0002\"\u0002nVcF\fX\u0005\u0004\u0003_\u001c%A\u0002+va2,G\u0007\u0003\u0005\u0002t\n\n\t\u00111\u0001g\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003s\u00042A\\A~\u0013\r\tip\u001c\u0002\u0007\u001f\nTWm\u0019;")
public class DropHoodieTableCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
Serializable {
    private final TableIdentifier tableIdentifier;
    private final boolean ifExists;
    private final boolean isView;
    private final boolean purge;
    private final String MOR_SNAPSHOT_TABLE_SUFFIX;
    private final String MOR_READ_OPTIMIZED_TABLE_SUFFIX;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Object, Object, Object>> unapply(DropHoodieTableCommand x$0) {
        return DropHoodieTableCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, Object>, DropHoodieTableCommand> tupled() {
        return DropHoodieTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<Object, DropHoodieTableCommand>>>> curried() {
        return DropHoodieTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DropHoodieTableCommand dropHoodieTableCommand = this;
        synchronized (dropHoodieTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean isView() {
        return this.isView;
    }

    public boolean purge() {
        return this.purge;
    }

    private String MOR_SNAPSHOT_TABLE_SUFFIX() {
        return this.MOR_SNAPSHOT_TABLE_SUFFIX;
    }

    private String MOR_READ_OPTIMIZED_TABLE_SUFFIX() {
        return this.MOR_READ_OPTIMIZED_TABLE_SUFFIX;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(32).append("Start executing 'DROP TABLE' on ").append(this.tableIdentifier().unquotedString()).toString()).append(new StringBuilder(21).append(" (ifExists=").append(this.ifExists()).append(", purge=").append(this.purge()).append(").").toString()).toString());
        if (!sparkSession.catalog().tableExists(this.tableIdentifier().unquotedString())) {
            sparkSession.catalog().refreshTable(this.tableIdentifier().unquotedString());
        }
        sparkSession.sessionState().catalog().invalidateCachedTable(this.tableIdentifier());
        this.dropTableInCatalog(sparkSession, this.tableIdentifier(), this.ifExists(), this.purge());
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(36).append("Finished executing 'DROP TABLE' on ").append(this.tableIdentifier().unquotedString()).append(".").toString());
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private void dropTableInCatalog(SparkSession sparkSession, TableIdentifier tableIdentifier, boolean ifExists, boolean purge) {
        block3: {
            HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
            CatalogTable table2 = hoodieCatalogTable.table();
            CatalogTableType catalogTableType = table2.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            Predef$.MODULE$.assert(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2));
            String basePath = hoodieCatalogTable.tableLocation();
            SessionCatalog catalog = sparkSession.sessionState().catalog();
            if (hoodieCatalogTable.hoodieTableExists() && ((Object)((Object)HoodieTableType.MERGE_ON_READ)).equals((Object)hoodieCatalogTable.tableType()) && purge) {
                Tuple2<Option<CatalogTable>, Option<CatalogTable>> tuple2 = this.getTableRTAndRO(catalog, hoodieCatalogTable);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Option rtTableOpt = (Option)tuple2._1();
                Option roTableOpt = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)rtTableOpt, (Object)roTableOpt);
                Tuple2 tuple23 = tuple22;
                Option rtTableOpt2 = (Option)tuple23._1();
                Option roTableOpt2 = (Option)tuple23._2();
                rtTableOpt2.foreach((Function1 & Serializable)table -> {
                    catalog.dropTable(table.identifier(), true, false);
                    return BoxedUnit.UNIT;
                });
                roTableOpt2.foreach((Function1 & Serializable)table -> {
                    catalog.dropTable(table.identifier(), true, false);
                    return BoxedUnit.UNIT;
                });
                catalog.dropTable(table2.identifier().copy(hoodieCatalogTable.tableName(), table2.identifier().copy$default$2(), table2.identifier().copy$default$3()), ifExists, purge);
            } else {
                catalog.dropTable(table2.identifier(), ifExists, purge);
            }
            if (!purge) break block3;
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(9).append("Clean up ").append(basePath).toString());
            StoragePath targetPath = new StoragePath(basePath);
            HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(JavaSparkContext$.MODULE$.fromSparkContext(sparkSession.sparkContext()));
            HoodieStorage storage2 = HoodieStorageUtils.getStorage(basePath, HadoopFSUtils.getStorageConf(sparkSession.sparkContext().hadoopConfiguration()));
            FSUtils.deleteDir(engineContext, storage2, targetPath, sparkSession.sparkContext().defaultParallelism());
        }
    }

    private Tuple2<Option<CatalogTable>, Option<CatalogTable>> getTableRTAndRO(SessionCatalog catalog, HoodieCatalogTable hoodieTable) {
        CatalogTable roTable;
        CatalogTable rtTable;
        TableIdentifier qual$1 = hoodieTable.table().identifier();
        String x$1 = new StringBuilder(0).append(hoodieTable.tableName()).append(this.MOR_SNAPSHOT_TABLE_SUFFIX()).toString();
        Option x$2 = qual$1.copy$default$2();
        Option x$3 = qual$1.copy$default$3();
        TableIdentifier rtIdt = qual$1.copy(x$1, x$2, x$3);
        TableIdentifier qual$2 = hoodieTable.table().identifier();
        String x$4 = new StringBuilder(0).append(hoodieTable.tableName()).append(this.MOR_READ_OPTIMIZED_TABLE_SUFFIX()).toString();
        Option x$5 = qual$2.copy$default$2();
        Option x$6 = qual$2.copy$default$3();
        TableIdentifier roIdt = qual$2.copy(x$4, x$5, x$6);
        None$ rtTableOpt = None$.MODULE$;
        None$ roTableOpt = None$.MODULE$;
        if (catalog.tableExists(rtIdt) && (rtTable = catalog.getTableMetadata(rtIdt)).storage().locationUri().equals((Object)hoodieTable.table().storage().locationUri())) {
            Some some;
            String v;
            Option option = rtTable.storage().properties().get((Object)"hoodie.query.as.ro.table");
            if (option instanceof Some && (v = (String)(some = (Some)option).value()).equalsIgnoreCase("false")) {
                rtTableOpt = new Some((Object)rtTable);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (catalog.tableExists(roIdt) && (roTable = catalog.getTableMetadata(roIdt)).storage().locationUri().equals((Object)hoodieTable.table().storage().locationUri())) {
            Some some;
            String v;
            Option option = roTable.storage().properties().get((Object)"hoodie.query.as.ro.table");
            if (option instanceof Some && (v = (String)(some = (Some)option).value()).equalsIgnoreCase("true")) {
                roTableOpt = new Some((Object)roTable);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return new Tuple2((Object)rtTableOpt, (Object)roTableOpt);
    }

    public DropHoodieTableCommand copy(TableIdentifier tableIdentifier, boolean ifExists, boolean isView, boolean purge) {
        return new DropHoodieTableCommand(tableIdentifier, ifExists, isView, purge);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public boolean copy$default$2() {
        return this.ifExists();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public boolean copy$default$4() {
        return this.purge();
    }

    public String productPrefix() {
        return "DropHoodieTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableIdentifier();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifExists());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.purge());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropHoodieTableCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "tableIdentifier";
                break;
            }
            case 1: {
                string = "ifExists";
                break;
            }
            case 2: {
                string = "isView";
                break;
            }
            case 3: {
                string = "purge";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropHoodieTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropHoodieTableCommand dropHoodieTableCommand = (DropHoodieTableCommand)x$1;
        if (this.ifExists() != dropHoodieTableCommand.ifExists()) return false;
        if (this.isView() != dropHoodieTableCommand.isView()) return false;
        if (this.purge() != dropHoodieTableCommand.purge()) return false;
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = dropHoodieTableCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (!dropHoodieTableCommand.canEqual(this)) return false;
        return true;
    }

    public DropHoodieTableCommand(TableIdentifier tableIdentifier, boolean ifExists, boolean isView, boolean purge) {
        this.tableIdentifier = tableIdentifier;
        this.ifExists = ifExists;
        this.isView = isView;
        this.purge = purge;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        this.MOR_SNAPSHOT_TABLE_SUFFIX = "_rt";
        this.MOR_READ_OPTIMIZED_TABLE_SUFFIX = "_ro";
        Statics.releaseFence();
    }
}

