/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.HoodieSparkIndexClient;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.hudi.command.DropIndexCommand$;
import org.apache.spark.sql.hudi.command.IndexBaseCommand;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001B\u000e\u001d\u0001&B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u0005\"A1\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005V\u0001\tE\t\u0015!\u0003N\u0011!1\u0006A!f\u0001\n\u00039\u0006\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u000bq\u0003A\u0011A/\t\u000b\t\u0004A\u0011I2\t\u000fA\u0004\u0011\u0011!C\u0001c\"9Q\u000fAI\u0001\n\u00031\b\"CA\u0002\u0001E\u0005I\u0011AA\u0003\u0011%\tI\u0001AI\u0001\n\u0003\tY\u0001C\u0005\u0002\u0010\u0001\t\t\u0011\"\u0011\u0002\u0012!I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003W\u0001\u0011\u0011!C\u0001\u0003[A\u0011\"!\u000f\u0001\u0003\u0003%\t%a\u000f\t\u0013\u0005%\u0003!!A\u0005\u0002\u0005-\u0003\"CA(\u0001\u0005\u0005I\u0011IA)\u0011%\t)\u0006AA\u0001\n\u0003\n9fB\u0005\u0002\\q\t\t\u0011#\u0001\u0002^\u0019A1\u0004HA\u0001\u0012\u0003\ty\u0006\u0003\u0004]+\u0011\u0005\u0011q\u000f\u0005\n\u0003s*\u0012\u0011!C#\u0003wB\u0011\"! \u0016\u0003\u0003%\t)a \t\u0013\u0005\u001dU#!A\u0005\u0002\u0006%\u0005\"CAN+\u0005\u0005I\u0011BAO\u0005A!%o\u001c9J]\u0012,\u0007pQ8n[\u0006tGM\u0003\u0002\u001e=\u000591m\\7nC:$'BA\u0010!\u0003\u0011AW\u000fZ5\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Qc\u0006\u000e\t\u0003W1j\u0011\u0001H\u0005\u0003[q\u0011\u0001#\u00138eKb\u0014\u0015m]3D_6l\u0017M\u001c3\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\u000fA\u0013x\u000eZ;diB\u0011Q'\u0010\b\u0003mmr!a\u000e\u001e\u000e\u0003aR!!\u000f\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014B\u0001\u001f1\u0003\u001d\u0001\u0018mY6bO\u0016L!AP \u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005q\u0002\u0014!\u0002;bE2,W#\u0001\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015aB2bi\u0006dwn\u001a\u0006\u0003\u000f\u0002\n\u0001bY1uC2L8\u000f^\u0005\u0003\u0013\u0012\u0013AbQ1uC2|w\rV1cY\u0016\fa\u0001^1cY\u0016\u0004\u0013!C5oI\u0016Dh*Y7f+\u0005i\u0005C\u0001(S\u001d\ty\u0005\u000b\u0005\u00028a%\u0011\u0011\u000bM\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002Ra\u0005Q\u0011N\u001c3fq:\u000bW.\u001a\u0011\u0002#%<gn\u001c:f\u0013\u001atu\u000e^#ySN$8/F\u0001Y!\ty\u0013,\u0003\u0002[a\t9!i\\8mK\u0006t\u0017AE5h]>\u0014X-\u00134O_R,\u00050[:ug\u0002\na\u0001P5oSRtD\u0003\u00020`A\u0006\u0004\"a\u000b\u0001\t\u000b\u0001;\u0001\u0019\u0001\"\t\u000b-;\u0001\u0019A'\t\u000bY;\u0001\u0019\u0001-\u0002\u0007I,h\u000e\u0006\u0002eWB\u0019Q'Z4\n\u0005\u0019|$aA*fcB\u0011\u0001.[\u0007\u0002A%\u0011!\u000e\t\u0002\u0004%><\b\"\u00027\t\u0001\u0004i\u0017\u0001D:qCJ\\7+Z:tS>t\u0007C\u00015o\u0013\ty\u0007E\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0003d_BLH\u0003\u00020sgRDq\u0001Q\u0005\u0011\u0002\u0003\u0007!\tC\u0004L\u0013A\u0005\t\u0019A'\t\u000fYK\u0001\u0013!a\u00011\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A<+\u0005\tC8&A=\u0011\u0005i|X\"A>\u000b\u0005ql\u0018!C;oG\",7m[3e\u0015\tq\b'\u0001\u0006b]:|G/\u0019;j_:L1!!\u0001|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9A\u000b\u0002Nq\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\u0007U\tA\u00060A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003mC:<'BAA\u000f\u0003\u0011Q\u0017M^1\n\u0007M\u000b9\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002&A\u0019q&a\n\n\u0007\u0005%\u0002GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00020\u0005U\u0002cA\u0018\u00022%\u0019\u00111\u0007\u0019\u0003\u0007\u0005s\u0017\u0010C\u0005\u00028=\t\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0010\u0011\r\u0005}\u0012QIA\u0018\u001b\t\t\tEC\u0002\u0002DA\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9%!\u0011\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00041\u00065\u0003\"CA\u001c#\u0005\u0005\t\u0019AA\u0018\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005M\u00111\u000b\u0005\n\u0003o\u0011\u0012\u0011!a\u0001\u0003K\ta!Z9vC2\u001cHc\u0001-\u0002Z!I\u0011qG\n\u0002\u0002\u0003\u0007\u0011qF\u0001\u0011\tJ|\u0007/\u00138eKb\u001cu.\\7b]\u0012\u0004\"aK\u000b\u0014\u000bU\t\t'!\u001c\u0011\u0011\u0005\r\u0014\u0011\u000e\"N1zk!!!\u001a\u000b\u0007\u0005\u001d\u0004'A\u0004sk:$\u0018.\\3\n\t\u0005-\u0014Q\r\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003BA8\u0003kj!!!\u001d\u000b\t\u0005M\u00141D\u0001\u0003S>L1APA9)\t\ti&\u0001\u0005u_N#(/\u001b8h)\t\t\u0019\"A\u0003baBd\u0017\u0010F\u0004_\u0003\u0003\u000b\u0019)!\"\t\u000b\u0001C\u0002\u0019\u0001\"\t\u000b-C\u0002\u0019A'\t\u000bYC\u0002\u0019\u0001-\u0002\u000fUt\u0017\r\u001d9msR!\u00111RAL!\u0015y\u0013QRAI\u0013\r\ty\t\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r=\n\u0019JQ'Y\u0013\r\t)\n\r\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005e\u0015$!AA\u0002y\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\n\u0005\u0003\u0002\u0016\u0005\u0005\u0016\u0002BAR\u0003/\u0011aa\u00142kK\u000e$\b")
public class DropIndexCommand
extends IndexBaseCommand
implements Serializable {
    private final CatalogTable table;
    private final String indexName;
    private final boolean ignoreIfNotExists;

    public static Option<Tuple3<CatalogTable, String, Object>> unapply(DropIndexCommand x$0) {
        return DropIndexCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<CatalogTable, String, Object>, DropIndexCommand> tupled() {
        return DropIndexCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<String, Function1<Object, DropIndexCommand>>> curried() {
        return DropIndexCommand$.MODULE$.curried();
    }

    public CatalogTable table() {
        return this.table;
    }

    public String indexName() {
        return this.indexName;
    }

    public boolean ignoreIfNotExists() {
        return this.ignoreIfNotExists;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        TableIdentifier tableId = this.table().identifier();
        HoodieTableMetaClient metaClient = this.createHoodieTableMetaClient(tableId, sparkSession);
        org.apache.hudi.common.util.Option<HoodieIndexMetadata> indexMetadataOpt = metaClient.getIndexMetadata();
        if (metaClient.getTableConfig().getMetadataPartitions().contains(this.indexName())) {
            new HoodieSparkIndexClient(sparkSession).drop(metaClient, this.indexName(), this.ignoreIfNotExists());
        } else if (indexMetadataOpt.isPresent()) {
            HoodieIndexMetadata indexMetadata = indexMetadataOpt.get();
            List<HoodieIndexDefinition> indexDefinitions = indexMetadata.getIndexDefinitions().values().stream().filter(definition -> {
                MetadataPartitionType partitionType = MetadataPartitionType.fromPartitionPath(definition.getIndexName());
                return partitionType.getIndexNameWithoutPrefix((HoodieIndexDefinition)definition).equals(this.indexName());
            }).collect(Collectors.toList());
            if (indexDefinitions.isEmpty() && !this.ignoreIfNotExists()) {
                throw new HoodieIndexException(String.format("Index does not exist: %s", this.indexName()));
            }
            indexDefinitions.forEach(definition -> new HoodieSparkIndexClient(sparkSession).drop(metaClient, definition.getIndexName(), this.ignoreIfNotExists()));
        } else if (!this.ignoreIfNotExists()) {
            throw new HoodieIndexException(String.format("Index does not exist: %s", this.indexName()));
        }
        sparkSession.sessionState().catalog().invalidateCachedTable(tableId);
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public DropIndexCommand copy(CatalogTable table, String indexName, boolean ignoreIfNotExists) {
        return new DropIndexCommand(table, indexName, ignoreIfNotExists);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.indexName();
    }

    public boolean copy$default$3() {
        return this.ignoreIfNotExists();
    }

    public String productPrefix() {
        return "DropIndexCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.indexName();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreIfNotExists());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropIndexCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "table";
                break;
            }
            case 1: {
                string = "indexName";
                break;
            }
            case 2: {
                string = "ignoreIfNotExists";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropIndexCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropIndexCommand dropIndexCommand = (DropIndexCommand)x$1;
        if (this.ignoreIfNotExists() != dropIndexCommand.ignoreIfNotExists()) return false;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = dropIndexCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        String string = this.indexName();
        String string2 = dropIndexCommand.indexName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!dropIndexCommand.canEqual(this)) return false;
        return true;
    }

    public DropIndexCommand(CatalogTable table, String indexName, boolean ignoreIfNotExists) {
        this.table = table;
        this.indexName = indexName;
        this.ignoreIfNotExists = ignoreIfNotExists;
    }
}

