/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.PartitionStatistics;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.hudi.command.RepairHoodieTableCommand$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ThreadUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t%d\u0001\u0002\u0015*\u0001ZB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t;\u0002\u0011\t\u0012)A\u00053\"Aa\f\u0001BK\u0002\u0013\u0005q\f\u0003\u0005d\u0001\tE\t\u0015!\u0003a\u0011!!\u0007A!f\u0001\n\u0003y\u0006\u0002C3\u0001\u0005#\u0005\u000b\u0011\u00021\t\u0011\u0019\u0004!Q3A\u0005\u0002\u001dD\u0001\u0002\u001d\u0001\u0003\u0012\u0003\u0006I\u0001\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\bq\u0002\u0011\r\u0011\"\u0001z\u0011\u001d\t\u0019\u0001\u0001Q\u0001\niD\u0001\"!\u0002\u0001\u0005\u0004%\t!\u001f\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003{\u0011!\tI\u0001\u0001b\u0001\n\u0003I\bbBA\u0006\u0001\u0001\u0006IA\u001f\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\t9\u0003\u0001C\u0005\u0003SAq!!(\u0001\t\u0013\ty\nC\u0005\u00022\u0002\t\t\u0011\"\u0001\u00024\"I\u0011Q\u0018\u0001\u0012\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003+\u0004\u0011\u0013!C\u0001\u0003/D\u0011\"a7\u0001#\u0003%\t!a6\t\u0013\u0005u\u0007!%A\u0005\u0002\u0005}\u0007\u0002CAr\u0001\u0005\u0005I\u0011I=\t\u0013\u0005\u0015\b!!A\u0005\u0002\u0005\u001d\b\"CAu\u0001\u0005\u0005I\u0011AAv\u0011%\t9\u0010AA\u0001\n\u0003\nI\u0010C\u0005\u0003\b\u0001\t\t\u0011\"\u0001\u0003\n!I!Q\u0002\u0001\u0002\u0002\u0013\u0005#q\u0002\u0005\n\u0005'\u0001\u0011\u0011!C!\u0005+9\u0011B!\u0007*\u0003\u0003E\tAa\u0007\u0007\u0011!J\u0013\u0011!E\u0001\u0005;Aa!\u001d\u0011\u0005\u0002\tU\u0002\"\u0003B\u001cA\u0005\u0005IQ\tB\u001d\u0011%\u0011Y\u0004IA\u0001\n\u0003\u0013i\u0004C\u0005\u0003H\u0001\n\n\u0011\"\u0001\u0002`\"I!\u0011\n\u0011\u0002\u0002\u0013\u0005%1\n\u0005\n\u0005;\u0002\u0013\u0013!C\u0001\u0003?D\u0011Ba\u0018!\u0003\u0003%IA!\u0019\u00031I+\u0007/Y5s\u0011>|G-[3UC\ndWmQ8n[\u0006tGM\u0003\u0002+W\u000591m\\7nC:$'B\u0001\u0017.\u0003\u0011AW\u000fZ5\u000b\u00059z\u0013aA:rY*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u00019\u0014)R&\u0011\u0005azT\"A\u001d\u000b\u0005iZ\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003yu\nQ\u0001\u001d7b]NT!AP\u0017\u0002\u0011\r\fG/\u00197zgRL!\u0001Q\u001d\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003\u0005\u000ek\u0011!K\u0005\u0003\t&\u0012\u0011\u0004S8pI&,G*Z1g%Vtg.\u00192mK\u000e{W.\\1oIB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n9\u0001K]8ek\u000e$\bC\u0001'U\u001d\ti%K\u0004\u0002O#6\tqJ\u0003\u0002Qk\u00051AH]8pizJ\u0011\u0001S\u0005\u0003'\u001e\u000bq\u0001]1dW\u0006<W-\u0003\u0002V-\na1+\u001a:jC2L'0\u00192mK*\u00111kR\u0001\ni\u0006\u0014G.\u001a(b[\u0016,\u0012!\u0017\t\u00035nk\u0011!P\u0005\u00039v\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0013aE3oC\ndW-\u00113e!\u0006\u0014H/\u001b;j_:\u001cX#\u00011\u0011\u0005\u0019\u000b\u0017B\u00012H\u0005\u001d\u0011un\u001c7fC:\fA#\u001a8bE2,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001F3oC\ndW\r\u0012:paB\u000b'\u000f^5uS>t7/A\u000bf]\u0006\u0014G.\u001a#s_B\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0007\rlG-F\u0001i!\tIWN\u0004\u0002kWB\u0011ajR\u0005\u0003Y\u001e\u000ba\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011AnR\u0001\u0005G6$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006gR,ho\u001e\t\u0003\u0005\u0002AQaV\u0005A\u0002eCQAX\u0005A\u0002\u0001DQ\u0001Z\u0005A\u0002\u0001DqAZ\u0005\u0011\u0002\u0003\u0007\u0001.A\u0005O+6{f)\u0013'F'V\t!\u0010E\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fA\u0001\\1oO*\tq0\u0001\u0003kCZ\f\u0017B\u00018}\u0003)qU+T0G\u00132+5\u000bI\u0001\u000b)>#\u0016\tT0T\u0013j+\u0015a\u0003+P)\u0006culU%[\u000b\u0002\n\u0001\u0002\u0012#M?RKU*R\u0001\n\t\u0012cu\fV%N\u000b\u0002\n1A];o)\u0011\t\t\"a\b\u0011\u000b1\u000b\u0019\"a\u0006\n\u0007\u0005UaKA\u0002TKF\u0004B!!\u0007\u0002\u001c5\tQ&C\u0002\u0002\u001e5\u00121AU8x\u0011\u0019\u0001\u0004\u00031\u0001\u0002\"A!\u0011\u0011DA\u0012\u0013\r\t)#\f\u0002\r'B\f'o[*fgNLwN\\\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\u0015\u0005-\u0012\u0011GA\u001a\u0003\u0007\n)\tE\u0002G\u0003[I1!a\fH\u0005\u0011)f.\u001b;\t\rA\n\u0002\u0019AA\u0011\u0011\u001d\t)$\u0005a\u0001\u0003o\tQ\u0001^1cY\u0016\u0004B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{i\u0014aB2bi\u0006dwnZ\u0005\u0005\u0003\u0003\nYD\u0001\u0007DCR\fGn\\4UC\ndW\rC\u0004\u0002FE\u0001\r!a\u0012\u0002+A\f'\u000f^5uS>t7\u000b]3dg\u0006sG\rT8dgB)A*a\u0005\u0002JA9a)a\u0013\u0002P\u0005U\u0014bAA'\u000f\n1A+\u001e9mKJ\u0002B!!\u0015\u0002p9!\u00111KA6\u001d\u0011\t)&!\u001b\u000f\t\u0005]\u0013q\r\b\u0005\u00033\n)G\u0004\u0003\u0002\\\u0005\rd\u0002BA/\u0003Cr1ATA0\u0013\u0005!\u0014B\u0001\u001a4\u0013\t\u0001\u0014'\u0003\u0002/_%\u0011a(L\u0005\u0004\u0003{i\u0014\u0002BA7\u0003w\tAbQ1uC2|w\rV=qKNLA!!\u001d\u0002t\t\u0011B+\u00192mKB\u000b'\u000f^5uS>t7\u000b]3d\u0015\u0011\ti'a\u000f\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005\u0011am\u001d\u0006\u0004\u0003\u007f\n\u0014A\u00025bI>|\u0007/\u0003\u0003\u0002\u0004\u0006e$\u0001\u0002)bi\"Dq!a\"\u0012\u0001\u0004\tI)\u0001\bqCJ$\u0018\u000e^5p]N#\u0018\r^:\u0011\r%\fY\t[AH\u0013\r\tii\u001c\u0002\u0004\u001b\u0006\u0004\b\u0003BAI\u00033k!!a%\u000b\u0007)\n)JC\u0002\u0002\u00186\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005m\u00151\u0013\u0002\u0014!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;jgRL7m]\u0001\u000fIJ|\u0007\u000fU1si&$\u0018n\u001c8t)\u0019\t\t+a*\u00020B\u0019a)a)\n\u0007\u0005\u0015vIA\u0002J]RDq!!\u0010\u0013\u0001\u0004\tI\u000b\u0005\u0003\u0002:\u0005-\u0016\u0002BAW\u0003w\u0011abU3tg&|gnQ1uC2|w\rC\u0004\u0002FI\u0001\r!a\u0012\u0002\t\r|\u0007/\u001f\u000b\ng\u0006U\u0016qWA]\u0003wCqaV\n\u0011\u0002\u0003\u0007\u0011\fC\u0004_'A\u0005\t\u0019\u00011\t\u000f\u0011\u001c\u0002\u0013!a\u0001A\"9am\u0005I\u0001\u0002\u0004A\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0003T3!WAbW\t\t)\r\u0005\u0003\u0002H\u0006EWBAAe\u0015\u0011\tY-!4\u0002\u0013Ut7\r[3dW\u0016$'bAAh\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0017\u0011\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u00033T3\u0001YAb\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002b*\u001a\u0001.a1\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t+\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00181\u001f\t\u0004\r\u0006=\u0018bAAy\u000f\n\u0019\u0011I\\=\t\u0013\u0005U($!AA\u0002\u0005\u0005\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002|B1\u0011Q B\u0002\u0003[l!!a@\u000b\u0007\t\u0005q)\u0001\u0006d_2dWm\u0019;j_:LAA!\u0002\u0002\u0000\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0001'1\u0002\u0005\n\u0003kd\u0012\u0011!a\u0001\u0003[\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019!P!\u0005\t\u0013\u0005UX$!AA\u0002\u0005\u0005\u0016AB3rk\u0006d7\u000fF\u0002a\u0005/A\u0011\"!>\u001f\u0003\u0003\u0005\r!!<\u00021I+\u0007/Y5s\u0011>|G-[3UC\ndWmQ8n[\u0006tG\r\u0005\u0002CAM)\u0001Ea\b\u0003,AI!\u0011\u0005B\u00143\u0002\u0004\u0007n]\u0007\u0003\u0005GQ1A!\nH\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u000b\u0003$\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\t5\"1G\u0007\u0003\u0005_Q1A!\r\u007f\u0003\tIw.C\u0002V\u0005_!\"Aa\u0007\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A_\u0001\u0006CB\u0004H.\u001f\u000b\ng\n}\"\u0011\tB\"\u0005\u000bBQaV\u0012A\u0002eCQAX\u0012A\u0002\u0001DQ\u0001Z\u0012A\u0002\u0001DqAZ\u0012\u0011\u0002\u0003\u0007\u0001.A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BA!\u0014\u0003ZA)aIa\u0014\u0003T%\u0019!\u0011K$\u0003\r=\u0003H/[8o!\u001d1%QK-aA\"L1Aa\u0016H\u0005\u0019!V\u000f\u001d7fi!A!1L\u0013\u0002\u0002\u0003\u00071/A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B2!\rY(QM\u0005\u0004\u0005Ob(AB(cU\u0016\u001cG\u000f")
public class RepairHoodieTableCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final boolean enableAddPartitions;
    private final boolean enableDropPartitions;
    private final String cmd;
    private final String NUM_FILES;
    private final String TOTAL_SIZE;
    private final String DDL_TIME;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$4() {
        return RepairHoodieTableCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<TableIdentifier, Object, Object, String>> unapply(RepairHoodieTableCommand x$0) {
        return RepairHoodieTableCommand$.MODULE$.unapply(x$0);
    }

    public static String apply$default$4() {
        return RepairHoodieTableCommand$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, String>, RepairHoodieTableCommand> tupled() {
        return RepairHoodieTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<String, RepairHoodieTableCommand>>>> curried() {
        return RepairHoodieTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        RepairHoodieTableCommand repairHoodieTableCommand = this;
        synchronized (repairHoodieTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean enableAddPartitions() {
        return this.enableAddPartitions;
    }

    public boolean enableDropPartitions() {
        return this.enableDropPartitions;
    }

    public String cmd() {
        return this.cmd;
    }

    public String NUM_FILES() {
        return this.NUM_FILES;
    }

    public String TOTAL_SIZE() {
        return this.TOTAL_SIZE;
    }

    public String DDL_TIME() {
        return this.DDL_TIME;
    }

    public Seq<Row> run(SparkSession spark) {
        int n;
        int droppedAmount;
        SessionCatalog catalog = spark.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        if (table.partitionColumnNames().isEmpty()) {
            throw new AnalysisException(new StringBuilder(58).append("Operation not allowed: ").append(this.cmd()).append(" only works on partitioned tables: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        if (table.storage().locationUri().isEmpty()) {
            throw new AnalysisException(new StringBuilder(0).append(new StringBuilder(49).append("Operation not allowed: ").append(this.cmd()).append(" only works on table with ").toString()).append(new StringBuilder(19).append("location provided: ").append(tableIdentWithDB).toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        Path root = new Path(table.location());
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(30).append("Recover all the partitions in ").append(root).toString());
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(spark, table.identifier());
        boolean isHiveStyledPartitioning = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(hoodieCatalogTable.tableConfig().getHiveStylePartitioningEnable()));
        Seq partitionSpecsAndLocs = (Seq)hoodieCatalogTable.getPartitionPaths().map((Function1 & Serializable)partitionPath -> {
            String[] values2 = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(partitionPath), '/');
            if (isHiveStyledPartitioning) {
                values2 = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])values2), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$1), '=')[1], ClassTag$.MODULE$.apply(String.class));
            }
            return new Tuple2((Object)((IterableOnceOps)table.partitionColumnNames().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])values2))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)new Path(root, partitionPath));
        });
        int n2 = droppedAmount = this.enableDropPartitions() ? this.dropPartitions(catalog, (Seq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs) : 0;
        if (this.enableAddPartitions()) {
            int total = partitionSpecsAndLocs.length();
            Seq partitionList = (Seq)partitionSpecsAndLocs.map((Function1 & Serializable)x$2 -> ((Path)x$2._2()).toString());
            Map partitionStats = spark.sqlContext().conf().gatherFastStats() && total > 0 ? HoodieSqlCommonUtils$.MODULE$.getFilesInPartitions(spark, table, HoodieStorageUtils.getStorage((String)partitionList.head(), HadoopFSUtils.getStorageConf(spark.sessionState().newHadoopConf())), (Seq<String>)partitionList).mapValues((Function1 & Serializable)statuses -> new PartitionStatistics(statuses.length(), BoxesRunTime.unboxToLong((Object)((IterableOnceOps)statuses.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getLength()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)))) : Predef$.MODULE$.Map().empty();
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(54).append("Finished to gather the fast stats for all ").append(total).append(" partitions.").toString());
            this.addPartitions(spark, table, (Seq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, (Map<String, PartitionStatistics>)partitionStats.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            n = total;
        } else {
            n = 0;
        }
        int addedAmount = n;
        boolean x$1 = true;
        TableIdentifier x$22 = table.copy$default$1();
        CatalogTableType x$3 = table.copy$default$2();
        CatalogStorageFormat x$4 = table.copy$default$3();
        StructType x$5 = table.copy$default$4();
        Option x$6 = table.copy$default$5();
        Seq x$7 = table.copy$default$6();
        Option x$8 = table.copy$default$7();
        String x$9 = table.copy$default$8();
        long x$10 = table.copy$default$9();
        long x$11 = table.copy$default$10();
        String x$12 = table.copy$default$11();
        Map x$13 = table.copy$default$12();
        Option x$14 = table.copy$default$13();
        Option x$15 = table.copy$default$14();
        Option x$16 = table.copy$default$15();
        Seq x$17 = table.copy$default$16();
        boolean x$18 = table.copy$default$18();
        Map x$19 = table.copy$default$19();
        Option x$20 = table.copy$default$20();
        spark.sessionState().catalog().alterTable(table.copy(x$22, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, true, x$18, x$19, x$20));
        try {
            spark.catalog().refreshTable(tableIdentWithDB);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0 & Serializable)() -> new StringBuilder(183).append(new StringBuilder(50).append("Cannot refresh the table '").append(tableIdentWithDB).append("'. A query of the table ").toString()).append("might return wrong result if the table was cached. To avoid such issue, you should ").append("uncache the table manually via the UNCACHE TABLE command after table recovering will ").append("complete fully.").toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(47).append("Recovered all partitions: added (").append(addedAmount).append("), dropped (").append(droppedAmount).append(").").toString());
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private void addPartitions(SparkSession spark, CatalogTable table, Seq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, Map<String, PartitionStatistics> partitionStats) {
        int total = partitionSpecsAndLocs.length();
        LongRef done = LongRef.create((long)0L);
        int batchSize = spark.sparkContext().conf().getInt("spark.sql.addPartitionInBatch.size", 100);
        partitionSpecsAndLocs.iterator().grouped(batchSize).foreach((Function1 & Serializable)batch -> {
            RepairHoodieTableCommand.$anonfun$addPartitions$1(this, partitionStats, table, spark, done, total, batch);
            return BoxedUnit.UNIT;
        });
    }

    private int dropPartitions(SessionCatalog catalog, Seq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs) {
        Seq dropPartSpecs = (Seq)ThreadUtils$.MODULE$.parmap(catalog.listPartitions(this.tableName(), catalog.listPartitions$default$2()), "RepairTableCommand: non-existing partitions", 8, (Function1 & Serializable)partition -> partition.storage().locationUri().flatMap((Function1 & Serializable)uri2 -> ((SeqOps)partitionSpecsAndLocs.map((Function1 & Serializable)x$4 -> (Path)x$4._2())).contains((Object)new Path(uri2)) ? None$.MODULE$ : new Some((Object)partition.spec()))).flatten(Predef$.MODULE$.$conforms());
        catalog.dropPartitions(this.tableName(), dropPartSpecs, true, false, true);
        return dropPartSpecs.length();
    }

    public RepairHoodieTableCommand copy(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        return new RepairHoodieTableCommand(tableName, enableAddPartitions, enableDropPartitions, cmd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.enableAddPartitions();
    }

    public boolean copy$default$3() {
        return this.enableDropPartitions();
    }

    public String copy$default$4() {
        return this.cmd();
    }

    public String productPrefix() {
        return "RepairHoodieTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.enableAddPartitions());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.enableDropPartitions());
                break;
            }
            case 3: {
                object = this.cmd();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RepairHoodieTableCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "tableName";
                break;
            }
            case 1: {
                string = "enableAddPartitions";
                break;
            }
            case 2: {
                string = "enableDropPartitions";
                break;
            }
            case 3: {
                string = "cmd";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RepairHoodieTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RepairHoodieTableCommand repairHoodieTableCommand = (RepairHoodieTableCommand)x$1;
        if (this.enableAddPartitions() != repairHoodieTableCommand.enableAddPartitions()) return false;
        if (this.enableDropPartitions() != repairHoodieTableCommand.enableDropPartitions()) return false;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = repairHoodieTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.cmd();
        String string2 = repairHoodieTableCommand.cmd();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!repairHoodieTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(RepairHoodieTableCommand $this, Map partitionStats$1, CatalogTable table$2, SparkSession spark$1, LongRef done$1, int total$2, Seq batch) {
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        Seq parts = (Seq)batch.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map spec = (Map)tuple2._1();
            Path location = (Path)tuple2._2();
            Map params = (Map)partitionStats$1.get((Object)location.toString()).map((Function1 & Serializable)x0$2 -> {
                PartitionStatistics partitionStatistics = x0$2;
                if (partitionStatistics == null) {
                    throw new MatchError((Object)partitionStatistics);
                }
                int numFiles = partitionStatistics.numFiles();
                long totalSize = partitionStatistics.totalSize();
                Map map2 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.NUM_FILES()), (Object)Integer.toString(numFiles)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.TOTAL_SIZE()), (Object)Long.toString(totalSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.DDL_TIME()), (Object)Long.toString(now))}));
                return map2;
            }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
            CatalogTablePartition catalogTablePartition = new CatalogTablePartition(spec, table$2.storage().copy((Option)new Some((Object)location.toUri()), table$2.storage().copy$default$2(), table$2.storage().copy$default$3(), table$2.storage().copy$default$4(), table$2.storage().copy$default$5(), table$2.storage().copy$default$6()), params, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            return catalogTablePartition;
        });
        spark$1.sessionState().catalog().createPartitions($this.tableName(), parts, true);
        done$1.elem += (long)parts.length();
        $this.logDebug((Function0 & Serializable)() -> new StringBuilder(32).append("Recovered ").append(parts.length()).append(" partitions (").append(done$1.elem).append("/").append(total$2).append(" so far)").toString());
    }

    public RepairHoodieTableCommand(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        this.tableName = tableName;
        this.enableAddPartitions = enableAddPartitions;
        this.enableDropPartitions = enableDropPartitions;
        this.cmd = cmd;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        this.NUM_FILES = "numFiles";
        this.TOTAL_SIZE = "totalSize";
        this.DDL_TIME = "transient_lastDdlTime";
        Statics.releaseFence();
    }
}

