/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.hudi.command.TruncateHoodieTableCommand$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001b\"A!\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005m\u0001\tE\t\u0015!\u0003U\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u0015\u0011\b\u0001\"\u0011t\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\n\u0001\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011\u0005\u0001\u0012\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"a\u000f\u0001\u0003\u0003%\t!!\u0010\t\u0013\u0005\u0015\u0003!!A\u0005\u0002\u0005\u001d\u0003\"CA*\u0001\u0005\u0005I\u0011IA+\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r!I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0013qO\u0004\n\u0003wJ\u0012\u0011!E\u0001\u0003{2\u0001\u0002G\r\u0002\u0002#\u0005\u0011q\u0010\u0005\u0007[J!\t!a&\t\u0013\u0005e%#!A\u0005F\u0005m\u0005\"CAO%\u0005\u0005I\u0011QAP\u0011%\t)KEA\u0001\n\u0003\u000b9\u000bC\u0005\u00026J\t\t\u0011\"\u0003\u00028\nQBK];oG\u0006$X\rS8pI&,G+\u00192mK\u000e{W.\\1oI*\u0011!dG\u0001\bG>lW.\u00198e\u0015\taR$\u0001\u0003ik\u0012L'B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011C\u0002\u0001(cUJt\b\u0005\u0002)_5\t\u0011F\u0003\u0002+W\u00059An\\4jG\u0006d'B\u0001\u0017.\u0003\u0015\u0001H.\u00198t\u0015\tqS$\u0001\u0005dCR\fG._:u\u0013\t\u0001\u0014FA\u0006M_\u001eL7-\u00197QY\u0006t\u0007C\u0001\u001a4\u001b\u0005I\u0012B\u0001\u001b\u001a\u0005eAun\u001c3jK2+\u0017M\u001a*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005Y:T\"A\u000e\n\u0005aZ\"\u0001\u0006)s_ZLG-Z:I_>$\u0017.Z\"p]\u001aLw\r\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4HA\u0004Qe>$Wo\u0019;\u0011\u0005\u0001CeBA!G\u001d\t\u0011U)D\u0001D\u0015\t!U%\u0001\u0004=e>|GOP\u0005\u0002y%\u0011qiO\u0001\ba\u0006\u001c7.Y4f\u0013\tI%J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Hw\u0005yA/\u00192mK&#WM\u001c;jM&,'/F\u0001N!\tqu*D\u0001.\u0013\t\u0001VFA\bUC\ndW-\u00133f]RLg-[3s\u0003A!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b%A\u0007qCJ$\u0018\u000e^5p]N\u0003XmY\u000b\u0002)B\u0019!(V,\n\u0005Y[$AB(qi&|g\u000e\u0005\u0002YS:\u0011\u0011L\u001a\b\u00035\u0012t!aW2\u000f\u0005q\u0013gBA/b\u001d\tq\u0006M\u0004\u0002C?&\tA%\u0003\u0002#G%\u0011\u0001%I\u0005\u0003=}I!AL\u000f\n\u0005\u0015l\u0013aB2bi\u0006dwnZ\u0005\u0003O\"\fAbQ1uC2|w\rV=qKNT!!Z\u0017\n\u0005)\\'A\u0005+bE2,\u0007+\u0019:uSRLwN\\*qK\u000eT!a\u001a5\u0002\u001dA\f'\u000f^5uS>t7\u000b]3dA\u00051A(\u001b8jiz\"2a\u001c9r!\t\u0011\u0004\u0001C\u0003L\u000b\u0001\u0007Q\nC\u0003S\u000b\u0001\u0007A+A\u0002sk:$\"\u0001^>\u0011\u0007\u0001+x/\u0003\u0002w\u0015\n\u00191+Z9\u0011\u0005aLX\"A\u000f\n\u0005il\"a\u0001*po\")AP\u0002a\u0001{\u0006a1\u000f]1sWN+7o]5p]B\u0011\u0001P`\u0005\u0003\u007fv\u0011Ab\u00159be.\u001cVm]:j_:\fAaY8qsR)q.!\u0002\u0002\b!91j\u0002I\u0001\u0002\u0004i\u0005b\u0002*\b!\u0003\u0005\r\u0001V\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiAK\u0002N\u0003\u001fY#!!\u0005\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037Y\u0014AC1o]>$\u0018\r^5p]&!\u0011qDA\u000b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)CK\u0002U\u0003\u001f\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0016!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\tA\u0001\\1oO*\u0011\u0011QG\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002:\u0005=\"AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002@A\u0019!(!\u0011\n\u0007\u0005\r3HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002J\u0005=\u0003c\u0001\u001e\u0002L%\u0019\u0011QJ\u001e\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002R1\t\t\u00111\u0001\u0002@\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0016\u0011\r\u0005e\u0013qLA%\u001b\t\tYFC\u0002\u0002^m\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t'a\u0017\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003O\ni\u0007E\u0002;\u0003SJ1!a\u001b<\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0015\u000f\u0003\u0003\u0005\r!!\u0013\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003W\t\u0019\bC\u0005\u0002R=\t\t\u00111\u0001\u0002@\u00051Q-];bYN$B!a\u001a\u0002z!I\u0011\u0011\u000b\t\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u001b)J,hnY1uK\"{w\u000eZ5f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003eI\u0019RAEAA\u0003\u001b\u0003r!a!\u0002\n6#v.\u0004\u0002\u0002\u0006*\u0019\u0011qQ\u001e\u0002\u000fI,h\u000e^5nK&!\u00111RAC\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003\u001f\u000b)*\u0004\u0002\u0002\u0012*!\u00111SA\u001a\u0003\tIw.C\u0002J\u0003##\"!! \u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b=\f\t+a)\t\u000b-+\u0002\u0019A'\t\u000bI+\u0002\u0019\u0001+\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011VAY!\u0011QT+a+\u0011\u000bi\ni+\u0014+\n\u0007\u0005=6H\u0001\u0004UkBdWM\r\u0005\t\u0003g3\u0012\u0011!a\u0001_\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005e\u0006\u0003BA\u0017\u0003wKA!!0\u00020\t1qJ\u00196fGR\u0004")
public class TruncateHoodieTableCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
ProvidesHoodieConfig,
Serializable {
    private final TableIdentifier tableIdentifier;
    private final Option<Map<String, String>> partitionSpec;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Option<Map<String, String>>>> unapply(TruncateHoodieTableCommand x$0) {
        return TruncateHoodieTableCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<TableIdentifier, Option<Map<String, String>>>, TruncateHoodieTableCommand> tupled() {
        return TruncateHoodieTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, TruncateHoodieTableCommand>> curried() {
        return TruncateHoodieTableCommand$.MODULE$.curried();
    }

    @Override
    public Map<String, String> buildHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildHoodieConfig$(this, hoodieCatalogTable);
    }

    @Override
    public Map<String, String> buildHoodieInsertConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession, boolean isOverwritePartition, boolean isOverwriteTable, Map<String, Option<String>> insertPartitions, Map<String, String> extraOptions, Option<String> staticOverwritePartitionPathOpt) {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$(this, hoodieCatalogTable, sparkSession, isOverwritePartition, isOverwriteTable, insertPartitions, extraOptions, staticOverwritePartitionPathOpt);
    }

    @Override
    public Map<String, Option<String>> buildHoodieInsertConfig$default$5() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$5$(this);
    }

    @Override
    public Option<String> buildHoodieInsertConfig$default$7() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$7$(this);
    }

    @Override
    public Map<String, String> getDropDupsConfig(boolean useLegacyInsertModeFlow, Map<String, String> incomingParams) {
        return ProvidesHoodieConfig.getDropDupsConfig$(this, useLegacyInsertModeFlow, incomingParams);
    }

    @Override
    public Tuple4<SaveMode, Object, Object, Option<String>> deduceOverwriteConfig(SparkSession sparkSession, HoodieCatalogTable catalogTable, Map<String, Option<String>> partitionSpec, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.deduceOverwriteConfig$(this, sparkSession, catalogTable, partitionSpec, extraOptions);
    }

    @Override
    public Map<String, String> buildHoodieDropPartitionsConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, String partitionsToDrop) {
        return ProvidesHoodieConfig.buildHoodieDropPartitionsConfig$(this, sparkSession, hoodieCatalogTable, partitionsToDrop);
    }

    @Override
    public Map<String, String> buildHoodieDeleteTableConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        return ProvidesHoodieConfig.buildHoodieDeleteTableConfig$(this, hoodieCatalogTable, sparkSession);
    }

    @Override
    public HiveSyncConfig buildHiveSyncConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, HoodieTableConfig tableConfig, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.buildHiveSyncConfig$(this, sparkSession, hoodieCatalogTable, tableConfig, extraOptions);
    }

    @Override
    public Map<String, String> buildHiveSyncConfig$default$4() {
        return ProvidesHoodieConfig.buildHiveSyncConfig$default$4$(this);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        TruncateHoodieTableCommand truncateHoodieTableCommand = this;
        synchronized (truncateHoodieTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        String fullTableName = new StringBuilder(1).append(this.tableIdentifier().database()).append(".").append(this.tableIdentifier().table()).toString();
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(41).append("start execute truncate table command for ").append(fullTableName).toString());
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableIdentifier());
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableIdentifier());
        String tableId = table.identifier().quotedString();
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringBuilder(48).append("Operation not allowed: TRUNCATE TABLE on views: ").append(tableId).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        if (table.partitionColumnNames().isEmpty() && this.partitionSpec().isDefined()) {
            throw new AnalysisException(new StringBuilder(0).append("Operation not allowed: TRUNCATE TABLE ... PARTITION is not supported ").append(new StringBuilder(37).append("for tables that are not partitioned: ").append(tableId).toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        String basePath = hoodieCatalogTable.tableLocation();
        TypedProperties properties2 = hoodieCatalogTable.tableConfig().getProps();
        if (this.partitionSpec().isEmpty()) {
            StoragePath targetPath = new StoragePath(basePath);
            HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(JavaSparkContext$.MODULE$.fromSparkContext(sparkSession.sparkContext()));
            HoodieStorage storage2 = HoodieStorageUtils.getStorage(basePath, HadoopFSUtils.getStorageConf(sparkSession.sessionState().newHadoopConf()));
            FSUtils.deleteDir(engineContext, storage2, targetPath, sparkSession.sparkContext().defaultParallelism());
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.newTableBuilder().fromProperties(properties2).initTable(HadoopFSUtils.getStorageConf(sparkSession.sessionState().newHadoopConf()), hoodieCatalogTable.tableLocation());
            hoodieCatalogTable.tableConfig().clearMetadataPartitions(metaClient);
        } else {
            boolean success;
            Seq normalizedSpecs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)this.partitionSpec().map((Function1 & Serializable)spec -> HoodieSqlCommonUtils$.MODULE$.normalizePartitionSpec(spec, (Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)hoodieCatalogTable.partitionFields()), hoodieCatalogTable.tableName(), (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver())).get()}));
            String partitionsToDrop = HoodieSqlCommonUtils$.MODULE$.getPartitionPathToDrop(hoodieCatalogTable, (Seq<Map<String, String>>)normalizedSpecs);
            Map<String, String> parameters2 = this.buildHoodieDropPartitionsConfig(sparkSession, hoodieCatalogTable, partitionsToDrop);
            Tuple6<Object, org.apache.hudi.common.util.Option<String>, org.apache.hudi.common.util.Option<String>, org.apache.hudi.common.util.Option<String>, SparkRDDWriteClient<?>, HoodieTableConfig> tuple6 = HoodieSparkSqlWriter$.MODULE$.write(sparkSession.sqlContext(), SaveMode.Append, parameters2, (Dataset<Row>)sparkSession.emptyDataFrame(), HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
            if (tuple6 == null) {
                throw new MatchError(tuple6);
            }
            boolean bl = success = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
            boolean success2 = bl;
            if (!success2) {
                throw new HoodieException("Truncate Hoodie Table command failed");
            }
        }
        sparkSession.catalog().refreshTable(table.identifier().quotedString());
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(42).append("Finish execute truncate table command for ").append(fullTableName).toString());
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public TruncateHoodieTableCommand copy(TableIdentifier tableIdentifier, Option<Map<String, String>> partitionSpec) {
        return new TruncateHoodieTableCommand(tableIdentifier, partitionSpec);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "TruncateHoodieTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableIdentifier();
                break;
            }
            case 1: {
                object = this.partitionSpec();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncateHoodieTableCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "tableIdentifier";
                break;
            }
            case 1: {
                string = "partitionSpec";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncateHoodieTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncateHoodieTableCommand truncateHoodieTableCommand = (TruncateHoodieTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = truncateHoodieTableCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = truncateHoodieTableCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncateHoodieTableCommand.canEqual(this)) return false;
        return true;
    }

    public TruncateHoodieTableCommand(TableIdentifier tableIdentifier, Option<Map<String, String>> partitionSpec) {
        this.tableIdentifier = tableIdentifier;
        this.partitionSpec = partitionSpec;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        ProvidesHoodieConfig.$init$(this);
        Statics.releaseFence();
    }
}

