/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RunCleanProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001\u0002\t\u0012\u0001\u0001BQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004=\u0001\u0001\u0006Ia\r\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!)a\t\u0001C!\u000f\")1\n\u0001C!e!)A\n\u0001C!}!)Q\n\u0001C!\u001d\u001e)A-\u0005E\u0001K\u001a)\u0001#\u0005E\u0001M\")af\u0003C\u0001U\"91n\u0003b\u0001\n\u0003a\u0007BB;\fA\u0003%Q\u000eC\u0003w\u0017\u0011\u0005qOA\tSk:\u001cE.Z1o!J|7-\u001a3ve\u0016T!AE\n\u0002\u0015A\u0014xnY3ekJ,7O\u0003\u0002\u0015+\u000591m\\7nC:$'B\u0001\f\u0018\u0003\u0011AW\u000fZ5\u000b\u0005aI\u0012aA:rY*\u0011!dG\u0001\u0006gB\f'o\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\tS\u0005\u000b\t\u0003E\rj\u0011!E\u0005\u0003IE\u0011QBQ1tKB\u0013xnY3ekJ,\u0007C\u0001\u0012'\u0013\t9\u0013C\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3feB\u0011\u0011\u0006L\u0007\u0002U)\u00111&G\u0001\tS:$XM\u001d8bY&\u0011QF\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0007\u0005\u0002#\u0001\u0005Q\u0001+\u0011*B\u001b\u0016#VIU*\u0016\u0003M\u00022\u0001N\u001c:\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$!B!se\u0006L\bC\u0001\u0012;\u0013\tY\u0014C\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\u0018a\u0003)B%\u0006kU\tV#S'\u0002\n1bT+U!V#v\fV-Q\u000bV\tq\b\u0005\u0002A\u00076\t\u0011I\u0003\u0002C/\u0005)A/\u001f9fg&\u0011A)\u0011\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0013!\u00022vS2$W#\u0001%\u0011\u0005\tJ\u0015B\u0001&\u0012\u0005%\u0001&o\\2fIV\u0014X-\u0001\u0006qCJ\fW.\u001a;feN\f!b\\;uaV$H+\u001f9f\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005={\u0006c\u0001)Y7:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)~\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005]+\u0014a\u00029bG.\fw-Z\u0005\u00033j\u00131aU3r\u0015\t9V\u0007\u0005\u0002];6\tq#\u0003\u0002_/\t\u0019!k\\<\t\u000b\u0001L\u0001\u0019A1\u0002\t\u0005\u0014xm\u001d\t\u0003E\tL!aY\t\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0003E\u0011VO\\\"mK\u0006t\u0007K]8dK\u0012,(/\u001a\t\u0003E-\u0019\"aC4\u0011\u0005QB\u0017BA56\u0005\u0019\te.\u001f*fMR\tQ-\u0001\u0003O\u00036+U#A7\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018\u0001\u00027b]\u001eT\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\n11\u000b\u001e:j]\u001e\fQAT!N\u000b\u0002\nqAY;jY\u0012,'/F\u0001y!\rIh0J\u0007\u0002u*\u00111\u0010`\u0001\tMVt7\r^5p]*\u0011Q0]\u0001\u0005kRLG.\u0003\u0002\u0000u\nA1+\u001e9qY&,'\u000f")
public class RunCleanProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RunCleanProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RunCleanProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public Procedure build() {
        return new RunCleanProcedure();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        Seq seq;
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        boolean skipLocking = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get());
        boolean scheduleInLine = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[2]).get());
        Map confs = Predef$.MODULE$.Map().empty();
        if (this.getArgValueOrDefault(args2, this.PARAMETERS()[3]).isDefined()) {
            confs = (Map)confs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_POLICY.key()), (Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[3]).get().toString()));
        }
        if (this.getArgValueOrDefault(args2, this.PARAMETERS()[4]).isDefined()) {
            confs = (Map)confs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key()), (Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[4]).get().toString()));
        }
        if (this.getArgValueOrDefault(args2, this.PARAMETERS()[5]).isDefined()) {
            confs = (Map)confs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_HOURS_RETAINED.key()), (Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[5]).get().toString()));
        }
        if (this.getArgValueOrDefault(args2, this.PARAMETERS()[6]).isDefined()) {
            confs = (Map)confs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_FILE_VERSIONS_RETAINED.key()), (Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[6]).get().toString()));
        }
        if (this.getArgValueOrDefault(args2, this.PARAMETERS()[7]).isDefined()) {
            confs = (Map)confs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEAN_TRIGGER_STRATEGY.key()), (Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[7]).get().toString()));
        }
        if (this.getArgValueOrDefault(args2, this.PARAMETERS()[8]).isDefined()) {
            confs = (Map)confs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEAN_MAX_COMMITS.key()), (Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[8]).get().toString()));
        }
        if (this.getArgValueOrDefault(args2, this.PARAMETERS()[9]).isDefined()) {
            confs = (Map)confs.$plus$plus(HoodieCLIUtils$.MODULE$.extractOptions((String)this.getArgValueOrDefault(args2, this.PARAMETERS()[9]).get()));
        }
        String basePath = this.getBasePath(tableName, (Option<Object>)Option$.MODULE$.empty());
        try (SparkRDDWriteClient<?> client = null;){
            client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient(this.sparkSession(), basePath, (Map<String, String>)confs, tableName);
            String cleanInstantTime = client.createNewInstantTime();
            HoodieCleanMetadata hoodieCleanMeta = client.clean(cleanInstantTime, scheduleInLine, skipLocking);
            seq = hoodieCleanMeta == null ? (Seq)package$.MODULE$.Seq().empty() : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{hoodieCleanMeta.getStartCleanTime(), BoxesRunTime.boxToLong((long)hoodieCleanMeta.getTimeTakenInMillis()), BoxesRunTime.boxToInteger((int)hoodieCleanMeta.getTotalFilesDeleted()), hoodieCleanMeta.getEarliestCommitToRetain(), JsonUtils.getObjectMapper().writeValueAsString(hoodieCleanMeta.getBootstrapPartitionMetadata()), hoodieCleanMeta.getVersion()}))}));
        }
        return seq;
    }

    public RunCleanProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "skip_locking", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(2, "schedule_in_line", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)true)), ProcedureParameter$.MODULE$.optional(3, "clean_policy", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(4, "retain_commits", DataTypes.IntegerType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(5, "hours_retained", DataTypes.IntegerType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(6, "file_versions_retained", DataTypes.IntegerType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(7, "trigger_strategy", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(8, "trigger_max_commits", DataTypes.IntegerType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(9, "options", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("start_clean_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("time_taken_in_millis", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_deleted", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("earliest_commit_to_retain", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("bootstrap_part_metadata", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("version", DataTypes.IntegerType, true, Metadata$.MODULE$.empty())}));
    }
}

