/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowBootstrapPartitionsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001B\t\u0013\u0001\u0005BQ!\u000b\u0001\u0005\u0002)Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00048\u0001\u0001\u0006IA\f\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019\u0001\u0005\u0001)A\u0005u!)\u0011\t\u0001C\u0001[!)!\t\u0001C\u0001s!)1\t\u0001C!\t\")!\f\u0001C\u00057\")\u0011\u000f\u0001C!e\u001e)1O\u0005E\u0001i\u001a)\u0011C\u0005E\u0001k\")\u0011\u0006\u0004C\u0001s\"9!\u0010\u0004b\u0001\n\u0003Y\bbBA\u0005\u0019\u0001\u0006I\u0001 \u0005\b\u0003\u0017aA\u0011AA\u0007\u0005\u0001\u001a\u0006n\\<C_>$8\u000f\u001e:baB\u000b'\u000f^5uS>t7\u000f\u0015:pG\u0016$WO]3\u000b\u0005M!\u0012A\u00039s_\u000e,G-\u001e:fg*\u0011QCF\u0001\bG>lW.\u00198e\u0015\t9\u0002$\u0001\u0003ik\u0012L'BA\r\u001b\u0003\r\u0019\u0018\u000f\u001c\u0006\u00037q\tQa\u001d9be.T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011c\u0001\u0001#MA\u00111\u0005J\u0007\u0002%%\u0011QE\u0005\u0002\u000e\u0005\u0006\u001cX\r\u0015:pG\u0016$WO]3\u0011\u0005\r:\u0013B\u0001\u0015\u0013\u0005A\u0001&o\\2fIV\u0014XMQ;jY\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0002WA\u00111\u0005A\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#\u0001\u0018\u0011\u0007=\u0012D'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0015\t%O]1z!\t\u0019S'\u0003\u00027%\t\u0011\u0002K]8dK\u0012,(/\u001a)be\u0006lW\r^3s\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\u0002\u0017=+F\u000bU+U?RK\u0006+R\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011Q\bG\u0001\u0006if\u0004Xm]\u0005\u0003\u007fq\u0012!b\u0015;sk\u000e$H+\u001f9f\u00031yU\u000b\u0016)V)~#\u0016\fU#!\u0003)\u0001\u0018M]1nKR,'o]\u0001\u000b_V$\b/\u001e;UsB,\u0017\u0001B2bY2$\"!R+\u0011\u0007\u0019s\u0015K\u0004\u0002H\u0019:\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nI\u0001\u0007yI|w\u000e\u001e \n\u0003EJ!!\u0014\u0019\u0002\u000fA\f7m[1hK&\u0011q\n\u0015\u0002\u0004'\u0016\f(BA'1!\t\u00116+D\u0001\u0019\u0013\t!\u0006DA\u0002S_^DQA\u0016\u0005A\u0002]\u000bA!\u0019:hgB\u00111\u0005W\u0005\u00033J\u0011Q\u0002\u0015:pG\u0016$WO]3Be\u001e\u001c\u0018AG2sK\u0006$XMQ8piN$(/\u00199J]\u0012,\u0007PU3bI\u0016\u0014HC\u0001/j!\tiv-D\u0001_\u0015\ty\u0006-\u0001\bC_>$8\u000f\u001e:ba&sG-\u001a=\u000b\u0005\u0005\u0014\u0017!B5oI\u0016D(BA2e\u0003%\u0011wn\u001c;tiJ\f\u0007O\u0003\u0002fM\u000611m\\7n_:T!a\u0006\u000f\n\u0005!t&aC%oI\u0016D(+Z1eKJDQA[\u0005A\u0002-\f!\"\\3uC\u000ec\u0017.\u001a8u!\taw.D\u0001n\u0015\tqG-A\u0003uC\ndW-\u0003\u0002q[\n)\u0002j\\8eS\u0016$\u0016M\u00197f\u001b\u0016$\u0018m\u00117jK:$\u0018!\u00022vS2$W#A\u0016\u0002AMCwn\u001e\"p_R\u001cHO]1q!\u0006\u0014H/\u001b;j_:\u001c\bK]8dK\u0012,(/\u001a\t\u0003G1\u0019\"\u0001\u0004<\u0011\u0005=:\u0018B\u0001=1\u0005\u0019\te.\u001f*fMR\tA/\u0001\u0003O\u00036+U#\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0004\u0005!!.\u0019<b\u0013\r\t9A \u0002\u0007'R\u0014\u0018N\\4\u0002\u000b9\u000bU*\u0012\u0011\u0002\u000f\t,\u0018\u000e\u001c3feV\u0011\u0011q\u0002\t\u0006\u0003#\tYBJ\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005Aa-\u001e8di&|gN\u0003\u0003\u0002\u001a\u0005\u0005\u0011\u0001B;uS2LA!!\b\u0002\u0014\tA1+\u001e9qY&,'\u000f")
public class ShowBootstrapPartitionsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("indexed_partitions", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowBootstrapPartitionsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowBootstrapPartitionsProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        BootstrapIndex.IndexReader indexReader = this.createBootstrapIndexReader(metaClient);
        List<String> indexedPartitions = indexReader.getIndexedPartitionPaths();
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(indexedPartitions.stream().toArray()), (Function1 & Serializable)r -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{r})), ClassTag$.MODULE$.apply(Row.class))).toList();
    }

    private BootstrapIndex.IndexReader createBootstrapIndexReader(HoodieTableMetaClient metaClient) {
        BootstrapIndex index = BootstrapIndex.getBootstrapIndex(metaClient);
        if (!index.useIndex()) {
            throw new HoodieException("This is not a bootstrapped Hudi table. Don't have any index info");
        }
        return index.createReader();
    }

    @Override
    public ShowBootstrapPartitionsProcedure build() {
        return new ShowBootstrapPartitionsProcedure();
    }
}

