/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.execution;

import java.io.Serializable;
import org.apache.spark.rdd.PartitionPruningRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.hudi.execution.RangeSample$;
import org.apache.spark.util.random.SamplingUtils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u000b\u0016\u0001\tB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\u000b\u0001BA\u0002\u0013%q\u000b\u0003\u0005\\\u0001\t\u0005\r\u0011\"\u0003]\u0011!\u0011\u0007A!A!B\u0013A\u0006\u0002C2\u0001\u0005\u000b\u0007I\u0011\u00013\t\u0011\u0015\u0004!\u0011!Q\u0001\n]B\u0001B\u001a\u0001\u0003\u0004\u0003\u0006Ya\u001a\u0005\u0006[\u0002!\tA\u001c\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!a%\u0001\t\u0003\t)jB\u0005\u0002@V\t\t\u0011#\u0001\u0002B\u001aAA#FA\u0001\u0012\u0003\t\u0019\r\u0003\u0004n\u001f\u0011\u0005\u00111\u001b\u0005\n\u0003+|\u0011\u0013!C\u0001\u0003/D\u0011\"a=\u0010#\u0003%\t!!>\t\u0013\u0005}x\"!A\u0005\n\t\u0005!a\u0003*b]\u001e,7+Y7qY\u0016T!AF\f\u0002\u0013\u0015DXmY;uS>t'B\u0001\r\u001a\u0003\u0011AW\u000fZ5\u000b\u0005iY\u0012aA:rY*\u0011A$H\u0001\u0006gB\f'o\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007\rjEkE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u00164\u001d\ta\u0013G\u0004\u0002.a5\taF\u0003\u00020C\u00051AH]8pizJ\u0011aJ\u0005\u0003e\u0019\nq\u0001]1dW\u0006<W-\u0003\u00025k\ta1+\u001a:jC2L'0\u00192mK*\u0011!GJ\u0001\u000bu\u0016s7m\u001c3f\u001dVl\u0007CA\u00139\u0013\tIdEA\u0002J]R\f1A\u001d3ea\ta4\tE\u0002>\u007f\u0005k\u0011A\u0010\u0006\u0003umI!\u0001\u0011 \u0003\u0007I#E\t\u0005\u0002C\u00072\u0001A!\u0003#\u0003\u0003\u0003\u0005\tQ!\u0001F\u0005\ryF%M\t\u0003\r&\u0003\"!J$\n\u0005!3#a\u0002(pi\"Lgn\u001a\t\u0005K)c5+\u0003\u0002LM\tA\u0001K]8ek\u000e$(\u0007\u0005\u0002C\u001b\u0012)a\n\u0001b\u0001\u001f\n\t1*\u0005\u0002G!B\u0011Q%U\u0005\u0003%\u001a\u00121!\u00118z!\t\u0011E\u000bB\u0003V\u0001\t\u0007qJA\u0001W\u0003\u0019\t7oY3oIV\t\u0001\f\u0005\u0002&3&\u0011!L\n\u0002\b\u0005>|G.Z1o\u0003)\t7oY3oI~#S-\u001d\u000b\u0003;\u0002\u0004\"!\n0\n\u0005}3#\u0001B+oSRDq!\u0019\u0003\u0002\u0002\u0003\u0007\u0001,A\u0002yIE\nq!Y:dK:$\u0007%\u0001\u000ftC6\u0004H.\u001a)pS:$8\u000fU3s!\u0006\u0014H/\u001b;j_:D\u0015N\u001c;\u0016\u0003]\nQd]1na2,\u0007k\\5oiN\u0004VM\u001d)beRLG/[8o\u0011&tG\u000fI\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u00015l\u00196\t\u0011N\u0003\u0002kM\u00059!/\u001a4mK\u000e$\u0018B\u00017j\u0005!\u0019E.Y:t)\u0006<\u0017A\u0002\u001fj]&$h\bF\u0003pgRL(\u0010\u0006\u0002qeB!\u0011\u000f\u0001'T\u001b\u0005)\u0002\"\u00024\n\u0001\b9\u0007\"\u0002\u001c\n\u0001\u00049\u0004\"\u0002\u001e\n\u0001\u0004)\bG\u0001<y!\rith\u001e\t\u0003\u0005b$\u0011\u0002\u0012;\u0002\u0002\u0003\u0005)\u0011A#\t\u000fYK\u0001\u0013!a\u00011\"91-\u0003I\u0001\u0002\u00049\u0014AD4fiJ\u000bgnZ3C_VtGm\u001d\u000b\u0002{B)a0a\u0002\u0002\f5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000b1\u0013AC2pY2,7\r^5p]&\u0019\u0011\u0011B@\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0007K\u00055A*!\u0005\n\u0007\u0005=aE\u0001\u0004UkBdWM\r\t\u0004K\u0005M\u0011bAA\u000bM\t)a\t\\8bi\u0006qA-\u001a;fe6Lg.\u001a\"pk:$W\u0003BA\u000e\u0003O!\u0002\"!\b\u0002:\u0005\u0005\u0013Q\t\u000b\u0007\u0003?\tI#a\r\u0011\u000b\u0015\n\t#!\n\n\u0007\u0005\rbEA\u0003BeJ\f\u0017\u0010E\u0002C\u0003O!QAT\u0006C\u0002=C\u0011\"a\u000b\f\u0003\u0003\u0005\u001d!!\f\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0003,\u0003_\t)#C\u0002\u00022U\u0012\u0001b\u0014:eKJLgn\u001a\u0005\n\u0003kY\u0011\u0011!a\u0002\u0003o\t!\"\u001a<jI\u0016t7-\u001a\u00134!\u0011A7.!\n\t\u000f\u0005m2\u00021\u0001\u0002>\u0005Q1-\u00198eS\u0012\fG/Z:\u0011\u000by\f9!a\u0010\u0011\u000f\u0015\ni!!\n\u0002\u0012!1\u00111I\u0006A\u0002]\n!\u0002]1si&$\u0018n\u001c8t\u0011\u001d\t9e\u0003a\u0001\u0003[\t\u0001b\u001c:eKJLgnZ\u0001\u0013I\u0016$XM]7j]\u0016\u0014vn\u001e\"pk:$7/\u0006\u0003\u0002N\u00055DCCA(\u0003k\nY(! \u0002\bR1\u0011\u0011KA3\u0003_\u0002R!JA\u0011\u0003'\u0002R!JA\u0011\u0003+\u0002B!a\u0016\u0002b5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&A\u0006fqB\u0014Xm]:j_:\u001c(bAA03\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002d\u0005e#!C+og\u00064WMU8x\u0011%\t9\u0007DA\u0001\u0002\b\tI'\u0001\u0006fm&$WM\\2fIQ\u0002RaKA\u0018\u0003W\u00022AQA7\t\u0015qEB1\u0001P\u0011%\t\t\bDA\u0001\u0002\b\t\u0019(\u0001\u0006fm&$WM\\2fIU\u0002B\u0001[6\u0002l!9\u00111\b\u0007A\u0002\u0005]\u0004#\u0002@\u0002\b\u0005e\u0004cB\u0013\u0002\u000e\u0005-\u0014\u0011\u0003\u0005\u0007\u0003\u0007b\u0001\u0019A\u001c\t\u000f\u0005}D\u00021\u0001\u0002\u0002\u0006IqN\u001d3fe&twm\u001d\t\u0006W\u0005\r\u0015\u0011N\u0005\u0004\u0003\u000b+$aA*fc\"9\u0011\u0011\u0012\u0007A\u0002\u0005-\u0015AC1uiJL'-\u001e;fgB)1&a!\u0002\u000eB!\u0011qKAH\u0013\u0011\t\t*!\u0017\u0003\u0013\u0005#HO]5ckR,\u0017AB:lKR\u001c\u0007.\u0006\u0003\u0002\u0018\u0006=FCBAM\u0003o\u000bY\f\u0006\u0003\u0002\u001c\u0006E\u0006cB\u0013\u0002\u000e\u0005u\u00151\u0015\t\u0004K\u0005}\u0015bAAQM\t!Aj\u001c8h!\u0015)\u0013\u0011EAS!!)\u0013qU\u001c\u0002\u001e\u0006-\u0016bAAUM\t1A+\u001e9mKN\u0002R!JA\u0011\u0003[\u00032AQAX\t\u0015qUB1\u0001P\u0011%\t\u0019,DA\u0001\u0002\b\t),\u0001\u0006fm&$WM\\2fIY\u0002B\u0001[6\u0002.\"1!(\u0004a\u0001\u0003s\u0003B!P \u0002.\"1\u0011QX\u0007A\u0002]\nac]1na2,7+\u001b>f!\u0016\u0014\b+\u0019:uSRLwN\\\u0001\f%\u0006tw-Z*b[BdW\r\u0005\u0002r\u001fM!q\u0002JAc!\u0011\t9-!5\u000e\u0005\u0005%'\u0002BAf\u0003\u001b\f!![8\u000b\u0005\u0005=\u0017\u0001\u00026bm\u0006L1\u0001NAe)\t\t\t-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0007\u00033\fy/!=\u0016\u0005\u0005m'f\u0001-\u0002^.\u0012\u0011q\u001c\t\u0005\u0003C\fY/\u0004\u0002\u0002d*!\u0011Q]At\u0003%)hn\u00195fG.,GMC\u0002\u0002j\u001a\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti/a9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003O#\t\u0007q\nB\u0003V#\t\u0007q*A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0007\u0003o\fY0!@\u0016\u0005\u0005e(fA\u001c\u0002^\u0012)aJ\u0005b\u0001\u001f\u0012)QK\u0005b\u0001\u001f\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\u0001\t\u0005\u0005\u000b\u0011Y!\u0004\u0002\u0003\b)!!\u0011BAg\u0003\u0011a\u0017M\\4\n\t\t5!q\u0001\u0002\u0007\u001f\nTWm\u0019;")
public class RangeSample<K, V>
implements Serializable {
    private final int zEncodeNum;
    private final RDD<? extends Product2<K, V>> rdd;
    private boolean ascend;
    private final int samplePointsPerPartitionHint;
    private final ClassTag<K> evidence$1;

    public static <K, V> int $lessinit$greater$default$4() {
        return RangeSample$.MODULE$.$lessinit$greater$default$4();
    }

    public static <K, V> boolean $lessinit$greater$default$3() {
        return RangeSample$.MODULE$.$lessinit$greater$default$3();
    }

    private boolean ascend() {
        return this.ascend;
    }

    private void ascend_$eq(boolean x$1) {
        this.ascend = x$1;
    }

    public int samplePointsPerPartitionHint() {
        return this.samplePointsPerPartitionHint;
    }

    public ArrayBuffer<Tuple2<K, Object>> getRangeBounds() {
        ArrayBuffer arrayBuffer;
        if (this.zEncodeNum <= 1) {
            arrayBuffer = ArrayBuffer$.MODULE$.empty();
        } else {
            double sampleSize = scala.math.package$.MODULE$.min((double)this.samplePointsPerPartitionHint() * (double)this.zEncodeNum, 1000000.0);
            int sampleSizePerPartition = (int)scala.math.package$.MODULE$.ceil(3.0 * sampleSize / (double)this.rdd.partitions().length);
            Tuple2<Object, Tuple3<Object, Object, Object>[]> tuple2 = this.sketch(this.rdd.map((Function1 & Serializable)x$1 -> x$1._1(), this.evidence$1), sampleSizePerPartition, this.evidence$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long numItems = tuple2._1$mcJ$sp();
            Tuple3[] sketched = (Tuple3[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numItems), (Object)sketched);
            Tuple2 tuple23 = tuple22;
            long numItems2 = tuple23._1$mcJ$sp();
            Tuple3[] sketched2 = (Tuple3[])tuple23._2();
            if (numItems2 == 0L) {
                arrayBuffer = ArrayBuffer$.MODULE$.empty();
            } else {
                BoxedUnit boxedUnit;
                double fraction = scala.math.package$.MODULE$.min(sampleSize / (double)scala.math.package$.MODULE$.max(numItems2, 1L), 1.0);
                ArrayBuffer candidates = ArrayBuffer$.MODULE$.empty();
                Set imbalancedPartitions = (Set)Set$.MODULE$.empty();
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])sketched2), (Function1 & Serializable)x0$1 -> {
                    Growable growable;
                    Tuple3 tuple3 = x0$1;
                    if (tuple3 != null) {
                        int idx = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        long n = BoxesRunTime.unboxToLong((Object)tuple3._2());
                        Object sample = tuple3._3();
                        if (fraction * (double)n > (double)sampleSizePerPartition) {
                            growable = imbalancedPartitions.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
                        } else {
                            float weight = (float)((double)n / (double)ScalaRunTime$.MODULE$.array_length(sample));
                            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(sample), (Function1 & Serializable)key -> (ArrayBuffer)candidates.$plus$eq((Object)new Tuple2(key, (Object)BoxesRunTime.boxToFloat((float)weight))));
                            growable = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple3);
                    }
                    Growable growable2 = growable;
                    return growable2;
                });
                if (imbalancedPartitions.nonEmpty()) {
                    PartitionPruningRDD imbalanced = new PartitionPruningRDD(this.rdd.map((Function1 & Serializable)x$3 -> x$3._1(), this.evidence$1), (Function1)(JFunction1.mcZI.sp & Serializable)elem -> imbalancedPartitions.contains((Object)BoxesRunTime.boxToInteger((int)elem)), this.evidence$1);
                    int seed = scala.util.hashing.package$.MODULE$.byteswap32(-this.rdd.id() - 1);
                    Object reSampled = imbalanced.sample(false, fraction, (long)seed).collect();
                    float weight = (float)(1.0 / fraction);
                    boxedUnit = candidates.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(reSampled), (Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToFloat((float)weight)), ClassTag$.MODULE$.apply(Tuple2.class))));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                arrayBuffer = candidates;
            }
        }
        return arrayBuffer;
    }

    public <K> Object determineBound(ArrayBuffer<Tuple2<K, Object>> candidates, int partitions, Ordering<K> ordering, Ordering<K> evidence$2, ClassTag<K> evidence$3) {
        ArrayBuffer ordered = (ArrayBuffer)candidates.sortBy((Function1 & Serializable)x$4 -> x$4._1(), ordering);
        int numCandidates = ordered.size();
        double sumWeights = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)ordered.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)RangeSample.$anonfun$determineBound$2(x$5)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double step = sumWeights / (double)partitions;
        double cumWeight = 0.0;
        double target = step;
        ArrayBuffer bounds = ArrayBuffer$.MODULE$.empty();
        int j = 0;
        Option previousBound = Option$.MODULE$.empty();
        for (int i = 0; i < numCandidates && j < partitions - 1; ++i) {
            Tuple2 tuple2 = (Tuple2)ordered.apply(i);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            float weight = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2(key, (Object)BoxesRunTime.boxToFloat((float)weight));
            Tuple2 tuple23 = tuple22;
            Object key2 = tuple23._1();
            float weight2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
            cumWeight += (double)weight2;
            if (!(cumWeight >= target) || !previousBound.isEmpty() && !ordering.gt(key2, previousBound.get())) continue;
            bounds.$plus$eq(key2);
            target += step;
            ++j;
            previousBound = new Some(key2);
        }
        return bounds.toArray(evidence$3);
    }

    public <K> UnsafeRow[][] determineRowBounds(ArrayBuffer<Tuple2<K, Object>> candidates, int partitions, Seq<Ordering<K>> orderings, Seq<Attribute> attributes, Ordering<K> evidence$4, ClassTag<K> evidence$5) {
        return (UnsafeRow[][])((IterableOnceOps)((IterableOps)orderings.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            ArrayBuffer bounds;
            int index;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Ordering ordering = (Ordering)tuple2._1();
                index = tuple2._2$mcI$sp();
                ArrayBuffer ordered = (ArrayBuffer)candidates.sortBy((Function1 & Serializable)x$7 -> x$7._1(), ordering);
                int numCandidates = ordered.size();
                double sumWeights = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)ordered.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToDouble((double)RangeSample.$anonfun$determineRowBounds$3(x$8)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double step = sumWeights / (double)partitions;
                double cumWeight = 0.0;
                double target = step;
                bounds = ArrayBuffer$.MODULE$.empty();
                int j = 0;
                Option previousBound = Option$.MODULE$.empty();
                for (int i = 0; i < numCandidates && j < partitions - 1; ++i) {
                    Tuple2 tuple22 = (Tuple2)ordered.apply(i);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Object key = tuple22._1();
                    float weight = BoxesRunTime.unboxToFloat((Object)tuple22._2());
                    Tuple2 tuple23 = new Tuple2(key, (Object)BoxesRunTime.boxToFloat((float)weight));
                    Tuple2 tuple24 = tuple23;
                    Object key2 = tuple24._1();
                    float weight2 = BoxesRunTime.unboxToFloat((Object)tuple24._2());
                    cumWeight += (double)weight2;
                    if (!(cumWeight >= target) || !previousBound.isEmpty() && !ordering.gt(key2, previousBound.get())) continue;
                    bounds.$plus$eq(key2);
                    target += step;
                    ++j;
                    previousBound = new Some(key2);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            UnsafeProjection project = UnsafeProjection$.MODULE$.create((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{(Attribute)attributes.apply(index)})), attributes);
            UnsafeRow[] unsafeRowArray = (UnsafeRow[])((IterableOnceOps)bounds.map((Function1 & Serializable)bound -> {
                UnsafeRow row = (UnsafeRow)bound;
                return project.apply((InternalRow)row).copy();
            })).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
            return unsafeRowArray;
        })).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(UnsafeRow.class)));
    }

    public <K> Tuple2<Object, Tuple3<Object, Object, Object>[]> sketch(RDD<K> rdd, int sampleSizePerPartition, ClassTag<K> evidence$6) {
        int shift = rdd.id();
        Tuple3[] sketched = (Tuple3[])rdd.mapPartitionsWithIndex((Function2 & Serializable)(idx, iter) -> RangeSample.$anonfun$sketch$1(shift, sampleSizePerPartition, evidence$6, BoxesRunTime.unboxToInt((Object)idx), iter), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        long numItems = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sketched), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)RangeSample.$anonfun$sketch$2(x$11)), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)numItems), (Object)sketched);
    }

    public static final /* synthetic */ double $anonfun$determineBound$2(Tuple2 x$5) {
        return BoxesRunTime.unboxToFloat((Object)x$5._2());
    }

    public static final /* synthetic */ double $anonfun$determineRowBounds$3(Tuple2 x$8) {
        return BoxesRunTime.unboxToFloat((Object)x$8._2());
    }

    public static final /* synthetic */ Iterator $anonfun$sketch$1(int shift$1, int sampleSizePerPartition$2, ClassTag evidence$6$1, int idx, Iterator iter) {
        int seed = scala.util.hashing.package$.MODULE$.byteswap32(idx ^ shift$1 << 16);
        Tuple2 tuple2 = SamplingUtils$.MODULE$.reservoirSampleAndCount(iter, sampleSizePerPartition$2, (long)seed, evidence$6$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object sample = tuple2._1();
        long n = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2(sample, (Object)BoxesRunTime.boxToLong((long)n));
        Tuple2 tuple23 = tuple22;
        Object sample2 = tuple23._1();
        long n2 = tuple23._2$mcJ$sp();
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)idx), (Object)BoxesRunTime.boxToLong((long)n2), sample2)}));
    }

    public static final /* synthetic */ long $anonfun$sketch$2(Tuple3 x$11) {
        return BoxesRunTime.unboxToLong((Object)x$11._2());
    }

    public RangeSample(int zEncodeNum, RDD<? extends Product2<K, V>> rdd, boolean ascend, int samplePointsPerPartitionHint, ClassTag<K> evidence$1) {
        this.zEncodeNum = zEncodeNum;
        this.rdd = rdd;
        this.ascend = ascend;
        this.samplePointsPerPartitionHint = samplePointsPerPartitionHint;
        this.evidence$1 = evidence$1;
        Predef$.MODULE$.require(zEncodeNum >= 0, (Function0 & Serializable)() -> new StringBuilder(51).append("Number of zEncodeNum cannot be negative but found ").append($this.zEncodeNum).append(".").toString());
        Predef$.MODULE$.require(samplePointsPerPartitionHint > 0, (Function0 & Serializable)() -> new StringBuilder(61).append("Sample points per partition must be greater than 0 but found ").append(this.samplePointsPerPartitionHint()).toString());
    }
}

