/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.streaming;

import java.io.Serializable;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.IncrementalRelationV1;
import org.apache.hudi.MergeOnReadIncrementalRelationV1;
import org.apache.hudi.MergeOnReadIncrementalRelationV1$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.cdc.CDCRelation$;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.cdc.HoodieCDCUtils;
import org.apache.hudi.common.table.checkpoint.CheckpointUtils;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV1;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.streaming.HoodieEarliestOffsetRangeLimit$;
import org.apache.spark.sql.hudi.streaming.HoodieLatestOffsetRangeLimit$;
import org.apache.spark.sql.hudi.streaming.HoodieMetadataLog;
import org.apache.spark.sql.hudi.streaming.HoodieOffsetRangeLimit;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset$;
import org.apache.spark.sql.hudi.streaming.HoodieSpecifiedOffsetRangeLimit;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\f\u0018\u0001\u0011B\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011!y\u0007A!A!\u0002\u0013\u0001\b\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011a\u0004!\u0011!Q\u0001\neDQ\u0001 \u0001\u0005\u0002uD!\"!\u0004\u0001\u0011\u000b\u0007I\u0011BA\b\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0011\u0011%\tI\u0003\u0001b\u0001\n\u0013\tY\u0003\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA\u0017\u0011)\tI\u0006\u0001EC\u0002\u0013%\u00111\f\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\ty\u0007\u0001C\u0005\u0003cBq!!\u001e\u0001\t\u0003\n9\bC\u0004\u0002\u0002\u0002!\t%a!\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011\u0011\u0016\u0001\u0005\n\u0005-\u0006bBAY\u0001\u0011\u0005\u00131\u0017\u0002\u0015\u0011>|G-[3TiJ,\u0017-\\*pkJ\u001cWMV\u0019\u000b\u0005aI\u0012!C:ue\u0016\fW.\u001b8h\u0015\tQ2$\u0001\u0003ik\u0012L'B\u0001\u000f\u001e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u00011C\u0002\u0001&[QR\u0004\n\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\r=\u0013'.Z2u!\tq#'D\u00010\u0015\tA\u0002G\u0003\u000227\u0005IQ\r_3dkRLwN\\\u0005\u0003g=\u0012aaU8ve\u000e,\u0007CA\u001b9\u001b\u00051$BA\u001c\u001e\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001d7\u0005\u001daunZ4j]\u001e\u0004\"aO#\u000f\u0005q\u0012eBA\u001fA\u001b\u0005q$BA $\u0003\u0019a$o\\8u}%\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\t\u00069\u0001/Y2lC\u001e,'\"A!\n\u0005\u0019;%\u0001D*fe&\fG.\u001b>bE2,'BA\"E!\tI5*D\u0001K\u0015\tQr$\u0003\u0002M\u0015\n\u00192\u000b]1sW\u0006#\u0017\r\u001d;feN+\b\u000f]8si\u0006Q1/\u001d7D_:$X\r\u001f;\u0011\u0005=\u0003V\"A\u000e\n\u0005E[\"AC*R\u0019\u000e{g\u000e^3yi\u0006QQ.\u001a;b\u00072LWM\u001c;\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016!\u0002;bE2,'B\u0001-K\u0003\u0019\u0019w.\\7p]&\u0011!,\u0016\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u00031iW\r^1eCR\f\u0007+\u0019;i!\ti\u0016M\u0004\u0002_?B\u0011Q\bR\u0005\u0003A\u0012\u000ba\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\u0019\u0019FO]5oO*\u0011\u0001\rR\u0001\rg\u000eDW-\\1PaRLwN\u001c\t\u0004M\u001eLW\"\u0001#\n\u0005!$%AB(qi&|g\u000e\u0005\u0002k[6\t1N\u0003\u0002m7\u0005)A/\u001f9fg&\u0011an\u001b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017A\u00039be\u0006lW\r^3sgB!Q,\u001d/]\u0013\t\u00118MA\u0002NCB\f\u0001c\u001c4gg\u0016$(+\u00198hK2KW.\u001b;\u0011\u0005U4X\"A\f\n\u0005]<\"A\u0006%p_\u0012LWm\u00144gg\u0016$(+\u00198hK2KW.\u001b;\u0002#]\u0014\u0018\u000e^3UC\ndWMV3sg&|g\u000e\u0005\u0002Uu&\u001110\u0016\u0002\u0013\u0011>|G-[3UC\ndWMV3sg&|g.\u0001\u0004=S:LGO\u0010\u000b\u000f}~\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006!\t)\b\u0001C\u0003N\u0011\u0001\u0007a\nC\u0003S\u0011\u0001\u00071\u000bC\u0003\\\u0011\u0001\u0007A\fC\u0003e\u0011\u0001\u0007Q\rC\u0003p\u0011\u0001\u0007\u0001\u000fC\u0003t\u0011\u0001\u0007A\u000fC\u0003y\u0011\u0001\u0007\u00110A\u0005uC\ndW\rV=qKV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC,\u0002\u000b5|G-\u001a7\n\t\u0005m\u0011Q\u0003\u0002\u0010\u0011>|G-[3UC\ndW\rV=qK\u0006Q\u0011n]\"E\u0007F+XM]=\u0016\u0005\u0005\u0005\u0002c\u00014\u0002$%\u0019\u0011Q\u0005#\u0003\u000f\t{w\u000e\\3b]\u0006Y\u0011n]\"E\u0007F+XM]=!\u0003QAw\u000e\u001c7po\u000e{W.\\5u\u0011\u0006tG\r\\5oOV\u0011\u0011Q\u0006\t\u0005\u0003_\t\tF\u0004\u0003\u00022\u0005-c\u0002BA\u001a\u0003\u000frA!!\u000e\u0002F9!\u0011qGA\"\u001d\u0011\tI$!\u0011\u000f\t\u0005m\u0012q\b\b\u0004{\u0005u\u0012\"\u0001\u0012\n\u0005\u0001\n\u0013B\u0001\u000e \u0013\tA&*\u0003\u0002W/&\u0019\u0011\u0011J+\u0002\u0011QLW.\u001a7j]\u0016LA!!\u0014\u0002P\u0005iA+[7fY&tW-\u0016;jYNT1!!\u0013V\u0013\u0011\t\u0019&!\u0016\u0003)!{G\u000e\\8x\u0007>lW.\u001b;IC:$G.\u001b8h\u0015\u0011\ti%a\u0014\u0002+!|G\u000e\\8x\u0007>lW.\u001b;IC:$G.\u001b8hA\u0005q\u0011N\\5uS\u0006dwJ\u001a4tKR\u001cXCAA/!\r)\u0018qL\u0005\u0004\u0003C:\"A\u0005%p_\u0012LWmU8ve\u000e,wJ\u001a4tKRD3ADA3!\r1\u0017qM\u0005\u0004\u0003S\"%!\u0003;sC:\u001c\u0018.\u001a8u\u0003\u0019\u00198\r[3nCV\t\u0011.A\bhKRd\u0015\r^3ti>3gm]3u+\t\t\u0019\b\u0005\u0003gO\u0006u\u0013!C4fi>3gm]3u+\t\tI\b\u0005\u0003gO\u0006m\u0004c\u0001\u0018\u0002~%\u0019\u0011qP\u0018\u0003\r=3gm]3u\u0003!9W\r\u001e\"bi\u000eDGCBAC\u00033\u000bi\n\u0005\u0003\u0002\b\u0006Me\u0002BAE\u0003#sA!a#\u0002\u0010:!\u0011\u0011HAG\u0013\tqr$\u0003\u0002\u001d;%\u00111iG\u0005\u0005\u0003+\u000b9JA\u0005ECR\fgI]1nK*\u00111i\u0007\u0005\b\u00037\u0013\u0002\u0019AA=\u0003\u0015\u0019H/\u0019:u\u0011\u001d\tyJ\u0005a\u0001\u0003w\n1!\u001a8e\u0003=\u0019H/\u0019:u\u0007>lW.\u001b;US6,Gc\u0001/\u0002&\"9\u0011qU\nA\u0002\u0005u\u0013aC:uCJ$xJ\u001a4tKR\f1\u0003\u001e:b]Nd\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$2\u0001XAW\u0011\u0019\ty\u000b\u0006a\u00019\u0006Q1m\\7nSR$\u0016.\\3\u0002\tM$x\u000e\u001d\u000b\u0003\u0003k\u00032AZA\\\u0013\r\tI\f\u0012\u0002\u0005+:LG\u000f")
public class HoodieStreamSourceV1
implements Source,
Logging,
Serializable,
SparkAdapterSupport {
    private HoodieTableType tableType;
    private transient HoodieSourceOffset initialOffsets;
    private final SQLContext sqlContext;
    private final HoodieTableMetaClient metaClient;
    private final String metadataPath;
    private final Option<StructType> schemaOption;
    private final Map<String, String> parameters;
    private final HoodieOffsetRangeLimit offsetRangeLimit;
    private final HoodieTableVersion writeTableVersion;
    private final boolean isCDCQuery;
    private final TimelineUtils.HollowCommitHandling hollowCommitHandling;
    private SparkAdapter sparkAdapter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
        Source.commit$((Source)this, (org.apache.spark.sql.execution.streaming.Offset)end);
    }

    public Offset initialOffset() {
        return Source.initialOffset$((Source)this);
    }

    public Offset deserializeOffset(String json) {
        return Source.deserializeOffset$((Source)this, (String)json);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieStreamSourceV1 hoodieStreamSourceV1 = this;
        synchronized (hoodieStreamSourceV1) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieStreamSourceV1 hoodieStreamSourceV1 = this;
        synchronized (hoodieStreamSourceV1) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tableType = this.metaClient.getTableType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tableType;
    }

    private HoodieTableType tableType() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    private boolean isCDCQuery() {
        return this.isCDCQuery;
    }

    private TimelineUtils.HollowCommitHandling hollowCommitHandling() {
        return this.hollowCommitHandling;
    }

    private HoodieSourceOffset initialOffsets$lzycompute() {
        HoodieStreamSourceV1 hoodieStreamSourceV1 = this;
        synchronized (hoodieStreamSourceV1) {
            if (!this.bitmap$trans$0) {
                HoodieMetadataLog metadataLog = new HoodieMetadataLog(this.sqlContext.sparkSession(), this.metadataPath);
                this.initialOffsets = (HoodieSourceOffset)metadataLog.get(0L).getOrElse((Function0 & Serializable)() -> {
                    void var3_6;
                    HoodieSourceOffset hoodieSourceOffset;
                    HoodieOffsetRangeLimit hoodieOffsetRangeLimit = $this.offsetRangeLimit;
                    if (HoodieEarliestOffsetRangeLimit$.MODULE$.equals(hoodieOffsetRangeLimit)) {
                        hoodieSourceOffset = HoodieSourceOffset$.MODULE$.INIT_OFFSET();
                    } else if (HoodieLatestOffsetRangeLimit$.MODULE$.equals(hoodieOffsetRangeLimit)) {
                        hoodieSourceOffset = (HoodieSourceOffset)this.getLatestOffset().getOrElse((Function0 & Serializable)() -> HoodieSourceOffset$.MODULE$.INIT_OFFSET());
                    } else if (hoodieOffsetRangeLimit instanceof HoodieSpecifiedOffsetRangeLimit) {
                        HoodieSpecifiedOffsetRangeLimit hoodieSpecifiedOffsetRangeLimit = (HoodieSpecifiedOffsetRangeLimit)hoodieOffsetRangeLimit;
                        String instantTime = hoodieSpecifiedOffsetRangeLimit.instantTime();
                        hoodieSourceOffset = new HoodieSourceOffset(instantTime);
                    } else {
                        throw new MatchError((Object)hoodieOffsetRangeLimit);
                    }
                    HoodieSourceOffset offset = hoodieSourceOffset;
                    metadataLog.add(0L, offset);
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("The initial offset is ").append(offset).toString());
                    return var3_6;
                });
                this.bitmap$trans$0 = true;
            }
        }
        return this.initialOffsets;
    }

    private HoodieSourceOffset initialOffsets() {
        return !this.bitmap$trans$0 ? this.initialOffsets$lzycompute() : this.initialOffsets;
    }

    public StructType schema() {
        return this.isCDCQuery() ? CDCRelation$.MODULE$.FULL_CDC_SPARK_SCHEMA() : (StructType)this.schemaOption.getOrElse((Function0 & Serializable)() -> {
            TableSchemaResolver schemaUtil = new TableSchemaResolver($this.metaClient);
            return AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schemaUtil.getTableAvroSchema());
        });
    }

    private Option<HoodieSourceOffset> getLatestOffset() {
        None$ none$;
        HoodieTimeline filteredTimeline;
        this.metaClient.reloadActiveTimeline();
        HoodieTimeline hoodieTimeline = filteredTimeline = TimelineUtils.handleHollowCommitIfNeeded(this.metaClient.getActiveTimeline().filterCompletedInstants(), this.metaClient, this.hollowCommitHandling());
        if (!hoodieTimeline.empty()) {
            TimelineUtils.HollowCommitHandling hollowCommitHandling = this.hollowCommitHandling();
            TimelineUtils.HollowCommitHandling hollowCommitHandling2 = TimelineUtils.HollowCommitHandling.USE_TRANSITION_TIME;
            String timestamp = !(hollowCommitHandling != null ? !((Object)((Object)hollowCommitHandling)).equals((Object)hollowCommitHandling2) : hollowCommitHandling2 != null) ? hoodieTimeline.getInstantsOrderedByCompletionTime().skip(hoodieTimeline.countInstants() - 1).findFirst().get().getCompletionTime() : hoodieTimeline.lastInstant().get().requestedTime();
            none$ = new Some((Object)new HoodieSourceOffset(timestamp));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
        return this.getLatestOffset();
    }

    public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start2, org.apache.spark.sql.execution.streaming.Offset end) {
        Dataset dataset;
        HoodieSourceOffset startOffset = (HoodieSourceOffset)start2.map((Function1 & Serializable)x$1 -> HoodieSourceOffset$.MODULE$.apply((org.apache.spark.sql.execution.streaming.Offset)x$1)).getOrElse((Function0 & Serializable)() -> this.initialOffsets());
        HoodieSourceOffset endOffset = HoodieSourceOffset$.MODULE$.apply(end);
        startOffset = new HoodieSourceOffset(this.translateCheckpoint(startOffset.offsetCommitTime()));
        endOffset = new HoodieSourceOffset(this.translateCheckpoint(endOffset.offsetCommitTime()));
        HoodieSourceOffset hoodieSourceOffset = startOffset;
        HoodieSourceOffset hoodieSourceOffset2 = endOffset;
        if (!(hoodieSourceOffset != null ? !((Object)hoodieSourceOffset).equals(hoodieSourceOffset2) : hoodieSourceOffset2 != null)) {
            dataset = this.sqlContext.internalCreateDataFrame(this.sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
        } else if (this.isCDCQuery()) {
            Map cdcOptions = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.START_COMMIT().key()), (Object)this.startCommitTime(startOffset)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.END_COMMIT().key()), (Object)endOffset.offsetCommitTime())}));
            RDD<InternalRow> rdd = CDCRelation$.MODULE$.getCDCRelation(this.sqlContext, this.metaClient, (Map<String, String>)cdcOptions, CDCRelation$.MODULE$.getCDCRelation$default$4()).buildScan0(HoodieCDCUtils.CDC_COLUMNS, (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)));
            dataset = this.sqlContext.sparkSession().internalCreateDataFrame(rdd, CDCRelation$.MODULE$.FULL_CDC_SPARK_SCHEMA(), true);
        } else {
            RDD<Row> rDD;
            Map incParams = (Map)this.parameters.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.START_COMMIT().key()), (Object)this.startCommitTime(startOffset)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.END_COMMIT().key()), (Object)endOffset.offsetCommitTime()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.INCREMENTAL_READ_HANDLE_HOLLOW_COMMIT().key()), (Object)this.hollowCommitHandling().name())})));
            HoodieTableType hoodieTableType = this.tableType();
            if (((Object)((Object)HoodieTableType.COPY_ON_WRITE)).equals((Object)hoodieTableType)) {
                SparkRowSerDe serDe = this.sparkAdapter().createSparkRowSerDe(this.schema());
                rDD = new IncrementalRelationV1(this.sqlContext, (Map<String, String>)incParams, (Option<StructType>)new Some((Object)this.schema()), this.metaClient).buildScan().map((Function1 & Serializable)x$1 -> serDe.serializeRow((Row)x$1), ClassTag$.MODULE$.apply(InternalRow.class));
            } else if (((Object)((Object)HoodieTableType.MERGE_ON_READ)).equals((Object)hoodieTableType)) {
                String[] requiredColumns = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.schema().fields()), (Function1 & Serializable)x$2 -> x$2.name(), ClassTag$.MODULE$.apply(String.class));
                rDD = new MergeOnReadIncrementalRelationV1(this.sqlContext, (Map<String, String>)incParams, this.metaClient, (Option<StructType>)new Some((Object)this.schema()), MergeOnReadIncrementalRelationV1$.MODULE$.$lessinit$greater$default$5()).buildScan(requiredColumns, (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)));
            } else {
                throw new IllegalArgumentException(new StringBuilder(21).append("UnSupport tableType: ").append((Object)this.tableType()).toString());
            }
            RDD<Row> rdd = rDD;
            dataset = this.sqlContext.internalCreateDataFrame((RDD)rdd, this.schema(), true);
        }
        return dataset;
    }

    private String startCommitTime(HoodieSourceOffset startOffset) {
        String string;
        HoodieSourceOffset hoodieSourceOffset = startOffset;
        HoodieSourceOffset hoodieSourceOffset2 = HoodieSourceOffset$.MODULE$.INIT_OFFSET();
        HoodieSourceOffset hoodieSourceOffset3 = hoodieSourceOffset;
        if (!(hoodieSourceOffset2 != null ? !((Object)hoodieSourceOffset2).equals(hoodieSourceOffset3) : hoodieSourceOffset3 != null)) {
            string = startOffset.offsetCommitTime();
        } else if (hoodieSourceOffset != null) {
            String commitTime;
            string = commitTime = hoodieSourceOffset.offsetCommitTime();
        } else {
            throw new IllegalStateException("UnKnow offset type.");
        }
        return string;
    }

    private String translateCheckpoint(String commitTime) {
        return this.writeTableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) ? CheckpointUtils.convertToCheckpointV2ForCommitTime(new StreamerCheckpointV1(commitTime), this.metaClient).getCheckpointKey() : commitTime;
    }

    public void stop() {
    }

    public HoodieStreamSourceV1(SQLContext sqlContext, HoodieTableMetaClient metaClient, String metadataPath, Option<StructType> schemaOption, Map<String, String> parameters2, HoodieOffsetRangeLimit offsetRangeLimit, HoodieTableVersion writeTableVersion) {
        this.sqlContext = sqlContext;
        this.metaClient = metaClient;
        this.metadataPath = metadataPath;
        this.schemaOption = schemaOption;
        this.parameters = parameters2;
        this.offsetRangeLimit = offsetRangeLimit;
        this.writeTableVersion = writeTableVersion;
        Source.$init$((Source)this);
        Logging.$init$((Logging)this);
        SparkAdapterSupport.$init$(this);
        this.isCDCQuery = CDCRelation$.MODULE$.isCDCEnabled(metaClient) && parameters2.get((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()).contains((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()) && parameters2.get((Object)DataSourceReadOptions$.MODULE$.INCREMENTAL_FORMAT().key()).contains((Object)DataSourceReadOptions$.MODULE$.INCREMENTAL_FORMAT_CDC_VAL());
        this.hollowCommitHandling = (TimelineUtils.HollowCommitHandling)((Object)parameters2.get((Object)DataSourceReadOptions$.MODULE$.INCREMENTAL_READ_HANDLE_HOLLOW_COMMIT().key()).map((Function1 & Serializable)x$1 -> TimelineUtils.HollowCommitHandling.valueOf(x$1)).getOrElse((Function0 & Serializable)() -> TimelineUtils.HollowCommitHandling.BLOCK));
    }
}

