/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.streaming;

import java.io.Serializable;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.IncrementalRelationV2;
import org.apache.hudi.MergeOnReadIncrementalRelationV2;
import org.apache.hudi.MergeOnReadIncrementalRelationV2$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.cdc.CDCRelation$;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.cdc.HoodieCDCUtils;
import org.apache.hudi.common.table.checkpoint.CheckpointUtils;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.streaming.HoodieEarliestOffsetRangeLimit$;
import org.apache.spark.sql.hudi.streaming.HoodieLatestOffsetRangeLimit$;
import org.apache.spark.sql.hudi.streaming.HoodieMetadataLog;
import org.apache.spark.sql.hudi.streaming.HoodieOffsetRangeLimit;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset$;
import org.apache.spark.sql.hudi.streaming.HoodieSpecifiedOffsetRangeLimit;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001\u0002\u000b\u0016\u0001\tB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003d\u0011!i\u0007A!A!\u0002\u0013q\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\t\u0011Y\u0004!\u0011!Q\u0001\n]DQA\u001f\u0001\u0005\u0002mD!\"!\u0003\u0001\u0011\u000b\u0007I\u0011BA\u0006\u0011%\tI\u0002\u0001b\u0001\n\u0013\tY\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\u000f\u0011)\t)\u0003\u0001EC\u0002\u0013%\u0011q\u0005\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0004\u0002N\u0001!\t%a\u0014\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x!9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0006bBAW\u0001\u0011\u0005\u0013q\u0016\u0002\u0015\u0011>|G-[3TiJ,\u0017-\\*pkJ\u001cWM\u0016\u001a\u000b\u0005Y9\u0012!C:ue\u0016\fW.\u001b8h\u0015\tA\u0012$\u0001\u0003ik\u0012L'B\u0001\u000e\u001c\u0003\r\u0019\u0018\u000f\u001c\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011C\u0002\u0001$WIBd\t\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\r=\u0013'.Z2u!\ta\u0003'D\u0001.\u0015\t1bF\u0003\u000203\u0005IQ\r_3dkRLwN\\\u0005\u0003c5\u0012aaU8ve\u000e,\u0007CA\u001a7\u001b\u0005!$BA\u001b\u001c\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001c5\u0005\u001daunZ4j]\u001e\u0004\"!O\"\u000f\u0005i\u0002eBA\u001e?\u001b\u0005a$BA\u001f\"\u0003\u0019a$o\\8u}%\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B\u0005\u00069\u0001/Y2lC\u001e,'\"A \n\u0005\u0011+%\u0001D*fe&\fG.\u001b>bE2,'BA!C!\t9\u0015*D\u0001I\u0015\tAR$\u0003\u0002K\u0011\n\u00192\u000b]1sW\u0006#\u0017\r\u001d;feN+\b\u000f]8si\u0006Q1/\u001d7D_:$X\r\u001f;\u0011\u00055sU\"A\r\n\u0005=K\"AC*R\u0019\u000e{g\u000e^3yi\u0006QQ.\u001a;b\u00072LWM\u001c;\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016!\u0002;bE2,'B\u0001,I\u0003\u0019\u0019w.\\7p]&\u0011\u0001l\u0015\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u00031iW\r^1eCR\f\u0007+\u0019;i!\tYvL\u0004\u0002];B\u00111HQ\u0005\u0003=\n\u000ba\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011aLQ\u0001\rg\u000eDW-\\1PaRLwN\u001c\t\u0004I\u0016<W\"\u0001\"\n\u0005\u0019\u0014%AB(qi&|g\u000e\u0005\u0002iW6\t\u0011N\u0003\u0002k3\u0005)A/\u001f9fg&\u0011A.\u001b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017A\u00039be\u0006lW\r^3sgB!1l\u001c.[\u0013\t\u0001\u0018MA\u0002NCB\f\u0001c\u001c4gg\u0016$(+\u00198hK2KW.\u001b;\u0011\u0005M$X\"A\u000b\n\u0005U,\"A\u0006%p_\u0012LWm\u00144gg\u0016$(+\u00198hK2KW.\u001b;\u0002#]\u0014\u0018\u000e^3UC\ndWMV3sg&|g\u000e\u0005\u0002Sq&\u0011\u0011p\u0015\u0002\u0013\u0011>|G-[3UC\ndWMV3sg&|g.\u0001\u0004=S:LGO\u0010\u000b\ryvtx0!\u0001\u0002\u0004\u0005\u0015\u0011q\u0001\t\u0003g\u0002AQa\u0013\u0005A\u00021CQ\u0001\u0015\u0005A\u0002ECQ!\u0017\u0005A\u0002iCQA\u0019\u0005A\u0002\rDQ!\u001c\u0005A\u00029DQ!\u001d\u0005A\u0002IDQA\u001e\u0005A\u0002]\f\u0011\u0002^1cY\u0016$\u0016\u0010]3\u0016\u0005\u00055\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005MQ+A\u0003n_\u0012,G.\u0003\u0003\u0002\u0018\u0005E!a\u0004%p_\u0012LW\rV1cY\u0016$\u0016\u0010]3\u0002\u0015%\u001c8\tR\"Rk\u0016\u0014\u00180\u0006\u0002\u0002\u001eA\u0019A-a\b\n\u0007\u0005\u0005\"IA\u0004C_>dW-\u00198\u0002\u0017%\u001c8\tR\"Rk\u0016\u0014\u0018\u0010I\u0001\u000fS:LG/[1m\u001f\u001a47/\u001a;t+\t\tI\u0003E\u0002t\u0003WI1!!\f\u0016\u0005IAun\u001c3jKN{WO]2f\u001f\u001a47/\u001a;)\u00071\t\t\u0004E\u0002e\u0003gI1!!\u000eC\u0005%!(/\u00198tS\u0016tG/\u0001\u0004tG\",W.Y\u000b\u0002O\u0006yq-\u001a;MCR,7\u000f^(gMN,G/\u0006\u0002\u0002@A!A-ZA\u0015\u0003%9W\r^(gMN,G/\u0006\u0002\u0002FA!A-ZA$!\ra\u0013\u0011J\u0005\u0004\u0003\u0017j#AB(gMN,G/\u0001\u0005hKR\u0014\u0015\r^2i)\u0019\t\t&!\u001c\u0002rA!\u00111KA4\u001d\u0011\t)&!\u001a\u000f\t\u0005]\u00131\r\b\u0005\u00033\n\tG\u0004\u0003\u0002\\\u0005}cbA\u001e\u0002^%\t\u0001%\u0003\u0002\u001f?%\u0011A$H\u0005\u00035mI!!Q\r\n\t\u0005%\u00141\u000e\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!!Q\r\t\u000f\u0005=\u0004\u00031\u0001\u0002F\u0005)1\u000f^1si\"9\u00111\u000f\tA\u0002\u0005\u001d\u0013aA3oI\u0006\u0011s-\u001a;Ti\u0006\u0014HoQ8na2,G/[8o)&lW-\u00118e%\u0006tw-\u001a+za\u0016$B!!\u001f\u0002\"B1A-a\u001f[\u0003\u007fJ1!! C\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011QAN\u001d\u0011\t\u0019)!&\u000f\t\u0005\u0015\u0015\u0011\u0013\b\u0005\u0003\u000f\u000byI\u0004\u0003\u0002\n\u00065e\u0002BA-\u0003\u0017K!\u0001G\u000f\n\u0005YC\u0015B\u0001+V\u0013\r\t\u0019jU\u0001\u0004Y><\u0017\u0002BAL\u00033\u000bA\"\u00138ti\u0006tGOU1oO\u0016T1!a%T\u0013\u0011\ti*a(\u0003\u0013I\u000bgnZ3UsB,'\u0002BAL\u00033Cq!a)\u0012\u0001\u0004\tI#A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\u0018a\u0005;sC:\u001cH.\u0019;f\u0007\",7m\u001b9pS:$Hc\u0001.\u0002*\"1\u00111\u0016\nA\u0002i\u000b!bY8n[&$H+[7f\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005E\u0006c\u00013\u00024&\u0019\u0011Q\u0017\"\u0003\tUs\u0017\u000e\u001e")
public class HoodieStreamSourceV2
implements Source,
Logging,
Serializable,
SparkAdapterSupport {
    private HoodieTableType tableType;
    private transient HoodieSourceOffset initialOffsets;
    private final SQLContext sqlContext;
    private final HoodieTableMetaClient metaClient;
    private final String metadataPath;
    private final Option<StructType> schemaOption;
    private final Map<String, String> parameters;
    private final HoodieOffsetRangeLimit offsetRangeLimit;
    private final HoodieTableVersion writeTableVersion;
    private final boolean isCDCQuery;
    private SparkAdapter sparkAdapter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
        Source.commit$((Source)this, (org.apache.spark.sql.execution.streaming.Offset)end);
    }

    public Offset initialOffset() {
        return Source.initialOffset$((Source)this);
    }

    public Offset deserializeOffset(String json) {
        return Source.deserializeOffset$((Source)this, (String)json);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieStreamSourceV2 hoodieStreamSourceV2 = this;
        synchronized (hoodieStreamSourceV2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieStreamSourceV2 hoodieStreamSourceV2 = this;
        synchronized (hoodieStreamSourceV2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tableType = this.metaClient.getTableType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tableType;
    }

    private HoodieTableType tableType() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    private boolean isCDCQuery() {
        return this.isCDCQuery;
    }

    private HoodieSourceOffset initialOffsets$lzycompute() {
        HoodieStreamSourceV2 hoodieStreamSourceV2 = this;
        synchronized (hoodieStreamSourceV2) {
            if (!this.bitmap$trans$0) {
                HoodieMetadataLog metadataLog = new HoodieMetadataLog(this.sqlContext.sparkSession(), this.metadataPath);
                this.initialOffsets = (HoodieSourceOffset)metadataLog.get(0L).getOrElse((Function0 & Serializable)() -> {
                    void var3_6;
                    HoodieSourceOffset hoodieSourceOffset;
                    HoodieOffsetRangeLimit hoodieOffsetRangeLimit = $this.offsetRangeLimit;
                    if (HoodieEarliestOffsetRangeLimit$.MODULE$.equals(hoodieOffsetRangeLimit)) {
                        hoodieSourceOffset = HoodieSourceOffset$.MODULE$.INIT_OFFSET();
                    } else if (HoodieLatestOffsetRangeLimit$.MODULE$.equals(hoodieOffsetRangeLimit)) {
                        hoodieSourceOffset = (HoodieSourceOffset)this.getLatestOffset().getOrElse((Function0 & Serializable)() -> HoodieSourceOffset$.MODULE$.INIT_OFFSET());
                    } else if (hoodieOffsetRangeLimit instanceof HoodieSpecifiedOffsetRangeLimit) {
                        HoodieSpecifiedOffsetRangeLimit hoodieSpecifiedOffsetRangeLimit = (HoodieSpecifiedOffsetRangeLimit)hoodieOffsetRangeLimit;
                        String completionTime = hoodieSpecifiedOffsetRangeLimit.instantTime();
                        hoodieSourceOffset = new HoodieSourceOffset(completionTime);
                    } else {
                        throw new MatchError((Object)hoodieOffsetRangeLimit);
                    }
                    HoodieSourceOffset offset = hoodieSourceOffset;
                    metadataLog.add(0L, offset);
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("The initial offset is ").append(offset).toString());
                    return var3_6;
                });
                this.bitmap$trans$0 = true;
            }
        }
        return this.initialOffsets;
    }

    private HoodieSourceOffset initialOffsets() {
        return !this.bitmap$trans$0 ? this.initialOffsets$lzycompute() : this.initialOffsets;
    }

    public StructType schema() {
        return this.isCDCQuery() ? CDCRelation$.MODULE$.FULL_CDC_SPARK_SCHEMA() : (StructType)this.schemaOption.getOrElse((Function0 & Serializable)() -> {
            TableSchemaResolver schemaUtil = new TableSchemaResolver($this.metaClient);
            return AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schemaUtil.getTableAvroSchema());
        });
    }

    private Option<HoodieSourceOffset> getLatestOffset() {
        this.metaClient.reloadActiveTimeline();
        org.apache.hudi.common.util.Option<String> latestCompletionTime = this.metaClient.getActiveTimeline().filterCompletedInstants().getLatestCompletionTime();
        return latestCompletionTime.isPresent() ? new Some((Object)new HoodieSourceOffset(latestCompletionTime.get())) : None$.MODULE$;
    }

    public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
        return this.getLatestOffset();
    }

    public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start2, org.apache.spark.sql.execution.streaming.Offset end) {
        Dataset dataset;
        HoodieSourceOffset startOffset = (HoodieSourceOffset)start2.map((Function1 & Serializable)x$1 -> HoodieSourceOffset$.MODULE$.apply((org.apache.spark.sql.execution.streaming.Offset)x$1)).getOrElse((Function0 & Serializable)() -> this.initialOffsets());
        HoodieSourceOffset endOffset = HoodieSourceOffset$.MODULE$.apply(end);
        startOffset = new HoodieSourceOffset(this.translateCheckpoint(startOffset.offsetCommitTime()));
        endOffset = new HoodieSourceOffset(this.translateCheckpoint(endOffset.offsetCommitTime()));
        HoodieSourceOffset hoodieSourceOffset = startOffset;
        HoodieSourceOffset hoodieSourceOffset2 = endOffset;
        if (!(hoodieSourceOffset != null ? !((Object)hoodieSourceOffset).equals(hoodieSourceOffset2) : hoodieSourceOffset2 != null)) {
            dataset = this.sqlContext.internalCreateDataFrame(this.sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
        } else {
            Tuple2<String, InstantRange.RangeType> tuple2 = this.getStartCompletionTimeAndRangeType(startOffset);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String startCompletionTime = (String)tuple2._1();
            InstantRange.RangeType rangeType = (InstantRange.RangeType)((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2((Object)startCompletionTime, (Object)rangeType);
            Tuple2 tuple23 = tuple22;
            String startCompletionTime2 = (String)tuple23._1();
            InstantRange.RangeType rangeType2 = (InstantRange.RangeType)((Object)tuple23._2());
            if (this.isCDCQuery()) {
                Map cdcOptions = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.START_COMMIT().key()), (Object)startCompletionTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.END_COMMIT().key()), (Object)endOffset.offsetCommitTime())}));
                RDD<InternalRow> rdd = CDCRelation$.MODULE$.getCDCRelation(this.sqlContext, this.metaClient, (Map<String, String>)cdcOptions, rangeType2).buildScan0(HoodieCDCUtils.CDC_COLUMNS, (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)));
                dataset = this.sqlContext.sparkSession().internalCreateDataFrame(rdd, CDCRelation$.MODULE$.FULL_CDC_SPARK_SCHEMA(), true);
            } else {
                RDD<Row> rDD;
                Map incParams = (Map)this.parameters.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.START_COMMIT().key()), (Object)startCompletionTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.END_COMMIT().key()), (Object)endOffset.offsetCommitTime())})));
                HoodieTableType hoodieTableType = this.tableType();
                if (((Object)((Object)HoodieTableType.COPY_ON_WRITE)).equals((Object)hoodieTableType)) {
                    SparkRowSerDe serDe = this.sparkAdapter().createSparkRowSerDe(this.schema());
                    rDD = new IncrementalRelationV2(this.sqlContext, (Map<String, String>)incParams, (Option<StructType>)new Some((Object)this.schema()), this.metaClient, rangeType2).buildScan().map((Function1 & Serializable)x$1 -> serDe.serializeRow((Row)x$1), ClassTag$.MODULE$.apply(InternalRow.class));
                } else if (((Object)((Object)HoodieTableType.MERGE_ON_READ)).equals((Object)hoodieTableType)) {
                    String[] requiredColumns = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.schema().fields()), (Function1 & Serializable)x$3 -> x$3.name(), ClassTag$.MODULE$.apply(String.class));
                    SQLContext x$12 = this.sqlContext;
                    Map x$2 = incParams;
                    HoodieTableMetaClient x$32 = this.metaClient;
                    Some x$4 = new Some((Object)this.schema());
                    InstantRange.RangeType x$5 = rangeType2;
                    Option<StructType> x$6 = MergeOnReadIncrementalRelationV2$.MODULE$.$lessinit$greater$default$5();
                    rDD = new MergeOnReadIncrementalRelationV2(x$12, (Map<String, String>)x$2, x$32, (Option<StructType>)x$4, x$6, x$5).buildScan(requiredColumns, (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)));
                } else {
                    throw new IllegalArgumentException(new StringBuilder(21).append("UnSupport tableType: ").append((Object)this.tableType()).toString());
                }
                RDD<Row> rdd = rDD;
                dataset = this.sqlContext.internalCreateDataFrame((RDD)rdd, this.schema(), true);
            }
        }
        return dataset;
    }

    private Tuple2<String, InstantRange.RangeType> getStartCompletionTimeAndRangeType(HoodieSourceOffset startOffset) {
        Tuple2 tuple2;
        HoodieSourceOffset hoodieSourceOffset = startOffset;
        HoodieSourceOffset hoodieSourceOffset2 = HoodieSourceOffset$.MODULE$.INIT_OFFSET();
        HoodieSourceOffset hoodieSourceOffset3 = hoodieSourceOffset;
        if (!(hoodieSourceOffset2 != null ? !((Object)hoodieSourceOffset2).equals(hoodieSourceOffset3) : hoodieSourceOffset3 != null)) {
            tuple2 = new Tuple2((Object)startOffset.offsetCommitTime(), (Object)InstantRange.RangeType.CLOSED_CLOSED);
        } else if (hoodieSourceOffset != null) {
            String completionTime = hoodieSourceOffset.offsetCommitTime();
            tuple2 = new Tuple2((Object)completionTime, (Object)InstantRange.RangeType.OPEN_CLOSED);
        } else {
            throw new IllegalStateException("UnKnow offset type.");
        }
        return tuple2;
    }

    private String translateCheckpoint(String commitTime) {
        return this.writeTableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) ? commitTime : CheckpointUtils.convertToCheckpointV1ForCommitTime(new StreamerCheckpointV2(commitTime), this.metaClient).getCheckpointKey();
    }

    public void stop() {
    }

    public HoodieStreamSourceV2(SQLContext sqlContext, HoodieTableMetaClient metaClient, String metadataPath, Option<StructType> schemaOption, Map<String, String> parameters2, HoodieOffsetRangeLimit offsetRangeLimit, HoodieTableVersion writeTableVersion) {
        this.sqlContext = sqlContext;
        this.metaClient = metaClient;
        this.metadataPath = metadataPath;
        this.schemaOption = schemaOption;
        this.parameters = parameters2;
        this.offsetRangeLimit = offsetRangeLimit;
        this.writeTableVersion = writeTableVersion;
        Source.$init$((Source)this);
        Logging.$init$((Logging)this);
        SparkAdapterSupport.$init$(this);
        this.isCDCQuery = CDCRelation$.MODULE$.isCDCEnabled(metaClient) && parameters2.get((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()).contains((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()) && parameters2.get((Object)DataSourceReadOptions$.MODULE$.INCREMENTAL_FORMAT().key()).contains((Object)DataSourceReadOptions$.MODULE$.INCREMENTAL_FORMAT_CDC_VAL());
    }
}

