/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import java.io.File;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.scripting.definitions.CachingSequence;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionProvider;", "()V", "_cachedDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "cachedDefinitions", "getCachedDefinitions", "()Lkotlin/sequences/Sequence;", "currentDefinitions", "getCurrentDefinitions", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "clearCache", "", "findDefinition", "file", "Ljava/io/File;", "findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "fileName", "", "getDefaultDefinition", "getDefaultScriptDefinition", "getKnownFilenameExtensions", "getScriptingHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "isScript", "", "nonScriptFileName", "Companion", "kotlin-scripting-compiler-impl"})
public abstract class LazyScriptDefinitionProvider
implements ScriptDefinitionProvider {
    @NotNull
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Sequence<? extends ScriptDefinition> _cachedDefinitions;
    @NotNull
    private static final String[] nonScriptFilenameSuffixes;
    public static final Companion Companion;

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @NotNull
    protected abstract Sequence<ScriptDefinition> getCurrentDefinitions();

    @NotNull
    protected ScriptingHostConfiguration getScriptingHostConfiguration() {
        return JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration();
    }

    @Override
    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        return ScriptDefinition.Companion.getDefault(this.getScriptingHostConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Sequence<ScriptDefinition> getCachedDefinitions() {
        boolean bl = this.lock.getReadLockCount() > 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "cachedDefinitions should only be used under the read lock";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this._cachedDefinitions == null) {
            int n;
            int n2;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl4 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl5 = false;
                this._cachedDefinitions = new CachingSequence<ScriptDefinition>(SequencesKt.constrainOnce(this.getCurrentDefinitions()));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        Sequence<ScriptDefinition> sequence = this._cachedDefinitions;
        if (sequence == null) {
            Intrinsics.throwNpe();
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearCache() {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl2 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl3 = false;
            this._cachedDefinitions = null;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl4 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    protected boolean nonScriptFileName(@NotNull String fileName) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(fileName, "fileName");
            String[] $this$any$iv = nonScriptFilenameSuffixes;
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!StringsKt.endsWith(fileName, it, true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ScriptDefinition findDefinition(@NotNull File file) {
        ScriptDefinition scriptDefinition;
        Intrinsics.checkParameterIsNotNull(file, "file");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        if (this.nonScriptFileName(string)) {
            scriptDefinition = null;
        } else {
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            boolean bl = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                ScriptDefinition scriptDefinition2;
                block6: {
                    boolean bl2 = false;
                    Sequence<ScriptDefinition> $this$firstOrNull$iv = this.getCachedDefinitions();
                    boolean $i$f$firstOrNull = false;
                    Iterator<ScriptDefinition> iterator2 = $this$firstOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        ScriptDefinition element$iv;
                        ScriptDefinition it = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (!it.isScript(file)) continue;
                        scriptDefinition2 = element$iv;
                        break block6;
                    }
                    scriptDefinition2 = null;
                }
                ScriptDefinition scriptDefinition3 = scriptDefinition2;
                scriptDefinition = scriptDefinition3;
            }
            finally {
                readLock.unlock();
            }
        }
        return scriptDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        KotlinScriptDefinition kotlinScriptDefinition;
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        if (this.nonScriptFileName(fileName)) {
            kotlinScriptDefinition = null;
        } else {
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            boolean bl = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                Object v1;
                block6: {
                    boolean bl2 = false;
                    Sequence $this$firstOrNull$iv = SequencesKt.map(this.getCachedDefinitions(), findScriptDefinition.1.1.INSTANCE);
                    boolean $i$f$firstOrNull = false;
                    Iterator iterator2 = $this$firstOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        KotlinScriptDefinition it = (KotlinScriptDefinition)((Object)element$iv);
                        boolean bl3 = false;
                        if (!it.isScript(fileName)) continue;
                        v1 = element$iv;
                        break block6;
                    }
                    v1 = null;
                }
                KotlinScriptDefinition kotlinScriptDefinition2 = v1;
                kotlinScriptDefinition = kotlinScriptDefinition2;
            }
            finally {
                readLock.unlock();
            }
        }
        return kotlinScriptDefinition;
    }

    @Override
    public boolean isScript(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return this.findDefinition(file) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Sequence<String> getKnownFilenameExtensions() {
        Sequence<String> sequence;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            sequence = SequencesKt.map(this.getCachedDefinitions(), getKnownFilenameExtensions.1.1.INSTANCE);
        }
        finally {
            readLock.unlock();
        }
        return sequence;
    }

    @Override
    @NotNull
    public KotlinScriptDefinition getDefaultScriptDefinition() {
        return this.getDefaultDefinition().getLegacyDefinition();
    }

    static {
        Companion = new Companion(null);
        nonScriptFilenameSuffixes = new String[]{".kt", ".java"};
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider$Companion;", "", "()V", "nonScriptFilenameSuffixes", "", "", "getNonScriptFilenameSuffixes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "kotlin-scripting-compiler-impl"})
    public static final class Companion {
        @NotNull
        protected final String[] getNonScriptFilenameSuffixes() {
            return nonScriptFilenameSuffixes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

