/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.bzip2;

import io.airlift.compress.bzip2.Crc32;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class CBZip2InputStream
extends InputStream {
    private static final long BLOCK_DELIMITER = 54156738319193L;
    private static final int MAX_CODE_LEN = 23;
    public static final int END_OF_BLOCK = -2;
    private static final int END_OF_STREAM = -1;
    private static final int DELIMITER_BIT_LENGTH = 48;
    private long reportedBytesReadFromCompressedStream;
    private long bytesReadFromCompressedStream;
    private boolean initialized;
    private final byte[] array = new byte[1];
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private long bsBuff;
    private long bsLive;
    private final Crc32 crc32 = new Crc32();
    private int nInUse;
    private BufferedInputStream in;
    private int currentChar = -1;
    private STATE currentState = STATE.START_BLOCK_STATE;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedCombinedCRC;
    private boolean skipResult;
    private int suCount;
    private int suCh2;
    private int suChPrev;
    private int suI2;
    private int suJ2;
    private int suRNToGo;
    private int suRTPos;
    private int suTPos;
    private char suZ;
    private Data data;
    private static final int[] R_NUMS = new int[]{619, 720, 127, 481, 931, 816, 813, 233, 566, 247, 985, 724, 205, 454, 863, 491, 741, 242, 949, 214, 733, 859, 335, 708, 621, 574, 73, 654, 730, 472, 419, 436, 278, 496, 867, 210, 399, 680, 480, 51, 878, 465, 811, 169, 869, 675, 611, 697, 867, 561, 862, 687, 507, 283, 482, 129, 807, 591, 733, 623, 150, 238, 59, 379, 684, 877, 625, 169, 643, 105, 170, 607, 520, 932, 727, 476, 693, 425, 174, 647, 73, 122, 335, 530, 442, 853, 695, 249, 445, 515, 909, 545, 703, 919, 874, 474, 882, 500, 594, 612, 641, 801, 220, 162, 819, 984, 589, 513, 495, 799, 161, 604, 958, 533, 221, 400, 386, 867, 600, 782, 382, 596, 414, 171, 516, 375, 682, 485, 911, 276, 98, 553, 163, 354, 666, 933, 424, 341, 533, 870, 227, 730, 475, 186, 263, 647, 537, 686, 600, 224, 469, 68, 770, 919, 190, 373, 294, 822, 808, 206, 184, 943, 795, 384, 383, 461, 404, 758, 839, 887, 715, 67, 618, 276, 204, 918, 873, 777, 604, 560, 951, 160, 578, 722, 79, 804, 96, 409, 713, 940, 652, 934, 970, 447, 318, 353, 859, 672, 112, 785, 645, 863, 803, 350, 139, 93, 354, 99, 820, 908, 609, 772, 154, 274, 580, 184, 79, 626, 630, 742, 653, 282, 762, 623, 680, 81, 927, 626, 789, 125, 411, 521, 938, 300, 821, 78, 343, 175, 128, 250, 170, 774, 972, 275, 999, 639, 495, 78, 352, 126, 857, 956, 358, 619, 580, 124, 737, 594, 701, 612, 669, 112, 134, 694, 363, 992, 809, 743, 168, 974, 944, 375, 748, 52, 600, 747, 642, 182, 862, 81, 344, 805, 988, 739, 511, 655, 814, 334, 249, 515, 897, 955, 664, 981, 649, 113, 974, 459, 893, 228, 433, 837, 553, 268, 926, 240, 102, 654, 459, 51, 686, 754, 806, 760, 493, 403, 415, 394, 687, 700, 946, 670, 656, 610, 738, 392, 760, 799, 887, 653, 978, 321, 576, 617, 626, 502, 894, 679, 243, 440, 680, 879, 194, 572, 640, 724, 926, 56, 204, 700, 707, 151, 457, 449, 797, 195, 791, 558, 945, 679, 297, 59, 87, 824, 713, 663, 412, 693, 342, 606, 134, 108, 571, 364, 631, 212, 174, 643, 304, 329, 343, 97, 430, 751, 497, 314, 983, 374, 822, 928, 140, 206, 73, 263, 980, 736, 876, 478, 430, 305, 170, 514, 364, 692, 829, 82, 855, 953, 676, 246, 369, 970, 294, 750, 807, 827, 150, 790, 288, 923, 804, 378, 215, 828, 592, 281, 565, 555, 710, 82, 896, 831, 547, 261, 524, 462, 293, 465, 502, 56, 661, 821, 976, 991, 658, 869, 905, 758, 745, 193, 768, 550, 608, 933, 378, 286, 215, 979, 792, 961, 61, 688, 793, 644, 986, 403, 106, 366, 905, 644, 372, 567, 466, 434, 645, 210, 389, 550, 919, 135, 780, 773, 635, 389, 707, 100, 626, 958, 165, 504, 920, 176, 193, 713, 857, 265, 203, 50, 668, 108, 645, 990, 626, 197, 510, 357, 358, 850, 858, 364, 936, 638};

    public CBZip2InputStream(InputStream in) {
        int blockSize = 57;
        this.blockSize100k = blockSize - 48;
        this.in = new BufferedInputStream(in, 9216);
    }

    public long getProcessedByteCount() {
        return this.reportedBytesReadFromCompressedStream;
    }

    private void updateProcessedByteCount(int count) {
        this.bytesReadFromCompressedStream += (long)count;
    }

    private int readAByte(InputStream inStream) throws IOException {
        int read = inStream.read();
        if (read >= 0) {
            this.updateProcessedByteCount(1);
        }
        return read;
    }

    private boolean skipToNextMarker(long marker, int markerBitLength) throws IllegalArgumentException {
        try {
            if (markerBitLength > 63) {
                throw new IllegalArgumentException("skipToNextMarker can not find patterns greater than 63 bits");
            }
            long bytes = this.bsR(markerBitLength);
            if (bytes == -1L) {
                this.reportedBytesReadFromCompressedStream = this.bytesReadFromCompressedStream;
                return false;
            }
            while (true) {
                if (bytes == marker) {
                    long markerBytesRead = ((long)markerBitLength + this.bsLive + 7L) / 8L;
                    this.reportedBytesReadFromCompressedStream = this.bytesReadFromCompressedStream - markerBytesRead;
                    return true;
                }
                bytes <<= 1;
                bytes &= (1L << markerBitLength) - 1L;
                int oneBit = (int)this.bsR(1L);
                if (oneBit == -1) break;
                bytes |= (long)oneBit;
            }
            this.reportedBytesReadFromCompressedStream = this.bytesReadFromCompressedStream;
            return false;
        }
        catch (IOException ex) {
            this.reportedBytesReadFromCompressedStream = this.bytesReadFromCompressedStream;
            return false;
        }
    }

    private void makeMaps() {
        boolean[] inUse = this.data.inUse;
        byte[] seqToUnseq = this.data.seqToUnseq;
        int nInUseShadow = 0;
        for (int i = 0; i < 256; ++i) {
            if (!inUse[i]) continue;
            seqToUnseq[nInUseShadow++] = (byte)i;
        }
        this.nInUse = nInUseShadow;
    }

    private void changeStateToProcessABlock() throws IOException {
        if (this.skipResult) {
            this.initBlock();
            this.setupBlock();
        } else {
            this.currentState = STATE.EOF;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.in != null) {
            int result2 = this.read(this.array, 0, 1);
            int value = 0xFF & this.array[0];
            return result2 > 0 ? value : result2;
        }
        throw new IOException("stream closed");
    }

    @Override
    public int read(byte[] dest, int offs, int len) throws IOException {
        if (offs < 0) {
            throw new IndexOutOfBoundsException("offs(" + offs + ") < 0.");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len(" + len + ") < 0.");
        }
        if (offs + len > dest.length) {
            throw new IndexOutOfBoundsException("offs(" + offs + ") + len(" + len + ") > dest.length(" + dest.length + ").");
        }
        if (this.in == null) {
            throw new IOException("stream closed");
        }
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        int hi = offs + len;
        int destOffs = offs;
        int b = 0;
        while (destOffs < hi && (b = this.read0()) >= 0) {
            dest[destOffs++] = (byte)b;
        }
        int result2 = destOffs - offs;
        if (result2 == 0) {
            result2 = b;
            this.skipResult = this.skipToNextMarker(54156738319193L, 48);
            this.changeStateToProcessABlock();
        }
        return result2;
    }

    private int read0() throws IOException {
        int retChar = this.currentChar;
        switch (this.currentState.ordinal()) {
            case 0: {
                return -1;
            }
            case 8: {
                return -2;
            }
            case 1: {
                throw new IllegalStateException();
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                throw new IllegalStateException();
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return retChar;
    }

    private void init() throws IOException {
        int magic2 = this.readAByte(this.in);
        if (magic2 != 104) {
            throw new IOException("Stream is not BZip2 formatted: expected 'h' as first byte but got '" + (char)magic2 + "'");
        }
        int blockSize = this.readAByte(this.in);
        if (blockSize < 49 || blockSize > 57) {
            throw new IOException("Stream is not BZip2 formatted: illegal blocksize " + (char)blockSize);
        }
        this.blockSize100k = blockSize - 48;
        this.initBlock();
        this.setupBlock();
    }

    private void initBlock() throws IOException {
        char magic0 = this.bsGetUByte();
        char magic1 = this.bsGetUByte();
        char magic2 = this.bsGetUByte();
        char magic3 = this.bsGetUByte();
        char magic4 = this.bsGetUByte();
        char magic5 = this.bsGetUByte();
        if (magic0 == '\u0017' && magic1 == 'r' && magic2 == 'E' && magic3 == '8' && magic4 == 'P' && magic5 == '\u0090') {
            this.complete();
        } else {
            if (magic0 != '1' || magic1 != 'A' || magic2 != 'Y' || magic3 != '&' || magic4 != 'S' || magic5 != 'Y') {
                this.currentState = STATE.EOF;
                throw new IOException("bad block header");
            }
            this.storedBlockCRC = this.bsGetInt();
            boolean bl = this.blockRandomised = this.bsR(1L) == 1L;
            if (this.data == null) {
                this.data = new Data(this.blockSize100k);
            }
            this.getAndMoveToFrontDecode();
            this.crc32.initialiseCRC();
            this.currentState = STATE.START_BLOCK_STATE;
        }
    }

    private void endBlock() throws IOException {
        int computedBlockCRC = this.crc32.getFinalCRC();
        if (this.storedBlockCRC != computedBlockCRC) {
            this.computedCombinedCRC = this.storedCombinedCRC << 1 | this.storedCombinedCRC >>> 31;
            this.computedCombinedCRC ^= this.storedBlockCRC;
            throw new IOException("crc error");
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= computedBlockCRC;
    }

    private void complete() throws IOException {
        this.storedCombinedCRC = this.bsGetInt();
        this.currentState = STATE.EOF;
        this.data = null;
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            throw new IOException("crc error");
        }
    }

    @Override
    public void close() throws IOException {
        BufferedInputStream inShadow = this.in;
        if (inShadow != null) {
            try {
                if (inShadow != System.in) {
                    ((InputStream)inShadow).close();
                }
            }
            finally {
                this.data = null;
                this.in = null;
            }
        }
    }

    private long bsR(long n) throws IOException {
        long bsLiveShadow = this.bsLive;
        long bsBuffShadow = this.bsBuff;
        if (bsLiveShadow < n) {
            BufferedInputStream inShadow = this.in;
            do {
                int thech;
                if ((thech = this.readAByte(inShadow)) < 0) {
                    throw new IOException("unexpected end of stream");
                }
                bsBuffShadow = bsBuffShadow << 8 | (long)thech;
            } while ((bsLiveShadow += 8L) < n);
            this.bsBuff = bsBuffShadow;
        }
        this.bsLive = bsLiveShadow - n;
        return bsBuffShadow >> (int)(bsLiveShadow - n) & (1L << (int)n) - 1L;
    }

    private boolean bsGetBit() throws IOException {
        long bsLiveShadow = this.bsLive;
        long bsBuffShadow = this.bsBuff;
        if (bsLiveShadow < 1L) {
            int thech = this.readAByte(this.in);
            if (thech < 0) {
                throw new IOException("unexpected end of stream");
            }
            bsBuffShadow = bsBuffShadow << 8 | (long)thech;
            bsLiveShadow += 8L;
            this.bsBuff = bsBuffShadow;
        }
        this.bsLive = bsLiveShadow - 1L;
        return (bsBuffShadow >> (int)(bsLiveShadow - 1L) & 1L) != 0L;
    }

    private char bsGetUByte() throws IOException {
        return (char)this.bsR(8L);
    }

    private int bsGetInt() throws IOException {
        return (int)(((this.bsR(8L) << 8 | this.bsR(8L)) << 8 | this.bsR(8L)) << 8 | this.bsR(8L));
    }

    private static void hbCreateDecodeTables(int[] limit, int[] base2, int[] perm, char[] length, int minLen, int maxLen, int alphaSize) {
        int i;
        int pp = 0;
        for (i = minLen; i <= maxLen; ++i) {
            for (int j = 0; j < alphaSize; ++j) {
                if (length[j] != i) continue;
                perm[pp++] = j;
            }
        }
        i = 23;
        while (--i > 0) {
            base2[i] = 0;
            limit[i] = 0;
        }
        for (i = 0; i < alphaSize; ++i) {
            int n = length[i] + '\u0001';
            base2[n] = base2[n] + 1;
        }
        int b = base2[0];
        for (i = 1; i < 23; ++i) {
            base2[i] = b += base2[i];
        }
        int vec = 0;
        int b2 = base2[i];
        for (i = minLen; i <= maxLen; ++i) {
            int nb = base2[i + 1];
            b2 = nb;
            limit[i] = (vec += nb - b2) - 1;
            vec <<= 1;
        }
        for (i = minLen + 1; i <= maxLen; ++i) {
            base2[i] = (limit[i - 1] + 1 << 1) - base2[i];
        }
    }

    private void recvDecodingTables() throws IOException {
        int i;
        int i2;
        Data dataShadow = this.data;
        boolean[] inUse = dataShadow.inUse;
        byte[] pos = dataShadow.recvDecodingTablesPos;
        byte[] selector = dataShadow.selector;
        byte[] selectorMtf = dataShadow.selectorMtf;
        int inUse16 = 0;
        for (i2 = 0; i2 < 16; ++i2) {
            if (!this.bsGetBit()) continue;
            inUse16 |= 1 << i2;
        }
        i2 = 256;
        while (--i2 >= 0) {
            inUse[i2] = false;
        }
        for (i2 = 0; i2 < 16; ++i2) {
            if ((inUse16 & 1 << i2) == 0) continue;
            int i16 = i2 << 4;
            for (int j = 0; j < 16; ++j) {
                if (!this.bsGetBit()) continue;
                inUse[i16 + j] = true;
            }
        }
        this.makeMaps();
        int alphaSize = this.nInUse + 2;
        int nGroups = (int)this.bsR(3L);
        int nSelectors = (int)this.bsR(15L);
        for (i = 0; i < nSelectors; ++i) {
            int j = 0;
            while (this.bsGetBit()) {
                ++j;
            }
            selectorMtf[i] = (byte)j;
        }
        int v = nGroups;
        while (--v >= 0) {
            pos[v] = (byte)v;
        }
        for (i = 0; i < nSelectors; ++i) {
            int v2;
            byte tmp = pos[v2];
            for (v2 = selectorMtf[i] & 0xFF; v2 > 0; --v2) {
                pos[v2] = pos[v2 - 1];
            }
            pos[0] = tmp;
            selector[i] = tmp;
        }
        char[][] len = dataShadow.tempCharArray2D;
        for (int t = 0; t < nGroups; ++t) {
            int curr = (int)this.bsR(5L);
            char[] lenT = len[t];
            for (int i3 = 0; i3 < alphaSize; ++i3) {
                while (this.bsGetBit()) {
                    curr += this.bsGetBit() ? -1 : 1;
                }
                lenT[i3] = (char)curr;
            }
        }
        this.createHuffmanDecodingTables(alphaSize, nGroups);
    }

    private void createHuffmanDecodingTables(int alphaSize, int nGroups) {
        Data dataShadow = this.data;
        char[][] len = dataShadow.tempCharArray2D;
        int[] minLens = dataShadow.minLens;
        int[][] limit = dataShadow.limit;
        int[][] base2 = dataShadow.base;
        int[][] perm = dataShadow.perm;
        for (int t = 0; t < nGroups; ++t) {
            int minLen = 32;
            int maxLen = 0;
            char[] lenT = len[t];
            int i = alphaSize;
            while (--i >= 0) {
                int lent = lenT[i];
                if (lent > maxLen) {
                    maxLen = lent;
                }
                if (lent >= minLen) continue;
                minLen = lent;
            }
            CBZip2InputStream.hbCreateDecodeTables(limit[t], base2[t], perm[t], len[t], minLen, maxLen, alphaSize);
            minLens[t] = minLen;
        }
    }

    private void getAndMoveToFrontDecode() throws IOException {
        this.origPtr = (int)this.bsR(24L);
        this.recvDecodingTables();
        BufferedInputStream inShadow = this.in;
        Data dataShadow = this.data;
        byte[] ll8 = dataShadow.ll8;
        int[] unzftab = dataShadow.unzftab;
        byte[] selector = dataShadow.selector;
        byte[] seqToUnseq = dataShadow.seqToUnseq;
        char[] yy = dataShadow.getAndMoveToFrontDecodeYy;
        int[] minLens = dataShadow.minLens;
        int[][] limit = dataShadow.limit;
        int[][] base2 = dataShadow.base;
        int[][] perm = dataShadow.perm;
        int limitLast = this.blockSize100k * 100000;
        int i = 256;
        while (--i >= 0) {
            yy[i] = (char)i;
            unzftab[i] = 0;
        }
        int groupNo = 0;
        int groupPos = 49;
        int eob = this.nInUse + 1;
        int nextSym = this.getAndMoveToFrontDecode0(0);
        int bsBuffShadow = (int)this.bsBuff;
        int bsLiveShadow = (int)this.bsLive;
        int lastShadow = -1;
        int zt = selector[groupNo] & 0xFF;
        int[] baseZt = base2[zt];
        int[] limitZt = limit[zt];
        int[] permZt = perm[zt];
        int minLensZt = minLens[zt];
        while (nextSym != eob) {
            if (nextSym == 0 || nextSym == 1) {
                int s = -1;
                int n = 1;
                while (true) {
                    if (nextSym == 0) {
                        s += n;
                    } else {
                        if (nextSym != 1) break;
                        s += n << 1;
                    }
                    if (groupPos == 0) {
                        groupPos = 49;
                        zt = selector[++groupNo] & 0xFF;
                        baseZt = base2[zt];
                        limitZt = limit[zt];
                        permZt = perm[zt];
                        minLensZt = minLens[zt];
                    } else {
                        --groupPos;
                    }
                    int zn = minLensZt;
                    while (bsLiveShadow < zn) {
                        int thech = this.readAByte(inShadow);
                        if (thech >= 0) {
                            bsBuffShadow = bsBuffShadow << 8 | thech;
                            bsLiveShadow += 8;
                            continue;
                        }
                        throw new IOException("unexpected end of stream");
                    }
                    long zvec = (long)(bsBuffShadow >> bsLiveShadow - zn) & (1L << zn) - 1L;
                    bsLiveShadow -= zn;
                    while (zvec > (long)limitZt[zn]) {
                        ++zn;
                        while (bsLiveShadow < 1) {
                            int thech = this.readAByte(inShadow);
                            if (thech >= 0) {
                                bsBuffShadow = bsBuffShadow << 8 | thech;
                                bsLiveShadow += 8;
                                continue;
                            }
                            throw new IOException("unexpected end of stream");
                        }
                        zvec = zvec << 1 | (long)(bsBuffShadow >> --bsLiveShadow & 1);
                    }
                    nextSym = permZt[(int)(zvec - (long)baseZt[zn])];
                    n <<= 1;
                }
                byte ch = seqToUnseq[yy[0]];
                int n2 = ch & 0xFF;
                unzftab[n2] = unzftab[n2] + (s + 1);
                while (s-- >= 0) {
                    ll8[++lastShadow] = ch;
                }
                if (lastShadow < limitLast) continue;
                throw new IOException("block overrun");
            }
            if (++lastShadow >= limitLast) {
                throw new IOException("block overrun");
            }
            char tmp = yy[nextSym - 1];
            int n = seqToUnseq[tmp] & 0xFF;
            unzftab[n] = unzftab[n] + 1;
            ll8[lastShadow] = seqToUnseq[tmp];
            if (nextSym <= 16) {
                int j = nextSym - 1;
                while (j > 0) {
                    yy[j--] = yy[j];
                }
            } else {
                System.arraycopy(yy, 0, yy, 1, nextSym - 1);
            }
            yy[0] = tmp;
            if (groupPos == 0) {
                groupPos = 49;
                zt = selector[++groupNo] & 0xFF;
                baseZt = base2[zt];
                limitZt = limit[zt];
                permZt = perm[zt];
                minLensZt = minLens[zt];
            } else {
                --groupPos;
            }
            int zn = minLensZt;
            while (bsLiveShadow < zn) {
                int thech = this.readAByte(inShadow);
                if (thech >= 0) {
                    bsBuffShadow = bsBuffShadow << 8 | thech;
                    bsLiveShadow += 8;
                    continue;
                }
                throw new IOException("unexpected end of stream");
            }
            int zvec = bsBuffShadow >> bsLiveShadow - zn & (1 << zn) - 1;
            bsLiveShadow -= zn;
            while (zvec > limitZt[zn]) {
                ++zn;
                while (bsLiveShadow < 1) {
                    int thech = this.readAByte(inShadow);
                    if (thech >= 0) {
                        bsBuffShadow = bsBuffShadow << 8 | thech;
                        bsLiveShadow += 8;
                        continue;
                    }
                    throw new IOException("unexpected end of stream");
                }
                zvec = zvec << 1 | bsBuffShadow >> --bsLiveShadow & 1;
            }
            nextSym = permZt[zvec - baseZt[zn]];
        }
        this.last = lastShadow;
        this.bsLive = bsLiveShadow;
        this.bsBuff = bsBuffShadow;
    }

    private int getAndMoveToFrontDecode0(int groupNo) throws IOException {
        BufferedInputStream inShadow = this.in;
        Data dataShadow = this.data;
        int zt = dataShadow.selector[groupNo] & 0xFF;
        int[] limitZt = dataShadow.limit[zt];
        int zn = dataShadow.minLens[zt];
        int zvec = (int)this.bsR(zn);
        int bsLiveShadow = (int)this.bsLive;
        int bsBuffShadow = (int)this.bsBuff;
        while (zvec > limitZt[zn]) {
            ++zn;
            while (bsLiveShadow < 1) {
                int thech = this.readAByte(inShadow);
                if (thech >= 0) {
                    bsBuffShadow = bsBuffShadow << 8 | thech;
                    bsLiveShadow += 8;
                    continue;
                }
                throw new IOException("unexpected end of stream");
            }
            zvec = zvec << 1 | bsBuffShadow >> --bsLiveShadow & 1;
        }
        this.bsLive = bsLiveShadow;
        this.bsBuff = bsBuffShadow;
        return dataShadow.perm[zt][zvec - dataShadow.base[zt][zn]];
    }

    private void setupBlock() throws IOException {
        int i;
        if (this.data == null) {
            return;
        }
        int[] cftab = this.data.cftab;
        int[] tt = this.data.initTT(this.last + 1);
        byte[] ll8 = this.data.ll8;
        cftab[0] = 0;
        System.arraycopy(this.data.unzftab, 0, cftab, 1, 256);
        int c = cftab[0];
        for (i = 1; i <= 256; ++i) {
            cftab[i] = c += cftab[i];
        }
        i = 0;
        int lastShadow = this.last;
        while (i <= lastShadow) {
            int n = ll8[i] & 0xFF;
            int n2 = cftab[n];
            cftab[n] = n2 + 1;
            tt[n2] = i++;
        }
        if (this.origPtr < 0 || this.origPtr >= tt.length) {
            throw new IOException("stream corrupted");
        }
        this.suTPos = tt[this.origPtr];
        this.suCount = 0;
        this.suI2 = 0;
        this.suCh2 = 256;
        if (this.blockRandomised) {
            this.suRNToGo = 0;
            this.suRTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() throws IOException {
        if (this.suI2 <= this.last) {
            this.suChPrev = this.suCh2;
            int suCh2Shadow = this.data.ll8[this.suTPos] & 0xFF;
            this.suTPos = this.data.tt[this.suTPos];
            if (this.suRNToGo == 0) {
                this.suRNToGo = R_NUMS[this.suRTPos] - 1;
                if (++this.suRTPos == 512) {
                    this.suRTPos = 0;
                }
            } else {
                --this.suRNToGo;
            }
            this.suCh2 = suCh2Shadow ^= this.suRNToGo == 1 ? 1 : 0;
            ++this.suI2;
            this.currentChar = suCh2Shadow;
            this.currentState = STATE.RAND_PART_B_STATE;
            this.crc32.updateCRC(suCh2Shadow);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartA() throws IOException {
        if (this.suI2 <= this.last) {
            int suCh2Shadow;
            this.suChPrev = this.suCh2;
            this.suCh2 = suCh2Shadow = this.data.ll8[this.suTPos] & 0xFF;
            this.suTPos = this.data.tt[this.suTPos];
            ++this.suI2;
            this.currentChar = suCh2Shadow;
            this.currentState = STATE.NO_RAND_PART_B_STATE;
            this.crc32.updateCRC(suCh2Shadow);
        } else {
            this.currentState = STATE.NO_RAND_PART_A_STATE;
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() throws IOException {
        if (this.suCh2 != this.suChPrev) {
            this.currentState = STATE.RAND_PART_A_STATE;
            this.suCount = 1;
            this.setupRandPartA();
        } else if (++this.suCount >= 4) {
            this.suZ = (char)(this.data.ll8[this.suTPos] & 0xFF);
            this.suTPos = this.data.tt[this.suTPos];
            if (this.suRNToGo == 0) {
                this.suRNToGo = R_NUMS[this.suRTPos] - 1;
                if (++this.suRTPos == 512) {
                    this.suRTPos = 0;
                }
            } else {
                --this.suRNToGo;
            }
            this.suJ2 = 0;
            this.currentState = STATE.RAND_PART_C_STATE;
            if (this.suRNToGo == 1) {
                this.suZ = (char)(this.suZ ^ '\u0001');
            }
            this.setupRandPartC();
        } else {
            this.currentState = STATE.RAND_PART_A_STATE;
            this.setupRandPartA();
        }
    }

    private void setupRandPartC() throws IOException {
        if (this.suJ2 < this.suZ) {
            this.currentChar = this.suCh2;
            this.crc32.updateCRC(this.suCh2);
            ++this.suJ2;
        } else {
            this.currentState = STATE.RAND_PART_A_STATE;
            ++this.suI2;
            this.suCount = 0;
            this.setupRandPartA();
        }
    }

    private void setupNoRandPartB() throws IOException {
        if (this.suCh2 != this.suChPrev) {
            this.suCount = 1;
            this.setupNoRandPartA();
        } else if (++this.suCount >= 4) {
            this.suZ = (char)(this.data.ll8[this.suTPos] & 0xFF);
            this.suTPos = this.data.tt[this.suTPos];
            this.suJ2 = 0;
            this.setupNoRandPartC();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupNoRandPartC() throws IOException {
        if (this.suJ2 < this.suZ) {
            int suCh2Shadow;
            this.currentChar = suCh2Shadow = this.suCh2;
            this.crc32.updateCRC(suCh2Shadow);
            ++this.suJ2;
            this.currentState = STATE.NO_RAND_PART_C_STATE;
        } else {
            ++this.suI2;
            this.suCount = 0;
            this.setupNoRandPartA();
        }
    }

    public static enum STATE {
        EOF,
        START_BLOCK_STATE,
        RAND_PART_A_STATE,
        RAND_PART_B_STATE,
        RAND_PART_C_STATE,
        NO_RAND_PART_A_STATE,
        NO_RAND_PART_B_STATE,
        NO_RAND_PART_C_STATE,
        NO_PROCESS_STATE;

    }

    private static final class Data {
        final boolean[] inUse = new boolean[256];
        final byte[] seqToUnseq = new byte[256];
        final byte[] selector = new byte[18002];
        final byte[] selectorMtf = new byte[18002];
        final int[] unzftab = new int[256];
        final int[][] limit = new int[6][258];
        final int[][] base = new int[6][258];
        final int[][] perm = new int[6][258];
        final int[] minLens = new int[6];
        final int[] cftab = new int[257];
        final char[] getAndMoveToFrontDecodeYy = new char[256];
        final char[][] tempCharArray2D = new char[6][258];
        final byte[] recvDecodingTablesPos = new byte[6];
        int[] tt;
        byte[] ll8;

        Data(int blockSize100k) {
            this.ll8 = new byte[blockSize100k * 100000];
        }

        int[] initTT(int length) {
            int[] ttShadow = this.tt;
            if (ttShadow == null || ttShadow.length < length) {
                this.tt = ttShadow = new int[length];
            }
            return ttShadow;
        }
    }
}

