/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter;

import io.confluent.kafka.formatter.SchemaMessageDeserializer;
import io.confluent.kafka.formatter.SchemaMessageFormatter;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.io.EncoderFactory;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class AvroMessageFormatter
extends SchemaMessageFormatter<Object> {
    private final EncoderFactory encoderFactory = EncoderFactory.get();

    public AvroMessageFormatter() {
    }

    AvroMessageFormatter(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
        super(schemaRegistryClient, keyDeserializer);
    }

    @Override
    protected SchemaMessageDeserializer<Object> createDeserializer(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
        return new AvroMessageDeserializer(schemaRegistryClient, keyDeserializer);
    }

    @Override
    protected void writeTo(byte[] data2, PrintStream output) throws IOException {
        Object object = this.deserializer.deserialize(data2);
        try {
            AvroSchemaUtils.toJson(object, output);
        }
        catch (AvroRuntimeException e) {
            Schema schema = AvroSchemaUtils.getSchema(object);
            throw new SerializationException(String.format("Error serializing Avro data of schema %s to json", schema), e);
        }
    }

    @Override
    protected SchemaProvider getProvider() {
        return new AvroSchemaProvider();
    }

    static class AvroMessageDeserializer
    extends AbstractKafkaAvroDeserializer
    implements SchemaMessageDeserializer<Object> {
        protected final Deserializer keyDeserializer;

        AvroMessageDeserializer(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
            this.schemaRegistry = schemaRegistryClient;
            this.keyDeserializer = keyDeserializer;
        }

        @Override
        public Deserializer getKeyDeserializer() {
            return this.keyDeserializer;
        }

        @Override
        public Object deserializeKey(String topic, byte[] payload) {
            return this.keyDeserializer.deserialize(topic, payload);
        }

        @Override
        public Object deserialize(byte[] payload) throws SerializationException {
            return super.deserialize(payload);
        }
    }
}

