/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class ServerClusterId {
    private static final String KAFKA_CLUSTER = "kafka-cluster";
    private static final String SCHEMA_REGISTRY_CLUSTER = "schema-registry-cluster";
    private final String id = "";
    private final Map<String, Object> scope;

    @JsonCreator
    public ServerClusterId(@JsonProperty(value="scope") Map<String, Object> scope2) {
        this.scope = ImmutableMap.copyOf(Objects.requireNonNull(scope2, "scope"));
    }

    public String getId() {
        return "";
    }

    public Map<String, Object> getScope() {
        return this.scope;
    }

    public static ServerClusterId of(String kafkaClusterId, String schemaRegistryClusterId) {
        return new ServerClusterId((Map<String, Object>)ImmutableMap.of((Object)"path", Collections.emptyList(), (Object)"clusters", (Object)ImmutableMap.of((Object)KAFKA_CLUSTER, (Object)kafkaClusterId, (Object)SCHEMA_REGISTRY_CLUSTER, (Object)schemaRegistryClusterId)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerClusterId)) {
            return false;
        }
        ServerClusterId that = (ServerClusterId)o;
        return this.getId().equals(that.getId()) && this.getScope().equals(that.getScope());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getScope());
    }
}

