/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Arrays;
import java.util.Collection;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.CheckResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Checks {
    @Nullable
    private final Name name;
    @Nullable
    private final Regex regex;
    @Nullable
    private final Collection<Name> nameList;
    @NotNull
    private final Function1<FunctionDescriptor, String> additionalCheck;
    @NotNull
    private final Check[] checks;

    public final boolean isApplicable(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        if (this.name != null && Intrinsics.areEqual(functionDescriptor.getName(), this.name) ^ true) {
            return false;
        }
        if (this.regex != null) {
            String string = functionDescriptor.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "functionDescriptor.name.asString()");
            CharSequence charSequence = string;
            Regex regex2 = this.regex;
            boolean bl = false;
            if (!regex2.matches(charSequence)) {
                return false;
            }
        }
        return this.nameList == null || this.nameList.contains(functionDescriptor.getName());
    }

    @NotNull
    public final CheckResult checkAll(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        for (Check check2 : this.checks) {
            String checkResult = check2.invoke(functionDescriptor);
            if (checkResult == null) continue;
            return new CheckResult.IllegalSignature(checkResult);
        }
        String additionalCheckResult = this.additionalCheck.invoke(functionDescriptor);
        if (additionalCheckResult != null) {
            return new CheckResult.IllegalSignature(additionalCheckResult);
        }
        return CheckResult.SuccessCheck.INSTANCE;
    }

    private Checks(Name name2, Regex regex2, Collection<Name> nameList, Function1<? super FunctionDescriptor, String> additionalCheck, Check ... checks2) {
        this.name = name2;
        this.regex = regex2;
        this.nameList = nameList;
        this.additionalCheck = additionalCheck;
        this.checks = checks2;
    }

    public Checks(@NotNull Name name2, @NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkParameterIsNotNull(name2, "name");
        Intrinsics.checkParameterIsNotNull(checks2, "checks");
        Intrinsics.checkParameterIsNotNull(additionalChecks, "additionalChecks");
        this(name2, null, null, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Name name2, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 2.INSTANCE;
        }
        this(name2, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    public Checks(@NotNull Regex regex2, @NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkParameterIsNotNull(regex2, "regex");
        Intrinsics.checkParameterIsNotNull(checks2, "checks");
        Intrinsics.checkParameterIsNotNull(additionalChecks, "additionalChecks");
        this(null, regex2, null, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Regex regex2, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 3.INSTANCE;
        }
        this(regex2, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    public Checks(@NotNull Collection<Name> nameList, @NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkParameterIsNotNull(nameList, "nameList");
        Intrinsics.checkParameterIsNotNull(checks2, "checks");
        Intrinsics.checkParameterIsNotNull(additionalChecks, "additionalChecks");
        this(null, null, nameList, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Collection collection, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 4.INSTANCE;
        }
        this(collection, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }
}

