/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieIndexCommitMetadata;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.callback.HoodieWriteCommitCallback;
import org.apache.hudi.callback.common.HoodieWriteCommitCallbackMessage;
import org.apache.hudi.callback.util.HoodieCommitCallbackFactory;
import org.apache.hudi.client.BaseHoodieClient;
import org.apache.hudi.client.BaseHoodieTableServiceClient;
import org.apache.hudi.client.RunsTableService;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.heartbeat.HeartbeatUtils;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieRestoreException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.action.InternalSchemaChangeApplier;
import org.apache.hudi.internal.schema.action.TableChange;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.io.FileBasedInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.restore.RestoreUtils;
import org.apache.hudi.table.action.savepoint.SavepointHelpers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.util.CommonClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieWriteClient<T, I, K, O>
extends BaseHoodieClient
implements RunsTableService {
    protected static final String LOOKUP_STR = "lookup";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieWriteClient.class);
    private final transient HoodieIndex<?, ?> index;
    private final SupportsUpgradeDowngrade upgradeDowngradeHelper;
    private transient WriteOperationType operationType;
    private transient HoodieWriteCommitCallback commitCallback;
    protected transient Timer.Context writeTimer = null;
    protected Option<Pair<HoodieInstant, Map<String, String>>> lastCompletedTxnAndMetadata = Option.empty();
    protected Set<String> pendingInflightAndRequestedInstants = Collections.emptySet();
    protected BaseHoodieTableServiceClient<?, ?, O> tableServiceClient;

    @Deprecated
    public BaseHoodieWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        this(context, writeConfig, Option.empty(), upgradeDowngradeHelper);
    }

    @Deprecated
    public BaseHoodieWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, Option<EmbeddedTimelineService> timelineService, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        super(context, writeConfig, timelineService);
        this.index = this.createIndex(writeConfig);
        this.upgradeDowngradeHelper = upgradeDowngradeHelper;
        this.metrics.emitIndexTypeMetrics(this.config.getIndexType().ordinal());
    }

    protected abstract HoodieIndex<?, ?> createIndex(HoodieWriteConfig var1);

    public void setOperationType(WriteOperationType operationType) {
        this.operationType = operationType;
    }

    public WriteOperationType getOperationType() {
        return this.operationType;
    }

    public BaseHoodieTableServiceClient<?, ?, O> getTableServiceClient() {
        return this.tableServiceClient;
    }

    public boolean commit(String instantTime, O writeStatuses) {
        return this.commit(instantTime, writeStatuses, Option.empty());
    }

    public boolean commit(String instantTime, O writeStatuses, Option<Map<String, String>> extraMetadata) {
        HoodieTableMetaClient metaClient = this.createMetaClient(false);
        String actionType = metaClient.getCommitActionType();
        return this.commit(instantTime, writeStatuses, extraMetadata, actionType, Collections.emptyMap());
    }

    public boolean commit(String instantTime, O writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds) {
        return this.commit(instantTime, writeStatuses, extraMetadata, commitActionType, partitionToReplacedFileIds, Option.empty());
    }

    public abstract boolean commit(String var1, O var2, Option<Map<String, String>> var3, String var4, Map<String, List<String>> var5, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> var6);

    public boolean commitStats(String instantTime, List<HoodieWriteStat> stats, Option<Map<String, String>> extraMetadata, String commitActionType) {
        return this.commitStats(instantTime, stats, extraMetadata, commitActionType, Collections.emptyMap(), Option.empty());
    }

    public boolean commitStats(String instantTime, List<HoodieWriteStat> stats, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplaceFileIds, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFunc) {
        if (!this.config.allowEmptyCommit() && stats.isEmpty()) {
            return true;
        }
        LOG.info("Committing " + instantTime + " action " + commitActionType);
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        HoodieCommitMetadata metadata2 = CommitUtils.buildMetadata(stats, partitionToReplaceFileIds, extraMetadata, this.operationType, this.config.getWriteSchema(), commitActionType);
        HoodieInstant inflightInstant = table.getMetaClient().createNewInstant(HoodieInstant.State.INFLIGHT, commitActionType, instantTime);
        HeartbeatUtils.abortIfHeartbeatExpired(instantTime, table, this.heartbeatClient, this.config);
        this.txnManager.beginTransaction(Option.of(inflightInstant), this.lastCompletedTxnAndMetadata.isPresent() ? Option.of(this.lastCompletedTxnAndMetadata.get().getLeft()) : Option.empty());
        try {
            this.preCommit(metadata2);
            if (extraPreCommitFunc.isPresent()) {
                extraPreCommitFunc.get().accept(table.getMetaClient(), metadata2);
            }
            this.commit(table, commitActionType, instantTime, metadata2, stats);
            this.postCommit(table, metadata2, instantTime, extraMetadata);
            LOG.info("Committed " + instantTime);
        }
        catch (IOException e) {
            throw new HoodieCommitException("Failed to complete commit " + this.config.getBasePath() + " at time " + instantTime, e);
        }
        finally {
            this.txnManager.endTransaction(Option.of(inflightInstant));
            this.releaseResources(instantTime);
        }
        this.mayBeCleanAndArchive(table);
        try {
            this.runTableServicesInline(table, metadata2, extraMetadata);
        }
        catch (Exception e) {
            if (this.config.isFailOnInlineTableServiceExceptionEnabled()) {
                throw e;
            }
            LOG.warn("Inline compaction or clustering failed with exception: " + e.getMessage() + ". Moving further since \"hoodie.fail.writes.on.inline.table.service.exception\" is set to false.");
        }
        this.emitCommitMetrics(instantTime, metadata2, commitActionType);
        if (this.config.writeCommitCallbackOn()) {
            if (null == this.commitCallback) {
                this.commitCallback = HoodieCommitCallbackFactory.create(this.config);
            }
            this.commitCallback.call(new HoodieWriteCommitCallbackMessage(instantTime, this.config.getTableName(), this.config.getBasePath(), stats, Option.of(commitActionType), extraMetadata));
        }
        return true;
    }

    protected void commit(HoodieTable table, String commitActionType, String instantTime, HoodieCommitMetadata metadata2, List<HoodieWriteStat> stats) throws IOException {
        LOG.info("Committing " + instantTime + " action " + commitActionType);
        HoodieActiveTimeline activeTimeline = table.getActiveTimeline();
        this.finalizeWrite(table, instantTime, stats);
        if (!metadata2.getExtraMetadata().containsKey("latest_schema") && metadata2.getExtraMetadata().containsKey("schema") && table.getConfig().getSchemaEvolutionEnable()) {
            this.saveInternalSchema(table, instantTime, metadata2);
        }
        this.writeTableMetadata(table, instantTime, metadata2);
        activeTimeline.saveAsComplete(false, table.getMetaClient().createNewInstant(HoodieInstant.State.INFLIGHT, commitActionType, instantTime), TimelineMetadataUtils.serializeCommitMetadata(table.getMetaClient().getCommitMetadataSerDe(), metadata2));
    }

    private void saveInternalSchema(HoodieTable table, String instantTime, HoodieCommitMetadata metadata2) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(table.getMetaClient());
        String historySchemaStr = schemaUtil.getTableHistorySchemaStrFromCommitMetadata().orElse("");
        FileBasedInternalSchemaStorageManager schemasManager = new FileBasedInternalSchemaStorageManager(table.getMetaClient());
        if (!historySchemaStr.isEmpty() || Boolean.parseBoolean(this.config.getString(HoodieCommonConfig.RECONCILE_SCHEMA.key()))) {
            InternalSchema internalSchema;
            Schema avroSchema = HoodieAvroUtils.createHoodieWriteSchema(this.config.getSchema(), this.config.allowOperationMetadataField());
            if (historySchemaStr.isEmpty()) {
                internalSchema = SerDeHelper.fromJson(this.config.getInternalSchema()).orElseGet(() -> AvroInternalSchemaConverter.convert(avroSchema));
                internalSchema.setSchemaId(Long.parseLong(instantTime));
            } else {
                internalSchema = InternalSchemaUtils.searchSchema(Long.parseLong(instantTime), SerDeHelper.parseSchemas(historySchemaStr));
            }
            InternalSchema evolvedSchema = AvroSchemaEvolutionUtils.reconcileSchema(avroSchema, internalSchema, this.config.getBooleanOrDefault(HoodieCommonConfig.SET_NULL_FOR_MISSING_COLUMNS));
            if (evolvedSchema.equals(internalSchema)) {
                metadata2.addMetadata("latest_schema", SerDeHelper.toJson(evolvedSchema));
                schemasManager.persistHistorySchemaStr(instantTime, historySchemaStr.isEmpty() ? SerDeHelper.inheritSchemas(evolvedSchema, "") : historySchemaStr);
            } else {
                evolvedSchema.setSchemaId(Long.parseLong(instantTime));
                String newSchemaStr = SerDeHelper.toJson(evolvedSchema);
                metadata2.addMetadata("latest_schema", newSchemaStr);
                schemasManager.persistHistorySchemaStr(instantTime, SerDeHelper.inheritSchemas(evolvedSchema, historySchemaStr));
            }
            metadata2.addMetadata("schema", AvroInternalSchemaConverter.convert(evolvedSchema, avroSchema.getFullName()).toString());
        }
    }

    protected HoodieTable createTableAndValidate(HoodieWriteConfig writeConfig, BiFunction<HoodieWriteConfig, HoodieEngineContext, HoodieTable> createTableFn) {
        HoodieTable table = createTableFn.apply(writeConfig, this.context);
        CommonClientUtils.validateTableVersion(table.getMetaClient().getTableConfig(), writeConfig);
        return table;
    }

    protected HoodieTable createTableAndValidate(HoodieWriteConfig writeConfig, HoodieTableMetaClient metaClient, TriFunction<HoodieWriteConfig, HoodieEngineContext, HoodieTableMetaClient, HoodieTable> createTableFn) {
        HoodieTable table = createTableFn.apply(writeConfig, this.context, metaClient);
        CommonClientUtils.validateTableVersion(table.getMetaClient().getTableConfig(), writeConfig);
        return table;
    }

    protected abstract HoodieTable<T, I, K, O> createTable(HoodieWriteConfig var1);

    protected abstract HoodieTable<T, I, K, O> createTable(HoodieWriteConfig var1, HoodieTableMetaClient var2);

    void emitCommitMetrics(String instantTime, HoodieCommitMetadata metadata2, String actionType) {
        if (this.writeTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.writeTimer.stop());
            TimelineUtils.parseDateFromInstantTimeSafely(instantTime).ifPresent(parsedInstant -> this.metrics.updateCommitMetrics(parsedInstant.getTime(), durationInMs, metadata2, actionType));
            this.writeTimer = null;
        }
    }

    protected void preCommit(HoodieCommitMetadata metadata2) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        this.resolveWriteConflict(table, metadata2, this.pendingInflightAndRequestedInstants);
    }

    public abstract I filterExists(I var1);

    public void bootstrap(Option<Map<String, String>> extraMetadata) {
        if (this.config.getWriteConcurrencyMode().supportsMultiWriter()) {
            throw new HoodieException("Cannot bootstrap the table in multi-writer mode");
        }
        HoodieTable table = this.initTable(WriteOperationType.UPSERT, Option.ofNullable("00000000000001"));
        this.tableServiceClient.rollbackFailedBootstrap();
        table.bootstrap(this.context, extraMetadata);
    }

    public abstract O upsert(I var1, String var2);

    public abstract O upsertPreppedRecords(I var1, String var2);

    public abstract O insert(I var1, String var2);

    public abstract O insertPreppedRecords(I var1, String var2);

    public abstract O bulkInsert(I var1, String var2);

    public abstract O bulkInsert(I var1, String var2, Option<BulkInsertPartitioner> var3);

    public abstract O bulkInsertPreppedRecords(I var1, String var2, Option<BulkInsertPartitioner> var3);

    public abstract O delete(K var1, String var2);

    public abstract O deletePrepped(I var1, String var2);

    public void preWrite(String instantTime, WriteOperationType writeOperationType, HoodieTableMetaClient metaClient) {
        this.setOperationType(writeOperationType);
        this.lastCompletedTxnAndMetadata = this.txnManager.isLockRequired() ? TransactionUtils.getLastCompletedTxnInstantAndMetadata(metaClient) : Option.empty();
        this.pendingInflightAndRequestedInstants = TransactionUtils.getInflightAndRequestedInstants(metaClient);
        this.pendingInflightAndRequestedInstants.remove(instantTime);
        this.tableServiceClient.setPendingInflightAndRequestedInstants(this.pendingInflightAndRequestedInstants);
        this.tableServiceClient.startAsyncCleanerService(this);
        this.tableServiceClient.startAsyncArchiveService(this);
    }

    public O postWrite(HoodieWriteMetadata<O> result2, String instantTime, HoodieTable hoodieTable) {
        if (result2.isCommitted()) {
            if (result2.getFinalizeDuration().isPresent()) {
                this.metrics.updateFinalizeWriteMetrics(result2.getFinalizeDuration().get().toMillis(), result2.getWriteStats().get().size());
            }
            this.postCommit(hoodieTable, result2.getCommitMetadata().get(), instantTime, Option.empty());
            this.mayBeCleanAndArchive(hoodieTable);
            this.emitCommitMetrics(instantTime, result2.getCommitMetadata().get(), hoodieTable.getMetaClient().getCommitActionType());
        }
        return result2.getWriteStatuses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postCommit(HoodieTable table, HoodieCommitMetadata metadata2, String instantTime, Option<Map<String, String>> extraMetadata) {
        try {
            this.context.setJobStatus(this.getClass().getSimpleName(), "Cleaning up marker directories for commit " + instantTime + " in table " + this.config.getTableName());
            WriteMarkersFactory.get(this.config.getMarkersType(), table, instantTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        }
        finally {
            this.heartbeatClient.stop(instantTime);
        }
    }

    protected void mayBeCleanAndArchive(HoodieTable table) {
        this.autoCleanOnCommit();
        this.autoArchiveOnCommit(table);
    }

    protected void runTableServicesInline(HoodieTable table, HoodieCommitMetadata metadata2, Option<Map<String, String>> extraMetadata) {
        this.tableServiceClient.runTableServicesInline(table, metadata2, extraMetadata);
    }

    protected void autoCleanOnCommit() {
        if (!this.config.isAutoClean()) {
            return;
        }
        if (this.config.isAsyncClean()) {
            LOG.info("Async cleaner has been spawned. Waiting for it to finish");
            this.tableServiceClient.asyncClean();
            LOG.info("Async cleaner has finished");
        } else {
            LOG.info("Start to clean synchronously.");
            this.clean();
        }
    }

    protected void autoArchiveOnCommit(HoodieTable table) {
        if (!this.config.isAutoArchive()) {
            return;
        }
        if (this.config.isAsyncArchive()) {
            LOG.info("Async archiver has been spawned. Waiting for it to finish");
            this.tableServiceClient.asyncArchive();
            LOG.info("Async archiver has finished");
        } else {
            LOG.info("Start to archive synchronously.");
            this.archive(table);
        }
    }

    public void runAnyPendingCompactions() {
        this.tableServiceClient.runAnyPendingCompactions(this.createTable(this.config));
    }

    public void runAnyPendingLogCompactions() {
        this.tableServiceClient.runAnyPendingLogCompactions(this.createTable(this.config));
    }

    public void savepoint(String user, String comment) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        if (table.getCompletedCommitsTimeline().empty()) {
            throw new HoodieSavepointException("Could not savepoint. Commit timeline is empty");
        }
        String latestCommit = table.getCompletedCommitsTimeline().lastInstant().get().requestedTime();
        LOG.info("Savepointing latest commit " + latestCommit);
        this.savepoint(latestCommit, user, comment);
    }

    public void savepoint(String instantTime, String user, String comment) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        table.savepoint(this.context, instantTime, user, comment);
    }

    public void deleteSavepoint() {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        HoodieTimeline savePointTimeline = table.getActiveTimeline().getSavePointTimeline();
        if (savePointTimeline.empty()) {
            throw new HoodieSavepointException("Could not delete savepoint. Savepoint timeline is empty");
        }
        String savepointTime = savePointTimeline.lastInstant().get().requestedTime();
        LOG.info("Deleting latest savepoint time " + savepointTime);
        this.deleteSavepoint(savepointTime);
    }

    public void deleteSavepoint(String savepointTime) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        SavepointHelpers.deleteSavepoint(table, savepointTime);
    }

    public void restoreToSavepoint() {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        HoodieTimeline savePointTimeline = table.getActiveTimeline().getSavePointTimeline();
        if (savePointTimeline.empty()) {
            throw new HoodieSavepointException("Could not restore to savepoint. Savepoint timeline is empty");
        }
        String savepointTime = savePointTimeline.lastInstant().get().requestedTime();
        LOG.info("Restoring to latest savepoint time " + savepointTime);
        this.restoreToSavepoint(savepointTime);
    }

    public void restoreToSavepoint(String savepointTime) {
        boolean initializeMetadataTableIfNecessary = this.config.isMetadataTableEnabled();
        if (initializeMetadataTableIfNecessary) {
            try {
                HoodieTableMetaClient mdtMetaClient = HoodieTableMetaClient.builder().setConf(this.storageConf.newInstance()).setBasePath(HoodieTableMetadata.getMetadataTableBasePath(this.config.getBasePath())).build();
                Option<HoodieInstant> oldestMdtCompaction = mdtMetaClient.getCommitTimeline().filterCompletedInstants().firstInstant();
                boolean deleteMDT = false;
                if (oldestMdtCompaction.isPresent() && InstantComparison.LESSER_THAN_OR_EQUALS.test(savepointTime, oldestMdtCompaction.get().requestedTime())) {
                    LOG.warn(String.format("Deleting MDT during restore to %s as the savepoint is older than oldest compaction %s on MDT", savepointTime, oldestMdtCompaction.get().requestedTime()));
                    deleteMDT = true;
                }
                if (!deleteMDT) {
                    HoodieInstant syncedInstant = mdtMetaClient.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", savepointTime);
                    if (mdtMetaClient.getCommitsTimeline().isBeforeTimelineStarts(syncedInstant.requestedTime())) {
                        LOG.warn(String.format("Deleting MDT during restore to %s as the savepoint is older than the MDT timeline %s", savepointTime, mdtMetaClient.getCommitsTimeline().firstInstant().get().requestedTime()));
                        deleteMDT = true;
                    }
                }
                if (deleteMDT) {
                    HoodieTableMetadataUtil.deleteMetadataTable(this.config.getBasePath(), this.context);
                    initializeMetadataTableIfNecessary = false;
                }
            }
            catch (Exception mdtMetaClient) {
                // empty catch block
            }
        }
        HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, Option.empty(), initializeMetadataTableIfNecessary);
        SavepointHelpers.validateSavepointPresence(table, savepointTime);
        ValidationUtils.checkArgument(!this.config.shouldArchiveBeyondSavepoint(), "Restore is not supported when " + HoodieArchivalConfig.ARCHIVE_BEYOND_SAVEPOINT.key() + " is enabled");
        this.restoreToInstant(savepointTime, initializeMetadataTableIfNecessary);
        SavepointHelpers.validateSavepointRestore(table, savepointTime);
    }

    @Deprecated
    public boolean rollback(String commitInstantTime) throws HoodieRollbackException {
        HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, Option.empty());
        Option<HoodiePendingRollbackInfo> pendingRollbackInfo = this.tableServiceClient.getPendingRollbackInfo(table.getMetaClient(), commitInstantTime);
        return this.tableServiceClient.rollback(commitInstantTime, pendingRollbackInfo, false, false);
    }

    @Deprecated
    public boolean rollback(String commitInstantTime, String rollbackInstantTimestamp) throws HoodieRollbackException {
        HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, Option.empty());
        Option<HoodiePendingRollbackInfo> pendingRollbackInfo = this.tableServiceClient.getPendingRollbackInfo(table.getMetaClient(), commitInstantTime);
        return this.tableServiceClient.rollback(commitInstantTime, pendingRollbackInfo, rollbackInstantTimestamp, false, false);
    }

    public HoodieRestoreMetadata restoreToInstant(String savepointToRestoreTimestamp, boolean initialMetadataTableIfNecessary) throws HoodieRestoreException {
        LOG.info("Begin restore to instant " + savepointToRestoreTimestamp);
        Timer.Context timerContext = this.metrics.getRollbackCtx();
        try {
            HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, Option.empty(), initialMetadataTableIfNecessary);
            Pair<String, Option<HoodieRestorePlan>> timestampAndRestorePlan = this.scheduleAndGetRestorePlan(savepointToRestoreTimestamp, table);
            String restoreInstantTimestamp = timestampAndRestorePlan.getLeft();
            Option<HoodieRestorePlan> restorePlanOption = timestampAndRestorePlan.getRight();
            if (restorePlanOption.isPresent()) {
                HoodieRestoreMetadata restoreMetadata = table.restore(this.context, restoreInstantTimestamp, savepointToRestoreTimestamp);
                if (timerContext != null) {
                    long durationInMs = this.metrics.getDurationInMs(timerContext.stop());
                    long totalFilesDeleted = restoreMetadata.getHoodieRestoreMetadata().values().stream().flatMap(Collection::stream).mapToLong(HoodieRollbackMetadata::getTotalFilesDeleted).sum();
                    this.metrics.updateRollbackMetrics(durationInMs, totalFilesDeleted);
                }
                return restoreMetadata;
            }
            throw new HoodieRestoreException("Failed to restore " + this.config.getBasePath() + " to commit " + savepointToRestoreTimestamp);
        }
        catch (Exception e) {
            throw new HoodieRestoreException("Failed to restore to " + savepointToRestoreTimestamp, e);
        }
    }

    private Pair<String, Option<HoodieRestorePlan>> scheduleAndGetRestorePlan(String savepointToRestoreTimestamp, HoodieTable<T, I, K, O> table) throws IOException {
        Option<HoodieInstant> failedRestore = table.getRestoreTimeline().filterInflightsAndRequested().lastInstant();
        if (failedRestore.isPresent() && savepointToRestoreTimestamp.equals(RestoreUtils.getSavepointToRestoreTimestamp(table, failedRestore.get()))) {
            return Pair.of(failedRestore.get().requestedTime(), Option.of(RestoreUtils.getRestorePlan(table.getMetaClient(), failedRestore.get())));
        }
        String restoreInstantTimestamp = this.createNewInstantTime();
        return Pair.of(restoreInstantTimestamp, table.scheduleRestore(this.context, restoreInstantTimestamp, savepointToRestoreTimestamp));
    }

    public HoodieCleanMetadata clean(String cleanInstantTime) throws HoodieIOException {
        return this.clean(cleanInstantTime, true, false);
    }

    @Deprecated
    public HoodieCleanMetadata clean(String cleanInstantTime, boolean skipLocking) throws HoodieIOException {
        return this.clean(cleanInstantTime, true, false);
    }

    public HoodieCleanMetadata clean(String cleanInstantTime, boolean scheduleInline, boolean skipLocking) throws HoodieIOException {
        return this.tableServiceClient.clean(cleanInstantTime, scheduleInline);
    }

    public HoodieCleanMetadata clean() {
        return this.clean(this.createNewInstantTime());
    }

    @Deprecated
    public HoodieCleanMetadata clean(boolean skipLocking) {
        return this.clean(this.createNewInstantTime());
    }

    protected void archive(HoodieTable table) {
        this.tableServiceClient.archive(table);
    }

    public void archive() {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        this.archive(table);
    }

    public String startCommit() {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        return this.startCommit(metaClient.getCommitActionType(), metaClient);
    }

    public String startCommit(String actionType, HoodieTableMetaClient metaClient) {
        if (this.needsUpgradeOrDowngrade(metaClient)) {
            this.executeUsingTxnManager(Option.empty(), () -> this.tryUpgrade(metaClient, Option.empty()));
        }
        CleanerUtils.rollbackFailedWrites(this.config.getFailedWritesCleanPolicy(), "commit", () -> this.tableServiceClient.rollbackFailedWrites());
        String instantTime = this.createNewInstantTime();
        this.startCommit(instantTime, actionType, metaClient);
        return instantTime;
    }

    public void startCommitWithTime(String instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        this.startCommitWithTime(instantTime, metaClient.getCommitActionType(), metaClient);
    }

    public void startCommitWithTime(String instantTime, String actionType) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        this.startCommitWithTime(instantTime, actionType, metaClient);
    }

    private void startCommitWithTime(String instantTime, String actionType, HoodieTableMetaClient metaClient) {
        if (this.needsUpgradeOrDowngrade(metaClient)) {
            this.executeUsingTxnManager(Option.empty(), () -> this.tryUpgrade(metaClient, Option.empty()));
        }
        CleanerUtils.rollbackFailedWrites(this.config.getFailedWritesCleanPolicy(), "commit", () -> this.tableServiceClient.rollbackFailedWrites());
        this.startCommit(instantTime, actionType, metaClient);
    }

    private void startCommit(String instantTime, String actionType, HoodieTableMetaClient metaClient) {
        LOG.info("Generate a new instant time: {} action: {}", (Object)instantTime, (Object)actionType);
        HoodieTimeline inflightRestoreTimeline = metaClient.getActiveTimeline().getRestoreTimeline().filterInflightsAndRequested();
        ValidationUtils.checkArgument(inflightRestoreTimeline.countInstants() == 0, "Found pending restore in active timeline. Please complete the restore fully before proceeding. As of now, table could be in an inconsistent state. Pending restores: " + Arrays.toString(inflightRestoreTimeline.getInstantsAsStream().map(HoodieInstant::requestedTime).collect(Collectors.toList()).toArray()));
        if (this.config.getFailedWritesCleanPolicy().isLazy()) {
            this.heartbeatClient.start(instantTime);
        }
        if (ClusteringUtils.isClusteringOrReplaceCommitAction(actionType)) {
            metaClient.getActiveTimeline().createRequestedCommitWithReplaceMetadata(instantTime, actionType);
        } else {
            metaClient.getActiveTimeline().createNewInstant(metaClient.createNewInstant(HoodieInstant.State.REQUESTED, actionType, instantTime));
        }
    }

    public Option<String> scheduleCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = this.createNewInstantTime();
        return this.scheduleCompactionAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.COMPACT).isPresent();
    }

    public Option<String> scheduleIndexing(List<MetadataPartitionType> partitionTypes, List<String> partitionPaths) {
        String instantTime = this.createNewInstantTime();
        Option<HoodieIndexPlan> indexPlan = this.createTable(this.config).scheduleIndexing(this.context, instantTime, partitionTypes, partitionPaths);
        return indexPlan.isPresent() ? Option.of(instantTime) : Option.empty();
    }

    public Option<HoodieIndexCommitMetadata> index(String indexInstantTime) {
        return this.createTable(this.config).index(this.context, indexInstantTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(List<String> metadataPartitions) {
        block18: {
            HoodieTable<T, I, K, O> table = this.createTable(this.config);
            String dropInstant = this.createNewInstantTime();
            HoodieInstant ownerInstant = table.getMetaClient().createNewInstant(HoodieInstant.State.INFLIGHT, "indexing", dropInstant);
            this.txnManager.beginTransaction(Option.of(ownerInstant), Option.empty());
            try {
                this.context.setJobStatus(this.getClass().getSimpleName(), "Dropping partitions from metadata table: " + this.config.getTableName());
                HoodieTableMetaClient metaClient = table.getMetaClient();
                metadataPartitions.forEach(partition -> {
                    if (MetadataPartitionType.isExpressionOrSecondaryIndex(partition)) {
                        metaClient.deleteIndexDefinition((String)partition);
                    }
                });
                Option<HoodieTableMetadataWriter> metadataWriterOpt = table.getMetadataWriter(dropInstant);
                metadataPartitions.forEach(partition -> metaClient.getTableConfig().setMetadataPartitionState(metaClient, (String)partition, false));
                if (!metadataWriterOpt.isPresent()) break block18;
                try (HoodieTableMetadataWriter metadataWriter = metadataWriterOpt.get();){
                    metadataWriter.dropMetadataPartitions(metadataPartitions);
                }
                catch (Exception e) {
                    if (e instanceof HoodieException) {
                        throw (HoodieException)e;
                    }
                    throw new HoodieException("Failed to drop partitions from metadata", e);
                }
            }
            finally {
                this.txnManager.endTransaction(Option.of(ownerInstant));
            }
        }
    }

    public HoodieWriteMetadata<O> cluster(String clusteringInstantTime) {
        if (this.shouldDelegateToTableServiceManager(this.config, ActionType.clustering)) {
            throw new UnsupportedOperationException("Clustering should be delegated to table service manager instead of direct run.");
        }
        return this.cluster(clusteringInstantTime, true);
    }

    public HoodieWriteMetadata<O> compact(String compactionInstantTime) {
        if (this.shouldDelegateToTableServiceManager(this.config, ActionType.compaction)) {
            throw new UnsupportedOperationException("Compaction should be delegated to table service manager instead of direct run.");
        }
        return this.compact(compactionInstantTime, this.config.shouldAutoCommit());
    }

    public void commitCompaction(String compactionInstantTime, HoodieCommitMetadata metadata2, Option<Map<String, String>> extraMetadata) {
        this.tableServiceClient.commitCompaction(compactionInstantTime, metadata2, extraMetadata);
    }

    protected void completeCompaction(HoodieCommitMetadata metadata2, HoodieTable table, String compactionCommitTime) {
        this.tableServiceClient.completeCompaction(metadata2, table, compactionCommitTime);
    }

    public Option<String> scheduleLogCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = this.createNewInstantTime();
        return this.scheduleLogCompactionAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleLogCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.LOG_COMPACT).isPresent();
    }

    public HoodieWriteMetadata<O> logCompact(String logCompactionInstantTime) {
        return this.logCompact(logCompactionInstantTime, this.config.shouldAutoCommit());
    }

    public void commitLogCompaction(String logCompactionInstantTime, HoodieCommitMetadata metadata2, Option<Map<String, String>> extraMetadata) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        extraMetadata.ifPresent(m -> m.forEach(metadata2::addMetadata));
        this.completeLogCompaction(metadata2, table, logCompactionInstantTime);
    }

    protected void completeLogCompaction(HoodieCommitMetadata metadata2, HoodieTable table, String logCompactionCommitTime) {
        this.tableServiceClient.completeLogCompaction(metadata2, table, logCompactionCommitTime);
    }

    protected HoodieWriteMetadata<O> compact(String compactionInstantTime, boolean shouldComplete) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        this.preWrite(compactionInstantTime, WriteOperationType.COMPACT, table.getMetaClient());
        return this.tableServiceClient.compact(compactionInstantTime, shouldComplete);
    }

    protected Option<String> inlineScheduleCompaction(Option<Map<String, String>> extraMetadata) {
        return this.scheduleCompaction(extraMetadata);
    }

    protected HoodieWriteMetadata<O> logCompact(String logCompactionInstantTime, boolean shouldComplete) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        this.preWrite(logCompactionInstantTime, WriteOperationType.LOG_COMPACT, table.getMetaClient());
        return this.tableServiceClient.logCompact(logCompactionInstantTime, shouldComplete);
    }

    public Option<String> scheduleClustering(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = this.createNewInstantTime();
        return this.scheduleClusteringAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleClusteringAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.CLUSTER).isPresent();
    }

    protected boolean scheduleCleaningAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.CLEAN).isPresent();
    }

    public HoodieWriteMetadata<O> cluster(String clusteringInstant, boolean shouldComplete) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        this.preWrite(clusteringInstant, WriteOperationType.CLUSTER, table.getMetaClient());
        return this.tableServiceClient.cluster(clusteringInstant, shouldComplete);
    }

    public boolean purgePendingClustering(String clusteringInstant) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config);
        this.preWrite(clusteringInstant, WriteOperationType.CLUSTER, table.getMetaClient());
        return this.tableServiceClient.purgePendingClustering(clusteringInstant);
    }

    public Option<String> scheduleTableService(Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        String instantTime = this.createNewInstantTime();
        return this.scheduleTableService(instantTime, extraMetadata, tableServiceType);
    }

    public Option<String> scheduleTableService(String instantTime, Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        return this.tableServiceClient.scheduleTableService(instantTime, extraMetadata, tableServiceType);
    }

    public HoodieMetrics getMetrics() {
        return this.metrics;
    }

    public HoodieIndex<?, ?> getIndex() {
        return this.index;
    }

    protected void doInitTable(WriteOperationType operationType, HoodieTableMetaClient metaClient, Option<String> instantTime) {
        Option<HoodieInstant> ownerInstant = Option.empty();
        if (instantTime.isPresent()) {
            ownerInstant = Option.of(metaClient.createNewInstant(HoodieInstant.State.INFLIGHT, CommitUtils.getCommitActionType(operationType, metaClient.getTableType()), instantTime.get()));
        }
        this.executeUsingTxnManager(ownerInstant, () -> {
            this.tryUpgrade(metaClient, instantTime);
            this.initMetadataTable(instantTime, metaClient);
        });
    }

    private void executeUsingTxnManager(Option<HoodieInstant> ownerInstant, Runnable r) {
        this.txnManager.beginTransaction(ownerInstant, Option.empty());
        try {
            r.run();
        }
        finally {
            this.txnManager.endTransaction(ownerInstant);
        }
    }

    protected void initMetadataTable(Option<String> instantTime, HoodieTableMetaClient metaClient) {
    }

    protected final HoodieTable initTable(WriteOperationType operationType, Option<String> instantTime, boolean initMetadataTable) {
        return this.initTable(operationType, instantTime);
    }

    public final HoodieTable initTable(WriteOperationType operationType, Option<String> instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        if (WriteOperationType.isDelete(operationType)) {
            this.setWriteSchemaForDeletes(metaClient);
        }
        this.doInitTable(operationType, metaClient, instantTime);
        HoodieTable<T, I, K, O> table = this.createTable(this.config, metaClient);
        this.validateAgainstTableProperties(table.getMetaClient().getTableConfig(), this.config);
        switch (operationType) {
            case INSERT: 
            case INSERT_PREPPED: 
            case UPSERT: 
            case UPSERT_PREPPED: 
            case BULK_INSERT: 
            case BULK_INSERT_PREPPED: 
            case INSERT_OVERWRITE: 
            case INSERT_OVERWRITE_TABLE: {
                this.setWriteTimer(table.getMetaClient().getCommitActionType());
                break;
            }
            case CLUSTER: 
            case COMPACT: 
            case LOG_COMPACT: {
                this.tableServiceClient.setTableServiceTimer(operationType);
                break;
            }
        }
        return table;
    }

    public void validateAgainstTableProperties(HoodieTableConfig tableConfig, HoodieWriteConfig writeConfig) {
        String bucketEngine;
        HoodieIndex.IndexType indexType;
        CommonClientUtils.validateTableVersion(tableConfig, writeConfig);
        TypedProperties properties2 = writeConfig.getProps();
        if (!tableConfig.populateMetaFields() && writeConfig.populateMetaFields()) {
            throw new HoodieException(HoodieTableConfig.POPULATE_META_FIELDS.key() + " already disabled for the table. Can't be re-enabled back");
        }
        if (!tableConfig.populateMetaFields()) {
            String keyGenClass = KeyGeneratorType.getKeyGeneratorClassName(new HoodieConfig((Properties)properties2));
            if (StringUtils.isNullOrEmpty(keyGenClass)) {
                keyGenClass = "org.apache.hudi.keygen.SimpleKeyGenerator";
            }
            if (!(keyGenClass.equals("org.apache.hudi.keygen.SimpleKeyGenerator") || keyGenClass.equals("org.apache.hudi.keygen.NonpartitionedKeyGenerator") || keyGenClass.equals("org.apache.hudi.keygen.ComplexKeyGenerator"))) {
                throw new HoodieException("Only simple, non-partitioned or complex key generator are supported when meta-fields are disabled. Used: " + keyGenClass);
            }
        }
        if (tableConfig.getTableType() == HoodieTableType.COPY_ON_WRITE && (indexType = writeConfig.getIndexType()) != null && indexType.equals((Object)HoodieIndex.IndexType.BUCKET) && (bucketEngine = ((Properties)properties2).getProperty("hoodie.index.bucket.engine")) != null && bucketEngine.equals("CONSISTENT_HASHING")) {
            throw new HoodieException("Consistent hashing bucket index does not work with COW table. Use simple bucket index or an MOR table.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setWriteSchemaForDeletes(HoodieTableMetaClient metaClient) {
        try {
            HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
            Option<HoodieInstant> lastInstant = activeTimeline.filterCompletedInstants().filter(s -> s.getAction().equals(metaClient.getCommitActionType()) || s.getAction().equals("replacecommit")).lastInstant();
            if (lastInstant.isPresent()) {
                HoodieCommitMetadata commitMetadata = metaClient.getCommitMetadataSerDe().deserialize(lastInstant.get(), activeTimeline.getInstantDetails(lastInstant.get()).get(), HoodieCommitMetadata.class);
                String extraSchema = commitMetadata.getExtraMetadata().get("schema");
                if (StringUtils.isNullOrEmpty(extraSchema)) throw new HoodieIOException("Latest commit does not have any schema in commit metadata");
                this.config.setSchema(commitMetadata.getExtraMetadata().get("schema"));
                return;
            } else {
                LOG.warn("None rows are deleted because the table is empty");
            }
            return;
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException thrown while reading last commit metadata", e);
        }
    }

    protected void releaseResources(String instantTime) {
    }

    @Override
    public void close() {
        super.close();
        this.index.close();
        this.tableServiceClient.close();
    }

    public void setWriteTimer(String commitType) {
        if (commitType.equals("commit")) {
            this.writeTimer = this.metrics.getCommitCtx();
        } else if (commitType.equals("deltacommit")) {
            this.writeTimer = this.metrics.getDeltaCommitCtx();
        }
    }

    protected void tryUpgrade(HoodieTableMetaClient metaClient, Option<String> instantTime) {
        UpgradeDowngrade upgradeDowngrade = new UpgradeDowngrade(metaClient, this.config, this.context, this.upgradeDowngradeHelper);
        if (upgradeDowngrade.needsUpgradeOrDowngrade(this.config.getWriteVersion())) {
            List<String> instantsToRollback = this.tableServiceClient.getInstantsToRollback(metaClient, HoodieFailedWritesCleaningPolicy.EAGER, instantTime);
            if (!instantsToRollback.isEmpty()) {
                Map<String, Option<HoodiePendingRollbackInfo>> pendingRollbacks = this.tableServiceClient.getPendingRollbackInfos(metaClient);
                instantsToRollback.forEach(entry -> pendingRollbacks.putIfAbsent((String)entry, Option.empty()));
                this.tableServiceClient.rollbackFailedWrites(pendingRollbacks, true, true);
            }
            new UpgradeDowngrade(metaClient, this.config, this.context, this.upgradeDowngradeHelper).run(HoodieTableVersion.current(), instantTime.orElse(null));
            metaClient.reloadTableConfig();
            metaClient.reloadActiveTimeline();
        }
    }

    private boolean needsUpgradeOrDowngrade(HoodieTableMetaClient metaClient) {
        UpgradeDowngrade upgradeDowngrade = new UpgradeDowngrade(metaClient, this.config, this.context, this.upgradeDowngradeHelper);
        return upgradeDowngrade.needsUpgradeOrDowngrade(this.config.getWriteVersion());
    }

    public boolean lazyRollbackFailedIndexing() {
        return this.tableServiceClient.rollbackFailedIndexingCommits();
    }

    public boolean rollbackFailedWrites() {
        return this.tableServiceClient.rollbackFailedWrites();
    }

    public void addColumn(String colName, Schema schema, String doc, String position, TableChange.ColumnPositionChange.ColumnPositionType positionType) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyAddChange(colName, AvroInternalSchemaConverter.convertToField(schema), doc, position, positionType);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void addColumn(String colName, Schema schema) {
        this.addColumn(colName, schema, null, "", TableChange.ColumnPositionChange.ColumnPositionType.NO_OPERATION);
    }

    public void deleteColumns(String ... colNames) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyDeleteChange(colNames);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void renameColumn(String colName, String newName) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyRenameChange(colName, newName);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void updateColumnNullability(String colName, boolean nullable) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyColumnNullabilityChange(colName, nullable);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void updateColumnType(String colName, Type newType) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyColumnTypeChange(colName, newType);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void updateColumnComment(String colName, String doc) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyColumnCommentChange(colName, doc);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void reOrderColPosition(String colName, String referColName, TableChange.ColumnPositionChange.ColumnPositionType orderType) {
        if (colName == null || orderType == null || referColName == null) {
            return;
        }
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyReOrderColPositionChange(colName, referColName, orderType);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public Pair<InternalSchema, HoodieTableMetaClient> getInternalSchemaAndMetaClient() {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        return Pair.of(this.getInternalSchema(schemaUtil), metaClient);
    }

    public void commitTableChange(InternalSchema newSchema, HoodieTableMetaClient metaClient) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        String historySchemaStr = schemaUtil.getTableHistorySchemaStrFromCommitMetadata().orElseGet(() -> SerDeHelper.inheritSchemas(this.getInternalSchema(schemaUtil), ""));
        Schema schema = AvroInternalSchemaConverter.convert(newSchema, AvroSchemaUtils.getAvroRecordQualifiedName(this.config.getTableName()));
        String commitActionType = CommitUtils.getCommitActionType(WriteOperationType.ALTER_SCHEMA, metaClient.getTableType());
        String instantTime = this.createNewInstantTime();
        this.startCommitWithTime(instantTime, commitActionType, metaClient);
        this.config.setSchema(schema.toString());
        HoodieActiveTimeline timeLine = metaClient.getActiveTimeline();
        HoodieInstant requested = metaClient.createNewInstant(HoodieInstant.State.REQUESTED, commitActionType, instantTime);
        HoodieCommitMetadata metadata2 = new HoodieCommitMetadata();
        metadata2.setOperationType(WriteOperationType.ALTER_SCHEMA);
        try {
            timeLine.transitionRequestedToInflight(requested, TimelineMetadataUtils.serializeCommitMetadata(metaClient.getCommitMetadataSerDe(), metadata2));
        }
        catch (IOException io) {
            throw new HoodieCommitException("Failed to commit " + instantTime + " unable to save inflight metadata ", io);
        }
        HashMap<String, String> extraMeta = new HashMap<String, String>();
        extraMeta.put("latest_schema", SerDeHelper.toJson(newSchema.setSchemaId(Long.parseLong(instantTime))));
        FileBasedInternalSchemaStorageManager schemasManager = new FileBasedInternalSchemaStorageManager(metaClient);
        schemasManager.persistHistorySchemaStr(instantTime, SerDeHelper.inheritSchemas(newSchema, historySchemaStr));
        this.commitStats(instantTime, Collections.emptyList(), Option.of(extraMeta), commitActionType);
    }

    private InternalSchema getInternalSchema(TableSchemaResolver schemaUtil) {
        return schemaUtil.getTableInternalSchemaFromCommitMetadata().orElseGet(() -> {
            try {
                return AvroInternalSchemaConverter.convert(schemaUtil.getTableAvroSchema());
            }
            catch (Exception e) {
                throw new HoodieException(String.format("cannot find schema for current table: %s", this.config.getBasePath()));
            }
        });
    }

    protected final void maybeDisableWriteRecordPositions(HoodieTableMetaClient metaClient) {
        if (this.config.shouldWriteRecordPositions() && this.config.getTableType() == HoodieTableType.MERGE_ON_READ && (this.config.getWriteConcurrencyMode() == WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL || !metaClient.getActiveTimeline().filterPendingCompactionTimeline().empty())) {
            this.config.setValue(HoodieWriteConfig.WRITE_RECORD_POSITIONS, String.valueOf(false));
        }
    }

    @FunctionalInterface
    protected static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

