/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.heartbeat;

import java.io.IOException;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.common.heartbeat.HoodieHeartbeatUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatUtils.class);

    public static boolean deleteHeartbeatFile(HoodieStorage storage2, String basePath, String instantTime) {
        boolean deleted = false;
        try {
            String heartbeatFolderPath = HoodieTableMetaClient.getHeartbeatFolderPath(basePath);
            deleted = storage2.deleteFile(new StoragePath(heartbeatFolderPath, instantTime));
            if (!deleted) {
                LOG.error("Failed to delete heartbeat for instant " + instantTime);
            } else {
                LOG.info("Deleted the heartbeat for instant " + instantTime);
            }
        }
        catch (IOException io) {
            LOG.error("Unable to delete heartbeat for instant " + instantTime, (Throwable)io);
        }
        return deleted;
    }

    public static boolean deleteHeartbeatFile(HoodieStorage storage2, String basePath, String instantTime, HoodieWriteConfig config) {
        if (config.getFailedWritesCleanPolicy().isLazy()) {
            return HeartbeatUtils.deleteHeartbeatFile(storage2, basePath, instantTime);
        }
        return false;
    }

    public static void abortIfHeartbeatExpired(String instantTime, HoodieTable table, HoodieHeartbeatClient heartbeatClient, HoodieWriteConfig config) {
        ValidationUtils.checkArgument(heartbeatClient != null);
        try {
            if (config.getFailedWritesCleanPolicy().isLazy() && heartbeatClient.isHeartbeatExpired(instantTime)) {
                throw new HoodieException("Heartbeat for instant " + instantTime + " has expired, last heartbeat " + HoodieHeartbeatUtils.getLastHeartbeatTime(table.getStorage(), config.getBasePath(), instantTime));
            }
        }
        catch (IOException io) {
            throw new HoodieException("Unable to read heartbeat", io);
        }
    }
}

