/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.codahale.metrics.jmx;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.hudi.com.codahale.metrics.jmx.JmxReporter;
import org.apache.hudi.com.codahale.metrics.jmx.ObjectNameFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultObjectNameFactory
implements ObjectNameFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxReporter.class);

    @Override
    public ObjectName createName(String type2, String domain, String name2) {
        try {
            Hashtable<String, String> properties2 = new Hashtable<String, String>();
            properties2.put("name", name2);
            properties2.put("type", type2);
            ObjectName objectName = new ObjectName(domain, properties2);
            if (objectName.isDomainPattern()) {
                domain = ObjectName.quote(domain);
            }
            if (objectName.isPropertyValuePattern("name")) {
                properties2.put("name", ObjectName.quote(name2));
            }
            if (objectName.isPropertyValuePattern("type")) {
                properties2.put("type", ObjectName.quote(type2));
            }
            objectName = new ObjectName(domain, properties2);
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            try {
                return new ObjectName(domain, "name", ObjectName.quote(name2));
            }
            catch (MalformedObjectNameException e1) {
                LOGGER.warn("Unable to register {} {}", new Object[]{type2, name2, e1});
                throw new RuntimeException(e1);
            }
        }
    }
}

