/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.uber.m3.tally;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hudi.com.uber.m3.tally.Counter;
import org.apache.hudi.com.uber.m3.tally.MetricBase;
import org.apache.hudi.com.uber.m3.tally.Reportable;
import org.apache.hudi.com.uber.m3.tally.ScopeImpl;
import org.apache.hudi.com.uber.m3.tally.StatsReporter;
import org.apache.hudi.com.uber.m3.util.ImmutableMap;

class CounterImpl
extends MetricBase
implements Counter,
Reportable {
    private final AtomicLong prev = new AtomicLong(0L);
    private final AtomicLong curr = new AtomicLong(0L);

    protected CounterImpl(ScopeImpl scope2, String fqn) {
        super(fqn);
        scope2.addToReportingQueue(this);
    }

    @Override
    public void inc(long delta) {
        this.curr.getAndAdd(delta);
    }

    long value() {
        long previous;
        long current = this.curr.get();
        if (current == (previous = this.prev.get())) {
            return 0L;
        }
        this.prev.set(current);
        return current - previous;
    }

    @Override
    public void report(ImmutableMap<String, String> tags, StatsReporter reporter2) {
        long delta = this.value();
        if (delta == 0L) {
            return;
        }
        reporter2.reportCounter(this.getQualifiedName(), tags, delta);
    }

    long snapshot() {
        return this.curr.get() - this.prev.get();
    }
}

