/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.cdc;

import java.util.Arrays;
import java.util.List;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.table.cdc.HoodieCDCSupplementalLoggingMode;
import org.apache.hudi.exception.HoodieException;

public class HoodieCDCUtils {
    public static final String CDC_LOGFILE_SUFFIX = ".cdc";
    public static final String CDC_OPERATION_TYPE = "op";
    public static final String CDC_COMMIT_TIMESTAMP = "ts_ms";
    public static final String CDC_BEFORE_IMAGE = "before";
    public static final String CDC_AFTER_IMAGE = "after";
    public static final String CDC_RECORD_KEY = "record_key";
    public static final String[] CDC_COLUMNS = new String[]{"op", "ts_ms", "before", "after"};
    public static final String CDC_SCHEMA_OP_AND_RECORDKEY_STRING = "{\"type\":\"record\",\"name\":\"Record\",\"fields\":[{\"name\":\"op\",\"type\":[\"string\",\"null\"]},{\"name\":\"record_key\",\"type\":[\"string\",\"null\"]}]}";
    public static final Schema CDC_SCHEMA_OP_AND_RECORDKEY = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Record\",\"fields\":[{\"name\":\"op\",\"type\":[\"string\",\"null\"]},{\"name\":\"record_key\",\"type\":[\"string\",\"null\"]}]}");

    public static Schema schemaBySupplementalLoggingMode(HoodieCDCSupplementalLoggingMode supplementalLoggingMode, Schema tableSchema) {
        if (supplementalLoggingMode == HoodieCDCSupplementalLoggingMode.OP_KEY_ONLY) {
            return CDC_SCHEMA_OP_AND_RECORDKEY;
        }
        if (supplementalLoggingMode == HoodieCDCSupplementalLoggingMode.DATA_BEFORE) {
            return HoodieCDCUtils.createCDCSchema(tableSchema, false);
        }
        if (supplementalLoggingMode == HoodieCDCSupplementalLoggingMode.DATA_BEFORE_AFTER) {
            return HoodieCDCUtils.createCDCSchema(tableSchema, true);
        }
        throw new HoodieException("not support this supplemental logging mode: " + (Object)((Object)supplementalLoggingMode));
    }

    private static Schema createCDCSchema(Schema tableSchema, boolean withAfterImage) {
        List<Schema.Field> fields2;
        Schema imageSchema = AvroSchemaUtils.createNullableSchema(tableSchema);
        Schema.Field opField = new Schema.Field(CDC_OPERATION_TYPE, AvroSchemaUtils.createNullableSchema(Schema.Type.STRING), "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field beforeField = new Schema.Field(CDC_BEFORE_IMAGE, imageSchema, "", (Object)JsonProperties.NULL_VALUE);
        if (withAfterImage) {
            Schema.Field tsField = new Schema.Field(CDC_COMMIT_TIMESTAMP, AvroSchemaUtils.createNullableSchema(Schema.Type.STRING), "", (Object)JsonProperties.NULL_VALUE);
            Schema.Field afterField = new Schema.Field(CDC_AFTER_IMAGE, imageSchema, "", (Object)JsonProperties.NULL_VALUE);
            fields2 = Arrays.asList(opField, tsField, beforeField, afterField);
        } else {
            Schema.Field keyField = new Schema.Field(CDC_RECORD_KEY, AvroSchemaUtils.createNullableSchema(Schema.Type.STRING), "", (Object)JsonProperties.NULL_VALUE);
            fields2 = Arrays.asList(opField, keyField, beforeField);
        }
        Schema mergedSchema = Schema.createRecord((String)"CDC", null, (String)tableSchema.getNamespace(), (boolean)false);
        mergedSchema.setFields(fields2);
        return mergedSchema;
    }

    public static GenericData.Record cdcRecord(Schema cdcSchema, String op, String commitTime, GenericRecord before, GenericRecord after) {
        GenericData.Record record = new GenericData.Record(cdcSchema);
        record.put(CDC_OPERATION_TYPE, (Object)op);
        record.put(CDC_COMMIT_TIMESTAMP, (Object)commitTime);
        record.put(CDC_BEFORE_IMAGE, (Object)before);
        record.put(CDC_AFTER_IMAGE, (Object)after);
        return record;
    }

    public static GenericData.Record cdcRecord(Schema cdcSchema, String op, String recordKey, GenericRecord before) {
        GenericData.Record record = new GenericData.Record(cdcSchema);
        record.put(CDC_OPERATION_TYPE, (Object)op);
        record.put(CDC_RECORD_KEY, (Object)recordKey);
        record.put(CDC_BEFORE_IMAGE, (Object)before);
        return record;
    }

    public static GenericData.Record cdcRecord(Schema cdcSchema, String op, String recordKey) {
        GenericData.Record record = new GenericData.Record(cdcSchema);
        record.put(CDC_OPERATION_TYPE, (Object)op);
        record.put(CDC_RECORD_KEY, (Object)recordKey);
        return record;
    }

    public static String recordToJson(GenericRecord record) {
        return GenericData.get().toString((Object)record);
    }
}

