/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.VersionMigrator;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public class MetadataMigrator<T> {
    private final Map<Integer, VersionMigrator<T>> migrators;
    private final Integer latestVersion;
    private final Integer oldestVersion;

    public MetadataMigrator(HoodieTableMetaClient metaClient, List<VersionMigrator<T>> migratorList) {
        this.migrators = migratorList.stream().map(m -> Pair.of(m.getManagedVersion(), m)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        this.latestVersion = (Integer)this.migrators.keySet().stream().reduce((x, y) -> x > y ? x : y).get();
        this.oldestVersion = (Integer)this.migrators.keySet().stream().reduce((x, y) -> x < y ? x : y).get();
    }

    public T upgradeToLatest(T metadata2, int metadataVersion) {
        if (metadataVersion == this.latestVersion) {
            return metadata2;
        }
        for (int newVersion = metadataVersion + 1; newVersion <= this.latestVersion; ++newVersion) {
            VersionMigrator<T> upgrader = this.migrators.get(newVersion);
            metadata2 = upgrader.upgradeFrom(metadata2);
        }
        return metadata2;
    }

    public T migrateToVersion(T metadata2, int metadataVersion, int targetVersion) {
        ValidationUtils.checkArgument(targetVersion >= this.oldestVersion);
        ValidationUtils.checkArgument(targetVersion <= this.latestVersion);
        if (metadataVersion == targetVersion) {
            return metadata2;
        }
        if (metadataVersion > targetVersion) {
            return this.downgradeToVersion(metadata2, metadataVersion, targetVersion);
        }
        return this.upgradeToVersion(metadata2, metadataVersion, targetVersion);
    }

    private T upgradeToVersion(T metadata2, int metadataVersion, int targetVersion) {
        for (int newVersion = metadataVersion + 1; newVersion <= targetVersion; ++newVersion) {
            VersionMigrator<T> upgrader = this.migrators.get(newVersion);
            metadata2 = upgrader.upgradeFrom(metadata2);
        }
        return metadata2;
    }

    private T downgradeToVersion(T metadata2, int metadataVersion, int targetVersion) {
        for (int newVersion = metadataVersion - 1; newVersion >= targetVersion; --newVersion) {
            VersionMigrator<T> downgrader = this.migrators.get(newVersion);
            metadata2 = downgrader.downgradeFrom(metadata2);
        }
        return metadata2;
    }
}

