/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.hudi.common.util.StringUtils;

public class BinaryUtil {
    public static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int end1 = offset1 + length1;
        int end2 = offset2 + length2;
        int i = offset1;
        for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
            int a = buffer1[i] & 0xFF;
            int b = buffer2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return length1 - length2;
    }

    public static byte[] paddingTo8Byte(byte[] a) {
        if (a.length == 8) {
            return a;
        }
        if (a.length > 8) {
            byte[] result2 = new byte[8];
            System.arraycopy(a, 0, result2, 0, 8);
            return result2;
        }
        int paddingSize = 8 - a.length;
        byte[] result3 = new byte[8];
        for (int i = 0; i < paddingSize; ++i) {
            result3[i] = 0;
        }
        System.arraycopy(a, 0, result3, paddingSize, a.length);
        return result3;
    }

    public static byte[] interleaving(byte[][] buffer, int size) {
        int candidateSize = buffer.length;
        byte[] result2 = new byte[size * candidateSize];
        int resBitPos = 0;
        int totalBits = size * 8;
        for (int bitStep = 0; bitStep < totalBits; ++bitStep) {
            int currentBytePos = (int)Math.floor(bitStep / 8);
            int currentBitPos = bitStep % 8;
            for (int i = 0; i < candidateSize; ++i) {
                int tempResBytePos = (int)Math.floor(resBitPos / 8);
                int tempResBitPos = resBitPos % 8;
                result2[tempResBytePos] = BinaryUtil.updatePos(result2[tempResBytePos], tempResBitPos, buffer[i][currentBytePos], currentBitPos);
                ++resBitPos;
            }
        }
        return result2;
    }

    public static byte updatePos(byte a, int apos, byte b, int bpos) {
        byte atemp;
        byte temp = (byte)(b & 1 << 7 - bpos);
        if (apos < bpos) {
            temp = (byte)(temp << bpos - apos);
        }
        if (apos > bpos) {
            temp = (byte)(temp >> apos - bpos);
        }
        if ((byte)((atemp = (byte)(a & 1 << 7 - apos)) ^ temp) == 0) {
            return a;
        }
        return (byte)(a ^ 1 << 7 - apos);
    }

    public static byte[] toBytes(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static byte[] toBytes(long val) {
        long temp = val;
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)temp;
            temp >>>= 8;
        }
        b[0] = (byte)temp;
        return b;
    }

    public static byte[] toBytes(double d) {
        return BinaryUtil.toBytes(Double.doubleToRawLongBits(d));
    }

    public static byte[] intTo8Byte(int a) {
        int temp = a;
        return BinaryUtil.paddingTo8Byte(BinaryUtil.toBytes(temp ^= Integer.MIN_VALUE));
    }

    public static byte[] byteTo8Byte(byte a) {
        return BinaryUtil.paddingTo8Byte(new byte[]{a});
    }

    public static byte[] longTo8Byte(long a) {
        long temp = a;
        return BinaryUtil.toBytes(temp ^= Long.MIN_VALUE);
    }

    public static byte[] doubleTo8Byte(double a) {
        byte[] temp = BinaryUtil.toBytes(a);
        if (a > 0.0) {
            temp[0] = (byte)(temp[0] ^ 0x80);
        }
        if (a < 0.0) {
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = ~temp[i];
            }
        }
        return temp;
    }

    public static byte[] utf8To8Byte(String a) {
        return BinaryUtil.paddingTo8Byte(StringUtils.getUTF8Bytes(a));
    }

    public static Long convertStringToLong(String a) {
        byte[] bytes = BinaryUtil.utf8To8Byte(a);
        return BinaryUtil.convertBytesToLong(bytes);
    }

    public static long convertBytesToLong(byte[] bytes) {
        byte[] paddedBytes = BinaryUtil.paddingTo8Byte(bytes);
        long temp = 0L;
        for (int i = 7; i >= 0; --i) {
            temp |= ((long)paddedBytes[i] & 0xFFL) << (7 - i) * 8;
        }
        return temp;
    }

    public static long generateChecksum(byte[] data2) {
        CRC32 crc = new CRC32();
        crc.update(data2);
        return crc.getValue();
    }
}

